package net.aihelp.ui.cs.util.viewer;

import android.content.Context;
import android.content.DialogInterface;
import android.text.TextUtils;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import net.aihelp.common.CustomConfig;
import net.aihelp.core.ui.dialog.AlertDialog;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.core.util.bus.Subscribe;
import net.aihelp.core.util.bus.ThreadMode;
import net.aihelp.data.event.OrientationChangeEvent;
import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.data.model.rpa.msg.UserMessage;
import net.aihelp.data.model.rpa.msg.bot.SelfService;
import net.aihelp.ui.adapter.BillingListAdapter;
import net.aihelp.utils.AppInfoUtil;
import net.aihelp.utils.FastClickValidator;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.Iterator;
import java.util.UUID;

public class SelfServiceViewer implements View.OnClickListener {

    private AlertDialog selfServiceDialog;

    private TextView mTvSend;
    private ImageView mIvClose;
    private RelativeLayout mEmptyLayout;

    private BillingListAdapter mAdapter;

    public void getService(Context context, SelfService selfService) {

        selfServiceDialog = new AlertDialog.Builder(context)
                .setContentView(ResResolver.getLayoutId("aihelp_dia_selecting_bill"))
                .setGravity(Gravity.BOTTOM)
                .fromBottom(true)
                .setCancelableOntheOutside(true)
                .setOnDismissListener(new DialogInterface.OnDismissListener() {
                    @Override
                    public void onDismiss(DialogInterface dialog) {
                        EventBus.getDefault().unregister(SelfServiceViewer.this);
                    }
                })
                .setWidthAndHeight(ViewGroup.LayoutParams.MATCH_PARENT, 500)
                .setHeightByDevice()
                .create();

        LinearLayout llRoot = selfServiceDialog.findViewById(ResResolver.getViewId("aihelp_ll_bill_dialog"));
        llRoot.setBackgroundColor(Styles.getColor(CustomConfig.CommonSetting.upperBackgroundColor));

        // Send
        mTvSend = selfServiceDialog.findViewById(ResResolver.getViewId("aihelp_tv_send"));
        Styles.reRenderTextView(mTvSend, ResResolver.getString("aihelp_send"),
                Styles.getColor(CustomConfig.CommonSetting.interactElementTextColor));
        mTvSend.setOnClickListener(this);

        // Close
        mIvClose = selfServiceDialog.findViewById(ResResolver.getViewId("aihelp_iv_close"));
        Styles.reRenderImageView(mIvClose, "aihelp_svg_ic_close_dialog");
        mIvClose.setOnClickListener(this);

        // Empty Layout
        mEmptyLayout = selfServiceDialog.findViewById(ResResolver.getViewId("aihelp_rl_empty"));

        // ListView
        ListView mBillList = selfServiceDialog.findViewById(ResResolver.getViewId("aihelp_lv_bill"));
        mAdapter = new BillingListAdapter(context, selfService.isEnableSend());
        mAdapter.setOnOrderCheckedListener(new BillingListAdapter.OnOrderCheckedListener() {
            @Override
            public void onOrderChecked() {
                mTvSend.setEnabled(true);
                mTvSend.setAlpha(1.0f);
            }
        });
        mBillList.setAdapter(mAdapter);
        selfServiceDialog.show();

        mTvSend.setVisibility(selfService.isEnableSend() ? View.VISIBLE : View.GONE);
        mIvClose.setVisibility(selfService.isEnableSend() ? View.GONE : View.VISIBLE);

        try {
            JSONArray jsonArray = new JSONArray(selfService.getSelfServiceData());
            if (jsonArray.length() > 0) {
                mAdapter.update(jsonArray);
            } else {
                showEmpty();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        EventBus.getDefault().register(SelfServiceViewer.this);
    }

    private void showEmpty() {
        mTvSend.setVisibility(View.GONE);
        mIvClose.setVisibility(View.GONE);
        mEmptyLayout.setVisibility(View.VISIBLE);
        TextView tvError = mEmptyLayout.findViewById(ResResolver.getViewId("aihelp_tv_error_desc"));
        tvError.setText(ResResolver.getString("aihelp_data_not_found_msg"));
    }

    @Override
    public void onClick(View v) {

        if (v.getId() == ResResolver.getViewId("aihelp_tv_send") && FastClickValidator.validate()) {
            if (AppInfoUtil.validateNetwork(v.getContext())) {
                String checkedBillJson = mAdapter.getCheckedBill();
                if (!TextUtils.isEmpty(checkedBillJson)) {
                    try {
                        StringBuilder stringBuilder = new StringBuilder();
                        JSONObject jsonObject = new JSONObject(checkedBillJson);
                        Iterator<String> keys = jsonObject.keys();
                        while (keys.hasNext()) {
                            String key = keys.next();
                            stringBuilder.append(key).append(": ").append(jsonObject.opt(key)).append("\n");
                        }

                        String content = stringBuilder.toString().trim();
                        UserMessage userMessage = Message.getUserTextMsg(content);
                        userMessage.setRequestParams(content, UserMessage.INPUT_FORMAT_TEXT,
                                UserMessage.INPUT_SOURCE_SELF_SERVICE);

                        if (onSelfServiceConfirmListener != null) {
                            onSelfServiceConfirmListener.onSelected(userMessage);
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (selfServiceDialog != null && selfServiceDialog.isShowing()) {
                    selfServiceDialog.dismiss();
                }
            }
        }

        if (v.getId() == ResResolver.getViewId("aihelp_iv_close") && FastClickValidator.validate()) {
            if (selfServiceDialog != null && selfServiceDialog.isShowing()) {
                selfServiceDialog.dismiss();
            }
        }
    }

    public JSONObject getRequestParams(String input, int inputFormat) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("input", input);
            jsonObject.put("skip", false);
            jsonObject.put("inputFormat", inputFormat);
            jsonObject.put("inputData", "");
            jsonObject.put("eventId", UUID.randomUUID().toString().replace("-", ""));
            return jsonObject;
        } catch (Exception e) {
            return new JSONObject();
        }
    }

    private OnSelfServiceConfirmListener onSelfServiceConfirmListener;

    public void setOnSelfServiceConfirmListener(OnSelfServiceConfirmListener onSelfServiceConfirmListener) {
        this.onSelfServiceConfirmListener = onSelfServiceConfirmListener;
    }

    public interface OnSelfServiceConfirmListener {
        void onSelected(Message message);
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onEventComing(OrientationChangeEvent event) {
        if (selfServiceDialog != null && selfServiceDialog.isShowing()) {
            selfServiceDialog.dismiss();
        }
    }

}
