package net.aihelp.ui.err;

import android.os.Bundle;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import net.aihelp.common.CustomConfig;
import net.aihelp.core.ui.BaseFragment;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.data.event.UpdateTitleEvent;
import net.aihelp.data.localize.config.ProcessEntranceHelper;
import net.aihelp.data.model.config.ProcessEntity;
import net.aihelp.data.track.event.EventTracker;
import net.aihelp.data.track.event.utils.EventType;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

public class FaqErrorFragment extends BaseFragment {

    public static FaqErrorFragment newInstance(Bundle bundle) {
        FaqErrorFragment faqFragment = new FaqErrorFragment();
        faqFragment.setArguments(bundle);
        return faqFragment;
    }

    @Override
    protected void initEventAndData(View view) {
        EventBus.getDefault().post(new UpdateTitleEvent(UpdateTitleEvent.HELP_CENTER, "", "Not Found"));

        LinearLayout flContent = (LinearLayout) get("aihelp_ll_root");
        int colorFromHex = Styles.getColorWithAlpha(CustomConfig.CommonSetting.upperBackgroundColor,
                CustomConfig.CommonSetting.upperBackgroundAlpha);
        flContent.setBackgroundColor(colorFromHex);

        ImageView imageView = view.findViewById(ResResolver.getViewId("aihelp_iv_empty"));
        TextView textView = view.findViewById(ResResolver.getViewId("aihelp_tv_empty"));
        Styles.reRenderImageView(imageView, "aihelp_svg_ic_empty");
        Styles.reRenderTextView(textView, "entrance id not found");

        ProcessEntity currentProcess = ProcessEntranceHelper.INSTANCE.getCurrentProcess();
        EventTracker.INSTANCE.log(EventType.ERR_NO_ENTRANCE_MATCHED,
                currentProcess != null ? currentProcess.getEntranceId() : "");
    }

    @Override
    protected void getBundleAfterDataPrepared(Bundle extras) {
    }

    @Override
    protected int getLayout() {
        return ResResolver.getLayoutId("aihelp_layout_list_empty");
    }

}
