package net.aihelp.ui.faq;

import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;


import net.aihelp.common.Const;
import net.aihelp.common.CustomConfig;
import net.aihelp.common.IntentValues;
import net.aihelp.core.ui.BaseFragment;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.data.event.NewMessageArrivedEvent;
import net.aihelp.data.event.SearchViewVisibilityChangeEvent;
import net.aihelp.data.event.LoadingElvaEvent;
import net.aihelp.data.event.UpdateTitleEvent;
import net.aihelp.data.logic.FaqPresenter;
import net.aihelp.data.logic.MqttCallbackImpl;
import net.aihelp.data.model.faq.FaqListEntity;
import net.aihelp.data.model.faq.FaqContentEntity;
import net.aihelp.ui.cs.util.TicketStatusTracker;
import net.aihelp.ui.widget.AIHelpServiceEntrance;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

import java.util.Iterator;
import java.util.List;

public abstract class BaseFaqFragment<T extends FaqPresenter> extends BaseFragment<T> implements View.OnClickListener {

    protected int intentMode;
    protected AIHelpServiceEntrance csEntrance;

    protected String titleIcon;
    protected String titleText;

    /**
     * 每个页面在创建的时候都会执行这段代码，相当于每个页面都有 currentSection 这个属性
     * 而不同页面的该字段存储的值正是当前页面所属的分类名称
     * 所以可以在 onResume 中直接将这个值 post 给 SupportFragment，即可实现正确的标题显示
     */
    @Override
    protected void getBundleBeforeDataPrepared(Bundle extras) {

        intentMode = extras.getInt(IntentValues.SUPPORT_MODE, -1);

        // FAQ 首页、搜索页、特定的 FAQ 分类页、单条 FAQ 页需要显示应用名称
        // 其他页面应该显示当前 FAQ 所在的分类名称和 icon
        // titleIcon = extras.getString(IntentValues.SECTION_ICON);
        titleText = extras.getString(IntentValues.SECTION_NAME);

        // 如果 titleIcon 和 titleText 的值为空，则使用默认的统一标题
        if (TextUtils.isEmpty(titleIcon)) {
            titleIcon = CustomConfig.HelpCenter.faqNavigationBarTitleIcon;
        }
        if (TextUtils.isEmpty(titleText)) {
            titleText = CustomConfig.HelpCenter.faqNavigationTitle;
        }

    }

    @Override
    public void onResume() {
        super.onResume();

        if (Const.TOGGLE_OPEN_FAQ_NOTIFICATION) {
            MqttCallbackImpl.getInstance().updateHostView(this);
        }

        EventBus.getDefault().post(new LoadingElvaEvent(IntentValues.HIDE_CS_LOADING));
        EventBus.getDefault().post(new UpdateTitleEvent(UpdateTitleEvent.HELP_CENTER, titleIcon, titleText));

        // 根据 faq 搜索页面的显示隐藏状态，来变更标题栏的样式
        EventBus.getDefault().post(new SearchViewVisibilityChangeEvent(this instanceof FaqSearchFragment));

        // update cs entrance view only if current fragment is restored
        // otherwise, the entrance view in empty layout maybe messed with the one in list
        if (mVaryViewHelperController != null && mVaryViewHelperController.isViewRestored()) {
            csEntrance = get("aihelp_cs_entrance");
            if (csEntrance != null) {
                csEntrance.setup(getMergedBundle(), getFaqFlowListener(), this);
            }
        }

    }

    /**
     * 移除所有的 sectionId，subSectionId，faqId 等，以免造成数据混乱
     * 因为新的页面会再次对指定的 key 进行赋值操作
     *
     * @return 移除对应 key 值的干净 bundle 对象
     */
    Bundle getMergedBundle() {
        Bundle arguments = new Bundle(getArguments());
        String[] excludedKeys = new String[]{IntentValues.SECTION_ID, IntentValues.SUB_SECTION_ID, IntentValues.SECTION_ICON,
                IntentValues.FAQ_MAIN_ID};
        outer:
        for (String excludedKey : excludedKeys) {
            Iterator<String> iterator = arguments.keySet().iterator();
            while (iterator.hasNext()) {
                String bundleKey = iterator.next();
                if (excludedKey.equals(bundleKey)) {
                    iterator.remove();
                    break outer;
                }
            }
        }
        return arguments;
    }

    public void refreshList(List<FaqListEntity> displayFaqList, String section) {
        refreshList(displayFaqList);
    }

    public void refreshList(List<FaqListEntity> displayFaqList) {

    }

    public void refreshQuestionContent(FaqContentEntity faq, String searchTerm) {
        csEntrance = get("aihelp_cs_entrance");
        if (csEntrance != null) {
            csEntrance.setup(getMergedBundle(), getFaqFlowListener(), this);
        }
    }

    void showSearchEmpty() {
        View layout = View.inflate(getContext(), ResResolver.getLayoutId("aihelp_layout_list_empty"), null);
        ImageView imageView = layout.findViewById(ResResolver.getViewId("aihelp_iv_empty"));
        TextView textView = layout.findViewById(ResResolver.getViewId("aihelp_tv_empty"));
        Styles.reRenderImageView(imageView, "aihelp_svg_ic_empty");
        Styles.reRenderTextView(textView, ResResolver.getString("aihelp_faq_search_empty"));
        super.showEmpty(layout);
    }

    @Override
    public void showEmpty(int... layoutId) {
        View layout = View.inflate(getContext(), ResResolver.getLayoutId("aihelp_layout_faq_home_empty"), null);

        ImageView imageView = layout.findViewById(ResResolver.getViewId("aihelp_iv_empty"));
        Styles.reRenderImageView(imageView, "aihelp_svg_ic_empty");

        TextView textView = layout.findViewById(ResResolver.getViewId("aihelp_tv_empty"));
        Styles.reRenderTextView(textView, ResResolver.getString("aihelp_data_not_found_msg"));

        csEntrance = layout.findViewById(ResResolver.getViewId("aihelp_cs_entrance_empty"));
        if (csEntrance != null) {
            csEntrance.setup(getMergedBundle(), getFaqFlowListener(), this);
        }

        super.showEmpty(layout);
    }

    public void showEntranceWithNotification(boolean hasUnreadMsg, boolean isMqttPush) {
        // Ensure the current page is visible before marking there are unread messages,
        // Otherwise when user chats with CS in conversation page, then come back to FAQ page,
        // there will be a new message notification which is actually not exists.
        if (isVisible()) {
            if (hasUnreadMsg) {
                TicketStatusTracker.hasUnreadMsg = true;
            } else {
                TicketStatusTracker.isTicketActive = true;
            }
            if (csEntrance != null) {
                csEntrance.updateViewVisibility(getMergedBundle(), this);
                // Open the customer service page when there are unread messages at the opening of HelpCenter.
                // Don't interrupt user's reading if the new message is pushed lively via mqtt.
                if (hasUnreadMsg && !isMqttPush) {
                    csEntrance.onIntentToCustomerService(getMergedBundle(), getFaqFlowListener(), this);
                }
            } else {
                EventBus.getDefault().post(new NewMessageArrivedEvent());
            }
        }
    }

    @Override
    public void onClick(View v) {
        if (v.getId() == ResResolver.getViewId("aihelp_cs_entrance")) {
            Bundle bundle = getArguments();
            if (bundle != null) {
                getFaqFlowListener().onIntentToCustomerService(bundle, true);
            }
        }
    }

    @Override
    protected void onTemplateResourceReady() {
        super.onTemplateResourceReady();
        EventBus.getDefault().post(new UpdateTitleEvent(
                UpdateTitleEvent.HELP_CENTER,
                CustomConfig.HelpCenter.faqNavigationBarTitleIcon,
                CustomConfig.HelpCenter.faqNavigationTitle
        ));
        EventBus.getDefault().post(new SearchViewVisibilityChangeEvent(this instanceof FaqSearchFragment));
        // 旋转屏幕后不会触发 onResume()，需要手动刷新一下才能显示客服入口
        csEntrance = get("aihelp_cs_entrance");
        if (csEntrance != null) {
            csEntrance.setup(getMergedBundle(), getFaqFlowListener(), this);
        }
    }
}
