package net.aihelp.ui.helper;

import android.view.View;

import net.aihelp.BuildConfig;
import net.aihelp.common.SpKeys;
import net.aihelp.config.AIHelpContext;
import net.aihelp.data.track.event.EventTracker;
import net.aihelp.data.track.event.utils.EventHelper;
import net.aihelp.init.AIHelpSupport;
import net.aihelp.utils.AppInfoUtil;
import net.aihelp.utils.SpUtil;
import net.aihelp.utils.TLog;
import net.aihelp.utils.ToastUtil;

public class BreakReleaseHelper implements View.OnClickListener, View.OnLongClickListener {

    private int count;

    @Override
    public void onClick(View v) {
        if (count < 7) {
            count++;
            return;
        }
        SpUtil.getInstance().put(SpKeys.TOGGLE_LOG, true);
        TLog.initLog(true);
        ToastUtil.INSTANCE.makeRawToast(AIHelpContext.getInstance().getContext(), String.format("Powered by AIHELP.NET @ %s", AIHelpSupport.getSDKVersion()));
    }


    @Override
    public boolean onLongClick(View v) {
        if (count >= 7) {
        }
        return true;
    }

    public static boolean isBreak() {
        return SpUtil.getInstance().getBoolean(SpKeys.TOGGLE_LOG) || BuildConfig.DEBUG;
    }

}
