package net.aihelp.ui.helper;

import android.os.Build;

import net.aihelp.BuildConfig;
import net.aihelp.common.API;
import net.aihelp.common.Const;
import net.aihelp.common.UserProfile;
import net.aihelp.config.AIHelpContext;
import net.aihelp.core.net.http.AIHelpRequest;
import net.aihelp.core.net.http.callback.ReqCallback;
import net.aihelp.core.util.crash.logger.AIHelpCrashLogger;
import net.aihelp.utils.AppInfoUtil;
import net.aihelp.utils.DeviceUuidFactory;

import org.json.JSONArray;
import org.json.JSONObject;

public class MessageSyncHelper {

    public static void syncLogMessage() {
        try {
            JSONArray cachedLogs = AIHelpCrashLogger.INSTANCE.getCachedLogs();
            if (cachedLogs.length() > 0) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("deviceModel", Build.MODEL);
                jsonObject.put("language", Const.ORIGINAL_LANGUAGE);
                jsonObject.put("OSVersion", Build.VERSION.RELEASE);
                jsonObject.put("gameVersion", AppInfoUtil.getAppVersion(AIHelpContext.getInstance().getContext()));
                jsonObject.put("userId", UserProfile.USER_ID);
                jsonObject.put("deviceId", DeviceUuidFactory.id(AIHelpContext.getInstance().getContext()));
                jsonObject.put("sdkVersion", BuildConfig.SDK_VERSION);
                jsonObject.put("logs", cachedLogs);
                AIHelpRequest.getInstance().requestPostByJson(API.TRACK_EXCEPTION, jsonObject, new ReqCallback<String>() {
                    @Override
                    public void onAsyncReqSuccess(String result) {
                        AIHelpCrashLogger.INSTANCE.deleteAllCachedLogs();
                    }
                });
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
