package net.aihelp.ui.preview;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.res.Configuration;
import android.os.Bundle;

import net.aihelp.common.ConfigValues;
import net.aihelp.common.CustomConfig;
import net.aihelp.common.IntentValues;
import net.aihelp.core.ui.BaseActivity;
import net.aihelp.ui.preview.data.PreviewInfo;
import net.aihelp.ui.preview.util.PreviewHelper;
import net.aihelp.ui.preview.viewer.FilePreviewer;
import net.aihelp.ui.preview.viewer.ImagePreviewer;
import net.aihelp.ui.preview.viewer.VideoPreviewer;
import net.aihelp.utils.ResResolver;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;

public class PreviewActivity extends BaseActivity {

    public static void startAct(Context context, PreviewInfo info) {
        if (context != null) {
            Intent intent = new Intent(context, PreviewActivity.class);
            intent.putExtra(IntentValues.PREVIEW_INFO, info);
            context.startActivity(intent);
        }
    }

    public static void startAct(Fragment fragment, PreviewInfo info) {
        if (fragment != null) {
            Intent intent = new Intent(fragment.getContext(), PreviewActivity.class);
            intent.putExtra(IntentValues.PREVIEW_INFO, info);
            if (info.isPicking()) {
                fragment.startActivityForResult(intent, IntentValues.REQUEST_CODE_PREVIEW);
            } else {
                fragment.startActivity(intent);
            }
        }
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        switch (CustomConfig.InitSetting.screenOrientation) {
            case ConfigValues.SCREEN_ORIENTATION_LANDSCAPE:
                setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_SENSOR_LANDSCAPE);
                break;
            case ConfigValues.SCREEN_ORIENTATION_PORTRAIT:
                setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_PORTRAIT);
                break;
            case ConfigValues.SCREEN_ORIENTATION_SENSOR:
                setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_UNSPECIFIED);
                break;
        }
        super.onCreate(savedInstanceState);
    }

    @Override
    public void initView() {
        PreviewInfo info = (PreviewInfo) getIntent().getSerializableExtra(IntentValues.PREVIEW_INFO);
        boolean prepared = PreviewHelper.prepare(this, info);
        if (prepared) {
            if (info.isImageFile()) {
                ImagePreviewer.previewImage(this, info);
            } else if (info.isVideoFile()) {
                VideoPreviewer.previewVideo(this, info);
            } else {
                FilePreviewer.previewFile(this, info);
            }
        }
    }

    @Override
    public void onConfigurationChanged(@NonNull Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (CustomConfig.InitSetting.screenOrientation == ConfigValues.SCREEN_ORIENTATION_SENSOR) {
            CustomConfig.InitSetting.isLandscape = newConfig.orientation == Configuration.ORIENTATION_LANDSCAPE;
            setContentView(ResResolver.getLayoutId("aihelp_act_preview"));
            initView();
        }
    }


    @Override
    public int getLayoutId() {
        return ResResolver.getLayoutId("aihelp_act_preview");
    }
}
