package net.aihelp.ui.preview.data;

import android.text.TextUtils;

import net.aihelp.utils.DomainSupportHelper;
import net.aihelp.utils.RegexUtil;

import java.io.Serializable;
import java.util.regex.Pattern;

public class PreviewInfo implements Serializable {

    public static final int PREVIEW_TYPE_IMAGE = 1;
    public static final int PREVIEW_TYPE_VIDEO = 2;
    public static final int PREVIEW_TYPE_FILE = 3;

    private int type;
    private String filePath;
    private String fileName;
    private long fileSize;
    private boolean isPicking;

    private PreviewInfo() {

    }

    public static PreviewInfo get(String filePath) {
        return get(filePath, "", 0, false);
    }

    public static PreviewInfo get(String filePath, String fileName) {
        return get(filePath, fileName, 0, false);
    }

    public static PreviewInfo get(String filePath, String fileName, long fileSize, boolean isPicking) {
        PreviewInfo info = new PreviewInfo();
        info.filePath = DomainSupportHelper.getAdjustedUrl(filePath);
        info.fileName = fileName;
        info.fileSize = fileSize;
        info.isPicking = isPicking;
        return preparePreviewType(info);
    }

    private static PreviewInfo preparePreviewType(PreviewInfo info) {
        String filePath = info.getFilePath();
        if (Pattern.compile(RegexUtil.ANDROID_SUPPORTED_IMAGE).matcher(filePath).matches()) {
            info.type = PREVIEW_TYPE_IMAGE;
        } else if (Pattern.compile(RegexUtil.ANDROID_SUPPORTED_VIDEO).matcher(filePath).matches()) {
            info.type = PREVIEW_TYPE_VIDEO;
        } else {
            info.type = PREVIEW_TYPE_FILE;
        }
        return info;
    }

    public int getType() {
        return type;
    }

    public String getFilePath() {
        return TextUtils.isEmpty(filePath) ? "" : filePath;
    }


    public String getFileName() {
        return TextUtils.isEmpty(fileName) ? "" : fileName;
    }

    public long getFileSize() {
        return fileSize;
    }

    public boolean isPicking() {
        return isPicking;
    }

    public boolean isImageFile() {
        return type == PREVIEW_TYPE_IMAGE;
    }

    public boolean isVideoFile() {
        return type == PREVIEW_TYPE_VIDEO;
    }

    public boolean isMediaFile() {
        return isImageFile() || isVideoFile();
    }

}
