package net.aihelp.ui.preview.viewer;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;

import net.aihelp.common.CustomConfig;
import net.aihelp.common.IntentValues;
import net.aihelp.ui.preview.data.PreviewInfo;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.ToastUtil;

public abstract class BasePreviewer {

    private static final int BYTES_FOR_1MB = 1024 * 1024;

    protected static boolean isFileSizeExceeded(Activity activity, PreviewInfo info) {
        if (activity == null || info == null) return false;
        if (info.getFileSize() > getMaxFileSize(info)) {
            fileSizeExceeded(activity, info);
            closePreviewScreen(activity);
            return true;
        }
        return false;
    }

    private static void fileSizeExceeded(Context context, PreviewInfo info) {
        long maxFileSize = getMaxFileSize(info);
        String msg = ResResolver.getString("aihelp_media_upload_err_size_android");
        try {
            ToastUtil.INSTANCE.makeRawToast(context, String.format(msg, maxFileSize / BYTES_FOR_1MB));
        } catch (Exception e) {
            ToastUtil.INSTANCE.makeRawToast(context, msg + ", < " + (maxFileSize / BYTES_FOR_1MB) + "M");
        }
    }

    private static void closePreviewScreen(Activity activity) {
        Intent intent = activity.getIntent();
        intent.removeExtra(IntentValues.PREVIEW_INFO);
        activity.setResult(Activity.RESULT_OK, intent);
        activity.finish();
    }

    private static long getMaxFileSize(PreviewInfo info) {
        int maxFileSize = BYTES_FOR_1MB;
        if (info != null) {
            switch (info.getType()) {
                case PreviewInfo.PREVIEW_TYPE_IMAGE:
                    maxFileSize = CustomConfig.UploadLimit.imageMaxSize;
                    break;
                case PreviewInfo.PREVIEW_TYPE_VIDEO:
                    maxFileSize = CustomConfig.UploadLimit.videoMaxSize;
                    break;
                case PreviewInfo.PREVIEW_TYPE_FILE:
                    maxFileSize = CustomConfig.UploadLimit.fileMaxSize;
                    break;
                default:
                    break;
            }
        }
        return maxFileSize;
    }

}
