package net.aihelp.ui.preview.viewer;

import android.app.Activity;
import android.view.View;
import android.widget.ImageView;

import net.aihelp.core.ui.glide.Glide;

import net.aihelp.common.CustomConfig;
import net.aihelp.core.util.viewer.PhotoView;
import net.aihelp.ui.preview.data.PreviewInfo;
import net.aihelp.utils.ResResolver;

public class ImagePreviewer extends BasePreviewer {

    public static void previewImage(Activity activity, PreviewInfo info) {
        if (activity == null || info == null || isFileSizeExceeded(activity, info)) return;
        PhotoView imageView = activity.findViewById(ResResolver.getViewId("aihelp_image_view"));
        imageView.setVisibility(View.VISIBLE);
        if (CustomConfig.InitSetting.isLandscape) {
            imageView.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
        } else {
            imageView.setScaleType(ImageView.ScaleType.FIT_CENTER);
        }
        if (!info.isPicking()) {
            imageView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    activity.setResult(Activity.RESULT_CANCELED, activity.getIntent());
                    activity.finish();
                }
            });
        }
        Glide.with(activity).load(info.getFilePath()).into(imageView);
    }

}
