package net.aihelp.ui.preview.viewer;

import android.app.Activity;
import android.content.res.ColorStateList;
import android.graphics.Color;
import android.media.MediaPlayer;
import android.os.Build;
import android.view.View;
import android.widget.ProgressBar;
import android.widget.VideoView;

import net.aihelp.core.ui.glide.Glide;
import net.aihelp.core.ui.glide.load.resource.drawable.GlideDrawable;
import net.aihelp.core.ui.glide.request.RequestListener;
import net.aihelp.core.ui.glide.request.target.Target;

import net.aihelp.core.util.viewer.PhotoView;
import net.aihelp.ui.preview.data.PreviewInfo;
import net.aihelp.utils.MediaUtils;
import net.aihelp.utils.ResResolver;

public class VideoPreviewer extends BasePreviewer {

    public static void previewVideo(Activity activity, PreviewInfo info) {
        if (activity == null || info == null || isFileSizeExceeded(activity, info)) return;
        PhotoView imageView = activity.findViewById(ResResolver.getViewId("aihelp_image_view"));
        ProgressBar progressBar = activity.findViewById(ResResolver.getViewId("aihelp_progress_bar"));
        VideoView videoView = activity.findViewById(ResResolver.getViewId("aihelp_video_view"));

        imageView.enableGesture(false);
        imageView.setVisibility(View.VISIBLE);
        progressBar.setVisibility(View.VISIBLE);

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            progressBar.setIndeterminateTintList(ColorStateList.valueOf(Color.WHITE));
        }
        videoView.setBackgroundColor(Color.TRANSPARENT);

        videoView.setOnPreparedListener(new MediaPlayer.OnPreparedListener() {
            @Override
            public void onPrepared(MediaPlayer mp) {
                videoView.start();
                mp.setLooping(true);
                if (Build.VERSION.SDK_INT < Build.VERSION_CODES.JELLY_BEAN_MR1) {
                    videoView.post(new Runnable() {
                        @Override
                        public void run() {
                            videoView.seekTo(0);
                            progressBar.setVisibility(View.GONE);
                            imageView.setVisibility(View.GONE);
                            videoView.setVisibility(View.VISIBLE);
                        }
                    });
                }
            }
        });
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR1) {
            videoView.setOnInfoListener(new MediaPlayer.OnInfoListener() {
                @Override
                public boolean onInfo(MediaPlayer mp, int what, int extra) {
                    if (what == MediaPlayer.MEDIA_INFO_VIDEO_RENDERING_START) {
                        videoView.seekTo(0);
                        progressBar.setVisibility(View.GONE);
                        imageView.setVisibility(View.GONE);
                        videoView.setVisibility(View.VISIBLE);
                        return true;
                    }
                    return false;
                }
            });
        }

        String imagePath = MediaUtils.getImageForVideoSync(info.getFilePath());
        videoView.setVideoPath(info.getFilePath());
        Glide.with(activity).load(imagePath).listener(new RequestListener<String, GlideDrawable>() {
            @Override
            public boolean onException(Exception e, String model, Target<GlideDrawable> target, boolean isFirstResource) {
                progressBar.setVisibility(View.VISIBLE);
                return false;
            }

            @Override
            public boolean onResourceReady(GlideDrawable resource, String model, Target<GlideDrawable> target, boolean isFromMemoryCache, boolean isFirstResource) {
                progressBar.post(new Runnable() {
                    @Override
                    public void run() {
                        videoView.setVisibility(View.VISIBLE);
                    }
                });
                return false;
            }
        }).into(imageView);

    }

}
