package net.aihelp.ui.task;

import android.os.Bundle;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import net.aihelp.common.CustomConfig;
import net.aihelp.core.ui.BaseFragment;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.data.event.SearchViewVisibilityChangeEvent;
import net.aihelp.data.event.UpdateTitleEvent;
import net.aihelp.data.logic.TaskListPresenter;
import net.aihelp.data.model.task.TaskEntity;
import net.aihelp.ui.adapter.task.TaskListAdapter;
import net.aihelp.utils.ListUtil;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

import java.util.List;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

public class TaskListFragment extends BaseFragment<TaskListPresenter> {

    private RecyclerView rvList;
    private TaskListAdapter mAdapter;
    private boolean isLoading = false;
    private int currentPage = 1;

    public static TaskListFragment newInstance(Bundle bundle) {
        TaskListFragment faqFragment = new TaskListFragment();
        faqFragment.setArguments(bundle);
        return faqFragment;
    }

    private final RecyclerView.OnScrollListener scrollListener = new RecyclerView.OnScrollListener() {
        @Override
        public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
            super.onScrolled(recyclerView, dx, dy);
            if (dx == 0 && dy == 0) return;
            LinearLayoutManager linearLayoutManager = (LinearLayoutManager) recyclerView.getLayoutManager();
            if (!isLoading) {
                if (linearLayoutManager != null && linearLayoutManager.findLastCompletelyVisibleItemPosition() == mAdapter.getTaskList().size() - 1) {
                    rvList.post(new Runnable() {
                        @Override
                        public void run() {
                            mAdapter.onLoadMore();
                            isLoading = true;
                            mPresenter.requestTaskList(++currentPage);
                        }
                    });
                }
            }
        }
    };

    @Override
    protected void getBundleBeforeDataPrepared(Bundle extras) {
        EventBus.getDefault().post(new SearchViewVisibilityChangeEvent(false));
    }

    @Override
    public void onResume() {
        super.onResume();
        EventBus.getDefault().post(new UpdateTitleEvent(UpdateTitleEvent.CUSTOM_SERVICE, null,
                ResResolver.getString("aihelp_my_task")));
    }

    @Override
    protected void initEventAndData(View view) {
        rvList = get("aihelp_rv_ticket");
        mAdapter = new TaskListAdapter();
        rvList.setAdapter(mAdapter);
        rvList.setLayoutManager(new LinearLayoutManager(getContext()));
        rvList.addOnScrollListener(scrollListener);
        mPresenter.requestTaskList(currentPage);
    }

    @Override
    protected int getLayout() {
        return ResResolver.getLayoutId("aihelp_fra_ticket_list");
    }

    @Override
    protected int getLoadingTargetViewId() {
        return ResResolver.getViewId("aihelp_rv_ticket");
    }

    public void refreshTicketList(boolean noMoreData, List<TaskEntity> list) {

        List<TaskEntity> taskList = mAdapter.getTaskList();
        if (isLoading && !ListUtil.isListEmpty(taskList)) {
            isLoading = false;
            taskList.remove(taskList.size() - 1);
            int scrollPosition = taskList.size();
            mAdapter.notifyItemRemoved(scrollPosition);
        }

        if (currentPage == 1 && ListUtil.isListEmpty(list)) {
            View layout = View.inflate(getContext(), ResResolver.getLayoutId("aihelp_layout_list_empty"), null);
            int colorFromHex = Styles.getColorWithAlpha(CustomConfig.CommonSetting.upperBackgroundColor, CustomConfig.CommonSetting.upperBackgroundAlpha);
            layout.setBackground(Styles.getDrawable(colorFromHex, 0));
            ImageView imageView = layout.findViewById(ResResolver.getViewId("aihelp_iv_empty"));
            TextView textView = layout.findViewById(ResResolver.getViewId("aihelp_tv_empty"));
            Styles.reRenderImageView(imageView, "aihelp_svg_ic_empty");
            Styles.reRenderTextView(textView, ResResolver.getString("aihelp_no_task"));
            super.showEmpty(layout);
        } else {
            mAdapter.updateStatusCount(list);
        }

        if (noMoreData) {
            rvList.removeOnScrollListener(scrollListener);
        }
    }

}
