package net.aihelp.ui.task.detail;

import android.content.Context;
import android.content.DialogInterface;
import android.text.TextUtils;
import android.view.View;
import android.view.WindowManager;
import android.widget.EditText;

import net.aihelp.common.CustomConfig;
import net.aihelp.core.ui.dialog.AlertDialog;
import net.aihelp.core.util.permission.AIHelpPermissions;
import net.aihelp.data.model.task.ReplyMessage;
import net.aihelp.ui.task.widget.ReplyInputView;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;
import net.aihelp.utils.UploadFileHelper;

import java.io.File;

public class TaskReplyComposer implements DialogInterface.OnDismissListener, ReplyInputView.OnUserInputListener {

    private AlertDialog dialog;

    private OnUserReplyListener onUserReplyListener;

    public void setOnUserReplyListener(OnUserReplyListener onUserReplyListener) {
        this.onUserReplyListener = onUserReplyListener;
    }

    public void showReplyComposer(TaskDetailFragment fragment, Context context) {
        ReplyInputView replyInputView = new ReplyInputView(context);
        replyInputView.setHostFragment(fragment);
        replyInputView.setOnUserInputListener(this);

        dialog = new AlertDialog.Builder(context)
                .setContentView(replyInputView)
                .fromBottom(true)
                .setCancelableOntheOutside(true)
                .fullWidth()
                .create();

        View container = dialog.findViewById(ResResolver.getViewId("aihelp_ll_input"));
        container.setBackgroundColor(Styles.getColorWithAlpha(CustomConfig.CommonSetting.upperBackgroundColor, 1.0f));

        dialog.getWindow().clearFlags(WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE | WindowManager.LayoutParams.FLAG_ALT_FOCUSABLE_IM);
        dialog.getWindow().setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_STATE_VISIBLE);

        dialog.setOnDismissListener(this);
        dialog.show();
    }

    @Override
    public void onDismiss(DialogInterface dialog) {
        AIHelpPermissions.getInstance().recycle();
    }

    @Override
    public void onUserSend(String input) {
        if (onUserReplyListener != null && !TextUtils.isEmpty(input)) {
            ReplyMessage replyMessage = new ReplyMessage();
            replyMessage.setReplyType(ReplyMessage.REPLY_TYPE_USER);
            replyMessage.setTimeStamp(System.currentTimeMillis());
            replyMessage.setContent(input);
            onUserReplyListener.onUserReply(replyMessage);
        }
        if (dialog != null) {
            dialog.dismiss();
        }
    }

    @Override
    public void onUserConfirmAttachment(int msgType, File file) {
        ReplyMessage fileMsg = new ReplyMessage();
        fileMsg.setReplyType(ReplyMessage.REPLY_TYPE_USER);
        fileMsg.setMsgStatus(ReplyMessage.STATUS_SENDING);
        fileMsg.setTimeStamp(System.currentTimeMillis());
        fileMsg.setContent(file.getPath());
        fileMsg.setMsgType(msgType);
        fileMsg.setFileInfo(file.getName(), file.length());
        onUserReplyListener.onUserReply(fileMsg);

        UploadFileHelper.INSTANCE.setOnUploadFileListener(new UploadFileHelper.OnUploadFileListener() {
            @Override
            public void onFileUploaded(String fileUrl) {
                boolean isUrlValid = !TextUtils.isEmpty(fileUrl);
                fileMsg.setMsgStatus(isUrlValid ? ReplyMessage.STATUS_NORMAL : ReplyMessage.STATUS_FAILURE);
                fileMsg.setContent(isUrlValid ? fileUrl : fileMsg.getContent());
                fileMsg.setMsgType(msgType);
                if (onUserReplyListener != null) {
                    onUserReplyListener.onUserReply(fileMsg);
                }
            }
        }).performUpload(file);

        if (dialog != null) {
            dialog.dismiss();
        }
    }

    public interface OnUserReplyListener {
        void onUserReply(ReplyMessage replyMessage);
    }

}
