package net.aihelp.ui.task.helper;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.ColorStateList;
import android.os.Build;
import android.text.TextUtils;
import android.util.SparseArray;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;

import net.aihelp.common.API;
import net.aihelp.common.CustomConfig;
import net.aihelp.common.UserProfile;
import net.aihelp.core.net.http.AIHelpRequest;
import net.aihelp.core.net.http.callback.ReqCallback;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.core.ui.dialog.AlertDialog;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.core.util.bus.Subscribe;
import net.aihelp.core.util.bus.ThreadMode;
import net.aihelp.core.util.bus.event.EventCenter;
import net.aihelp.data.event.OrientationChangeEvent;
import net.aihelp.data.localize.config.FeedbackOpinionHelper;
import net.aihelp.ui.cs.util.TicketStatusTracker;
import net.aihelp.ui.cs.util.viewer.EvaluateViewer;
import net.aihelp.ui.widget.AIHelpButton;
import net.aihelp.ui.widget.AIHelpRatingBar;
import net.aihelp.ui.widget.AIHelpScrollView;
import net.aihelp.ui.wrapper.TextWatcherWrapper;
import net.aihelp.ui.widget.AIHelpScrollView;
import net.aihelp.utils.AppInfoUtil;
import net.aihelp.utils.DeviceUuidFactory;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.SpUtil;
import net.aihelp.utils.Styles;
import net.aihelp.utils.ToastUtil;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

public class EvaluateTicketHelper {

    private AlertDialog rateSupportDialog;

    private LinearLayout llFeedbackLayout;
    private EditText etFeedback;

    private int selectedRateValue = 5;
    private final List<String> selectedOptionIds = new ArrayList<>();
    private String inputFeedback = "";

    public static EvaluateTicketHelper getInstance() {
        return new EvaluateTicketHelper();
    }

    public void showRateSupport(final Context context, final OnConfirmEvaluateListener listener) {
        rateSupportDialog = new AlertDialog.Builder(context)
                .setContentView(ResResolver.getLayoutId("aihelp_dia_rate_support"))
                .setGravity(Gravity.BOTTOM)
                .fromBottom(true)
                .setCancelableOntheOutside(true)
                .setOnDismissListener(new DialogInterface.OnDismissListener() {
                    @Override
                    public void onDismiss(DialogInterface dialog) {
                        EventBus.getDefault().unregister(EvaluateTicketHelper.this);
                    }
                })
                .fullWidth()
                .create();

        // 主背景
        int backgroundColor = Styles.getColorWithAlpha(CustomConfig.CommonSetting.upperBackgroundColor,
                Math.min(CustomConfig.CommonSetting.upperBackgroundAlpha + 0.6, 0.8));
        RelativeLayout rateLayout = rateSupportDialog.getView(ResResolver.getViewId("aihelp_rl_rate_layout"));
        rateLayout.setBackgroundColor(backgroundColor);

        // Title
        TextView tvTitle = rateSupportDialog.getView(ResResolver.getViewId("aihelp_tv_title"));
        Styles.reRenderTextView(tvTitle, CustomConfig.InitSetting.csInviteEvaluate);

        // Rating bar dislike text
        TextView tvRatingDislike = rateSupportDialog.getView(ResResolver.getViewId("aihelp_tv_rating_dislike"));
        Styles.reRenderTextView(tvRatingDislike, ResResolver.getString("aihelp_rate_dissatisfied"));

        // Rating bar like text
        TextView tvRatingLike = rateSupportDialog.getView(ResResolver.getViewId("aihelp_tv_rating_like"));
        Styles.reRenderTextView(tvRatingLike, ResResolver.getString("aihelp_rate_satisfied"));

        llFeedbackLayout = rateSupportDialog.getView(ResResolver.getViewId("aihelp_ll_feedback"));

        SparseArray<JSONArray> opinionArray = FeedbackOpinionHelper.INSTANCE.getOpinionArray();
        resetFeedbackOptions(context, opinionArray.get(selectedRateValue));

        AIHelpRatingBar ratingBar = rateSupportDialog.getView(ResResolver.getViewId("aihelp_rating_bar"));
        if (ratingBar != null) {
            ratingBar.setOnStatusChangedListener(new AIHelpRatingBar.OnStatusChangedListener() {
                @Override
                public void onRateStatusChanged(int newRateValue) {
                    selectedOptionIds.clear();
                    selectedRateValue = newRateValue;
                    resetFeedbackOptions(context, opinionArray.get(newRateValue));
                }
            });
        }

        AIHelpButton btnConfirm = rateSupportDialog.getView(ResResolver.getViewId("aihelp_btn_confirm"));
        btnConfirm.setText(ResResolver.getString("aihelp_yes")).setFullWidth();
        btnConfirm.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (AppInfoUtil.validateNetwork(v.getContext())) {
                    showThanksAfterEvaluate(context, selectedRateValue == 5);
                    rateSupportDialog.dismiss();
                    onConfirmEvaluate(context, listener);
                }
            }
        });

        rateSupportDialog.show();

        EventBus.getDefault().register(EvaluateTicketHelper.this);
    }

    private void onConfirmEvaluate(Context context, OnConfirmEvaluateListener listener) {
        if (listener != null) {
            String input = "";
            if (etFeedback != null) {
                input = etFeedback.getText().toString();
            }
            try {
                StringBuilder selectedIds = new StringBuilder();
                StringBuilder content = new StringBuilder();

                JSONArray options = FeedbackOpinionHelper.INSTANCE.getOpinionArray().get(selectedRateValue);
                for (int i = 0; i < selectedOptionIds.size(); i++) {
                    String id = selectedOptionIds.get(i);
                    for (int j = 0; j < options.length(); j++) {
                        JSONObject object = JsonHelper.getJsonObject(options, j);
                        if (id.equals(JsonHelper.optString(object, "id"))) {
                            selectedIds.append(id).append(",");
                            content.append(JsonHelper.optString(object, "msg")).append(",");
                        }
                    }
                }
                if (!TextUtils.isEmpty(input)) {
                    content.append("\r\n").append(input);
                }

                if (!AppInfoUtil.isNetworkAvailable(context)) {
                    Toast.makeText(context, ResResolver.getString("aihelp_network_no_connect"), Toast.LENGTH_SHORT).show();
                    return;
                }
                listener.onConfirmEvaluate(selectedRateValue, selectedIds.toString(), content.toString());
            } catch (Exception e) {
                // ignored
            }
        }
    }

    private void resetFeedbackOptions(Context context, JSONArray options) {
        AIHelpScrollView scrollView = rateSupportDialog.findViewById(ResResolver.getViewId("aihelp_scroll_view"));
        scrollView.updateMaxHeight();

        if (CustomConfig.InitSetting.isEvaluateBadServiceEnable) {
            if (Styles.isLandscape()) {
                prepareFeedbackForLandscape(context, options);
            } else {
                prepareFeedbackForPortrait(context, options);
            }
        }
    }

    private void prepareFeedbackForPortrait(Context context, JSONArray options) {
        llFeedbackLayout.removeAllViews();
        if (options != null && options.length() > 0) {
            for (int i = 0; i < options.length(); i++) {
                llFeedbackLayout.addView(getFeedbackOptionItem(context, JsonHelper.getJsonObject(options, i)));
            }
            prepareFeedbackInput(context);
        }
    }

    private void prepareFeedbackForLandscape(Context context, JSONArray options) {
        llFeedbackLayout.removeAllViews();
        if (options != null && options.length() > 0) {
            for (int i = 0; i < options.length(); i += 2) {
                View previousView = getFeedbackOptionItem(context, JsonHelper.getJsonObject(options, i));
                View afterwardsView = null;
                if (i + 1 < options.length()) {
                    afterwardsView = getFeedbackOptionItem(context, JsonHelper.getJsonObject(options, i + 1));
                }

                LinearLayout linearLayout = new LinearLayout(context);
                linearLayout.setOrientation(LinearLayout.HORIZONTAL);
                linearLayout.addView(previousView);
                if (afterwardsView != null) {
                    linearLayout.addView(afterwardsView);
                }
                llFeedbackLayout.addView(linearLayout);
            }
            prepareFeedbackInput(context);
        }
    }

    private void prepareFeedbackInput(Context context) {
        View view = View.inflate(context, ResResolver.getLayoutId("aihelp_layout_feedback_input"), null);
        view.setBackground(Styles.getDrawable(Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, 0.1f), 8));
        ViewGroup.MarginLayoutParams marginLayoutParams = new ViewGroup.MarginLayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        marginLayoutParams.topMargin = Styles.dpToPx(context, 10);
        view.setLayoutParams(marginLayoutParams);

        etFeedback = view.findViewById(ResResolver.getViewId("aihelp_et_feedback_input"));
        Styles.reRenderTextView(etFeedback, ResResolver.getString("aihelp_rate_additional_feedback_message"));

        TextView tvMaxLength = view.findViewById(ResResolver.getViewId("aihelp_tv_max_length"));
        Styles.reRenderTextView(tvMaxLength, "0/500", Styles.getColor(CustomConfig.CommonSetting.textColor));
        etFeedback.addTextChangedListener(new TextWatcherWrapper() {
            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
                tvMaxLength.setText(String.format("%s/%s", s.length(), 500));
            }
        });
        etFeedback.setMaxHeight(Styles.dpToPx(context, 120));

        if (!TextUtils.isEmpty(inputFeedback)) {
            etFeedback.setText(inputFeedback);
        }

        llFeedbackLayout.addView(view);
    }

    /**
     * 横屏下：选项分为两列显示 + 最后一个输入框，竖屏下：选项单列显示 + 最后一个输入框
     */
    private View getFeedbackOptionItem(Context context, JSONObject opinion) {
        CheckBox checkBox = (CheckBox) View.inflate(context, ResResolver.getLayoutId("aihelp_layout_feedback_option"), null);

        String id = JsonHelper.optString(opinion, "id");
        String msg = JsonHelper.optString(opinion, "msg");
        Styles.reRenderTextView(checkBox, msg);

        // 在设置监听之前设置勾选（可能是因为屏幕旋转出现的），否则会导致数据重复
        for (int i = 0; i < selectedOptionIds.size(); i++) {
            if (id.equals(selectedOptionIds.get(i))) {
                checkBox.setChecked(true);
                break;
            }
        }

        checkBox.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                if (isChecked) {
                    selectedOptionIds.add(JsonHelper.optString(opinion, "id"));
                } else {
                    selectedOptionIds.remove(JsonHelper.optString(opinion, "id"));
                }

                // 选项数量超过最大值后取消勾选
                // 使用 onCheckedChangedListener 的副作用，需要先添加到集合里，判断不符合条件后再取消
                if (selectedOptionIds.size() > CustomConfig.InitSetting.csEvaluateMaxCount) {
                    buttonView.setChecked(false);
                    selectedOptionIds.remove(JsonHelper.optString(opinion, "id"));
                    ToastUtil.INSTANCE.makeRawToast(buttonView.getContext(), String.format(ResResolver.getString("aihelp_select_max_options_android"), CustomConfig.InitSetting.csEvaluateMaxCount));
                }
            }
        });

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            ColorStateList colorStateList = new ColorStateList(
                    new int[][]{new int[]{-android.R.attr.state_checked}, new int[]{android.R.attr.state_checked}},
                    new int[]{Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, 0.1f),
                            Styles.getColor(CustomConfig.CommonSetting.interactElementTextColor)}
            );
            checkBox.setButtonTintList(colorStateList);
        }

        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        params.weight = 1;
        checkBox.setLayoutParams(params);

        return checkBox;
    }

    private void showThanksAfterEvaluate(final Context context, boolean isFiveStar) {
        AlertDialog showThanksDialog = new AlertDialog.Builder(context)
                .setContentView(ResResolver.getLayoutId("aihelp_dia_show_thanks"))
                .setGravity(Gravity.BOTTOM)
                .fromBottom(true)
                .setCancelableOntheOutside(true)
                .setWidthAndHeight(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT)
                .create();

        View rlShowThanks = showThanksDialog.getView(ResResolver.getViewId("aihelp_rl_show_thanks"));
        int backgroundColor = Styles.getColorWithAlpha(CustomConfig.CommonSetting.upperBackgroundColor,
                Math.min(CustomConfig.CommonSetting.upperBackgroundAlpha + 0.6f, 0.8f));
        rlShowThanks.setBackgroundColor(backgroundColor);

        TextView tvTitle = showThanksDialog.getView(ResResolver.getViewId("aihelp_tv_thanks"));
        Styles.reRenderTextView(tvTitle, ResResolver.getString("aihelp_rate_finished"));

        showThanksDialog.show();
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onEventComing(EventCenter event) {
        if (event instanceof OrientationChangeEvent && etFeedback != null) {
            inputFeedback = etFeedback.getText().toString();
            SparseArray<JSONArray> opinionArray = FeedbackOpinionHelper.INSTANCE.getOpinionArray();
            resetFeedbackOptions(etFeedback.getContext(), opinionArray.get(selectedRateValue));
        }
    }

    public interface OnConfirmEvaluateListener {
        boolean onConfirmEvaluate(int rate, String selectedId, String content);
    }

}
