package net.aihelp.ui.task.widget;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.view.View;

import net.aihelp.common.CustomConfig;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.core.util.permission.IPermissionCallback;
import net.aihelp.core.util.permission.Permission;
import net.aihelp.core.util.permission.RequestAlertHelper;
import net.aihelp.data.attachment.AttachmentPicker;
import net.aihelp.data.attachment.IAttachmentPickerListener;
import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.data.model.task.ReplyMessage;
import net.aihelp.ui.cs.bottom.BottomManualInputView;
import net.aihelp.ui.widget.snackbar.Snackbar;
import net.aihelp.utils.RegexUtil;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;
import net.aihelp.utils.ToastUtil;

import java.io.File;

import androidx.fragment.app.Fragment;

public class ReplyInputView extends BottomManualInputView implements IAttachmentPickerListener {

    private Fragment hostFragment;
    private OnUserInputListener listener;

    public void setHostFragment(Fragment hostFragment) {
        this.hostFragment = hostFragment;
    }

    public void setOnUserInputListener(OnUserInputListener listener) {
        this.listener = listener;
    }

    @Override
    public Fragment getHostFragment() {
        return hostFragment;
    }

    public ReplyInputView(Context context) {
        super(context);
        if (vToolsLayout != null) {
            vToolsLayout.setBackgroundColor(Styles.getColorWithAlpha(CustomConfig.CommonSetting.upperBackgroundColor,
                    CustomConfig.CommonSetting.upperBackgroundAlpha));
        }
        setPadding(0, 0, 0, Styles.dpToPx(context, 10));
    }

    @Override
    public void onClick(View v) {
        super.onClick(v);
        if (v.getId() == ResResolver.getViewId("aihelp_btn_send")) {
            String input = etInput.getText().toString().trim();
            if (listener != null) {
                listener.onUserSend(input);
            }
            etInput.setText("");
        }
    }

    @Override
    protected void requestPermission(int attachmentType) {
        requestPermission(Permission.REQUEST_CODE_TASK_CENTER, attachmentType);
    }

    @Permission(requestCode = Permission.REQUEST_CODE_TASK_CENTER)
    private void onPermissionResult(Permission.Result result, IPermissionCallback callback, int requestType) {
        switch (result) {
            case GRANTED:
            case NONE:
                AttachmentPicker.INSTANCE.setPickerHost(hostFragment).setAttachmentPickerListener(this).launchPicker(requestType);
                break;
            case DENIED:
            case RATIONAL:
            case GO_SETTING:
                RequestAlertHelper.showPermissionDeniedAlert(getContext(), result, callback);
                break;
            default:
                break;
        }
    }

    @Override
    protected int getMsgTypeByPath(String filePath) {
        if (CustomConfig.UploadLimit.isImageEnableUploading && RegexUtil.isMatch(filePath, RegexUtil.AIHELP_SUPPORTED_IMAGE)) {
            if (RegexUtil.isMatch(filePath, RegexUtil.ANDROID_SUPPORTED_IMAGE)) {
                return ReplyMessage.MSG_TYPE_IMAGE;
            } else {
                return ReplyMessage.MSG_TYPE_FILE;
            }
        }
        if (CustomConfig.UploadLimit.isVideoEnableUploading && RegexUtil.isMatch(filePath, RegexUtil.AIHELP_SUPPORTED_VIDEO)) {
            if (RegexUtil.isMatch(filePath, RegexUtil.ANDROID_SUPPORTED_VIDEO)) {
                return ReplyMessage.MSG_TYPE_VIDEO;
            } else {
                return ReplyMessage.MSG_TYPE_FILE;
            }
        }
        // upload file as file type, but with no file style is not correct
        // upload file as url is fine, but what the UI would be like when the file is uploading?
        if (CustomConfig.UploadLimit.isFileEnableUploading && isSupportedFileType(filePath)) {
            return ReplyMessage.MSG_TYPE_FILE;
        }
        return -1;
    }

    @Override
    protected void onMessageTypeConfirmed(int msgType, File file) {
        if (file != null && listener != null) {
            listener.onUserConfirmAttachment(msgType, file);
        }
    }

    @SuppressLint("MissingSuperCall")
    @Override
    protected void onDetachedFromWindow() {
        // ignore super
        EventBus.getDefault().unregister(this);
    }

    public interface OnUserInputListener {
        void onUserSend(String input);

        void onUserConfirmAttachment(int msgType, File file);
    }

}
