package net.aihelp.ui.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import net.aihelp.common.CustomConfig;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.core.util.bus.Subscribe;
import net.aihelp.core.util.bus.ThreadMode;
import net.aihelp.data.event.TemplateReadyEvent;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;
import net.aihelp.utils.TLog;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public class AIHelpFakeSearch extends LinearLayout {

    public AIHelpFakeSearch(Context context) {
        this(context, null);
    }

    public AIHelpFakeSearch(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AIHelpFakeSearch(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);

        View.inflate(context, ResResolver.getLayoutId("aihelp_layout_fake_search"), this);

        View rootLayout = findViewById(ResResolver.getViewId("aihelp_ll_search"));
        rootLayout.setBackground(Styles.getDrawable(Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, 0.1), 999));

        ImageView imageView = findViewById(ResResolver.getViewId("aihelp_iv_search"));
        Styles.reRenderImageView(imageView, "aihelp_svg_ic_search_grey",
                Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, 0.5f));

        TextView textView = findViewById(ResResolver.getViewId("aihelp_tv_search_hint"));
        textView.setText(CustomConfig.HelpCenter.faqSearchHint);
        textView.setTextColor(Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, 0.35f));

    }

    public void update(boolean isFeedbackVisible) {
        if (Styles.isLandscape() && isFeedbackVisible) {
            ViewGroup.LayoutParams layoutParams = getLayoutParams();
            layoutParams.width = Styles.dpToPx(getContext(), 36);
        }
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        EventBus.getDefault().register(this);
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        EventBus.getDefault().unregister(this);
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onTemplateReady(TemplateReadyEvent templateReadyEvent) {
        View rootLayout = findViewById(ResResolver.getViewId("aihelp_ll_search"));
        rootLayout.setBackground(Styles.getDrawable(Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, 0.1), 999));

        ImageView imageView = findViewById(ResResolver.getViewId("aihelp_iv_search"));
        Styles.reRenderImageView(imageView, "aihelp_svg_ic_search_grey",
                Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, 0.5f));

        TextView textView = findViewById(ResResolver.getViewId("aihelp_tv_search_hint"));
        textView.setText(CustomConfig.HelpCenter.faqSearchHint);
        textView.setTextColor(Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, 0.35f));
    }

}
