package net.aihelp.ui.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.widget.ScrollView;

import net.aihelp.utils.Styles;

public class AIHelpScrollView extends ScrollView {

    private int maxHeight;

    public AIHelpScrollView(Context context) {
        this(context, null);
    }

    public AIHelpScrollView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AIHelpScrollView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public int getMaxHeight() {
        return maxHeight;
    }

    public void setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (maxHeight > 0) {
            heightMeasureSpec = MeasureSpec.makeMeasureSpec(maxHeight, MeasureSpec.AT_MOST);
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    public void updateMaxHeight() {
        float factor = Styles.isLandscape() ? 0.075f : 0.5f;
        if (Styles.isLandscape()) {
            maxHeight = (int) (Styles.getScreenWidth(getContext()) * factor);
        } else {
            maxHeight = (int) (Styles.getScreenHeight(getContext()) * factor);
        }
        invalidate();
    }

}
