package net.aihelp.ui.widget;

import android.content.Context;
import android.graphics.Color;
import android.os.Bundle;
import android.util.AttributeSet;
import android.view.View;
import android.widget.RelativeLayout;

import net.aihelp.common.ConfigValues;
import net.aihelp.common.CustomConfig;
import net.aihelp.common.IntentValues;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.core.util.bus.Subscribe;
import net.aihelp.core.util.bus.ThreadMode;
import net.aihelp.core.util.bus.event.EventCenter;
import net.aihelp.data.event.NewMessageArrivedEvent;
import net.aihelp.data.track.event.EventTracker;
import net.aihelp.data.track.event.utils.EventType;
import net.aihelp.data.track.statistic.StatisticTracker;
import net.aihelp.ui.faq.BaseFaqFragment;
import net.aihelp.ui.faq.FaqContentFragment;
import net.aihelp.ui.faq.FaqHomeFragment;
import net.aihelp.ui.faq.FaqListFragment;
import net.aihelp.ui.faq.IFaqEventListener;
import net.aihelp.ui.cs.util.TicketStatusTracker;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public class AIHelpServiceEntrance extends RelativeLayout {

    View vNotification;

    public AIHelpServiceEntrance(@NonNull Context context) {
        this(context, null);
    }

    public AIHelpServiceEntrance(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AIHelpServiceEntrance(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);

        View.inflate(context, ResResolver.getLayoutId("aihelp_layout_service_entrance"), this);

        AIHelpButton tvEntrance = findViewById(ResResolver.getViewId("aihelp_tv_entrance"));
        tvEntrance.setText(CustomConfig.HelpCenter.faqCSEntranceText);

        vNotification = findViewById(ResResolver.getViewId("aihelp_v_unread_status"));
        vNotification.setBackground(Styles.getDrawable(Color.parseColor("#FF4747"), 999));
        vNotification.setVisibility(GONE);

        updateEntranceStatus(false, false);
    }

    public void setup(Bundle bundle, IFaqEventListener faqEventListener, BaseFaqFragment faqFragment) {
        if (bundle != null && faqEventListener != null) {
            updateViewVisibility(bundle, faqFragment);
            updateViewClickEvent(bundle, faqEventListener, faqFragment);
        }
    }

    public void updateViewVisibility(Bundle bundle, BaseFaqFragment faqFragment) {
        if (TicketStatusTracker.hasUnreadMsg) {
            updateEntranceStatus(true, true);
        } else if (TicketStatusTracker.isTicketActive) {
            updateEntranceStatus(true, false);
        } else {
            if (bundle != null && faqFragment != null) {
                String entrances = bundle.getString(IntentValues.FAQ_SUPPORT_MOMENT, "");
                boolean visibleInFaqHome = faqFragment instanceof FaqHomeFragment && entrances.contains(ConfigValues.FAQ_SUPPORT_ENTRANCE_HOME_PAGE);
                boolean visibleInFaqList = faqFragment instanceof FaqListFragment && entrances.contains(ConfigValues.FAQ_SUPPORT_ENTRANCE_QUESTION_LIST);
                boolean visibleInFaqContent = faqFragment instanceof FaqContentFragment && entrances.contains(ConfigValues.FAQ_SUPPORT_ENTRANCE_ANSWER_PAGE);
                updateEntranceStatus(visibleInFaqHome || visibleInFaqList || visibleInFaqContent, false);
            }
        }
    }

    private void updateEntranceStatus(boolean entranceVisible, boolean notificationVisible) {
        if (entranceVisible) {
            setVisibility(View.VISIBLE);
            vNotification.setVisibility(notificationVisible ? VISIBLE : GONE);
        } else {
            setVisibility(View.GONE);
        }
    }

    private void updateViewClickEvent(Bundle bundle, IFaqEventListener faqEventListener, BaseFaqFragment faqFragment) {
        setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                onIntentToCustomerService(bundle, faqEventListener, faqFragment);
            }
        });
    }

    public void onIntentToCustomerService(Bundle bundle, IFaqEventListener faqEventListener, BaseFaqFragment faqFragment) {
        if (bundle != null && faqEventListener != null && faqFragment != null) {
            updateEntranceStatus(true, false);
            faqEventListener.onIntentToCustomerService(bundle, true);

            String faqContentVisitId = "";
            if (faqFragment instanceof FaqContentFragment) {
                FaqContentFragment faqContentFragment = (FaqContentFragment) faqFragment;
                faqContentVisitId = faqContentFragment.hashCode() + "";
            }
            StatisticTracker.getInstance().clickServiceEntrance(faqContentVisitId);
            EventTracker.INSTANCE.log(EventType.HC_ACTION_CHECK_CUSTOMER_SERVICE);
        }
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        EventBus.getDefault().register(this);
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        EventBus.getDefault().unregister(this);
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onEventComing(EventCenter event) {
        if (event instanceof NewMessageArrivedEvent) {
            updateViewVisibility(null, null);
        }
    }

}
