package net.aihelp.ui.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.RelativeLayout;
import android.widget.TextView;

import net.aihelp.common.CustomConfig;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

public class AIHelpTaskCenterEntrance extends RelativeLayout {

    private TextView tvEntrance;
    private View unreadDot;

    public AIHelpTaskCenterEntrance(Context context) {
        this(context, null);
    }

    public AIHelpTaskCenterEntrance(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AIHelpTaskCenterEntrance(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);

        View rootView = View.inflate(context, ResResolver.getLayoutId("aihelp_layout_task_entrance"), this);
        tvEntrance = rootView.findViewById(ResResolver.getViewId("aihelp_tv_entrance"));
        unreadDot = rootView.findViewById(ResResolver.getViewId("aihelp_v_unread_status"));

        tvEntrance.setTextColor(Styles.getClickableTextColor(CustomConfig.CommonSetting.textColor));
        unreadDot.setBackground(Styles.getDrawable(Styles.getColor(CustomConfig.CommonSetting.highlightedColor), 999));

    }

    public void updateUnreadStatus(boolean isUnread) {
        unreadDot.setVisibility(isUnread ? VISIBLE : GONE);
    }

    public void updateMaxWidth(int titleRight) {
        int maxWidth = Styles.getScreenWidth(getContext())
                - titleRight
                - Styles.dpToPx(getContext(), 15 * 2);
        if (Styles.isLandscape()) {
            maxWidth = maxWidth - Styles.dpToPx(getContext(), 36);
        }
        tvEntrance.setMaxWidth(maxWidth);
    }

}
