package net.aihelp.utils;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;

import net.aihelp.common.Const;

import androidx.annotation.RestrictTo;

@RestrictTo(RestrictTo.Scope.LIBRARY)
public class AppInfoUtil {

    public static String getAppName(Context context) {
        String appName = null;
        try {
            PackageManager pm = context.getPackageManager();
            ApplicationInfo ai = context.getApplicationInfo();
            appName = pm.getApplicationLabel(ai).toString();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return appName == null ? "AIHelp" : appName;
    }

    public static String getAppVersion(Context context) {
        if (context == null) return "Context is null!";
        String appVersion = null;
        try {
            String packageName = context.getPackageName();
            PackageInfo p = context.getPackageManager().getPackageInfo(packageName, 0);
            appVersion = p.versionName;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return appVersion;
    }

    public static Intent getLaunchIntent(Context context, String packageName) {
        Intent launchIntentForPackage = null;
        try {
            PackageManager pm = context.getPackageManager();
            launchIntentForPackage = pm.getLaunchIntentForPackage(packageName);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return launchIntentForPackage;
    }

    public static void goRateApp(Context context) {
        Intent intent = new Intent(Intent.ACTION_VIEW);
        intent.setData(Uri.parse("market://details?id=" + context.getPackageName()));
        if (intent.resolveActivity(context.getPackageManager()) != null) { //可以接收
            context.startActivity(intent);
        } else {
            intent.setData(Uri.parse("https://play.google.com/store/apps/details?id=" + context.getPackageName()));
            if (intent.resolveActivity(context.getPackageManager()) != null) { //有浏览器
                context.startActivity(intent);
            }
        }
    }

    @SuppressLint("QueryPermissionsNeeded")
    public static boolean isUrlStillNeedResponding(Context context, String url) {
        if (TextUtils.isEmpty(url) || !validateNetwork(context)) {
            return false;
        }
        if (url.contains("js-bridge=enable") && Const.sOnSpecificUrlClickedListener != null) {
            if (FastClickValidator.validate(0.5f)) {
                Const.sOnSpecificUrlClickedListener.onSpecificUrlClicked(url);
            }
            return false;
        }
        if (context != null && !url.startsWith("http")) {
            openWithBrowser(context, url);
            return false;
        }
        return true;
    }

    public static void openWithBrowser(Context context, String url) {
        if (RegexUtil.isLocalFile(url)) return;
        try {
            Uri uri = Uri.parse(url);
            Intent intent = new Intent(Intent.ACTION_VIEW, uri);
            if (intent.resolveActivity(context.getPackageManager()) != null) {
                if (context instanceof Activity) {
                    context.startActivity(intent);
                } else {
                    intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                    context.getApplicationContext().startActivity(intent);
                }
            } else {
                intent = Intent.parseUri(url, Intent.URI_INTENT_SCHEME);
                if (intent != null) {
                    intent.addCategory(Intent.CATEGORY_BROWSABLE);
                    intent.setComponent(null);
                    intent.setSelector(null);
                    PackageManager packageManager = context.getPackageManager();
                    ResolveInfo info = packageManager.resolveActivity(intent, PackageManager.MATCH_DEFAULT_ONLY);
                    if (info != null) {
                        context.startActivity(intent);
                    }
                }
            }
        } catch (Exception e) {
            // ignored
        }
    }

    public static boolean isNetworkAvailable(Context context) {
        if (context == null) return true;

        Context applicationContext = context.getApplicationContext();
        ConnectivityManager connectivityManager = (ConnectivityManager) applicationContext.getSystemService(Context.CONNECTIVITY_SERVICE);
        if (connectivityManager == null) {
            return false;
        }

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            Network network = connectivityManager.getActiveNetwork();
            if (network == null) {
                return false;
            }
            NetworkCapabilities capabilities = connectivityManager.getNetworkCapabilities(network);
            return capabilities != null &&
                    (capabilities.hasCapability(NetworkCapabilities.NET_CAPABILITY_INTERNET) ||
                            capabilities.hasTransport(NetworkCapabilities.TRANSPORT_CELLULAR) ||
                            capabilities.hasTransport(NetworkCapabilities.TRANSPORT_WIFI) ||
                            capabilities.hasTransport(NetworkCapabilities.TRANSPORT_ETHERNET) ||
                            capabilities.hasTransport(NetworkCapabilities.TRANSPORT_VPN));
        } else {
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            return networkInfo != null && networkInfo.isConnected();
        }
    }

    public static boolean validateNetwork(Context context) {
        boolean isAvailable = isNetworkAvailable(context);
        if (!isAvailable) {
            ToastUtil.INSTANCE.makeRawToast(context, ResResolver.getString("aihelp_network_no_connect"));
        }
        return isAvailable;
    }
}
