package net.aihelp.utils;

import android.text.TextUtils;

import net.aihelp.common.API;
import net.aihelp.common.Const;
import net.aihelp.config.enums.PublishCountryOrRegion;
import net.aihelp.ui.helper.BreakReleaseHelper;

import java.util.Locale;

public class DomainSupportHelper {

    /**
     * Replace hostname 'aihelp.net' with 'aihelp.net.cn' or 'aihelp.net.in'.
     */
    public static String getAdjustedUrl(String originUrl) {
        if (Const.countryOrRegion != null) {
            String adjustedDomain = API.HOST_URL.substring(API.HOST_URL.indexOf(".") + 1);
            if (!originUrl.contains(adjustedDomain)) {
                return originUrl.replace("aihelp.net", adjustedDomain);
            }
        }
        return originUrl;
    }

    /**
     * Note: Adding .cn/.in suffix can only be applied to 'aihelp.net', not 'aihelpcn.net'.
     */
public static String getOptimizedDomain(String domain) {
    String updatedDomain = domain.replace("https://", "").replace("http://", "");
    if (updatedDomain.endsWith("aihelp.net")) {
        if (Const.countryOrRegion == null) {
            if (isSpecificCountryOrRegion("CN")) {
                Const.countryOrRegion = PublishCountryOrRegion.CN;
            } else if (isSpecificCountryOrRegion("IN")) {
                Const.countryOrRegion = PublishCountryOrRegion.IN;
            }
        }
        if (Const.countryOrRegion == PublishCountryOrRegion.CN) {
            updatedDomain = updatedDomain + ".cn";
        } else if (Const.countryOrRegion == PublishCountryOrRegion.IN) {
            updatedDomain = updatedDomain + ".in";
        }
    }
    return updatedDomain;
}

    private static boolean isSpecificCountryOrRegion(String target) {
        if (!BreakReleaseHelper.isBreak() && !TextUtils.isEmpty(target)) {
            String country = Locale.getDefault().getCountry();
            String simCountryIso = DeviceInfoUtil.getInstance().getSimCountryIso();
            return target.equalsIgnoreCase(country) || target.equalsIgnoreCase(simCountryIso);
        }
        return false;
    }
}
