package net.aihelp.utils;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;

import net.aihelp.config.AIHelpContext;
import net.aihelp.core.util.concurrent.ApiExecutorFactory;
import net.aihelp.ui.widget.snackbar.Snackbar;

import java.util.WeakHashMap;

import androidx.annotation.RestrictTo;

@RestrictTo(RestrictTo.Scope.LIBRARY)
public enum ToastUtil {

    INSTANCE;

    private Toast toast;
    private Snackbar snackbar;

    public void makeRawToast(Context context, String text) {
        ApiExecutorFactory.getHandlerExecutor().runOnUiThread(new Runnable() {
            @Override
            public void run() {
                try {
                    if (toast != null) {
                        toast.setView(null);
                        toast.setText(text);
                    } else {
                        toast = Toast.makeText(context.getApplicationContext(), text, Toast.LENGTH_SHORT);
                    }
                    toast.show();
                } catch (Exception e) {
                    Toast.makeText(context.getApplicationContext(), text, Toast.LENGTH_SHORT).show();
                }
            }
        });
    }

    public void makeText(Context context, String text, boolean isLong) {
        ApiExecutorFactory.getHandlerExecutor().runOnUiThread(new Runnable() {
            @Override
            public void run() {
                try {
                    View mView = LayoutInflater.from(context).inflate(ResResolver.getLayoutId("aihelp_toast_center_view"), null);
                    TextView textView = mView.findViewById(ResResolver.getViewId("aihelp_toast_txt"));
                    textView.setText(text);

                    if (toast != null) {
                        textView.setText(text);
                    } else {
                        toast = Toast.makeText(context.getApplicationContext(), text, isLong ? Toast.LENGTH_LONG : Toast.LENGTH_SHORT);
                    }

                    toast.setView(mView);
                    toast.setGravity(Gravity.CENTER, 0, 0);
                    toast.show();
                } catch (Exception e) {
                    // e.printStackTrace();
                    Toast.makeText(context.getApplicationContext(), text, Toast.LENGTH_SHORT).show();
                }
            }
        });
    }

    public void makeTextWithIcon(Context context, String text, boolean isLong) {
        ApiExecutorFactory.getHandlerExecutor().runOnUiThread(new Runnable() {
            @Override
            public void run() {
                try {
                    View mView = LayoutInflater.from(context).inflate(ResResolver.getLayoutId("aihelp_toast_network_fine"), null);
                    TextView textView = mView.findViewById(ResResolver.getViewId("aihelp_toast_txt"));
                    textView.setText(text);

                    if (toast != null) {
                        textView.setText(text);
                    } else {
                        toast = Toast.makeText(context.getApplicationContext(), text, isLong ? Toast.LENGTH_LONG : Toast.LENGTH_SHORT);
                    }

                    toast.setView(mView);
                    toast.setGravity(Gravity.CENTER, 0, 0);
                    toast.show();
                } catch (Exception e) {
                    // e.printStackTrace();
                    Toast.makeText(context.getApplicationContext(), text, Toast.LENGTH_SHORT).show();
                }
            }
        });
    }

    private final WeakHashMap<View, Snackbar> viewToSnackBarMapping = new WeakHashMap();

    public void showSnackBar(View view, String message, boolean isLong) {
        ApiExecutorFactory.getHandlerExecutor().runOnUiThread(new Runnable() {
            @Override
            public void run() {
                try {
                    if (message != null && message.length() != 0) {
                        if (view != null) {
                            snackbar = Snackbar.make(view, message, isLong ? Snackbar.LENGTH_LONG : Snackbar.LENGTH_SHORT);
                            snackbar.show();

                            viewToSnackBarMapping.put(view, snackbar);
                        } else {
                            makeText(AIHelpContext.getInstance().getContext(), message, false);
                        }
                    }
                } catch (Exception e) {
                    // e.printStackTrace();
                }
            }
        });
    }

    public void hideSnackBar(View view) {
        ApiExecutorFactory.getHandlerExecutor().runOnUiThread(new Runnable() {
            @Override
            public void run() {
                try {
                    if (view != null) {
                        Snackbar snackbar = viewToSnackBarMapping.get(view);
                        if (snackbar != null && snackbar.isShown()) {
                            snackbar.dismiss();
                        }
                        viewToSnackBarMapping.remove(view);
                    }
                } catch (Exception e) {
                    // e.printStackTrace();
                }
            }
        });
    }

    public void showSnackBar(Activity activity, String message, boolean isLong) {
        ApiExecutorFactory.getHandlerExecutor().runOnUiThread(new Runnable() {
            @Override
            public void run() {
                try {
                    if (snackbar != null && snackbar.isShown()) return;
                    if (message != null && message.length() != 0) {
                        Snackbar snackbar = Snackbar.make(activity.getWindow().getDecorView().findViewById(android.R.id.content),
                                message, isLong ? Snackbar.LENGTH_LONG : Snackbar.LENGTH_SHORT);
                        View snackBarView = snackbar.getView();
                        snackBarView.setBackgroundColor(Color.WHITE);
                        ((TextView) snackBarView.findViewById(ResResolver.getViewId("snackbar_text"))).setTextColor(Color.parseColor("#1B8AFA"));
                        snackbar.setActionTextColor(Color.parseColor("#1B8AFA"));
                        snackbar.show();
                    }
                } catch (Exception e) {
                    // e.printStackTrace();
                }
            }
        });
    }

    public void showSnackBar(Activity activity, String message, String action, View.OnClickListener listener) {
        ApiExecutorFactory.getHandlerExecutor().runOnUiThread(new Runnable() {
            @Override
            public void run() {
                try {
                    if (message != null && message.length() != 0) {
                        snackbar = Snackbar.make(activity.getWindow().getDecorView().findViewById(android.R.id.content),
                                message, Snackbar.LENGTH_LONG).setAction(action, listener);
                        View snackBarView = snackbar.getView();
                        snackBarView.setBackgroundColor(Color.parseColor("#EFF1F6"));
                        ((TextView) snackBarView.findViewById(ResResolver.getViewId("snackbar_text"))).setTextColor(Color.parseColor("#1B8AFA"));
                        snackbar.setActionTextColor(Color.parseColor("#1B8AFA"));
                        snackbar.show();
                    }
                } catch (Exception e) {
                    // e.printStackTrace();
                }
            }
        });
    }

    public void showRawSnackBar(Activity activity, String message, int duration) {
        ApiExecutorFactory.getHandlerExecutor().runOnUiThread(new Runnable() {
            @Override
            public void run() {
                try {
                    if (message != null && message.length() != 0) {
                        if (activity != null) {
                            View contentView = activity.getWindow().getDecorView().findViewById(android.R.id.content);
                            Snackbar.make(contentView, message, duration).show();
                        } else {
                            makeText(AIHelpContext.getInstance().getContext(), message, false);
                        }
                    }
                } catch (Exception e) {
                    // ignored
                }
            }
        });
    }

    public void showRawSnackBar(Activity activity, String message, String action, int duration, View.OnClickListener listener) {
        ApiExecutorFactory.getHandlerExecutor().runOnUiThread(new Runnable() {
            @Override
            public void run() {
                try {
                    if (message != null && message.length() != 0) {
                        if (activity != null) {
                            Snackbar snackbar = Snackbar.make(activity.getWindow().getDecorView().findViewById(android.R.id.content),
                                    message, duration).setAction(action, listener);
                            View snackBarText = snackbar.getView().findViewById(ResResolver.getViewId("snackbar_text"));
                            if (snackBarText instanceof TextView) {
                                ((TextView) snackbar.getView().findViewById(ResResolver.getViewId("snackbar_text"))).setMaxLines(4);
                            }
                            View snackBarAction = snackbar.getView().findViewById(ResResolver.getViewId("snackbar_action"));
                            if (snackBarAction instanceof TextView) {
                                ((TextView) snackbar.getView().findViewById(ResResolver.getViewId("snackbar_action"))).setTextColor(Color.parseColor("#5C7EFF"));
                            }
                            snackbar.show();
                        } else {
                            makeText(AIHelpContext.getInstance().getContext(), message, false);
                        }
                    }
                } catch (Exception e) {
                    // ignored
                }
            }
        });
    }

}
