// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab
import alphaTab.core.*

/**
 * This class represents the public API of alphaTab and provides all logic to display
 * a music sheet in any UI using the given 
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
public open class AlphaTabApiBase<TSettings>
{
    private var _startTime: Double = 0.0
    
    private var _trackIndexes: alphaTab.collections.DoubleList? = null
    
    private var _trackIndexLookup: alphaTab.core.ecmaScript.Set<Double>? = null
    
    private var _isDestroyed: Boolean = false
    
    /**
     * Gets the UI facade to use for interacting with the user interface.
     */
    public var uiFacade: alphaTab.platform.IUiFacade<TSettings>
    /**
     * Gets the UI container that holds the whole alphaTab control.
     */
    public var container: alphaTab.platform.IContainer
    /**
     * Gets the score renderer used for rendering the music sheet. This is the low-level API responsible for the actual rendering chain.
     */
    public var renderer: alphaTab.rendering.IScoreRenderer
    /**
     * Gets the score holding all information about the song being rendered.
     */
    public var score: alphaTab.model.Score? = null
    
    /**
     * Gets the settings that are used for rendering the music notation.
     */
    public lateinit var settings: alphaTab.Settings
    /**
     * Gets a list of the tracks that are currently rendered;
     */
    public var tracks: alphaTab.collections.List<alphaTab.model.Track> = alphaTab.collections.List<alphaTab.model.Track>(
    )
    
    
    /**
     * Gets the UI container that will hold all rendered results.
     */
    public var canvasElement: alphaTab.platform.IContainer
    public constructor(uiFacade: alphaTab.platform.IUiFacade<TSettings>, settings: TSettings){
        this.uiFacade = uiFacade
        this.container = uiFacade.rootContainer
        uiFacade.initialize(this, settings)
        alphaTab.Logger.logLevel = this.settings.core.logLevel
        this.canvasElement = uiFacade.createCanvasElement()
        this.container.appendChild(this.canvasElement)
        if (this.settings.core.useWorkers && this.uiFacade.areWorkersSupported && alphaTab.Environment.getRenderEngineFactory(this.settings.core.engine).supportsWorkers)
        {
            this.renderer = this.uiFacade.createWorkerRenderer()
        }
        else 
        {
            this.renderer = alphaTab.rendering.ScoreRenderer(this.settings)
        }
        this.container.resize.on(alphaTab.EnvironmentPartials.throttle(fun(): Unit{
            if (this._isDestroyed)
            {
                return
            }
            if (this.container.width != this.renderer.width)
            {
                this.triggerResize()
            }
        }
        , uiFacade.resizeThrottle))
        var initialResizeEventInfo: alphaTab.ResizeEventArgs = alphaTab.ResizeEventArgs()
        initialResizeEventInfo.oldWidth = this.renderer.width
        initialResizeEventInfo.newWidth = ((this.container.width).toInt() or 0).toDouble()
        initialResizeEventInfo.settings = this.settings
        this.onResize(initialResizeEventInfo)
        this.renderer.preRender.on(this::onRenderStarted)
        this.renderer.renderFinished.on(fun(renderingResult: alphaTab.rendering.RenderFinishedEventArgs): Unit{
            this.onRenderFinished(renderingResult)
        }
        )
        this.renderer.postRenderFinished.on(fun(): Unit{
            var duration: Double = alphaTab.core.ecmaScript.Date.now() - this._startTime
            alphaTab.Logger.debug("rendering", "Rendering completed in " + (duration).toInvariantString() + "ms")
            this.onPostRenderFinished()
        }
        )
        this.renderer.preRender.on(fun(_: Boolean): Unit{
            this._startTime = alphaTab.core.ecmaScript.Date.now()
        }
        )
        this.renderer.partialLayoutFinished.on(this::appendRenderResult)
        this.renderer.partialRenderFinished.on(this::updateRenderResult)
        this.renderer.renderFinished.on(fun(r: alphaTab.rendering.RenderFinishedEventArgs): Unit{
            this.appendRenderResult(r)
            this.appendRenderResult(null)
        }
        )
        this.renderer.error.on(this::onError)
        if (this.settings.player.enablePlayer)
        {
            this.setupPlayer()
        }
        this.setupClickHandling()
        this.uiFacade.beginInvoke(fun(): Unit{
            this.uiFacade.initialRender()
        }
        )
    }
    
    /**
     * Destroys the alphaTab control and restores the initial state of the UI.
     */
    public fun destroy(): Unit{
        this._isDestroyed = true
        if (alphaTab.core.TypeHelper.isTruthy(this.player))
        {
            this.player!!.destroy()
        }
        this.uiFacade.destroy()
        this.renderer.destroy()
    }
    
    /**
     * Applies any changes that were done to the settings object and informs the  about any new values to consider.
     */
    public fun updateSettings(): Unit{
        var score: alphaTab.model.Score? = this.score
        if (alphaTab.core.TypeHelper.isTruthy(score))
        {
            alphaTab.model.ModelUtils.applyPitchOffsets(this.settings, score)
        }
        this.renderer.updateSettings(this.settings)
        if (this.settings.player.enablePlayer)
        {
            this.setupPlayer()
            if (alphaTab.core.TypeHelper.isTruthy(score))
            {
                this.player?.applyTranspositionPitches(alphaTab.midi.MidiFileGenerator.buildTranspositionPitches(score, this.settings))
            }
        }
        else 
        {
            this.destroyPlayer()
        }
        this.onSettingsUpdated()
    }
    
    /**
     * Attempts a load of the score represented by the given data object.
     * @param scoreData The data container supported by 
     * @param trackIndexes 
     * The indexes of the tracks from the song that should be rendered. If not provided, the first track of the
     * song will be shown.
    
     */
    public fun load(scoreData: Any?, trackIndexes: alphaTab.collections.DoubleList? = null): Boolean{
        try
        {
            return this.uiFacade.load(scoreData, fun(score: alphaTab.model.Score): Unit{
                this.renderScore(score, trackIndexes)
            }
            , fun(error: alphaTab.core.ecmaScript.Error): Unit{
                this.onError(error)
            }
            )
        }
        catch (e: kotlin.Throwable)
        {
            this.onError((e as alphaTab.core.ecmaScript.Error))
            return false
        }
    }
    
    /**
     * Initiates a rendering of the given score.
     * @param score The score containing the tracks to be rendered.
     * @param trackIndexes 
     * The indexes of the tracks from the song that should be rendered. If not provided, the first track of the
     * song will be shown.
    
     */
    public fun renderScore(score: alphaTab.model.Score, trackIndexes: alphaTab.collections.DoubleList? = null): Unit{
        var tracks: alphaTab.collections.List<alphaTab.model.Track> = alphaTab.collections.List<alphaTab.model.Track>(
        )
        
        if (!alphaTab.core.TypeHelper.isTruthy(trackIndexes))
        {
            if (score.tracks.length > 0)
            {
                tracks.push(score.tracks[(0).toInt()])
            }
        }
        else 
        {
            if (trackIndexes.length == 0.0)
            {
                if (score.tracks.length > 0)
                {
                    tracks.push(score.tracks[(0).toInt()])
                }
            }
            else if (trackIndexes.length == 1.0 && trackIndexes[(0.0).toInt()] == -1.0)
            {
                for (track in score.tracks)
                {
                    tracks.push(track)
                }
            }
            else 
            {
                for (index in trackIndexes)
                {
                    if (index >= 0 && index <= score.tracks.length)
                    {
                        tracks.push(score.tracks[(index).toInt()])
                    }
                }
            }
        }
        this.internalRenderTracks(score, tracks)
    }
    
    /**
     * Renders the given list of tracks.
     * @param tracks The tracks to render. They must all belong to the same score.
     */
    public fun renderTracks(tracks: alphaTab.collections.List<alphaTab.model.Track>): Unit{
        if (tracks.length > 0)
        {
            var score: alphaTab.model.Score = tracks[(0).toInt()].score
            for (track in tracks)
            {
                if (track.score != score)
                {
                    this.onError(alphaTab.AlphaTabError(alphaTab.AlphaTabErrorType.General, "All rendered tracks must belong to the same score."))
                    return
                }
            }
            this.internalRenderTracks(score, tracks)
        }
    }
    
    /**
     */
    private fun internalRenderTracks(score: alphaTab.model.Score, tracks: alphaTab.collections.List<alphaTab.model.Track>): Unit{
        alphaTab.model.ModelUtils.applyPitchOffsets(this.settings, score)
        if (score != this.score)
        {
            this.score = score
            this.tracks = tracks
            this._trackIndexes = alphaTab.collections.DoubleList(
            )
            
            for (track in tracks)
            {
                this._trackIndexes!!.push(track.index)
            }
            this._trackIndexLookup = alphaTab.core.ecmaScript.Set<Double>(((this._trackIndexes as alphaTab.core.ecmaScript.Iterable<Double>?)))
            this.onScoreLoaded(score)
            this.loadMidiForScore()
            this.render()
        }
        else 
        {
            this.tracks = tracks
            this._trackIndexes = alphaTab.collections.DoubleList(
            )
            
            for (track in tracks)
            {
                this._trackIndexes!!.push(track.index)
            }
            this._trackIndexLookup = alphaTab.core.ecmaScript.Set<Double>(((this._trackIndexes as alphaTab.core.ecmaScript.Iterable<Double>?)))
            this.render()
        }
    }
    
    internal fun triggerResize(): Unit{
        if (!this.container.isVisible)
        {
            alphaTab.Logger.warning("Rendering", "AlphaTab container was invisible while autosizing, waiting for element to become visible", null)
            this.uiFacade.rootContainerBecameVisible.on(fun(): Unit{
                alphaTab.Logger.debug("Rendering", "AlphaTab container became visible, doing autosizing", null)
                this.triggerResize()
            }
            )
        }
        else 
        {
            var resizeEventInfo: alphaTab.ResizeEventArgs = alphaTab.ResizeEventArgs()
            resizeEventInfo.oldWidth = this.renderer.width
            resizeEventInfo.newWidth = this.container.width
            resizeEventInfo.settings = this.settings
            this.onResize(resizeEventInfo)
            this.renderer.updateSettings(this.settings)
            this.renderer.width = this.container.width
            this.renderer.resizeRender()
        }
    }
    
    /**
     */
    private fun appendRenderResult(result: alphaTab.rendering.RenderFinishedEventArgs?): Unit{
        if (alphaTab.core.TypeHelper.isTruthy(result))
        {
            this.canvasElement.width = result.totalWidth
            this.canvasElement.height = result.totalHeight
            if (alphaTab.core.TypeHelper.isTruthy(this._cursorWrapper))
            {
                this._cursorWrapper!!.width = result.totalWidth
                this._cursorWrapper!!.height = result.totalHeight
            }
            if (result.width > 0 || result.height > 0)
            {
                this.uiFacade.beginAppendRenderResults(result)
            }
        }
        else 
        {
            this.uiFacade.beginAppendRenderResults(result)
        }
    }
    
    /**
     */
    private fun updateRenderResult(result: alphaTab.rendering.RenderFinishedEventArgs?): Unit{
        if (alphaTab.core.TypeHelper.isTruthy(result) && alphaTab.core.TypeHelper.isTruthy(result.renderResult))
        {
            this.uiFacade.beginUpdateRenderResults(result)
        }
    }
    
    /**
     * Tells alphaTab to render the given alphaTex.
     * @param tex The alphaTex code to render.
     * @param tracks If set, the given tracks will be rendered, otherwise the first track only will be rendered.
     */
    public fun tex(tex: String, tracks: alphaTab.collections.DoubleList? = null): Unit{
        try
        {
            var parser: alphaTab.importer.AlphaTexImporter = alphaTab.importer.AlphaTexImporter()
            parser.logErrors = true
            parser.initFromString(tex, this.settings)
            var score: alphaTab.model.Score = parser.readScore()
            this.renderScore(score, tracks)
        }
        catch (e: kotlin.Throwable)
        {
            this.onError((e as alphaTab.core.ecmaScript.Error))
        }
    }
    
    /**
     * Attempts a load of the score represented by the given data object.
     * @param `data` The data object to decode
     * @param append Whether to fully replace or append the data from the given soundfont.
     */
    public fun loadSoundFont(`data`: Any?, append: Boolean = false): Boolean{
        if (!alphaTab.core.TypeHelper.isTruthy(this.player))
        {
            return false
        }
        return this.uiFacade.loadSoundFont(`data`, append)
    }
    
    /**
     * Resets all loaded soundfonts as if they were not loaded.
     */
    public fun resetSoundFonts(): Unit{
        if (!alphaTab.core.TypeHelper.isTruthy(this.player))
        {
            return
        }
        this.player!!.resetSoundFonts()
    }
    
    /**
     * Initiates a re-rendering of the current setup. If rendering is not yet possible, it will be deferred until the UI changes to be ready for rendering.
     */
    public fun render(): Unit{
        if (!alphaTab.core.TypeHelper.isTruthy(this.renderer))
        {
            return
        }
        if (this.uiFacade.canRender)
        {
            this.renderer.width = this.container.width
            this.renderer.renderScore(this.score, this._trackIndexes)
        }
        else 
        {
            this.uiFacade.canRenderChanged.on({
                this.render()
            }
            )
        }
    }
    
    private var _tickCache: alphaTab.midi.MidiTickLookup? = null
    
    public val tickCache: alphaTab.midi.MidiTickLookup?
    get(){
        return this._tickCache
    }
    
    /**
     * Gets the alphaSynth player used for playback. This is the low-level API to the Midi synthesizer used for playback.
     */
    public var player: alphaTab.synth.IAlphaSynth? = null
    
    public val isReadyForPlayback: Boolean
    get(){
        if (!alphaTab.core.TypeHelper.isTruthy(this.player))
        {
            return false
        }
        return this.player!!.isReadyForPlayback
    }
    
    public val playerState: alphaTab.synth.PlayerState
    get(){
        if (!alphaTab.core.TypeHelper.isTruthy(this.player))
        {
            return alphaTab.synth.PlayerState.Paused
        }
        return this.player!!.state
    }
    
    public var masterVolume: Double
    get(){
        if (!alphaTab.core.TypeHelper.isTruthy(this.player))
        {
            return 0.0
        }
        return this.player!!.masterVolume
    }
    set(value){
        if (alphaTab.core.TypeHelper.isTruthy(this.player))
        {
            this.player!!.masterVolume = value
        }
    }
    
    public var metronomeVolume: Double
    get(){
        if (!alphaTab.core.TypeHelper.isTruthy(this.player))
        {
            return 0.0
        }
        return this.player!!.metronomeVolume
    }
    set(value){
        if (alphaTab.core.TypeHelper.isTruthy(this.player))
        {
            this.player!!.metronomeVolume = value
        }
    }
    
    public var countInVolume: Double
    get(){
        if (!alphaTab.core.TypeHelper.isTruthy(this.player))
        {
            return 0.0
        }
        return this.player!!.countInVolume
    }
    set(value){
        if (alphaTab.core.TypeHelper.isTruthy(this.player))
        {
            this.player!!.countInVolume = value
        }
    }
    
    public var midiEventsPlayedFilter: alphaTab.collections.List<alphaTab.midi.MidiEventType>
    get(){
        if (!alphaTab.core.TypeHelper.isTruthy(this.player))
        {
            return alphaTab.collections.List<alphaTab.midi.MidiEventType>(
            )
            
        }
        return this.player!!.midiEventsPlayedFilter
    }
    set(value){
        if (alphaTab.core.TypeHelper.isTruthy(this.player))
        {
            this.player!!.midiEventsPlayedFilter = value
        }
    }
    
    public var tickPosition: Double
    get(){
        if (!alphaTab.core.TypeHelper.isTruthy(this.player))
        {
            return 0.0
        }
        return this.player!!.tickPosition
    }
    set(value){
        if (alphaTab.core.TypeHelper.isTruthy(this.player))
        {
            this.player!!.tickPosition = value
        }
    }
    
    public var timePosition: Double
    get(){
        if (!alphaTab.core.TypeHelper.isTruthy(this.player))
        {
            return 0.0
        }
        return this.player!!.timePosition
    }
    set(value){
        if (alphaTab.core.TypeHelper.isTruthy(this.player))
        {
            this.player!!.timePosition = value
        }
    }
    
    public var playbackRange: alphaTab.synth.PlaybackRange?
    get(){
        if (!alphaTab.core.TypeHelper.isTruthy(this.player))
        {
            return null
        }
        return this.player!!.playbackRange
    }
    set(value){
        if (alphaTab.core.TypeHelper.isTruthy(this.player))
        {
            this.player!!.playbackRange = value
            if (this.settings.player.enableCursor)
            {
                this.updateSelectionCursor(value)
            }
        }
    }
    
    public var playbackSpeed: Double
    get(){
        if (!alphaTab.core.TypeHelper.isTruthy(this.player))
        {
            return 0.0
        }
        return this.player!!.playbackSpeed
    }
    set(value){
        if (alphaTab.core.TypeHelper.isTruthy(this.player))
        {
            this.player!!.playbackSpeed = value
        }
    }
    
    public var isLooping: Boolean
    get(){
        if (!alphaTab.core.TypeHelper.isTruthy(this.player))
        {
            return false
        }
        return this.player!!.isLooping
    }
    set(value){
        if (alphaTab.core.TypeHelper.isTruthy(this.player))
        {
            this.player!!.isLooping = value
        }
    }
    
    private fun destroyPlayer(): Unit{
        if (!alphaTab.core.TypeHelper.isTruthy(this.player))
        {
            return
        }
        this.player!!.destroy()
        this.player = null
        this._previousTick = 0.0
        this._playerState = alphaTab.synth.PlayerState.Paused
        this.destroyCursors()
    }
    
    private fun setupPlayer(): Unit{
        this.updateCursors()
        if (alphaTab.core.TypeHelper.isTruthy(this.player))
        {
            return
        }
        this.player = this.uiFacade.createWorkerPlayer()
        if (!alphaTab.core.TypeHelper.isTruthy(this.player))
        {
            return
        }
        this.player!!.ready.on(fun(): Unit{
            this.loadMidiForScore()
        }
        )
        this.player!!.readyForPlayback.on(fun(): Unit{
            this.onPlayerReady()
            if (alphaTab.core.TypeHelper.isTruthy(this.tracks))
            {
                for (track in this.tracks)
                {
                    var volume: Double = track.playbackInfo.volume / (16.0).toDouble()
                    this.player!!.setChannelVolume(track.playbackInfo.primaryChannel, volume)
                    this.player!!.setChannelVolume(track.playbackInfo.secondaryChannel, volume)
                }
            }
        }
        )
        this.player!!.soundFontLoaded.on(this::onSoundFontLoaded)
        this.player!!.soundFontLoadFailed.on(fun(e: alphaTab.core.ecmaScript.Error): Unit{
            this.onError(e)
        }
        )
        this.player!!.midiLoaded.on(this::onMidiLoaded)
        this.player!!.midiLoadFailed.on(fun(e: alphaTab.core.ecmaScript.Error): Unit{
            this.onError(e)
        }
        )
        this.player!!.stateChanged.on(this::onPlayerStateChanged)
        this.player!!.positionChanged.on(this::onPlayerPositionChanged)
        this.player!!.midiEventsPlayed.on(this::onMidiEventsPlayed)
        this.player!!.playbackRangeChanged.on(this::onPlaybackRangeChanged)
        this.player!!.finished.on(this::onPlayerFinished)
        this.setupPlayerEvents()
    }
    
    private fun loadMidiForScore(): Unit{
        if (!alphaTab.core.TypeHelper.isTruthy(this.player) || !alphaTab.core.TypeHelper.isTruthy(this.score) || !this.player!!.isReady)
        {
            return
        }
        alphaTab.Logger.debug("AlphaTab", "Generating Midi")
        var midiFile: alphaTab.midi.MidiFile = alphaTab.midi.MidiFile()
        var handler: alphaTab.midi.AlphaSynthMidiFileHandler = alphaTab.midi.AlphaSynthMidiFileHandler(midiFile)
        var generator: alphaTab.midi.MidiFileGenerator = alphaTab.midi.MidiFileGenerator(this.score!!, this.settings, handler)
        generator.applyTranspositionPitches = false
        generator.generate()
        this._tickCache = generator.tickLookup
        this.onMidiLoad(midiFile)
        this.player!!.loadMidiFile(midiFile)
        this.player!!.applyTranspositionPitches(generator.transpositionPitches)
    }
    
    /**
     * Changes the volume of the given tracks.
     * @param tracks The tracks for which the volume should be changed.
     * @param volume The volume to set for all tracks in percent (0-1)
     */
    public fun changeTrackVolume(tracks: alphaTab.collections.List<alphaTab.model.Track>, volume: Double): Unit{
        if (!alphaTab.core.TypeHelper.isTruthy(this.player))
        {
            return
        }
        for (track in tracks)
        {
            this.player!!.setChannelVolume(track.playbackInfo.primaryChannel, volume)
            this.player!!.setChannelVolume(track.playbackInfo.secondaryChannel, volume)
        }
    }
    
    /**
     * Changes the given tracks to be played solo or not.
     * If one or more tracks are set to solo, only those tracks are hearable.
     * @param tracks The list of tracks to play solo or not.
     * @param solo If set to true, the tracks will be added to the solo list. If false, they are removed.
     */
    public fun changeTrackSolo(tracks: alphaTab.collections.List<alphaTab.model.Track>, solo: Boolean): Unit{
        if (!alphaTab.core.TypeHelper.isTruthy(this.player))
        {
            return
        }
        for (track in tracks)
        {
            this.player!!.setChannelSolo(track.playbackInfo.primaryChannel, solo)
            this.player!!.setChannelSolo(track.playbackInfo.secondaryChannel, solo)
        }
    }
    
    /**
     * Changes the given tracks to be muted or not.
     * @param tracks The list of track to mute or unmute.
     * @param mute If set to true, the tracks will be muted. If false they are unmuted.
     */
    public fun changeTrackMute(tracks: alphaTab.collections.List<alphaTab.model.Track>, mute: Boolean): Unit{
        if (!alphaTab.core.TypeHelper.isTruthy(this.player))
        {
            return
        }
        for (track in tracks)
        {
            this.player!!.setChannelMute(track.playbackInfo.primaryChannel, mute)
            this.player!!.setChannelMute(track.playbackInfo.secondaryChannel, mute)
        }
    }
    
    /**
     * Starts the playback of the current song.
     */
    public fun play(): Boolean{
        if (!alphaTab.core.TypeHelper.isTruthy(this.player))
        {
            return false
        }
        return this.player!!.play()
    }
    
    /**
     * Pauses the playback of the current song.
     */
    public fun pause(): Unit{
        if (!alphaTab.core.TypeHelper.isTruthy(this.player))
        {
            return
        }
        this.player!!.pause()
    }
    
    /**
     * Toggles between play/pause depending on the current player state.
     */
    public fun playPause(): Unit{
        if (!alphaTab.core.TypeHelper.isTruthy(this.player))
        {
            return
        }
        this.player!!.playPause()
    }
    
    /**
     * Stops the playback of the current song, and moves the playback position back to the start.
     */
    public fun stop(): Unit{
        if (!alphaTab.core.TypeHelper.isTruthy(this.player))
        {
            return
        }
        this.player!!.stop()
    }
    
    /**
     * Triggers the play of the given beat. This will stop the any other current ongoing playback.
     * @param beat the single beat to play
     */
    public fun playBeat(beat: alphaTab.model.Beat): Unit{
        if (!alphaTab.core.TypeHelper.isTruthy(this.player))
        {
            return
        }
        var midiFile: alphaTab.midi.MidiFile = alphaTab.midi.MidiFile()
        var handler: alphaTab.midi.AlphaSynthMidiFileHandler = alphaTab.midi.AlphaSynthMidiFileHandler(midiFile)
        var generator: alphaTab.midi.MidiFileGenerator = alphaTab.midi.MidiFileGenerator(beat.voice.bar.staff.track.score, this.settings, handler)
        generator.generateSingleBeat(beat)
        this.player!!.playOneTimeMidiFile(midiFile)
    }
    
    /**
     * Triggers the play of the given note. This will stop the any other current ongoing playback.
     */
    public fun playNote(note: alphaTab.model.Note): Unit{
        if (!alphaTab.core.TypeHelper.isTruthy(this.player))
        {
            return
        }
        var midiFile: alphaTab.midi.MidiFile = alphaTab.midi.MidiFile()
        var handler: alphaTab.midi.AlphaSynthMidiFileHandler = alphaTab.midi.AlphaSynthMidiFileHandler(midiFile)
        var generator: alphaTab.midi.MidiFileGenerator = alphaTab.midi.MidiFileGenerator(note.beat.voice.bar.staff.track.score, this.settings, handler)
        generator.generateSingleNote(note)
        this.player!!.playOneTimeMidiFile(midiFile)
    }
    
    private var _cursorWrapper: alphaTab.platform.IContainer? = null
    
    private var _barCursor: alphaTab.platform.IContainer? = null
    
    private var _beatCursor: alphaTab.platform.IContainer? = null
    
    private var _selectionWrapper: alphaTab.platform.IContainer? = null
    
    private var _previousTick: Double = 0.0
    
    private var _playerState: alphaTab.synth.PlayerState = alphaTab.synth.PlayerState.Paused
    
    private var _currentBeat: alphaTab.midi.MidiTickLookupFindBeatResult? = null
    
    private var _currentBarBounds: alphaTab.rendering.utils.MasterBarBounds? = null
    
    private var _previousStateForCursor: alphaTab.synth.PlayerState = alphaTab.synth.PlayerState.Paused
    
    private var _previousCursorCache: alphaTab.rendering.utils.BoundsLookup? = null
    
    private var _lastScroll: Double = 0.0
    
    private fun destroyCursors(): Unit{
        if (!alphaTab.core.TypeHelper.isTruthy(this._cursorWrapper))
        {
            return
        }
        this.uiFacade.destroyCursors()
        this._cursorWrapper = null
        this._barCursor = null
        this._beatCursor = null
        this._selectionWrapper = null
    }
    
    private fun updateCursors(): Unit{
        if (this.settings.player.enableCursor && !alphaTab.core.TypeHelper.isTruthy(this._cursorWrapper))
        {
            var cursors: alphaTab.platform.Cursors? = this.uiFacade.createCursors()
            if (alphaTab.core.TypeHelper.isTruthy(cursors))
            {
                this._cursorWrapper = cursors.cursorWrapper
                this._barCursor = cursors.barCursor
                this._beatCursor = cursors.beatCursor
                this._selectionWrapper = cursors.selectionWrapper
            }
            if (this._currentBeat != null)
            {
                this.cursorUpdateBeat(this._currentBeat!!, false, this._previousTick > 10, true)
            }
        }
        else if (!this.settings.player.enableCursor && alphaTab.core.TypeHelper.isTruthy(this._cursorWrapper))
        {
            this.destroyCursors()
        }
    }
    
    private fun setupPlayerEvents(): Unit{
        this._previousTick = 0.0
        this._playerState = alphaTab.synth.PlayerState.Paused
        this.renderer.postRenderFinished.on(fun(): Unit{
            this._currentBeat = null
            this.cursorUpdateTick(this._previousTick, false, this._previousTick > 10)
        }
        )
        if (alphaTab.core.TypeHelper.isTruthy(this.player))
        {
            this.player!!.positionChanged.on(fun(e: alphaTab.synth.PositionChangedEventArgs): Unit{
                this._previousTick = e.currentTick
                this.uiFacade.beginInvoke(fun(): Unit{
                    this.cursorUpdateTick(e.currentTick, false)
                }
                )
            }
            )
            this.player!!.stateChanged.on(fun(e: alphaTab.synth.PlayerStateChangedEventArgs): Unit{
                this._playerState = e.state
                if (!e.stopped && e.state == alphaTab.synth.PlayerState.Paused)
                {
                    var currentBeat: alphaTab.midi.MidiTickLookupFindBeatResult? = this._currentBeat
                    var tickCache: alphaTab.midi.MidiTickLookup? = this._tickCache
                    if (alphaTab.core.TypeHelper.isTruthy(currentBeat) && alphaTab.core.TypeHelper.isTruthy(tickCache))
                    {
                        this.player!!.tickPosition = tickCache.getBeatStart(currentBeat.beat)
                    }
                }
            }
            )
        }
    }
    
    /**
     * updates the cursors to highlight the beat at the specified tick position
     * @param shouldScroll whether we should scroll to the bar (if scrolling is active)
     */
    private fun cursorUpdateTick(tick: Double, stop: Boolean, shouldScroll: Boolean = false): Unit{
        var cache: alphaTab.midi.MidiTickLookup? = this._tickCache
        if (alphaTab.core.TypeHelper.isTruthy(cache))
        {
            var tracks: alphaTab.core.ecmaScript.Set<Double>? = this._trackIndexLookup
            if (tracks != null && tracks.size > 0)
            {
                var beat: alphaTab.midi.MidiTickLookupFindBeatResult? = cache.findBeat(tracks, tick, this._currentBeat)
                if (alphaTab.core.TypeHelper.isTruthy(beat))
                {
                    this.cursorUpdateBeat(beat, stop, shouldScroll)
                }
            }
        }
    }
    
    /**
     * updates the cursors to highlight the specified beat
     */
    private fun cursorUpdateBeat(lookupResult: alphaTab.midi.MidiTickLookupFindBeatResult, stop: Boolean, shouldScroll: Boolean, forceUpdate: Boolean = false): Unit{
        var beat: alphaTab.model.Beat = lookupResult.beat
        var nextBeat: alphaTab.model.Beat? = lookupResult.nextBeat?.beat 
        var duration: Double = lookupResult.duration
        var beatsToHighlight: alphaTab.collections.List<alphaTab.midi.BeatTickLookupItem> = lookupResult.beatLookup.highlightedBeats
        if (!alphaTab.core.TypeHelper.isTruthy(beat))
        {
            return
        }
        var cache: alphaTab.rendering.utils.BoundsLookup? = this.renderer.boundsLookup
        if (!alphaTab.core.TypeHelper.isTruthy(cache))
        {
            return
        }
        var previousBeat: alphaTab.midi.MidiTickLookupFindBeatResult? = this._currentBeat
        var previousCache: alphaTab.rendering.utils.BoundsLookup? = this._previousCursorCache
        var previousState: alphaTab.synth.PlayerState? = this._previousStateForCursor
        if (!forceUpdate && beat == previousBeat?.beat && cache == previousCache && previousState == this._playerState)
        {
            return
        }
        var beatBoundings: alphaTab.rendering.utils.BeatBounds? = cache.findBeat(beat)
        if (!alphaTab.core.TypeHelper.isTruthy(beatBoundings))
        {
            return
        }
        this._currentBeat = lookupResult
        this._previousCursorCache = cache
        this._previousStateForCursor = this._playerState
        this.uiFacade.beginInvoke(fun(): Unit{
            this.internalCursorUpdateBeat(
                beat
                , 
                nextBeat
                , 
                duration
                , 
                stop
                , 
                beatsToHighlight
                , 
                cache!!
                , 
                beatBoundings!!
                , 
                shouldScroll
            
            )
        }
        )
    }
    
    /**
     * Initiates a scroll to the cursor
     */
    public fun scrollToCursor(): Unit{
        var barBounds: alphaTab.rendering.utils.MasterBarBounds? = this._currentBarBounds
        if (alphaTab.core.TypeHelper.isTruthy(barBounds))
        {
            this.internalScrollToCursor(barBounds)
        }
    }
    
    /**
     */
    public fun internalScrollToCursor(barBoundings: alphaTab.rendering.utils.MasterBarBounds): Unit{
        var scrollElement: alphaTab.platform.IContainer = this.uiFacade.getScrollContainer()
        var isVertical: Boolean = alphaTab.Environment.getLayoutEngineFactory(this.settings.display.layoutMode).vertical
        var mode: alphaTab.ScrollMode = this.settings.player.scrollMode
        if (isVertical)
        {
            var y: Double = barBoundings.realBounds.y + this.settings.player.scrollOffsetY
            if (y != this._lastScroll)
            {
                this._lastScroll = y
                when (mode)
                {
                    alphaTab.ScrollMode.Continuous -> 
                    {
                        var elementOffset: alphaTab.rendering.utils.Bounds = this.uiFacade.getOffset(scrollElement, this.container)
                        this.uiFacade.scrollToY(scrollElement, elementOffset.y + y, this.settings.player.scrollSpeed)
                    }
                    alphaTab.ScrollMode.OffScreen -> 
                    {
                        var elementBottom: Double = scrollElement.scrollTop + this.uiFacade.getOffset(null, scrollElement).h
                        if (barBoundings.visualBounds.y + barBoundings.visualBounds.h >= elementBottom || barBoundings.visualBounds.y < scrollElement.scrollTop)
                        {
                            var scrollTop: Double = barBoundings.realBounds.y + this.settings.player.scrollOffsetY
                            this.uiFacade.scrollToY(scrollElement, scrollTop, this.settings.player.scrollSpeed)
                        }
                    }
                    else -> { }
                }
            }
        }
        else 
        {
            var x: Double = barBoundings.visualBounds.x
            if (x != this._lastScroll)
            {
                this._lastScroll = x
                when (mode)
                {
                    alphaTab.ScrollMode.Continuous -> 
                    {
                        var scrollLeftContinuous: Double = barBoundings.realBounds.x + this.settings.player.scrollOffsetX
                        this._lastScroll = barBoundings.visualBounds.x
                        this.uiFacade.scrollToX(scrollElement, scrollLeftContinuous, this.settings.player.scrollSpeed)
                    }
                    alphaTab.ScrollMode.OffScreen -> 
                    {
                        var elementRight: Double = scrollElement.scrollLeft + this.uiFacade.getOffset(null, scrollElement).w
                        if (barBoundings.visualBounds.x + barBoundings.visualBounds.w >= elementRight || barBoundings.visualBounds.x < scrollElement.scrollLeft)
                        {
                            var scrollLeftOffScreen: Double = barBoundings.realBounds.x + this.settings.player.scrollOffsetX
                            this._lastScroll = barBoundings.visualBounds.x
                            this.uiFacade.scrollToX(scrollElement, scrollLeftOffScreen, this.settings.player.scrollSpeed)
                        }
                    }
                    else -> { }
                }
            }
        }
    }
    
    /**
     */
    private fun internalCursorUpdateBeat(beat: alphaTab.model.Beat, nextBeat: alphaTab.model.Beat?, duration: Double, stop: Boolean, beatsToHighlight: alphaTab.collections.List<alphaTab.midi.BeatTickLookupItem>, cache: alphaTab.rendering.utils.BoundsLookup, beatBoundings: alphaTab.rendering.utils.BeatBounds, shouldScroll: Boolean): Unit{
        var paramshouldScroll = shouldScroll
        var barCursor: alphaTab.platform.IContainer? = this._barCursor
        var beatCursor: alphaTab.platform.IContainer? = this._beatCursor
        var barBoundings: alphaTab.rendering.utils.MasterBarBounds = beatBoundings.barBounds.masterBarBounds
        var barBounds: alphaTab.rendering.utils.Bounds = barBoundings.visualBounds
        this._currentBarBounds = barBoundings
        if (alphaTab.core.TypeHelper.isTruthy(barCursor))
        {
            barCursor.setBounds(barBounds.x, barBounds.y, barBounds.w, barBounds.h)
        }
        if (alphaTab.core.TypeHelper.isTruthy(beatCursor))
        {
            if (this.settings.player.enableAnimatedBeatCursor)
            {
                beatCursor.stopAnimation()
            }
            beatCursor.setBounds(beatBoundings.visualBounds.x, barBounds.y, 1.0, barBounds.h)
        }
        if (this.settings.player.enableElementHighlighting)
        {
            this.uiFacade.removeHighlights()
        }
        var shouldNotifyBeatChange: Boolean = false
        if (this._playerState == alphaTab.synth.PlayerState.Playing && !stop)
        {
            if (this.settings.player.enableElementHighlighting)
            {
                for (highlight in beatsToHighlight)
                {
                    var className: String = alphaTab.rendering.glyphs.BeatContainerGlyph.getGroupId(highlight.beat)
                    this.uiFacade.highlightElements(className, beat.voice.bar.index)
                }
            }
            if (this.settings.player.enableAnimatedBeatCursor)
            {
                var nextBeatX: Double = barBoundings.visualBounds.x + barBoundings.visualBounds.w
                if (alphaTab.core.TypeHelper.isTruthy(nextBeat))
                {
                    var nextBeatBoundings: alphaTab.rendering.utils.BeatBounds? = cache.findBeat(nextBeat)
                    if (alphaTab.core.TypeHelper.isTruthy(nextBeatBoundings) && nextBeatBoundings.barBounds.masterBarBounds.staveGroupBounds == barBoundings.staveGroupBounds)
                    {
                        nextBeatX = nextBeatBoundings.visualBounds.x
                    }
                }
                this.uiFacade.beginInvoke(fun(): Unit{
                    if (alphaTab.core.TypeHelper.isTruthy(beatCursor))
                    {
                        beatCursor.transitionToX(duration / this.playbackSpeed, nextBeatX)
                    }
                }
                )
            }
            paramshouldScroll = !((stop as Boolean))
            shouldNotifyBeatChange = true
        }
        if (paramshouldScroll && !this._beatMouseDown && this.settings.player.scrollMode != alphaTab.ScrollMode.Off)
        {
            this.internalScrollToCursor(barBoundings)
        }
        if (shouldNotifyBeatChange)
        {
            this.onPlayedBeatChanged(beat)
            this.onActiveBeatsChanged(alphaTab.synth.ActiveBeatsChangedEventArgs(beatsToHighlight.map(fun(i: alphaTab.midi.BeatTickLookupItem): alphaTab.model.Beat{
                return i.beat
            }
            )))
        }
    }
    
    public var playedBeatChanged: alphaTab.IEventEmitterOfT<alphaTab.model.Beat> = alphaTab.EventEmitterOfT<alphaTab.model.Beat>()
    
    /**
     */
    private fun onPlayedBeatChanged(beat: alphaTab.model.Beat): Unit{
        if (this._isDestroyed)
        {
            return
        }
        ((this.playedBeatChanged as alphaTab.EventEmitterOfT<alphaTab.model.Beat>)).trigger(beat)
        this.uiFacade.triggerEvent(this.container, "playedBeatChanged", beat)
    }
    
    public var activeBeatsChanged: alphaTab.IEventEmitterOfT<alphaTab.synth.ActiveBeatsChangedEventArgs> = alphaTab.EventEmitterOfT<alphaTab.synth.ActiveBeatsChangedEventArgs>()
    
    /**
     */
    private fun onActiveBeatsChanged(e: alphaTab.synth.ActiveBeatsChangedEventArgs): Unit{
        if (this._isDestroyed)
        {
            return
        }
        ((this.activeBeatsChanged as alphaTab.EventEmitterOfT<alphaTab.synth.ActiveBeatsChangedEventArgs>)).trigger(e)
        this.uiFacade.triggerEvent(this.container, "activeBeatsChanged", e)
    }
    
    private var _beatMouseDown: Boolean = false
    
    private var _noteMouseDown: Boolean = false
    
    private var _selectionStart: alphaTab.SelectionInfo? = null
    
    private var _selectionEnd: alphaTab.SelectionInfo? = null
    
    public var beatMouseDown: alphaTab.IEventEmitterOfT<alphaTab.model.Beat> = alphaTab.EventEmitterOfT<alphaTab.model.Beat>()
    
    public var beatMouseMove: alphaTab.IEventEmitterOfT<alphaTab.model.Beat> = alphaTab.EventEmitterOfT<alphaTab.model.Beat>()
    
    public var beatMouseUp: alphaTab.IEventEmitterOfT<alphaTab.model.Beat?> = alphaTab.EventEmitterOfT<alphaTab.model.Beat?>()
    
    public var noteMouseDown: alphaTab.IEventEmitterOfT<alphaTab.model.Note> = alphaTab.EventEmitterOfT<alphaTab.model.Note>()
    
    public var noteMouseMove: alphaTab.IEventEmitterOfT<alphaTab.model.Note> = alphaTab.EventEmitterOfT<alphaTab.model.Note>()
    
    public var noteMouseUp: alphaTab.IEventEmitterOfT<alphaTab.model.Note?> = alphaTab.EventEmitterOfT<alphaTab.model.Note?>()
    
    /**
     */
    private fun onBeatMouseDown(originalEvent: alphaTab.platform.IMouseEventArgs, beat: alphaTab.model.Beat): Unit{
        if (this._isDestroyed)
        {
            return
        }
        if (this.settings.player.enablePlayer && this.settings.player.enableCursor && this.settings.player.enableUserInteraction)
        {
            this._selectionStart = alphaTab.SelectionInfo(beat)
            this._selectionEnd = null
        }
        this._beatMouseDown = true
        ((this.beatMouseDown as alphaTab.EventEmitterOfT<alphaTab.model.Beat>)).trigger(beat)
        this.uiFacade.triggerEvent(this.container, "beatMouseDown", beat, originalEvent)
    }
    
    /**
     */
    private fun onNoteMouseDown(originalEvent: alphaTab.platform.IMouseEventArgs, note: alphaTab.model.Note): Unit{
        if (this._isDestroyed)
        {
            return
        }
        this._noteMouseDown = true
        ((this.noteMouseDown as alphaTab.EventEmitterOfT<alphaTab.model.Note>)).trigger(note)
        this.uiFacade.triggerEvent(this.container, "noteMouseDown", note, originalEvent)
    }
    
    /**
     */
    private fun onBeatMouseMove(originalEvent: alphaTab.platform.IMouseEventArgs, beat: alphaTab.model.Beat): Unit{
        if (this._isDestroyed)
        {
            return
        }
        if (this.settings.player.enableUserInteraction)
        {
            if (!alphaTab.core.TypeHelper.isTruthy(this._selectionEnd) || this._selectionEnd!!.beat != beat)
            {
                this._selectionEnd = alphaTab.SelectionInfo(beat)
                this.cursorSelectRange(this._selectionStart, this._selectionEnd)
            }
        }
        ((this.beatMouseMove as alphaTab.EventEmitterOfT<alphaTab.model.Beat>)).trigger(beat)
        this.uiFacade.triggerEvent(this.container, "beatMouseMove", beat, originalEvent)
    }
    
    /**
     */
    private fun onNoteMouseMove(originalEvent: alphaTab.platform.IMouseEventArgs, note: alphaTab.model.Note): Unit{
        if (this._isDestroyed)
        {
            return
        }
        ((this.noteMouseMove as alphaTab.EventEmitterOfT<alphaTab.model.Note>)).trigger(note)
        this.uiFacade.triggerEvent(this.container, "noteMouseMove", note, originalEvent)
    }
    
    /**
     */
    private fun onBeatMouseUp(originalEvent: alphaTab.platform.IMouseEventArgs, beat: alphaTab.model.Beat?): Unit{
        if (this._isDestroyed)
        {
            return
        }
        if (this.settings.player.enablePlayer && this.settings.player.enableCursor && this.settings.player.enableUserInteraction)
        {
            if (alphaTab.core.TypeHelper.isTruthy(this._selectionEnd))
            {
                var startTick: Double = this._tickCache?.getBeatStart(this._selectionStart!!.beat) ?: this._selectionStart!!.beat.absolutePlaybackStart
                var endTick: Double = this._tickCache?.getBeatStart(this._selectionEnd!!.beat) ?: this._selectionEnd!!.beat.absolutePlaybackStart
                if (endTick < startTick)
                {
                    var t: alphaTab.SelectionInfo = this._selectionStart!!
                    this._selectionStart = this._selectionEnd
                    this._selectionEnd = t
                }
            }
            if (alphaTab.core.TypeHelper.isTruthy(this._selectionStart) && alphaTab.core.TypeHelper.isTruthy(this._tickCache))
            {
                var tickCache: alphaTab.midi.MidiTickLookup = this._tickCache!!
                var realMasterBarStart: Double = tickCache.getMasterBarStart(this._selectionStart!!.beat.voice.bar.masterBar)
                this._currentBeat = null
                if (this._playerState == alphaTab.synth.PlayerState.Paused)
                {
                    this.cursorUpdateTick(this._tickCache!!.getBeatStart(this._selectionStart!!.beat), false)
                }
                this.tickPosition = realMasterBarStart + this._selectionStart!!.beat.playbackStart
                if (alphaTab.core.TypeHelper.isTruthy(this._selectionEnd) && this._selectionStart!!.beat != this._selectionEnd!!.beat)
                {
                    var realMasterBarEnd: Double = tickCache.getMasterBarStart(this._selectionEnd!!.beat.voice.bar.masterBar)
                    var range: alphaTab.synth.PlaybackRange = alphaTab.synth.PlaybackRange()
                    range.startTick = realMasterBarStart + this._selectionStart!!.beat.playbackStart
                    range.endTick = realMasterBarEnd + this._selectionEnd!!.beat.playbackStart + this._selectionEnd!!.beat.playbackDuration - 50.0
                    this.playbackRange = range
                }
                else 
                {
                    this._selectionStart = null
                    this.playbackRange = null
                    this.cursorSelectRange(this._selectionStart, this._selectionEnd)
                }
            }
        }
        ((this.beatMouseUp as alphaTab.EventEmitterOfT<alphaTab.model.Beat?>)).trigger(beat)
        this.uiFacade.triggerEvent(this.container, "beatMouseUp", beat, originalEvent)
        this._beatMouseDown = false
    }
    
    /**
     */
    private fun onNoteMouseUp(originalEvent: alphaTab.platform.IMouseEventArgs, note: alphaTab.model.Note?): Unit{
        if (this._isDestroyed)
        {
            return
        }
        ((this.noteMouseUp as alphaTab.EventEmitterOfT<alphaTab.model.Note?>)).trigger(note)
        this.uiFacade.triggerEvent(this.container, "noteMouseUp", note, originalEvent)
        this._noteMouseDown = false
    }
    
    /**
     */
    private fun updateSelectionCursor(range: alphaTab.synth.PlaybackRange?): Unit{
        if (!alphaTab.core.TypeHelper.isTruthy(this._tickCache))
        {
            return
        }
        if (alphaTab.core.TypeHelper.isTruthy(range))
        {
            var startBeat: alphaTab.midi.MidiTickLookupFindBeatResult? = this._tickCache!!.findBeat(this._trackIndexLookup!!, range.startTick)
            var endBeat: alphaTab.midi.MidiTickLookupFindBeatResult? = this._tickCache!!.findBeat(this._trackIndexLookup!!, range.endTick)
            if (alphaTab.core.TypeHelper.isTruthy(startBeat) && alphaTab.core.TypeHelper.isTruthy(endBeat))
            {
                var selectionStart: alphaTab.SelectionInfo = alphaTab.SelectionInfo(startBeat.beat)
                var selectionEnd: alphaTab.SelectionInfo = alphaTab.SelectionInfo(endBeat.beat)
                this.cursorSelectRange(selectionStart, selectionEnd)
            }
        }
        else 
        {
            this.cursorSelectRange(null, null)
        }
    }
    
    private fun setupClickHandling(): Unit{
        this.canvasElement.mouseDown.on(fun(e: alphaTab.platform.IMouseEventArgs): Unit{
            if (!e.isLeftMouseButton)
            {
                return
            }
            if (this.settings.player.enableUserInteraction)
            {
                e.preventDefault()
            }
            var relX: Double = e.getX(this.canvasElement)
            var relY: Double = e.getY(this.canvasElement)
            var beat: alphaTab.model.Beat? = this.renderer.boundsLookup?.getBeatAtPos(relX, relY) 
            if (alphaTab.core.TypeHelper.isTruthy(beat))
            {
                this.onBeatMouseDown(e, beat)
                if (this.settings.core.includeNoteBounds)
                {
                    var note: alphaTab.model.Note? = this.renderer.boundsLookup?.getNoteAtPos(beat, relX, relY)
                    if (alphaTab.core.TypeHelper.isTruthy(note))
                    {
                        this.onNoteMouseDown(e, note)
                    }
                }
            }
        }
        )
        this.canvasElement.mouseMove.on(fun(e: alphaTab.platform.IMouseEventArgs): Unit{
            if (!this._beatMouseDown)
            {
                return
            }
            var relX: Double = e.getX(this.canvasElement)
            var relY: Double = e.getY(this.canvasElement)
            var beat: alphaTab.model.Beat? = this.renderer.boundsLookup?.getBeatAtPos(relX, relY) 
            if (alphaTab.core.TypeHelper.isTruthy(beat))
            {
                this.onBeatMouseMove(e, beat)
                if (this._noteMouseDown)
                {
                    var note: alphaTab.model.Note? = this.renderer.boundsLookup?.getNoteAtPos(beat, relX, relY)
                    if (alphaTab.core.TypeHelper.isTruthy(note))
                    {
                        this.onNoteMouseMove(e, note)
                    }
                }
            }
        }
        )
        this.canvasElement.mouseUp.on(fun(e: alphaTab.platform.IMouseEventArgs): Unit{
            if (!this._beatMouseDown)
            {
                return
            }
            if (this.settings.player.enableUserInteraction)
            {
                e.preventDefault()
            }
            var relX: Double = e.getX(this.canvasElement)
            var relY: Double = e.getY(this.canvasElement)
            var beat: alphaTab.model.Beat? = this.renderer.boundsLookup?.getBeatAtPos(relX, relY) 
            this.onBeatMouseUp(e, beat)
            if (this._noteMouseDown)
            {
                if (alphaTab.core.TypeHelper.isTruthy(beat))
                {
                    var note: alphaTab.model.Note? = this.renderer.boundsLookup?.getNoteAtPos(beat, relX, relY) 
                    this.onNoteMouseUp(e, note)
                }
                else 
                {
                    this.onNoteMouseUp(e, null)
                }
            }
        }
        )
        this.renderer.postRenderFinished.on(fun(): Unit{
            if (!alphaTab.core.TypeHelper.isTruthy(this._selectionStart) || !this.settings.player.enablePlayer || !this.settings.player.enableCursor || !this.settings.player.enableUserInteraction)
            {
                return
            }
            this.cursorSelectRange(this._selectionStart, this._selectionEnd)
        }
        )
    }
    
    /**
     */
    private fun cursorSelectRange(startBeat: alphaTab.SelectionInfo?, endBeat: alphaTab.SelectionInfo?): Unit{
        var paramstartBeat = startBeat
        var paramendBeat = endBeat
        var cache: alphaTab.rendering.utils.BoundsLookup? = this.renderer.boundsLookup
        if (!alphaTab.core.TypeHelper.isTruthy(cache))
        {
            return
        }
        var selectionWrapper: alphaTab.platform.IContainer? = this._selectionWrapper
        if (!alphaTab.core.TypeHelper.isTruthy(selectionWrapper))
        {
            return
        }
        selectionWrapper.clear()
        if (!alphaTab.core.TypeHelper.isTruthy(paramstartBeat) || !alphaTab.core.TypeHelper.isTruthy(paramendBeat) || paramstartBeat.beat == paramendBeat.beat)
        {
            return
        }
        if (!alphaTab.core.TypeHelper.isTruthy(paramstartBeat.bounds))
        {
            paramstartBeat.bounds = cache.findBeat(paramstartBeat.beat)
        }
        if (!alphaTab.core.TypeHelper.isTruthy(paramendBeat.bounds))
        {
            paramendBeat.bounds = cache.findBeat(paramendBeat.beat)
        }
        var startTick: Double = this._tickCache?.getBeatStart(paramstartBeat.beat) ?: paramstartBeat.beat.absolutePlaybackStart
        var endTick: Double = this._tickCache?.getBeatStart(paramendBeat.beat) ?: paramendBeat.beat.absolutePlaybackStart
        if (endTick < startTick)
        {
            var t: alphaTab.SelectionInfo = paramstartBeat
            paramstartBeat = paramendBeat
            paramendBeat = t
        }
        var startX: Double = paramstartBeat.bounds!!.realBounds.x
        var endX: Double = paramendBeat.bounds!!.realBounds.x + paramendBeat.bounds!!.realBounds.w
        if (paramendBeat.beat.index == paramendBeat.beat.voice.beats.length - 1.0)
        {
            endX = paramendBeat.bounds!!.barBounds.masterBarBounds.realBounds.x + paramendBeat.bounds!!.barBounds.masterBarBounds.realBounds.w
        }
        if (paramstartBeat.bounds!!.barBounds.masterBarBounds.staveGroupBounds != paramendBeat.bounds!!.barBounds.masterBarBounds.staveGroupBounds)
        {
            var staffStartX: Double = paramstartBeat.bounds!!.barBounds.masterBarBounds.staveGroupBounds!!.visualBounds.x
            var staffEndX: Double = paramstartBeat.bounds!!.barBounds.masterBarBounds.staveGroupBounds!!.visualBounds.x + paramstartBeat.bounds!!.barBounds.masterBarBounds.staveGroupBounds!!.visualBounds.w
            var startSelection: alphaTab.platform.IContainer = this.uiFacade.createSelectionElement()!!
            startSelection.setBounds(startX, paramstartBeat.bounds!!.barBounds.masterBarBounds.visualBounds.y, staffEndX - startX, paramstartBeat.bounds!!.barBounds.masterBarBounds.visualBounds.h)
            selectionWrapper.appendChild(startSelection)
            var staffStartIndex: Double = paramstartBeat.bounds!!.barBounds.masterBarBounds.staveGroupBounds!!.index + 1.0
            var staffEndIndex: Double = paramendBeat.bounds!!.barBounds.masterBarBounds.staveGroupBounds!!.index
            if(true) {
                var staffIndex: Double = staffStartIndex
                
                while(staffIndex < staffEndIndex){
                    try{
                        var staffBounds: alphaTab.rendering.utils.StaveGroupBounds = cache.staveGroups[(staffIndex).toInt()]
                        var middleSelection: alphaTab.platform.IContainer = this.uiFacade.createSelectionElement()!!
                        middleSelection.setBounds(staffStartX, staffBounds.visualBounds.y, staffEndX - staffStartX, staffBounds.visualBounds.h)
                        selectionWrapper.appendChild(middleSelection)
                    }
                    finally{
                        staffIndex++
                    }
                }
            }
            var endSelection: alphaTab.platform.IContainer = this.uiFacade.createSelectionElement()!!
            endSelection.setBounds(staffStartX, paramendBeat.bounds!!.barBounds.masterBarBounds.visualBounds.y, endX - staffStartX, paramendBeat.bounds!!.barBounds.masterBarBounds.visualBounds.h)
            selectionWrapper.appendChild(endSelection)
        }
        else 
        {
            var selection: alphaTab.platform.IContainer = this.uiFacade.createSelectionElement()!!
            selection.setBounds(startX, paramstartBeat.bounds!!.barBounds.masterBarBounds.visualBounds.y, endX - startX, paramstartBeat.bounds!!.barBounds.masterBarBounds.visualBounds.h)
            selectionWrapper.appendChild(selection)
        }
    }
    
    public var scoreLoaded: alphaTab.IEventEmitterOfT<alphaTab.model.Score> = alphaTab.EventEmitterOfT<alphaTab.model.Score>()
    
    /**
     */
    private fun onScoreLoaded(score: alphaTab.model.Score): Unit{
        if (this._isDestroyed)
        {
            return
        }
        ((this.scoreLoaded as alphaTab.EventEmitterOfT<alphaTab.model.Score>)).trigger(score)
        this.uiFacade.triggerEvent(this.container, "scoreLoaded", score)
    }
    
    public var resize: alphaTab.IEventEmitterOfT<alphaTab.ResizeEventArgs> = alphaTab.EventEmitterOfT<alphaTab.ResizeEventArgs>()
    
    /**
     */
    private fun onResize(e: alphaTab.ResizeEventArgs): Unit{
        if (this._isDestroyed)
        {
            return
        }
        ((this.resize as alphaTab.EventEmitterOfT<alphaTab.ResizeEventArgs>)).trigger(e)
        this.uiFacade.triggerEvent(this.container, "resize", e)
    }
    
    public var renderStarted: alphaTab.IEventEmitterOfT<Boolean> = alphaTab.EventEmitterOfT<Boolean>()
    
    /**
     */
    private fun onRenderStarted(resize: Boolean): Unit{
        if (this._isDestroyed)
        {
            return
        }
        ((this.renderStarted as alphaTab.EventEmitterOfT<Boolean>)).trigger(resize)
        this.uiFacade.triggerEvent(this.container, "renderStarted", ((resize as Any?)))
    }
    
    public var renderFinished: alphaTab.IEventEmitterOfT<alphaTab.rendering.RenderFinishedEventArgs> = alphaTab.EventEmitterOfT<alphaTab.rendering.RenderFinishedEventArgs>()
    
    /**
     */
    private fun onRenderFinished(renderingResult: alphaTab.rendering.RenderFinishedEventArgs): Unit{
        if (this._isDestroyed)
        {
            return
        }
        ((this.renderFinished as alphaTab.EventEmitterOfT<alphaTab.rendering.RenderFinishedEventArgs>)).trigger(renderingResult)
        this.uiFacade.triggerEvent(this.container, "renderFinished", renderingResult)
    }
    
    public var postRenderFinished: alphaTab.IEventEmitter = alphaTab.EventEmitter()
    
    private fun onPostRenderFinished(): Unit{
        if (this._isDestroyed)
        {
            return
        }
        ((this.postRenderFinished as alphaTab.EventEmitter)).trigger()
        this.uiFacade.triggerEvent(this.container, "postRenderFinished", null)
    }
    
    public var error: alphaTab.IEventEmitterOfT<alphaTab.core.ecmaScript.Error> = alphaTab.EventEmitterOfT<alphaTab.core.ecmaScript.Error>()
    
    /**
     */
    public fun onError(error: alphaTab.core.ecmaScript.Error): Unit{
        if (this._isDestroyed)
        {
            return
        }
        alphaTab.Logger.error("API", "An unexpected error occurred", error)
        ((this.error as alphaTab.EventEmitterOfT<alphaTab.core.ecmaScript.Error>)).trigger(error)
        this.uiFacade.triggerEvent(this.container, "error", error)
    }
    
    public var playerReady: alphaTab.IEventEmitter = alphaTab.EventEmitter()
    
    private fun onPlayerReady(): Unit{
        if (this._isDestroyed)
        {
            return
        }
        ((this.playerReady as alphaTab.EventEmitter)).trigger()
        this.uiFacade.triggerEvent(this.container, "playerReady", null)
    }
    
    public var playerFinished: alphaTab.IEventEmitter = alphaTab.EventEmitter()
    
    private fun onPlayerFinished(): Unit{
        if (this._isDestroyed)
        {
            return
        }
        ((this.playerFinished as alphaTab.EventEmitter)).trigger()
        this.uiFacade.triggerEvent(this.container, "playerFinished", null)
    }
    
    public var soundFontLoaded: alphaTab.IEventEmitter = alphaTab.EventEmitter()
    
    private fun onSoundFontLoaded(): Unit{
        if (this._isDestroyed)
        {
            return
        }
        ((this.soundFontLoaded as alphaTab.EventEmitter)).trigger()
        this.uiFacade.triggerEvent(this.container, "soundFontLoaded", null)
    }
    
    public var midiLoad: alphaTab.IEventEmitterOfT<alphaTab.midi.MidiFile> = alphaTab.EventEmitterOfT<alphaTab.midi.MidiFile>()
    
    /**
     */
    private fun onMidiLoad(e: alphaTab.midi.MidiFile): Unit{
        if (this._isDestroyed)
        {
            return
        }
        ((this.midiLoad as alphaTab.EventEmitterOfT<alphaTab.midi.MidiFile>)).trigger(e)
        this.uiFacade.triggerEvent(this.container, "midiLoad", e)
    }
    
    public var midiLoaded: alphaTab.IEventEmitterOfT<alphaTab.synth.PositionChangedEventArgs> = alphaTab.EventEmitterOfT<alphaTab.synth.PositionChangedEventArgs>()
    
    /**
     */
    private fun onMidiLoaded(e: alphaTab.synth.PositionChangedEventArgs): Unit{
        if (this._isDestroyed)
        {
            return
        }
        ((this.midiLoaded as alphaTab.EventEmitterOfT<alphaTab.synth.PositionChangedEventArgs>)).trigger(e)
        this.uiFacade.triggerEvent(this.container, "midiFileLoaded", e)
    }
    
    public var playerStateChanged: alphaTab.IEventEmitterOfT<alphaTab.synth.PlayerStateChangedEventArgs> = alphaTab.EventEmitterOfT<alphaTab.synth.PlayerStateChangedEventArgs>()
    
    /**
     */
    private fun onPlayerStateChanged(e: alphaTab.synth.PlayerStateChangedEventArgs): Unit{
        if (this._isDestroyed)
        {
            return
        }
        ((this.playerStateChanged as alphaTab.EventEmitterOfT<alphaTab.synth.PlayerStateChangedEventArgs>)).trigger(e)
        this.uiFacade.triggerEvent(this.container, "playerStateChanged", e)
    }
    
    public var playerPositionChanged: alphaTab.IEventEmitterOfT<alphaTab.synth.PositionChangedEventArgs> = alphaTab.EventEmitterOfT<alphaTab.synth.PositionChangedEventArgs>()
    
    /**
     */
    private fun onPlayerPositionChanged(e: alphaTab.synth.PositionChangedEventArgs): Unit{
        if (this._isDestroyed)
        {
            return
        }
        if (this.score != null && this.tracks.length > 0)
        {
            ((this.playerPositionChanged as alphaTab.EventEmitterOfT<alphaTab.synth.PositionChangedEventArgs>)).trigger(e)
            this.uiFacade.triggerEvent(this.container, "playerPositionChanged", e)
        }
    }
    
    public var midiEventsPlayed: alphaTab.IEventEmitterOfT<alphaTab.synth.MidiEventsPlayedEventArgs> = alphaTab.EventEmitterOfT<alphaTab.synth.MidiEventsPlayedEventArgs>()
    
    /**
     */
    private fun onMidiEventsPlayed(e: alphaTab.synth.MidiEventsPlayedEventArgs): Unit{
        if (this._isDestroyed)
        {
            return
        }
        ((this.midiEventsPlayed as alphaTab.EventEmitterOfT<alphaTab.synth.MidiEventsPlayedEventArgs>)).trigger(e)
        this.uiFacade.triggerEvent(this.container, "midiEventsPlayed", e)
    }
    
    public var playbackRangeChanged: alphaTab.IEventEmitterOfT<alphaTab.synth.PlaybackRangeChangedEventArgs> = alphaTab.EventEmitterOfT<alphaTab.synth.PlaybackRangeChangedEventArgs>()
    
    /**
     */
    private fun onPlaybackRangeChanged(e: alphaTab.synth.PlaybackRangeChangedEventArgs): Unit{
        if (this._isDestroyed)
        {
            return
        }
        ((this.playbackRangeChanged as alphaTab.EventEmitterOfT<alphaTab.synth.PlaybackRangeChangedEventArgs>)).trigger(e)
        this.uiFacade.triggerEvent(this.container, "playbackRangeChanged", e)
    }
    
    internal var settingsUpdated: alphaTab.IEventEmitter = alphaTab.EventEmitter()
    
    private fun onSettingsUpdated(): Unit{
        if (this._isDestroyed)
        {
            return
        }
        ((this.settingsUpdated as alphaTab.EventEmitter)).trigger()
        this.uiFacade.triggerEvent(this.container, "settingsUpdated", null)
    }
    
}

@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class SelectionInfo
{
    public var beat: alphaTab.model.Beat
    public var bounds: alphaTab.rendering.utils.BeatBounds? = null
    
    public constructor(beat: alphaTab.model.Beat){
        this.beat = beat
    }
    
}

