// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab
import alphaTab.core.*

/**
 * This public class represents the global alphaTab environment where
 * alphaTab looks for information like available layout engines
 * staves etc.
 * This public class represents the global alphaTab environment where
 * alphaTab looks for information like available layout engines
 * staves etc.
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
public class Environment
{
    companion object{
        /**
         * The font size of the music font in pixel.
         */
        @kotlin.jvm.JvmStatic
        public val MusicFontSize: Double = 34.0
        
        /**
         * The scaling factor to use when rending raster graphics for sharper rendering on high-dpi displays.
         */
        @kotlin.jvm.JvmStatic
        public var HighDpiFactor: Double = 1.0
        
        /**
         */
        @kotlin.jvm.JvmStatic
        private fun appendScriptName(url: String): String{
            var paramurl = url
            if (alphaTab.core.TypeHelper.isTruthy(paramurl) && !paramurl.endsWith(".js"))
            {
                if (!paramurl.endsWith("/"))
                {
                    paramurl += "/"
                }
                paramurl += "alphaTab.js"
            }
            return paramurl
        }
        
        @kotlin.jvm.JvmStatic
        public var renderEngines: alphaTab.collections.Map<String, alphaTab.RenderEngineFactory> = alphaTab.Environment.createDefaultRenderEngines()
        
        @kotlin.jvm.JvmStatic
        public var layoutEngines: alphaTab.collections.Map<alphaTab.LayoutMode, alphaTab.LayoutEngineFactory> = alphaTab.Environment.createDefaultLayoutEngines()
        
        @kotlin.jvm.JvmStatic
        public var staveProfiles: alphaTab.collections.Map<alphaTab.StaveProfile, alphaTab.collections.List<alphaTab.rendering.BarRendererFactory>> = alphaTab.Environment.createDefaultStaveProfiles()
        
        /**
         */
        @kotlin.jvm.JvmStatic
        public fun getRenderEngineFactory(engine: String): alphaTab.RenderEngineFactory{
            if (!alphaTab.core.TypeHelper.isTruthy(engine) || !alphaTab.Environment.renderEngines.has(engine))
            {
                return alphaTab.Environment.renderEngines.get("default")!!
            }
            return alphaTab.Environment.renderEngines.get(engine)!!
        }
        
        /**
         */
        @kotlin.jvm.JvmStatic
        public fun getLayoutEngineFactory(layoutMode: alphaTab.LayoutMode): alphaTab.LayoutEngineFactory{
            if (!alphaTab.core.TypeHelper.isTruthy(layoutMode) || !alphaTab.Environment.layoutEngines.has(layoutMode))
            {
                return alphaTab.Environment.layoutEngines.get(alphaTab.LayoutMode.Page)!!
            }
            return alphaTab.Environment.layoutEngines.get(layoutMode)!!
        }
        
        /**
         * Gets all default ScoreImporters
         */
        @kotlin.jvm.JvmStatic
        public fun buildImporters(): alphaTab.collections.List<alphaTab.importer.ScoreImporter>{
            return alphaTab.collections.List<alphaTab.importer.ScoreImporter>(
                alphaTab.importer.Gp3To5Importer(), alphaTab.importer.GpxImporter(), alphaTab.importer.Gp7Importer(), alphaTab.importer.MusicXmlImporter(), alphaTab.importer.CapellaImporter(), alphaTab.importer.AlphaTexImporter())
            
        }
        
        @kotlin.jvm.JvmStatic
        private fun createDefaultRenderEngines(): alphaTab.collections.Map<String, alphaTab.RenderEngineFactory>{
            var renderEngines: alphaTab.collections.Map<String, alphaTab.RenderEngineFactory> = alphaTab.collections.Map<String, alphaTab.RenderEngineFactory>()
            renderEngines.set("svg", alphaTab.RenderEngineFactory(true, fun(): alphaTab.platform.svg.CssFontSvgCanvas{
                return alphaTab.platform.svg.CssFontSvgCanvas()
            }
            ))
            renderEngines.set("default", renderEngines.get("svg")!!)
            renderEngines.set("skia", alphaTab.RenderEngineFactory(false, fun(): alphaTab.platform.skia.SkiaCanvas{
                return alphaTab.platform.skia.SkiaCanvas()
            }
            ))
            alphaTab.EnvironmentPartials.createPlatformSpecificRenderEngines(renderEngines)
            return renderEngines
        }
        
        /**
         * Enables the usage of alphaSkia as rendering backend.
         * @param musicFontData The raw binary data of the music font.
         * @param alphaSkia The alphaSkia module.
         */
        @kotlin.jvm.JvmStatic
        public fun enableAlphaSkia(musicFontData: alphaTab.core.ecmaScript.ArrayBuffer, alphaSkia: Any?): Unit{
            alphaTab.platform.skia.SkiaCanvasPartials.enable(musicFontData, alphaSkia)
        }
        
        /**
         * Registers a new custom font for the usage in the alphaSkia rendering backend using
         * provided font information.
         * @param fontData The raw binary data of the font.
         * @param fontInfo If provided the font info provided overrules
         */
        @kotlin.jvm.JvmStatic
        public fun registerAlphaSkiaCustomFont(fontData: alphaTab.core.ecmaScript.Uint8Array, fontInfo: alphaTab.model.Font? = null): alphaTab.model.Font{
            return alphaTab.platform.skia.SkiaCanvas.registerFont(fontData, fontInfo)
        }
        
        @kotlin.jvm.JvmStatic
        private fun createDefaultStaveProfiles(): alphaTab.collections.Map<alphaTab.StaveProfile, alphaTab.collections.List<alphaTab.rendering.BarRendererFactory>>{
            var staveProfiles: alphaTab.collections.Map<alphaTab.StaveProfile, alphaTab.collections.List<alphaTab.rendering.BarRendererFactory>> = alphaTab.collections.Map<alphaTab.StaveProfile, alphaTab.collections.List<alphaTab.rendering.BarRendererFactory>>()
            staveProfiles.set(alphaTab.StaveProfile.ScoreTab, alphaTab.collections.List<alphaTab.rendering.BarRendererFactory>(
                alphaTab.rendering.EffectBarRendererFactory("score-effects", alphaTab.collections.List<alphaTab.rendering.EffectBarRendererInfo>(
                    
                    alphaTab.rendering.effects.TempoEffectInfo(), 
                    alphaTab.rendering.effects.TripletFeelEffectInfo(), 
                    alphaTab.rendering.effects.MarkerEffectInfo(), 
                    alphaTab.rendering.effects.TextEffectInfo(), 
                    alphaTab.rendering.effects.ChordsEffectInfo(), 
                    alphaTab.rendering.effects.FermataEffectInfo(), 
                    alphaTab.rendering.effects.WhammyBarEffectInfo(), 
                    alphaTab.rendering.effects.TrillEffectInfo(), 
                    alphaTab.rendering.effects.OttaviaEffectInfo(true), 
                    alphaTab.rendering.effects.WideBeatVibratoEffectInfo(), 
                    alphaTab.rendering.effects.SlightBeatVibratoEffectInfo(), 
                    alphaTab.rendering.effects.WideNoteVibratoEffectInfo(), 
                    alphaTab.rendering.effects.SlightNoteVibratoEffectInfo(), 
                    alphaTab.rendering.effects.LeftHandTapEffectInfo(), 
                    alphaTab.rendering.effects.AlternateEndingsEffectInfo())
                ), alphaTab.rendering.ScoreBarRendererFactory(), alphaTab.rendering.EffectBarRendererFactory("tab-effects", alphaTab.collections.List<alphaTab.rendering.EffectBarRendererInfo>(
                    
                    alphaTab.rendering.effects.CrescendoEffectInfo(), 
                    alphaTab.rendering.effects.OttaviaEffectInfo(false), 
                    alphaTab.rendering.effects.DynamicsEffectInfo(), 
                    alphaTab.rendering.effects.LyricsEffectInfo(), 
                    alphaTab.rendering.effects.TrillEffectInfo(), 
                    alphaTab.rendering.effects.WideBeatVibratoEffectInfo(), 
                    alphaTab.rendering.effects.SlightBeatVibratoEffectInfo(), 
                    alphaTab.rendering.effects.WideNoteVibratoEffectInfo(), 
                    alphaTab.rendering.effects.SlightNoteVibratoEffectInfo(), 
                    alphaTab.rendering.effects.TapEffectInfo(), 
                    alphaTab.rendering.effects.FadeInEffectInfo(), 
                    alphaTab.rendering.effects.HarmonicsEffectInfo(alphaTab.model.HarmonicType.Natural), 
                    alphaTab.rendering.effects.HarmonicsEffectInfo(alphaTab.model.HarmonicType.Artificial), 
                    alphaTab.rendering.effects.HarmonicsEffectInfo(alphaTab.model.HarmonicType.Pinch), 
                    alphaTab.rendering.effects.HarmonicsEffectInfo(alphaTab.model.HarmonicType.Tap), 
                    alphaTab.rendering.effects.HarmonicsEffectInfo(alphaTab.model.HarmonicType.Semi), 
                    alphaTab.rendering.effects.HarmonicsEffectInfo(alphaTab.model.HarmonicType.Feedback), 
                    alphaTab.rendering.effects.LetRingEffectInfo(), 
                    alphaTab.rendering.effects.CapoEffectInfo(), 
                    alphaTab.rendering.effects.FingeringEffectInfo(), 
                    alphaTab.rendering.effects.PalmMuteEffectInfo(), 
                    alphaTab.rendering.effects.PickStrokeEffectInfo(), 
                    alphaTab.rendering.effects.PickSlideEffectInfo(), 
                    alphaTab.rendering.effects.LeftHandTapEffectInfo())
                ), alphaTab.rendering.TabBarRendererFactory(false, false, false))
            )
            staveProfiles.set(alphaTab.StaveProfile.Score, alphaTab.collections.List<alphaTab.rendering.BarRendererFactory>(
                alphaTab.rendering.EffectBarRendererFactory("score-effects", alphaTab.collections.List<alphaTab.rendering.EffectBarRendererInfo>(
                    
                    alphaTab.rendering.effects.TempoEffectInfo(), 
                    alphaTab.rendering.effects.TripletFeelEffectInfo(), 
                    alphaTab.rendering.effects.MarkerEffectInfo(), 
                    alphaTab.rendering.effects.TextEffectInfo(), 
                    alphaTab.rendering.effects.ChordsEffectInfo(), 
                    alphaTab.rendering.effects.FermataEffectInfo(), 
                    alphaTab.rendering.effects.WhammyBarEffectInfo(), 
                    alphaTab.rendering.effects.TrillEffectInfo(), 
                    alphaTab.rendering.effects.OttaviaEffectInfo(true), 
                    alphaTab.rendering.effects.WideBeatVibratoEffectInfo(), 
                    alphaTab.rendering.effects.SlightBeatVibratoEffectInfo(), 
                    alphaTab.rendering.effects.WideNoteVibratoEffectInfo(), 
                    alphaTab.rendering.effects.SlightNoteVibratoEffectInfo(), 
                    alphaTab.rendering.effects.FadeInEffectInfo(), 
                    alphaTab.rendering.effects.LetRingEffectInfo(), 
                    alphaTab.rendering.effects.PalmMuteEffectInfo(), 
                    alphaTab.rendering.effects.PickStrokeEffectInfo(), 
                    alphaTab.rendering.effects.PickSlideEffectInfo(), 
                    alphaTab.rendering.effects.LeftHandTapEffectInfo(), 
                    alphaTab.rendering.effects.AlternateEndingsEffectInfo())
                ), alphaTab.rendering.ScoreBarRendererFactory(), alphaTab.rendering.EffectBarRendererFactory("score-bottom-effects", alphaTab.collections.List<alphaTab.rendering.EffectBarRendererInfo>(
                    alphaTab.rendering.effects.CrescendoEffectInfo(), alphaTab.rendering.effects.OttaviaEffectInfo(false), alphaTab.rendering.effects.DynamicsEffectInfo(), alphaTab.rendering.effects.LyricsEffectInfo())
                ))
            )
            var tabEffectInfos: alphaTab.collections.List<alphaTab.rendering.EffectBarRendererInfo> = alphaTab.collections.List<alphaTab.rendering.EffectBarRendererInfo>(
                
                alphaTab.rendering.effects.TempoEffectInfo(), 
                alphaTab.rendering.effects.TripletFeelEffectInfo(), 
                alphaTab.rendering.effects.MarkerEffectInfo(), 
                alphaTab.rendering.effects.TextEffectInfo(), 
                alphaTab.rendering.effects.ChordsEffectInfo(), 
                alphaTab.rendering.effects.FermataEffectInfo(), 
                alphaTab.rendering.effects.TrillEffectInfo(), 
                alphaTab.rendering.effects.WideBeatVibratoEffectInfo(), 
                alphaTab.rendering.effects.SlightBeatVibratoEffectInfo(), 
                alphaTab.rendering.effects.WideNoteVibratoEffectInfo(), 
                alphaTab.rendering.effects.SlightNoteVibratoEffectInfo(), 
                alphaTab.rendering.effects.TapEffectInfo(), 
                alphaTab.rendering.effects.FadeInEffectInfo(), 
                alphaTab.rendering.effects.HarmonicsEffectInfo(alphaTab.model.HarmonicType.Artificial), 
                alphaTab.rendering.effects.HarmonicsEffectInfo(alphaTab.model.HarmonicType.Pinch), 
                alphaTab.rendering.effects.HarmonicsEffectInfo(alphaTab.model.HarmonicType.Tap), 
                alphaTab.rendering.effects.HarmonicsEffectInfo(alphaTab.model.HarmonicType.Semi), 
                alphaTab.rendering.effects.HarmonicsEffectInfo(alphaTab.model.HarmonicType.Feedback), 
                alphaTab.rendering.effects.LetRingEffectInfo(), 
                alphaTab.rendering.effects.CapoEffectInfo(), 
                alphaTab.rendering.effects.FingeringEffectInfo(), 
                alphaTab.rendering.effects.PalmMuteEffectInfo(), 
                alphaTab.rendering.effects.PickStrokeEffectInfo(), 
                alphaTab.rendering.effects.PickSlideEffectInfo(), 
                alphaTab.rendering.effects.LeftHandTapEffectInfo(), 
                alphaTab.rendering.effects.AlternateEndingsEffectInfo())
            
            staveProfiles.set(alphaTab.StaveProfile.Tab, alphaTab.collections.List<alphaTab.rendering.BarRendererFactory>(
                alphaTab.rendering.EffectBarRendererFactory("tab-effects", tabEffectInfos), alphaTab.rendering.TabBarRendererFactory(true, true, true), alphaTab.rendering.EffectBarRendererFactory("tab-bottom-effects", alphaTab.collections.List<alphaTab.rendering.EffectBarRendererInfo>(
                    alphaTab.rendering.effects.LyricsEffectInfo())
                ))
            )
            staveProfiles.set(alphaTab.StaveProfile.TabMixed, alphaTab.collections.List<alphaTab.rendering.BarRendererFactory>(
                alphaTab.rendering.EffectBarRendererFactory("tab-effects", tabEffectInfos), alphaTab.rendering.TabBarRendererFactory(false, false, false), alphaTab.rendering.EffectBarRendererFactory("tab-bottom-effects", alphaTab.collections.List<alphaTab.rendering.EffectBarRendererInfo>(
                    alphaTab.rendering.effects.LyricsEffectInfo())
                ))
            )
            return staveProfiles
        }
        
        @kotlin.jvm.JvmStatic
        private fun createDefaultLayoutEngines(): alphaTab.collections.Map<alphaTab.LayoutMode, alphaTab.LayoutEngineFactory>{
            var engines: alphaTab.collections.Map<alphaTab.LayoutMode, alphaTab.LayoutEngineFactory> = alphaTab.collections.Map<alphaTab.LayoutMode, alphaTab.LayoutEngineFactory>()
            engines.set(alphaTab.LayoutMode.Page, alphaTab.LayoutEngineFactory(true, fun(r: alphaTab.rendering.ScoreRenderer): alphaTab.rendering.layout.PageViewLayout{
                return alphaTab.rendering.layout.PageViewLayout(r)
            }
            ))
            engines.set(alphaTab.LayoutMode.Horizontal, alphaTab.LayoutEngineFactory(false, fun(r: alphaTab.rendering.ScoreRenderer): alphaTab.rendering.layout.HorizontalScreenLayout{
                return alphaTab.rendering.layout.HorizontalScreenLayout(r)
            }
            ))
            return engines
        }
        
    }
    public constructor()
}

@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
public class LayoutEngineFactory
{
    public var vertical: Boolean
    public var createLayout: (arg1: alphaTab.rendering.ScoreRenderer) -> alphaTab.rendering.layout.ScoreLayout
    public constructor(vertical: Boolean, createLayout: (arg1: alphaTab.rendering.ScoreRenderer) -> alphaTab.rendering.layout.ScoreLayout){
        this.vertical = vertical
        this.createLayout = createLayout
    }
    
}

@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
public class RenderEngineFactory
{
    public var supportsWorkers: Boolean
    public var createCanvas: () -> alphaTab.platform.ICanvas
    public constructor(supportsWorkers: Boolean, canvas: () -> alphaTab.platform.ICanvas){
        this.supportsWorkers = supportsWorkers
        this.createCanvas = canvas
    }
    
}

