// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab
import alphaTab.core.*

/**
 * The notation settings control how various music notation elements are shown and behaving
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
public class NotationSettings
{
    /**
     * Gets or sets the mode to use for display and play music notation elements.
     */
    public var notationMode: alphaTab.NotationMode = alphaTab.NotationMode.GuitarPro
    
    /**
     * Gets or sets the fingering mode to use.
     */
    public var fingeringMode: alphaTab.FingeringMode = alphaTab.FingeringMode.ScoreDefault
    
    /**
     * Gets or sets the configuration on whether music notation elements are visible or not.
     * If notation elements are not specified, the default configuration will be applied.
     */
    public var elements: alphaTab.collections.ObjectBooleanMap<alphaTab.NotationElement> = alphaTab.collections.ObjectBooleanMap<alphaTab.NotationElement>()
    
    /**
     * Whether to show rhythm notation in the guitar tablature.
     */
    public var rhythmMode: alphaTab.TabRhythmMode = alphaTab.TabRhythmMode.Hidden
    
    /**
     * The height of the rythm bars.
     */
    public var rhythmHeight: Double = 15.0
    
    /**
     * The transposition pitch offsets for the individual tracks.
     * They apply to rendering and playback.
     */
    public var transpositionPitches: alphaTab.collections.DoubleList = alphaTab.collections.DoubleList(
    )
    
    
    /**
     * The transposition pitch offsets for the individual tracks.
     * They apply to rendering only.
     */
    public var displayTranspositionPitches: alphaTab.collections.DoubleList = alphaTab.collections.DoubleList(
    )
    
    
    /**
     * If set to true the guitar tabs on grace beats are rendered smaller.
     */
    public var smallGraceTabNotes: Boolean = true
    
    /**
     * If set to true bend arrows expand to the end of the last tied note
     * of the string. Otherwise they end on the next beat.
     */
    public var extendBendArrowsOnTiedNotes: Boolean = true
    
    /**
     * If set to true, line effects (like w/bar, let-ring etc)
     * are drawn until the end of the beat instead of the start.
     */
    public var extendLineEffectsToBeatEnd: Boolean = false
    
    /**
     * Gets or sets the height for slurs. The factor is multiplied with the a logarithmic distance
     * between slur start and end.
     */
    public var slurHeight: Double = 5.0
    
    /**
     * Gets whether the given music notation element should be shown
     * @param element the element to check
     */
    public fun isNotationElementVisible(element: alphaTab.NotationElement): Boolean{
        if (this.elements.has(element))
        {
            return this.elements.get(element)!!
        }
        if (alphaTab.NotationSettings.defaultElements.has(element))
        {
            return alphaTab.NotationSettings.defaultElements.get(element)!!
        }
        return true
    }
    
    companion object{
        /**
         * Gets the default configuration of the {@see notationElements} setting. Do not modify
         * this map as it might not result in the expected side effects.
         * If items are not listed explicitly in this list, they are considered visible.
         */
        @kotlin.jvm.JvmStatic
        public var defaultElements: alphaTab.collections.ObjectBooleanMap<alphaTab.NotationElement> = alphaTab.collections.ObjectBooleanMap<alphaTab.NotationElement>(alphaTab.core.TypeHelper.mapInitializer<alphaTab.collections.ObjectBooleanMapEntry<alphaTab.NotationElement>>(alphaTab.collections.ObjectBooleanMapEntry<alphaTab.NotationElement>(((alphaTab.NotationElement.ZerosOnDiveWhammys as alphaTab.NotationElement)), false)))
        
    }
    public constructor()
}

/**
 * Lists the different modes on how rhythm notation is shown on the tab staff.
 */
public enum class TabRhythmMode(override val value: Int): alphaTab.core.IAlphaTabEnum
{
    /**
     * Rhythm notation is hidden.
     */
    Hidden(0),
    /**
     * Rhythm notation is shown with individual beams per beat.
     */
    ShowWithBeams(1),
    /**
     * Rhythm notation is shown and behaves like normal score notation with connected bars.
     */
    ShowWithBars(2);
    companion object{
        public fun fromValue(v:Double): TabRhythmMode{
            return when(v.toInt()){
                Hidden.value -> Hidden
                ShowWithBeams.value -> ShowWithBeams
                ShowWithBars.value -> ShowWithBars
                else -> throw ClassCastException("No enum with value $v found")}
        }
    }
}

/**
 * Lists all modes on how fingerings should be displayed.
 */
public enum class FingeringMode(override val value: Int): alphaTab.core.IAlphaTabEnum
{
    /**
     * Fingerings will be shown in the standard notation staff.
     */
    ScoreDefault(0),
    /**
     * Fingerings will be shown in the standard notation staff. Piano finger style is enforced, where
     * fingers are rendered as 1-5 instead of p,i,m,a,c and T,1,2,3,4.
     */
    ScoreForcePiano(1),
    /**
     * Fingerings will be shown in a effect band above the tabs in case
     * they have only a single note on the beat.
     */
    SingleNoteEffectBand(2),
    /**
     * Fingerings will be shown in a effect band above the tabs in case
     * they have only a single note on the beat. Piano finger style is enforced, where
     * fingers are rendered as 1-5 instead of p,i,m,a,c and T,1,2,3,4.
     */
    SingleNoteEffectBandForcePiano(3);
    companion object{
        public fun fromValue(v:Double): FingeringMode{
            return when(v.toInt()){
                ScoreDefault.value -> ScoreDefault
                ScoreForcePiano.value -> ScoreForcePiano
                SingleNoteEffectBand.value -> SingleNoteEffectBand
                SingleNoteEffectBandForcePiano.value -> SingleNoteEffectBandForcePiano
                else -> throw ClassCastException("No enum with value $v found")}
        }
    }
}

/**
 * Lists all modes on how alphaTab can handle the display and playback of music notation.
 */
public enum class NotationMode(override val value: Int): alphaTab.core.IAlphaTabEnum
{
    /**
     * Music elements will be displayed and played as in Guitar Pro.
     */
    GuitarPro(0),
    /**
     * Music elements will be displayed and played as in traditional songbooks.
     * Changes:
     * 1. Bends
     *   For bends additional grace beats are introduced.
     *   Bends are categorized into gradual and fast bends.
     *   - Gradual bends are indicated by beat text "grad" or "grad.". Bend will sound along the beat duration.
     *   - Fast bends are done right before the next note. If the next note is tied even on-beat of the next note.
     * 2. Whammy Bars
     *   Dips are shown as simple annotation over the beats
     *   Whammy Bars are categorized into gradual and fast.
     *   - Gradual whammys are indicated by beat text "grad" or "grad.". Whammys will sound along the beat duration.
     *   - Fast whammys are done right the beat.
     * 3. Let Ring
     *   Tied notes with let ring are not shown in standard notation
     *   Let ring does not cause a longer playback, duration is defined via tied notes.
     */
    SongBook(1);
    companion object{
        public fun fromValue(v:Double): NotationMode{
            return when(v.toInt()){
                GuitarPro.value -> GuitarPro
                SongBook.value -> SongBook
                else -> throw ClassCastException("No enum with value $v found")}
        }
    }
}

/**
 * Lists all major music notation elements that are part
 * of the music sheet and can be dynamically controlled to be shown
 * or hidden.
 */
public enum class NotationElement(override val value: Int): alphaTab.core.IAlphaTabEnum
{
    /**
     * The score title shown at the start of the music sheet.
     */
    ScoreTitle(0),
    /**
     * The score subtitle shown at the start of the music sheet.
     */
    ScoreSubTitle(1),
    /**
     * The score artist shown at the start of the music sheet.
     */
    ScoreArtist(2),
    /**
     * The score album shown at the start of the music sheet.
     */
    ScoreAlbum(3),
    /**
     * The score words author shown at the start of the music sheet.
     */
    ScoreWords(4),
    /**
     * The score music author shown at the start of the music sheet.
     */
    ScoreMusic(5),
    /**
     * The score words&music author shown at the start of the music sheet.
     */
    ScoreWordsAndMusic(6),
    /**
     * The score copyright owner shown at the start of the music sheet.
     */
    ScoreCopyright(7),
    /**
     * The tuning information of the guitar shown
     * above the staves.
     */
    GuitarTuning(8),
    /**
     * The track names which are shown in the accolade.
     */
    TrackNames(9),
    /**
     * The chord diagrams for guitars. Usually shown
     * below the score info.
     */
    ChordDiagrams(10),
    /**
     * Parenthesis that are shown for tied bends
     * if they are preceeded by bends.
     */
    ParenthesisOnTiedBends(11),
    /**
     * The tab number for tied notes if the
     * bend of a note is increased at that point.
     */
    TabNotesOnTiedBends(12),
    /**
     * Zero tab numbers on "dive whammys".
     */
    ZerosOnDiveWhammys(13),
    /**
     * The alternate endings information on repeats shown above the staff.
     */
    EffectAlternateEndings(14),
    /**
     * The information about the fret on which the capo is placed shown above the staff.
     */
    EffectCapo(15),
    /**
     * The chord names shown above beats shown above the staff.
     */
    EffectChordNames(16),
    /**
     * The crescendo/decrescendo angle  shown above the staff.
     */
    EffectCrescendo(17),
    /**
     * The beat dynamics  shown above the staff.
     */
    EffectDynamics(18),
    /**
     * The curved angle for fade in/out effects  shown above the staff.
     */
    EffectFadeIn(19),
    /**
     * The fermata symbol shown above the staff.
     */
    EffectFermata(20),
    /**
     * The fingering information.
     */
    EffectFingering(21),
    /**
     * The harmonics names shown above the staff.
     * (does not represent the harmonic note heads)
     */
    EffectHarmonics(22),
    /**
     * The let ring name and line above the staff.
     */
    EffectLetRing(23),
    /**
     * The lyrics of the track shown above the staff.
     */
    EffectLyrics(24),
    /**
     * The section markers shown above the staff.
     */
    EffectMarker(25),
    /**
     * The ottava symbol and lines shown above the staff.
     */
    EffectOttavia(26),
    /**
     * The palm mute name and line shown above the staff.
     */
    EffectPalmMute(27),
    /**
     * The pick slide information shown above the staff.
     * (does not control the pick slide lines)
     */
    EffectPickSlide(28),
    /**
     * The pick stroke symbols shown above the staff.
     */
    EffectPickStroke(29),
    /**
     * The slight beat vibrato waves shown above the staff.
     */
    EffectSlightBeatVibrato(30),
    /**
     * The slight note vibrato waves shown above the staff.
     */
    EffectSlightNoteVibrato(31),
    /**
     * The tap/slap/pop effect names shown above the staff.
     */
    EffectTap(32),
    /**
     * The tempo information shown above the staff.
     */
    EffectTempo(33),
    /**
     * The additional beat text shown above the staff.
     */
    EffectText(34),
    /**
     * The trill name and waves shown above the staff.
     */
    EffectTrill(35),
    /**
     * The triplet feel symbol shown above the staff.
     */
    EffectTripletFeel(36),
    /**
     * The whammy bar information shown above the staff.
     * (does not control the whammy lines shown within the staff)
     */
    EffectWhammyBar(37),
    /**
     * The wide beat vibrato waves shown above the staff.
     */
    EffectWideBeatVibrato(38),
    /**
     * The wide note vibrato waves shown above the staff.
     */
    EffectWideNoteVibrato(39),
    /**
     * The left hand tap symbol shown above the staff.
     */
    EffectLeftHandTap(40);
    companion object{
        public fun fromValue(v:Double): NotationElement{
            return when(v.toInt()){
                ScoreTitle.value -> ScoreTitle
                ScoreSubTitle.value -> ScoreSubTitle
                ScoreArtist.value -> ScoreArtist
                ScoreAlbum.value -> ScoreAlbum
                ScoreWords.value -> ScoreWords
                ScoreMusic.value -> ScoreMusic
                ScoreWordsAndMusic.value -> ScoreWordsAndMusic
                ScoreCopyright.value -> ScoreCopyright
                GuitarTuning.value -> GuitarTuning
                TrackNames.value -> TrackNames
                ChordDiagrams.value -> ChordDiagrams
                ParenthesisOnTiedBends.value -> ParenthesisOnTiedBends
                TabNotesOnTiedBends.value -> TabNotesOnTiedBends
                ZerosOnDiveWhammys.value -> ZerosOnDiveWhammys
                EffectAlternateEndings.value -> EffectAlternateEndings
                EffectCapo.value -> EffectCapo
                EffectChordNames.value -> EffectChordNames
                EffectCrescendo.value -> EffectCrescendo
                EffectDynamics.value -> EffectDynamics
                EffectFadeIn.value -> EffectFadeIn
                EffectFermata.value -> EffectFermata
                EffectFingering.value -> EffectFingering
                EffectHarmonics.value -> EffectHarmonics
                EffectLetRing.value -> EffectLetRing
                EffectLyrics.value -> EffectLyrics
                EffectMarker.value -> EffectMarker
                EffectOttavia.value -> EffectOttavia
                EffectPalmMute.value -> EffectPalmMute
                EffectPickSlide.value -> EffectPickSlide
                EffectPickStroke.value -> EffectPickStroke
                EffectSlightBeatVibrato.value -> EffectSlightBeatVibrato
                EffectSlightNoteVibrato.value -> EffectSlightNoteVibrato
                EffectTap.value -> EffectTap
                EffectTempo.value -> EffectTempo
                EffectText.value -> EffectText
                EffectTrill.value -> EffectTrill
                EffectTripletFeel.value -> EffectTripletFeel
                EffectWhammyBar.value -> EffectWhammyBar
                EffectWideBeatVibrato.value -> EffectWideBeatVibrato
                EffectWideNoteVibrato.value -> EffectWideNoteVibrato
                EffectLeftHandTap.value -> EffectLeftHandTap
                else -> throw ClassCastException("No enum with value $v found")}
        }
    }
}

