// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab
import alphaTab.core.*

/**
 * The player settings control how the audio playback and UI is behaving.
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
public class PlayerSettings
{
    /**
     * Gets or sets the URL of the sound font to be loaded.
     */
    public var soundFont: String? = null
    
    /**
     * Gets or sets whether the player should be enabled.
     */
    public var enablePlayer: Boolean = false
    
    /**
     * Gets or sets whether playback cursors should be displayed.
     */
    public var enableCursor: Boolean = true
    
    /**
     * Gets or sets whether the beat cursor should be animated or just ticking.
     */
    public var enableAnimatedBeatCursor: Boolean = true
    
    /**
     * Gets or sets whether the notation elements of the currently played beat should be
     * highlighted.
     */
    public var enableElementHighlighting: Boolean = true
    
    /**
     * Gets or sets alphaTab should provide user interaction features to
     * select playback ranges and jump to the playback position by click (aka. seeking).
     */
    public var enableUserInteraction: Boolean = true
    
    /**
     * Gets or sets the X-offset to add when scrolling.
     */
    public var scrollOffsetX: Double = 0.0
    
    /**
     * Gets or sets the Y-offset to add when scrolling
     */
    public var scrollOffsetY: Double = 0.0
    
    /**
     * Gets or sets the mode how to scroll.
     */
    public var scrollMode: alphaTab.ScrollMode = alphaTab.ScrollMode.Continuous
    
    /**
     * Gets or sets how fast the scrolling to the new position should happen (in milliseconds)
     */
    public var scrollSpeed: Double = 300.0
    
    /**
     * Gets or sets the bend duration in milliseconds for songbook bends.
     */
    public var songBookBendDuration: Double = 75.0
    
    /**
     * Gets or sets the duration of whammy dips in milliseconds for songbook whammys.
     */
    public var songBookDipDuration: Double = 150.0
    
    /**
     * Gets or sets the settings on how the vibrato audio is generated.
     */
    public var vibrato: alphaTab.VibratoPlaybackSettings = alphaTab.VibratoPlaybackSettings()
    
    /**
     * Gets or sets the setitngs on how the slide audio is generated.
     */
    public var slide: alphaTab.SlidePlaybackSettings = alphaTab.SlidePlaybackSettings()
    
    /**
     * Gets or sets whether the triplet feel should be applied/played during audio playback.
     */
    public var playTripletFeel: Boolean = true
    
    /**
     * Gets or sets how many milliseconds of audio samples should be buffered in total. 
     * Larger buffers cause a delay from when audio settings like volumes will be applied. 
     * Smaller buffers can cause audio crackling due to constant buffering that is happening.
     */
    public var bufferTimeInMilliseconds: Double = 500.0
    
    public constructor()
}

/**
 * Lists all modes how alphaTab can scroll the container during playback.
 */
public enum class ScrollMode(override val value: Int): alphaTab.core.IAlphaTabEnum
{
    /**
     * Do not scroll automatically
     */
    Off(0),
    /**
     * Scrolling happens as soon the offsets of the cursors change.
     */
    Continuous(1),
    /**
     * Scrolling happens as soon the cursors exceed the displayed range.
     */
    OffScreen(2);
    companion object{
        public fun fromValue(v:Double): ScrollMode{
            return when(v.toInt()){
                Off.value -> Off
                Continuous.value -> Continuous
                OffScreen.value -> OffScreen
                else -> throw ClassCastException("No enum with value $v found")}
        }
    }
}

/**
 * This object defines the details on how to generate the vibrato effects.
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
public class VibratoPlaybackSettings
{
    /**
     * Gets or sets the wavelength of the note-wide vibrato in midi ticks.
     */
    public var noteWideLength: Double = 480.0
    
    /**
     * Gets or sets the amplitude for the note-wide vibrato in semitones.
     */
    public var noteWideAmplitude: Double = 2.0
    
    /**
     * Gets or sets the wavelength of the note-slight vibrato in midi ticks.
     */
    public var noteSlightLength: Double = 480.0
    
    /**
     * Gets or sets the amplitude for the note-slight vibrato in semitones.
     */
    public var noteSlightAmplitude: Double = 2.0
    
    /**
     * Gets or sets the wavelength of the beat-wide vibrato in midi ticks.
     */
    public var beatWideLength: Double = 240.0
    
    /**
     * Gets or sets the amplitude for the beat-wide vibrato in semitones.
     */
    public var beatWideAmplitude: Double = 3.0
    
    /**
     * Gets or sets the wavelength of the beat-slight vibrato in midi ticks.
     */
    public var beatSlightLength: Double = 240.0
    
    /**
     * Gets or sets the amplitude for the beat-slight vibrato in semitones.
     */
    public var beatSlightAmplitude: Double = 3.0
    
    public constructor()
}

/**
 * This object defines the details on how to generate the slide effects.
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
public class SlidePlaybackSettings
{
    /**
     * Gets or sets 1/4 tones (bend value) offset that
     * simple slides like slide-out-below or slide-in-above use.
     */
    public var simpleSlidePitchOffset: Double = 6.0
    
    /**
     * Gets or sets the percentage which the simple slides should take up
     * from the whole note. for "slide into" effects the slide will take place
     * from time 0 where the note is plucked to 25% of the overall note duration.
     * For "slide out" effects the slide will start 75% and finish at 100% of the overall
     * note duration.
     */
    public var simpleSlideDurationRatio: Double = 0.25
    
    /**
     * Gets or sets the percentage which the legato and shift slides should take up
     * from the whole note. For a value 0.5 the sliding will start at 50% of the overall note duration
     * and finish at 100%
     */
    public var shiftSlideDurationRatio: Double = 0.5
    
    public constructor()
}

