// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.exporter
import alphaTab.core.*

/**
 * This class can write a score.gpif XML from a given score model.
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class GpifWriter
{
    private var _rhythmIdLookup: alphaTab.collections.Map<String, String> = alphaTab.collections.Map<String, String>()
    
    /**
     */
    public fun writeXml(score: alphaTab.model.Score): String{
        var xmlDocument: alphaTab.xml.XmlDocument = alphaTab.xml.XmlDocument()
        this._rhythmIdLookup = alphaTab.collections.Map<String, String>()
        this.writeDom(xmlDocument, score)
        return xmlDocument.toFormattedString("", true)
    }
    
    /**
     */
    private fun writeDom(parent: alphaTab.xml.XmlNode, score: alphaTab.model.Score): Unit{
        var gpif: alphaTab.xml.XmlNode = parent.addElement("GPIF")
        gpif.addElement("GPVersion").innerText = "7"
        var gpRevision: alphaTab.xml.XmlNode = gpif.addElement("GPRevision")
        gpRevision.innerText = "7"
        gpRevision.attributes.set("required", "12021")
        gpRevision.attributes.set("recommended", "12023")
        gpRevision.innerText = "12025"
        gpif.addElement("Encoding").addElement("EncodingDescription").innerText = "GP7"
        this.writeScoreNode(gpif, score)
        this.writeMasterTrackNode(gpif, score)
        this.writeAudioTracksNode(gpif, score)
        this.writeTracksNode(gpif, score)
        this.writeMasterBarsNode(gpif, score)
        var bars: alphaTab.xml.XmlNode = gpif.addElement("Bars")
        var voices: alphaTab.xml.XmlNode = gpif.addElement("Voices")
        var beats: alphaTab.xml.XmlNode = gpif.addElement("Beats")
        var notes: alphaTab.xml.XmlNode = gpif.addElement("Notes")
        var rhythms: alphaTab.xml.XmlNode = gpif.addElement("Rhythms")
        for (tracks in score.tracks)
        {
            for (staff in tracks.staves)
            {
                for (bar in staff.bars)
                {
                    this.writeBarNode(bars, bar)
                    for (voice in bar.voices)
                    {
                        this.writeVoiceNode(voices, voice)
                        for (beat in voice.beats)
                        {
                            this.writeBeatNode(beats, beat, rhythms)
                            for (note in beat.notes)
                            {
                                this.writeNoteNode(notes, note)
                            }
                        }
                    }
                }
            }
        }
    }
    
    /**
     */
    private fun writeNoteNode(parent: alphaTab.xml.XmlNode, note: alphaTab.model.Note): Unit{
        var noteNode: alphaTab.xml.XmlNode = parent.addElement("Note")
        noteNode.attributes.set("id", note.id.toInvariantString())
        this.writeNoteProperties(noteNode, note)
        if (note.isGhost)
        {
            noteNode.addElement("AntiAccent").innerText = "normal"
        }
        if (note.isLetRing)
        {
            noteNode.addElement("LetRing")
        }
        if (note.isTrill)
        {
            noteNode.addElement("Trill").innerText = note.trillValue.toInvariantString()
        }
        var accentFlags: Double = 0.0
        if (note.isStaccato)
        {
            accentFlags = ((accentFlags.toInt()) or (1)).toDouble()
        }
        when (note.accentuated)
        {
            alphaTab.model.AccentuationType.Normal -> 
            {
                accentFlags = ((accentFlags.toInt()) or (8)).toDouble()
            }
            alphaTab.model.AccentuationType.Heavy -> 
            {
                accentFlags = ((accentFlags.toInt()) or (4)).toDouble()
            }
            else -> { }
        }
        if (accentFlags > 0)
        {
            noteNode.addElement("Accent").innerText = accentFlags.toInvariantString()
        }
        if (note.isTieOrigin || note.isTieDestination)
        {
            var tie: alphaTab.xml.XmlNode = noteNode.addElement("Tie")
            tie.attributes.set("origin", if(note.isTieOrigin)  "true" else "false")
            tie.attributes.set("destination", if(note.isTieDestination)  "true" else "false")
        }
        when (note.vibrato)
        {
            alphaTab.model.VibratoType.Slight -> 
            {
                noteNode.addElement("Vibrato").innerText = "Slight"
            }
            alphaTab.model.VibratoType.Wide -> 
            {
                noteNode.addElement("Vibrato").innerText = "Wide"
            }
            else -> { }
        }
        if (note.isFingering)
        {
            when (note.leftHandFinger)
            {
                alphaTab.model.Fingers.Thumb -> 
                {
                    noteNode.addElement("LeftFingering").innerText = "P"
                }
                alphaTab.model.Fingers.IndexFinger -> 
                {
                    noteNode.addElement("LeftFingering").innerText = "I"
                }
                alphaTab.model.Fingers.MiddleFinger -> 
                {
                    noteNode.addElement("LeftFingering").innerText = "M"
                }
                alphaTab.model.Fingers.AnnularFinger -> 
                {
                    noteNode.addElement("LeftFingering").innerText = "A"
                }
                alphaTab.model.Fingers.LittleFinger -> 
                {
                    noteNode.addElement("LeftFingering").innerText = "C"
                }
                else -> { }
            }
            when (note.rightHandFinger)
            {
                alphaTab.model.Fingers.Thumb -> 
                {
                    noteNode.addElement("RightFingering").innerText = "P"
                }
                alphaTab.model.Fingers.IndexFinger -> 
                {
                    noteNode.addElement("RightFingering").innerText = "I"
                }
                alphaTab.model.Fingers.MiddleFinger -> 
                {
                    noteNode.addElement("RightFingering").innerText = "M"
                }
                alphaTab.model.Fingers.AnnularFinger -> 
                {
                    noteNode.addElement("RightFingering").innerText = "A"
                }
                alphaTab.model.Fingers.LittleFinger -> 
                {
                    noteNode.addElement("RightFingering").innerText = "C"
                }
                else -> { }
            }
        }
        if (note.percussionArticulation >= 0)
        {
            noteNode.addElement("InstrumentArticulation").innerText = note.percussionArticulation.toInvariantString()
        }
        else 
        {
            noteNode.addElement("InstrumentArticulation").innerText = "0"
        }
    }
    
    /**
     */
    private fun writeNoteProperties(parent: alphaTab.xml.XmlNode, note: alphaTab.model.Note): Unit{
        var properties: alphaTab.xml.XmlNode = parent.addElement("Properties")
        this.writeConcertPitch(properties, note)
        this.writeTransposedPitch(properties, note)
        if (note.isStringed)
        {
            this.writeSimplePropertyNode(properties, "String", "String", (note.string - 1.0).toInvariantString())
            this.writeSimplePropertyNode(properties, "Fret", "Fret", note.fret.toInvariantString())
            this.writeSimplePropertyNode(properties, "Midi", "Number", note.realValue.toInvariantString())
        }
        if (note.isPiano)
        {
            this.writeSimplePropertyNode(properties, "Octave", "Number", note.octave.toInvariantString())
            this.writeSimplePropertyNode(properties, "Tone", "Step", note.tone.toInvariantString())
            this.writeSimplePropertyNode(properties, "Midi", "Number", note.realValue.toInvariantString())
        }
        if (note.beat.tap)
        {
            this.writeSimplePropertyNode(properties, "Tapped", "Enable", null)
        }
        if (note.harmonicType != alphaTab.model.HarmonicType.None)
        {
            when (note.harmonicType)
            {
                alphaTab.model.HarmonicType.Natural -> 
                {
                    this.writeSimplePropertyNode(properties, "HarmonicType", "HType", "Natural")
                }
                alphaTab.model.HarmonicType.Artificial -> 
                {
                    this.writeSimplePropertyNode(properties, "HarmonicType", "HType", "Artificial")
                }
                alphaTab.model.HarmonicType.Pinch -> 
                {
                    this.writeSimplePropertyNode(properties, "HarmonicType", "HType", "Pinch")
                }
                alphaTab.model.HarmonicType.Tap -> 
                {
                    this.writeSimplePropertyNode(properties, "HarmonicType", "HType", "Tap")
                }
                alphaTab.model.HarmonicType.Semi -> 
                {
                    this.writeSimplePropertyNode(properties, "HarmonicType", "HType", "Semi")
                }
                alphaTab.model.HarmonicType.Feedback -> 
                {
                    this.writeSimplePropertyNode(properties, "HarmonicType", "HType", "Feedback")
                }
                else -> { }
            }
            if (note.harmonicValue != 0.0)
            {
                this.writeSimplePropertyNode(properties, "HarmonicFret", "HFret", note.harmonicValue.toInvariantString())
            }
        }
        if (note.isDead)
        {
            this.writeSimplePropertyNode(properties, "Muted", "Enable", null)
        }
        if (note.isPalmMute)
        {
            this.writeSimplePropertyNode(properties, "PalmMuted", "Enable", null)
        }
        if (note.hasBend)
        {
            this.writeBend(properties, note)
        }
        if (note.isHammerPullOrigin)
        {
            this.writeSimplePropertyNode(properties, "HopoOrigin", "Enable", null)
        }
        if (note.isHammerPullDestination)
        {
            this.writeSimplePropertyNode(properties, "HopoDestination", "Enable", null)
        }
        if (note.isLeftHandTapped)
        {
            this.writeSimplePropertyNode(properties, "LeftHandTapped", "Enable", null)
        }
        var slideFlags: Double = 0.0
        when (note.slideInType)
        {
            alphaTab.model.SlideInType.IntoFromAbove -> 
            {
                slideFlags = ((slideFlags.toInt()) or (32)).toDouble()
            }
            alphaTab.model.SlideInType.IntoFromBelow -> 
            {
                slideFlags = ((slideFlags.toInt()) or (16)).toDouble()
            }
            else -> { }
        }
        when (note.slideOutType)
        {
            alphaTab.model.SlideOutType.Shift -> 
            {
                slideFlags = ((slideFlags.toInt()) or (1)).toDouble()
            }
            alphaTab.model.SlideOutType.Legato -> 
            {
                slideFlags = ((slideFlags.toInt()) or (2)).toDouble()
            }
            alphaTab.model.SlideOutType.OutDown -> 
            {
                slideFlags = ((slideFlags.toInt()) or (4)).toDouble()
            }
            alphaTab.model.SlideOutType.OutUp -> 
            {
                slideFlags = ((slideFlags.toInt()) or (8)).toDouble()
            }
            alphaTab.model.SlideOutType.PickSlideDown -> 
            {
                slideFlags = ((slideFlags.toInt()) or (64)).toDouble()
            }
            alphaTab.model.SlideOutType.PickSlideUp -> 
            {
                slideFlags = ((slideFlags.toInt()) or (128)).toDouble()
            }
            else -> { }
        }
        if (slideFlags > 0)
        {
            this.writeSimplePropertyNode(properties, "Slide", "Flags", slideFlags.toInvariantString())
        }
    }
    
    /**
     */
    private fun writeTransposedPitch(properties: alphaTab.xml.XmlNode, note: alphaTab.model.Note): Unit{
        if (note.isPercussion)
        {
            this.writePitch(properties, "ConcertPitch", "C", "-1", "")
        }
        else 
        {
            this.writePitchForValue(properties, "TransposedPitch", note.displayValueWithoutBend, note.accidentalMode)
        }
    }
    
    /**
     */
    private fun writeConcertPitch(properties: alphaTab.xml.XmlNode, note: alphaTab.model.Note): Unit{
        if (note.isPercussion)
        {
            this.writePitch(properties, "ConcertPitch", "C", "-1", "")
        }
        else 
        {
            this.writePitchForValue(properties, "ConcertPitch", note.realValueWithoutHarmonic, note.accidentalMode)
        }
    }
    
    /**
     */
    private fun writePitchForValue(properties: alphaTab.xml.XmlNode, propertyName: String, value: Double, accidentalMode: alphaTab.model.NoteAccidentalMode): Unit{
        var paramvalue = value
        var index: Double = 0.0
        var octave: Double = 0.0
        var step: String = ""
        var accidental: String = ""
        var updateParts: () -> Unit = fun(): Unit{
            index = value % 12.0
            octave = (((value / (12.0).toDouble())).toInt() or 0).toDouble()
            step = alphaTab.model.Tuning.defaultSteps[(index).toInt()]
            accidental = alphaTab.model.Tuning.defaultAccidentals[(index).toInt()]
        }
        
        updateParts()
        when (accidentalMode)
        {
            alphaTab.model.NoteAccidentalMode.Default -> 
            {
            }
            alphaTab.model.NoteAccidentalMode.ForceNone -> 
            {
                accidental = ""
            }
            alphaTab.model.NoteAccidentalMode.ForceNatural -> 
            {
                accidental = ""
            }
            alphaTab.model.NoteAccidentalMode.ForceSharp -> 
            {
                accidental = "#"
            }
            alphaTab.model.NoteAccidentalMode.ForceDoubleSharp -> 
            {
                if (accidental == "#")
                {
                    paramvalue -= 2.0
                    updateParts()
                }
                accidental = "x"
            }
            alphaTab.model.NoteAccidentalMode.ForceFlat -> 
            {
                if (accidental == "#")
                {
                    paramvalue += 1.0
                    updateParts()
                }
                accidental = "b"
            }
            alphaTab.model.NoteAccidentalMode.ForceDoubleFlat -> 
            {
                if (accidental == "#")
                {
                    paramvalue += 2.0
                    updateParts()
                }
                accidental = "bb"
            }
            else -> { }
        }
        this.writePitch(properties, propertyName, step, octave.toInvariantString(), accidental)
    }
    
    /**
     */
    private fun writePitch(properties: alphaTab.xml.XmlNode, propertyName: String, step: String, octave: String, accidental: String): Unit{
        var property: alphaTab.xml.XmlNode = properties.addElement("Property")
        property.attributes.set("name", propertyName)
        var pitch: alphaTab.xml.XmlNode = property.addElement("Pitch")
        pitch.addElement("Step").innerText = step
        pitch.addElement("Accidental").innerText = accidental
        pitch.addElement("Octave").innerText = octave
    }
    
    /**
     */
    private fun writeBend(properties: alphaTab.xml.XmlNode, note: alphaTab.model.Note): Unit{
        if (note.hasBend && note.bendPoints!!.length <= 4)
        {
            this.writeStandardBend(properties, note.bendPoints!!)
        }
    }
    
    /**
     */
    private fun writeStandardBend(properties: alphaTab.xml.XmlNode, bendPoints: alphaTab.collections.List<alphaTab.model.BendPoint>): Unit{
        this.writeSimplePropertyNode(properties, "Bended", "Enable", null)
        var bendOrigin: alphaTab.model.BendPoint = bendPoints[(0).toInt()]
        var bendDestination: alphaTab.model.BendPoint = bendPoints[(bendPoints.length - 1.0).toInt()]
        var bendMiddle1: alphaTab.model.BendPoint
        var bendMiddle2: alphaTab.model.BendPoint
        when (bendPoints.length)
        {
            4.0 -> 
            {
                bendMiddle1 = bendPoints[(1).toInt()]
                bendMiddle2 = bendPoints[(2).toInt()]
            }
            3.0 -> 
            {
                bendMiddle1 = bendPoints[(1).toInt()]
                bendMiddle2 = bendPoints[(1).toInt()]
            }
            else -> 
            {
                bendMiddle1 = alphaTab.model.BendPoint((bendOrigin.offset + bendDestination.offset) / (2.0).toDouble(), (bendOrigin.value + bendDestination.value) / (2.0).toDouble())
                bendMiddle2 = bendMiddle1
            }
        }
        this.writeSimplePropertyNode(properties, "BendDestinationOffset", "Float", this.toBendOffset(bendDestination.offset).toInvariantString())
        this.writeSimplePropertyNode(properties, "BendDestinationValue", "Float", this.toBendValue(bendDestination.value).toInvariantString())
        this.writeSimplePropertyNode(properties, "BendMiddleOffset1", "Float", this.toBendOffset(bendMiddle1.offset).toInvariantString())
        this.writeSimplePropertyNode(properties, "BendMiddleOffset2", "Float", this.toBendOffset(bendMiddle2.offset).toInvariantString())
        this.writeSimplePropertyNode(properties, "BendMiddleValue", "Float", this.toBendValue(bendMiddle1.value).toInvariantString())
        this.writeSimplePropertyNode(properties, "BendOriginOffset", "Float", this.toBendOffset(bendOrigin.offset).toInvariantString())
        this.writeSimplePropertyNode(properties, "BendOriginValue", "Float", this.toBendValue(bendOrigin.value).toInvariantString())
    }
    
    /**
     */
    private fun toBendValue(value: Double): Double{
        return value * 25.0
    }
    
    /**
     */
    private fun toBendOffset(value: Double): Double{
        return (value / alphaTab.model.BendPoint.MaxPosition) * 100.0
    }
    
    /**
     */
    private fun writeBeatNode(parent: alphaTab.xml.XmlNode, beat: alphaTab.model.Beat, rhythms: alphaTab.xml.XmlNode): Unit{
        var beatNode: alphaTab.xml.XmlNode = parent.addElement("Beat")
        beatNode.attributes.set("id", beat.id.toInvariantString())
        beatNode.addElement("Dynamic").innerText = beat.dynamics.toString()
        if (beat.fadeIn)
        {
            beatNode.addElement("Fadding").innerText = "FadeIn"
        }
        if (beat.isTremolo)
        {
            when (beat.tremoloSpeed)
            {
                alphaTab.model.Duration.Eighth -> 
                {
                    beatNode.addElement("Tremolo").innerText = "1/2"
                }
                alphaTab.model.Duration.Sixteenth -> 
                {
                    beatNode.addElement("Tremolo").innerText = "1/4"
                }
                alphaTab.model.Duration.ThirtySecond -> 
                {
                    beatNode.addElement("Tremolo").innerText = "1/8"
                }
                else -> { }
            }
        }
        if (beat.hasChord)
        {
            beatNode.addElement("Chord").setCData(beat.chordId!!)
        }
        if (beat.crescendo != alphaTab.model.CrescendoType.None)
        {
            beatNode.addElement("Hairpin").innerText = beat.crescendo.toString()
        }
        when (beat.brushType)
        {
            alphaTab.model.BrushType.ArpeggioUp -> 
            {
                beatNode.addElement("Arpeggio").innerText = "Up"
            }
            alphaTab.model.BrushType.ArpeggioDown -> 
            {
                beatNode.addElement("Arpeggio").innerText = "Down"
            }
            else -> { }
        }
        if (alphaTab.core.TypeHelper.isTruthy(beat.text))
        {
            beatNode.addElement("FreeText").setCData(beat.text!!)
        }
        when (beat.graceType)
        {
            alphaTab.model.GraceType.OnBeat, alphaTab.model.GraceType.BeforeBeat -> 
            {
                beatNode.addElement("GraceNotes").innerText = beat.graceType.toString()
            }
            else -> { }
        }
        if (beat.ottava != alphaTab.model.Ottavia.Regular)
        {
            beatNode.addElement("Ottavia").innerText = beat.ottava.toString().substr(1.0)
        }
        if (beat.hasWhammyBar)
        {
            this.writeWhammyNode(beatNode, beat)
        }
        if (beat.isLegatoOrigin || beat.isLegatoDestination)
        {
            var legato: alphaTab.xml.XmlNode = beatNode.addElement("Legato")
            legato.attributes.set("origin", if(beat.isLegatoOrigin)  "true" else "false")
            legato.attributes.set("destination", if(beat.isLegatoDestination)  "true" else "false")
        }
        this.writeRhythm(beatNode, beat, rhythms)
        if (beat.preferredBeamDirection != null)
        {
            when (beat.preferredBeamDirection)
            {
                alphaTab.rendering.utils.BeamDirection.Up -> 
                {
                    beatNode.addElement("TransposedPitchStemOrientation").innerText = "Upward"
                }
                alphaTab.rendering.utils.BeamDirection.Down -> 
                {
                    beatNode.addElement("TransposedPitchStemOrientation").innerText = "Downward"
                }
                else -> { }
            }
        }
        beatNode.addElement("ConcertPitchStemOrientation").innerText = "Undefined"
        if (!beat.isRest)
        {
            beatNode.addElement("Notes").innerText = beat.notes.map(fun(n: alphaTab.model.Note): Double{
                return n.id
            }
            ).join(" ")
        }
        this.writeBeatProperties(beatNode, beat)
        this.writeBeatXProperties(beatNode, beat)
        if (alphaTab.core.TypeHelper.isTruthy(beat.lyrics) && beat.lyrics!!.length > 0)
        {
            this.writeBeatLyrics(beatNode, beat.lyrics!!)
        }
    }
    
    /**
     */
    private fun writeBeatLyrics(beatNode: alphaTab.xml.XmlNode, lyrics: alphaTab.collections.List<String>): Unit{
        var lyricsNode: alphaTab.xml.XmlNode = beatNode.addElement("Lyrics")
        for (l in lyrics)
        {
            var line: alphaTab.xml.XmlNode = lyricsNode.addElement("Line")
            line.setCData(l)
        }
    }
    
    /**
     */
    private fun writeBeatXProperties(beatNode: alphaTab.xml.XmlNode, beat: alphaTab.model.Beat): Unit{
        var beatProperties: alphaTab.xml.XmlNode = beatNode.addElement("XProperties")
        if (beat.brushDuration > 0)
        {
            this.writeSimpleXPropertyNode(beatProperties, "687935489", "Int", beat.brushDuration.toInvariantString())
        }
    }
    
    /**
     */
    private fun writeBeatProperties(beatNode: alphaTab.xml.XmlNode, beat: alphaTab.model.Beat): Unit{
        var beatProperties: alphaTab.xml.XmlNode = beatNode.addElement("Properties")
        when (beat.brushType)
        {
            alphaTab.model.BrushType.BrushUp -> 
            {
                this.writeSimplePropertyNode(beatProperties, "Brush", "Direction", "Up")
            }
            alphaTab.model.BrushType.BrushDown -> 
            {
                this.writeSimplePropertyNode(beatProperties, "Brush", "Direction", "Down")
            }
            else -> { }
        }
        when (beat.pickStroke)
        {
            alphaTab.model.PickStroke.Up -> 
            {
                this.writeSimplePropertyNode(beatProperties, "PickStroke", "Direction", "Up")
            }
            alphaTab.model.PickStroke.Down -> 
            {
                this.writeSimplePropertyNode(beatProperties, "PickStroke", "Direction", "Down")
            }
            else -> { }
        }
        if (beat.slap)
        {
            this.writeSimplePropertyNode(beatProperties, "Slapped", "Enable", null)
        }
        if (beat.pop)
        {
            this.writeSimplePropertyNode(beatProperties, "Popped", "Enable", null)
        }
        when (beat.vibrato)
        {
            alphaTab.model.VibratoType.Wide -> 
            {
                this.writeSimplePropertyNode(beatProperties, "VibratoWTremBar", "Strength", "Wide")
            }
            alphaTab.model.VibratoType.Slight -> 
            {
                this.writeSimplePropertyNode(beatProperties, "VibratoWTremBar", "Strength", "Slight")
            }
            else -> { }
        }
    }
    
    /**
     */
    private fun writeRhythm(parent: alphaTab.xml.XmlNode, beat: alphaTab.model.Beat, rhythms: alphaTab.xml.XmlNode): Unit{
        var rhythmId: String = """${(beat.duration).toTemplate()}_${(beat.dots).toTemplate()}_${(beat.tupletNumerator).toTemplate()}_${(beat.tupletDenominator).toTemplate()}';"""
        var rhythm: String
        if (!this._rhythmIdLookup.has(rhythmId))
        {
            rhythm = this._rhythmIdLookup.size.toInvariantString()
            this._rhythmIdLookup.set(rhythmId, rhythm)
            var rhythmNode: alphaTab.xml.XmlNode = rhythms.addElement("Rhythm")
            rhythmNode.attributes.set("id", rhythm)
            if (beat.hasTuplet)
            {
                var tupletNode: alphaTab.xml.XmlNode = rhythmNode.addElement("PrimaryTuplet")
                tupletNode.attributes.set("num", beat.tupletNumerator.toInvariantString())
                tupletNode.attributes.set("den", beat.tupletDenominator.toInvariantString())
            }
            if (beat.dots > 0)
            {
                rhythmNode.addElement("AugmentationDot").attributes.set("count", beat.dots.toInvariantString())
            }
            var noteValue: String = "Quarter"
            when (beat.duration)
            {
                alphaTab.model.Duration.QuadrupleWhole -> 
                {
                    noteValue = "Long"
                }
                alphaTab.model.Duration.DoubleWhole -> 
                {
                    noteValue = "DoubleWhole"
                }
                alphaTab.model.Duration.Whole -> 
                {
                    noteValue = "Whole"
                }
                alphaTab.model.Duration.Half -> 
                {
                    noteValue = "Half"
                }
                alphaTab.model.Duration.Quarter -> 
                {
                    noteValue = "Quarter"
                }
                alphaTab.model.Duration.Eighth -> 
                {
                    noteValue = "Eighth"
                }
                alphaTab.model.Duration.Sixteenth -> 
                {
                    noteValue = "16th"
                }
                alphaTab.model.Duration.ThirtySecond -> 
                {
                    noteValue = "32nd"
                }
                alphaTab.model.Duration.SixtyFourth -> 
                {
                    noteValue = "64th"
                }
                alphaTab.model.Duration.OneHundredTwentyEighth -> 
                {
                    noteValue = "128th"
                }
                alphaTab.model.Duration.TwoHundredFiftySixth -> 
                {
                    noteValue = "256th"
                }
                else -> { }
            }
            rhythmNode.addElement("NoteValue").innerText = noteValue
        }
        else 
        {
            rhythm = this._rhythmIdLookup.get(rhythmId)!!
        }
        parent.addElement("Rhythm").attributes.set("ref", rhythm)
    }
    
    /**
     */
    private fun writeWhammyNode(parent: alphaTab.xml.XmlNode, beat: alphaTab.model.Beat): Unit{
        if (beat.hasWhammyBar && beat.whammyBarPoints!!.length <= 4)
        {
            this.writeStandardWhammy(parent, beat.whammyBarPoints!!)
        }
    }
    
    /**
     */
    private fun writeStandardWhammy(parent: alphaTab.xml.XmlNode, whammyBarPoints: alphaTab.collections.List<alphaTab.model.BendPoint>): Unit{
        var whammyNode: alphaTab.xml.XmlNode = parent.addElement("Whammy")
        var whammyOrigin: alphaTab.model.BendPoint = whammyBarPoints[(0).toInt()]
        var whammyDestination: alphaTab.model.BendPoint = whammyBarPoints[(whammyBarPoints.length - 1.0).toInt()]
        var whammyMiddle1: alphaTab.model.BendPoint
        var whammyMiddle2: alphaTab.model.BendPoint
        when (whammyBarPoints.length)
        {
            4.0 -> 
            {
                whammyMiddle1 = whammyBarPoints[(1).toInt()]
                whammyMiddle2 = whammyBarPoints[(2).toInt()]
            }
            3.0 -> 
            {
                whammyMiddle1 = whammyBarPoints[(1).toInt()]
                whammyMiddle2 = whammyBarPoints[(1).toInt()]
            }
            else -> 
            {
                whammyMiddle1 = alphaTab.model.BendPoint((whammyOrigin.offset + whammyDestination.offset) / (2.0).toDouble(), (whammyOrigin.value + whammyDestination.value) / (2.0).toDouble())
                whammyMiddle2 = whammyMiddle1
            }
        }
        whammyNode.attributes.set("destinationOffset", this.toBendOffset(whammyDestination.offset).toInvariantString())
        whammyNode.attributes.set("destinationValue", this.toBendValue(whammyDestination.value).toInvariantString())
        whammyNode.attributes.set("middleOffset1", this.toBendOffset(whammyMiddle1.offset).toInvariantString())
        whammyNode.attributes.set("middleOffset2", this.toBendOffset(whammyMiddle2.offset).toInvariantString())
        whammyNode.attributes.set("middleValue", this.toBendValue(whammyMiddle1.value).toInvariantString())
        whammyNode.attributes.set("originOffset", this.toBendOffset(whammyOrigin.offset).toInvariantString())
        whammyNode.attributes.set("originValue", this.toBendValue(whammyOrigin.value).toInvariantString())
    }
    
    /**
     */
    private fun writeScoreNode(parent: alphaTab.xml.XmlNode, score: alphaTab.model.Score): Unit{
        var scoreNode: alphaTab.xml.XmlNode = parent.addElement("Score")
        scoreNode.addElement("Title").setCData(score.title)
        scoreNode.addElement("SubTitle").setCData(score.subTitle)
        scoreNode.addElement("Artist").setCData(score.artist)
        scoreNode.addElement("Album").setCData(score.album)
        scoreNode.addElement("Words").setCData(score.words)
        scoreNode.addElement("Music").setCData(score.music)
        scoreNode.addElement("WordsAndMusic").setCData(if(score.words == score.music)  score.words else "")
        scoreNode.addElement("Copyright").setCData(score.copyright)
        scoreNode.addElement("Tabber").setCData(score.tab)
        scoreNode.addElement("Instructions").setCData(score.instructions)
        scoreNode.addElement("Notices").setCData(score.notices)
        scoreNode.addElement("FirstPageHeader").setCData("")
        scoreNode.addElement("FirstPageFooter").setCData("")
        scoreNode.addElement("PageHeader").setCData("")
        scoreNode.addElement("PageFooter").setCData("")
        scoreNode.addElement("ScoreSystemsDefaultLayout").setCData(score.defaultSystemsLayout.toInvariantString())
        scoreNode.addElement("ScoreSystemsLayout").setCData(score.systemsLayout.join(" "))
        scoreNode.addElement("ScoreZoomPolicy").innerText = "Value"
        scoreNode.addElement("ScoreZoom").innerText = "1"
        scoreNode.addElement("MultiVoice").innerText = "1>"
    }
    
    /**
     */
    private fun writeMasterTrackNode(parent: alphaTab.xml.XmlNode, score: alphaTab.model.Score): Unit{
        var masterTrackNode: alphaTab.xml.XmlNode = parent.addElement("MasterTrack")
        masterTrackNode.addElement("Tracks").innerText = score.tracks.map(fun(t: alphaTab.model.Track): Double{
            return t.index
        }
        ).join(" ")
        var automations: alphaTab.xml.XmlNode = masterTrackNode.addElement("Automations")
        if (score.masterBars.length > 0 && score.masterBars[(0).toInt()].isAnacrusis)
        {
            masterTrackNode.addElement("Anacrusis")
        }
        var initialTempoAutomation: alphaTab.xml.XmlNode = automations.addElement("Automation")
        initialTempoAutomation.addElement("Type").innerText = "Tempo"
        initialTempoAutomation.addElement("Linear").innerText = "false"
        initialTempoAutomation.addElement("Bar").innerText = "0"
        initialTempoAutomation.addElement("Position").innerText = "0"
        initialTempoAutomation.addElement("Visible").innerText = "true"
        initialTempoAutomation.addElement("Value").innerText = """${(score.tempo).toTemplate()} 2"""
        if (alphaTab.core.TypeHelper.isTruthy(score.tempoLabel))
        {
            initialTempoAutomation.addElement("Text").innerText = score.tempoLabel
        }
        for (mb in score.masterBars)
        {
            if (mb.index > 0 && alphaTab.core.TypeHelper.isTruthy(mb.tempoAutomation))
            {
                var tempoAutomation: alphaTab.xml.XmlNode = automations.addElement("Automation")
                tempoAutomation.addElement("Type").innerText = "Tempo"
                tempoAutomation.addElement("Linear").innerText = if(mb.tempoAutomation!!.isLinear)  "true" else "false"
                tempoAutomation.addElement("Bar").innerText = mb.index.toInvariantString()
                tempoAutomation.addElement("Position").innerText = mb.tempoAutomation!!.ratioPosition.toInvariantString()
                tempoAutomation.addElement("Visible").innerText = "true"
                tempoAutomation.addElement("Value").innerText = """${(mb.tempoAutomation!!.value).toTemplate()} 2"""
                if (alphaTab.core.TypeHelper.isTruthy(mb.tempoAutomation!!.text))
                {
                    tempoAutomation.addElement("Text").innerText = mb.tempoAutomation!!.text
                }
            }
        }
    }
    
    /**
     */
    private fun writeAudioTracksNode(parent: alphaTab.xml.XmlNode, score: alphaTab.model.Score): Unit{
        parent.addElement("AudioTracks")
    }
    
    /**
     */
    private fun writeTracksNode(parent: alphaTab.xml.XmlNode, score: alphaTab.model.Score): Unit{
        var tracksNode: alphaTab.xml.XmlNode = parent.addElement("Tracks")
        for (track in score.tracks)
        {
            this.writeTrackNode(tracksNode, track)
        }
    }
    
    /**
     */
    private fun writeTrackNode(parent: alphaTab.xml.XmlNode, track: alphaTab.model.Track): Unit{
        var trackNode: alphaTab.xml.XmlNode = parent.addElement("Track")
        trackNode.attributes.set("id", track.index.toInvariantString())
        trackNode.addElement("Name").setCData(track.name)
        trackNode.addElement("ShortName").setCData(track.shortName)
        trackNode.addElement("Color").innerText = """${(track.color.r).toTemplate()} ${(track.color.g).toTemplate()} ${(track.color.b).toTemplate()}"""
        trackNode.addElement("SystemsDefautLayout").innerText = track.defaultSystemsLayout.toInvariantString()
        trackNode.addElement("SystemsLayout").innerText = track.systemsLayout.join(" ")
        trackNode.addElement("AutoBrush")
        trackNode.addElement("PalmMute").innerText = "0"
        trackNode.addElement("PlayingStyle").innerText = if(alphaTab.midi.GeneralMidi.isGuitar(track.playbackInfo.program))  "StringedPick" else "Default"
        trackNode.addElement("UseOneChannelPerString")
        trackNode.addElement("IconId").innerText = alphaTab.exporter.GpifWriter.getIconId(track.playbackInfo).toInvariantString()
        this.writeInstrumentSetNode(trackNode, track)
        this.writeTransposeNode(trackNode, track)
        this.writeRseNode(trackNode, track)
        trackNode.addElement("ForcedSound").innerText = "-1"
        this.writeMidiConnectionNode(trackNode, track)
        if (track.playbackInfo.isSolo)
        {
            trackNode.addElement("PlaybackState").innerText = "Solo"
        }
        else if (track.playbackInfo.isMute)
        {
            trackNode.addElement("PlaybackState").innerText = "Mute"
        }
        else 
        {
            trackNode.addElement("PlaybackState").innerText = "Default"
        }
        trackNode.addElement("AudioEngineState").innerText = "MIDI"
        this.writeLyricsNode(trackNode, track)
        this.writeStavesNode(trackNode, track)
        this.writeSoundsAndAutomations(trackNode, track)
    }
    
    /**
     */
    private fun writeSoundAndAutomation(soundsNode: alphaTab.xml.XmlNode, automationsNode: alphaTab.xml.XmlNode, name: String, path: String, role: String, barIndex: Double, program: Double, ratioPosition: Double = 0.0): Unit{
        var soundNode: alphaTab.xml.XmlNode = soundsNode.addElement("Sound")
        soundNode.addElement("Name").setCData(name)
        soundNode.addElement("Label").setCData(name)
        soundNode.addElement("Path").setCData(path)
        soundNode.addElement("Role").setCData(role)
        var midi: alphaTab.xml.XmlNode = soundNode.addElement("MIDI")
        midi.addElement("LSB").innerText = "0"
        midi.addElement("MSB").innerText = "0"
        midi.addElement("Program").innerText = program.toInvariantString()
        var automationNode: alphaTab.xml.XmlNode = automationsNode.addElement("Automation")
        automationNode.addElement("Type").innerText = "Sound"
        automationNode.addElement("Linear").innerText = "false"
        automationNode.addElement("Bar").innerText = barIndex.toInvariantString()
        automationNode.addElement("Position").innerText = ratioPosition.toInvariantString()
        automationNode.addElement("Visible").innerText = "true"
        automationNode.addElement("Value").setCData("""${(path).toTemplate()};${(name).toTemplate()};${(role).toTemplate()}""")
    }
    
    /**
     */
    private fun writeSoundsAndAutomations(trackNode: alphaTab.xml.XmlNode, track: alphaTab.model.Track): Unit{
        var soundsNode: alphaTab.xml.XmlNode = trackNode.addElement("Sounds")
        var automationsNode: alphaTab.xml.XmlNode = trackNode.addElement("Automations")
        if (track.staves.length > 0 && track.staves[(0).toInt()].bars.length > 0)
        {
            var trackSoundName: String = """Track_${(track.index).toTemplate()}_Initial"""
            var trackSoundPath: String = """Midi/${(track.playbackInfo.program).toTemplate()}"""
            var trackSoundRole: String = "Factory"
            var trackSoundWritten: Boolean = false
            for (staff in track.staves)
            {
                for (bar in staff.bars)
                {
                    for (voice in bar.voices)
                    {
                        for (beat in voice.beats)
                        {
                            var soundAutomation: alphaTab.model.Automation? = beat.getAutomation(alphaTab.model.AutomationType.Instrument)
                            var isTrackSound: Boolean = bar.index == 0.0 && beat.index == 0.0
                            if (alphaTab.core.TypeHelper.isTruthy(soundAutomation))
                            {
                                var name: String = if(isTrackSound)  trackSoundName else """ProgramChange_${(beat.id).toTemplate()}"""
                                var path: String = if(isTrackSound)  trackSoundPath else """Midi/${(soundAutomation.value).toTemplate()}"""
                                var role: String = if(isTrackSound)  trackSoundRole else "User"
                                if (!isTrackSound && !trackSoundWritten)
                                {
                                    this.writeSoundAndAutomation(
                                        soundsNode
                                        , 
                                        automationsNode
                                        , 
                                        trackSoundName
                                        , 
                                        trackSoundPath
                                        , 
                                        (trackSoundRole.toString())
                                        , 
                                        track.staves[(0).toInt()].bars[(0).toInt()].index
                                        , 
                                        track.playbackInfo.program
                                    
                                    )
                                    trackSoundWritten = true
                                }
                                this.writeSoundAndAutomation(
                                    soundsNode
                                    , 
                                    automationsNode
                                    , 
                                    name
                                    , 
                                    path
                                    , 
                                    (role.toString())
                                    , 
                                    bar.index
                                    , 
                                    soundAutomation.value
                                    , 
                                    soundAutomation.ratioPosition
                                
                                )
                                if (isTrackSound)
                                {
                                    trackSoundWritten = true
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    
    /**
     */
    private fun writeMidiConnectionNode(trackNode: alphaTab.xml.XmlNode, track: alphaTab.model.Track): Unit{
        var midiConnection: alphaTab.xml.XmlNode = trackNode.addElement("MidiConnection")
        midiConnection.addElement("Port").innerText = track.playbackInfo.port.toInvariantString()
        midiConnection.addElement("PrimaryChannel").innerText = track.playbackInfo.primaryChannel.toInvariantString()
        midiConnection.addElement("SecondaryChannel").innerText = track.playbackInfo.secondaryChannel.toInvariantString()
        midiConnection.addElement("ForeOneChannelPerString").innerText = "false"
    }
    
    /**
     */
    private fun writeRseNode(trackNode: alphaTab.xml.XmlNode, track: alphaTab.model.Track): Unit{
        var rse: alphaTab.xml.XmlNode = trackNode.addElement("RSE")
        var channelStrip: alphaTab.xml.XmlNode = rse.addElement("ChannelStrip")
        channelStrip.attributes.set("version", "E56")
        var channelStripParameters: alphaTab.xml.XmlNode = channelStrip.addElement("Parameters")
        channelStripParameters.innerText = """0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 1 0.5 ${(track.playbackInfo.balance / (16.0).toDouble()).toTemplate()} ${(track.playbackInfo.volume / (16.0).toDouble()).toTemplate()} 0.5 0.5 0.5"""
    }
    
    /**
     */
    private fun writeStavesNode(trackNode: alphaTab.xml.XmlNode, track: alphaTab.model.Track): Unit{
        var staves: alphaTab.xml.XmlNode = trackNode.addElement("Staves")
        for (staff in track.staves)
        {
            this.writeStaffNode(staves, staff)
        }
    }
    
    /**
     */
    private fun writeStaffNode(parent: alphaTab.xml.XmlNode, staff: alphaTab.model.Staff): Unit{
        var staffNode: alphaTab.xml.XmlNode = parent.addElement("Staff")
        var properties: alphaTab.xml.XmlNode = staffNode.addElement("Properties")
        this.writeSimplePropertyNode(properties, "CapoFret", "Fret", staff.capo.toInvariantString())
        this.writeSimplePropertyNode(properties, "FretCount", "Fret", "24")
        if (staff.tuning.length > 0)
        {
            var tuningProperty: alphaTab.xml.XmlNode = properties.addElement("Property")
            tuningProperty.attributes.set("name", "Tuning")
            tuningProperty.addElement("Pitches").innerText = staff.tuning.slice().reverse().join(" ")
            tuningProperty.addElement("Label").setCData(staff.tuningName)
            tuningProperty.addElement("LabelVisible").innerText = if(alphaTab.core.TypeHelper.isTruthy(staff.tuningName))  "true" else "false"
            tuningProperty.addElement("Flat")
            when (staff.tuning.length)
            {
                3.0 -> 
                {
                    tuningProperty.addElement("Instrument").innerText = "Shamisen"
                }
                4.0 -> 
                {
                    if (staff.track.playbackInfo.program == 105.0)
                    {
                        tuningProperty.addElement("Instrument").innerText = "Banjo"
                    }
                    else if (staff.track.playbackInfo.program == 42.0)
                    {
                        tuningProperty.addElement("Instrument").innerText = "Cello"
                    }
                    else if (staff.track.playbackInfo.program == 43.0)
                    {
                        tuningProperty.addElement("Instrument").innerText = "Contrabass"
                    }
                    else if (staff.track.playbackInfo.program == 40.0)
                    {
                        tuningProperty.addElement("Instrument").innerText = "Violin"
                    }
                    else if (staff.track.playbackInfo.program == 41.0)
                    {
                        tuningProperty.addElement("Instrument").innerText = "Viola"
                    }
                    else 
                    {
                        tuningProperty.addElement("Instrument").innerText = "Bass"
                    }
                }
                5.0 -> 
                {
                    if (staff.track.playbackInfo.program == 105.0)
                    {
                        tuningProperty.addElement("Instrument").innerText = "Banjo"
                    }
                    else 
                    {
                        tuningProperty.addElement("Instrument").innerText = "Bass"
                    }
                }
                6.0 -> 
                {
                    if (staff.track.playbackInfo.program == 105.0)
                    {
                        tuningProperty.addElement("Instrument").innerText = "Banjo"
                    }
                    else if (staff.track.playbackInfo.program <= 39)
                    {
                        tuningProperty.addElement("Instrument").innerText = "Bass"
                    }
                    else 
                    {
                        tuningProperty.addElement("Instrument").innerText = "Guitar"
                    }
                }
                7.0 -> 
                {
                    if (staff.track.playbackInfo.program <= 39)
                    {
                        tuningProperty.addElement("Instrument").innerText = "Bass"
                    }
                    else 
                    {
                        tuningProperty.addElement("Instrument").innerText = "Guitar"
                    }
                }
                else -> 
                {
                    tuningProperty.addElement("Instrument").innerText = "Guitar"
                }
            }
        }
        this.writeSimplePropertyNode(properties, "PartialCapoFret", "Fret", "0")
        this.writeSimplePropertyNode(properties, "PartialCapoStringFlags", "Bitset", staff.tuning.map(fun(_: Double): String{
            return "0"
        }
        ).join(""))
        this.writeSimplePropertyNode(properties, "TuningFlat", "Enable", null)
        this.writeDiagramCollection(properties, staff, "DiagramCollection")
        this.writeDiagramCollection(properties, staff, "DiagramWorkingSet")
    }
    
    /**
     */
    private fun writeDiagramCollection(properties: alphaTab.xml.XmlNode, staff: alphaTab.model.Staff, name: String): Unit{
        var diagramCollectionProperty: alphaTab.xml.XmlNode = properties.addElement("Property")
        diagramCollectionProperty.attributes.set("name", name)
        var diagramCollectionItems: alphaTab.xml.XmlNode = diagramCollectionProperty.addElement("Items")
        var sc: alphaTab.collections.Map<String, alphaTab.model.Chord>? = staff.chords
        if (alphaTab.core.TypeHelper.isTruthy(sc))
        {
            for ((id, chord) in sc)
            {
                var diagramCollectionItem: alphaTab.xml.XmlNode = diagramCollectionItems.addElement("Item")
                diagramCollectionItem.attributes.set("id", id)
                diagramCollectionItem.attributes.set("name", chord.name)
                var diagram: alphaTab.xml.XmlNode = diagramCollectionItem.addElement("Diagram")
                diagram.attributes.set("stringCount", chord.strings.length.toInvariantString())
                diagram.attributes.set("fretCount", "5")
                diagram.attributes.set("baseFret", (chord.firstFret - 1.0).toInvariantString())
                diagram.attributes.set("barStates", chord.strings.map(fun(_: Double): String{
                    return "1"
                }
                ).join(" "))
                var frets: alphaTab.collections.DoubleList = alphaTab.collections.DoubleList(
                )
                
                var fretToStrings: alphaTab.collections.DoubleObjectMap<alphaTab.collections.DoubleList> = alphaTab.collections.DoubleObjectMap<alphaTab.collections.DoubleList>()
                if(true) {
                    var i: Double = 0.0
                    
                    while(i < chord.strings.length){
                        try{
                            var chordFret: Double = chord.strings[(i).toInt()]
                            if (chordFret != -1.0)
                            {
                                var fretNode: alphaTab.xml.XmlNode = diagram.addElement("Fret")
                                var chordString: Double = (chord.strings.length - 1.0 - i)
                                fretNode.attributes.set("string", chordString.toInvariantString())
                                fretNode.attributes.set("fret", (chordFret - chord.firstFret + 1.0).toInvariantString())
                                if (!fretToStrings.has(chordFret))
                                {
                                    fretToStrings.set(chordFret, alphaTab.collections.DoubleList(
                                    )
                                    )
                                    frets.push(chordFret)
                                }
                                fretToStrings.get(chordFret)!!.push(chordString)
                            }
                        }
                        finally{
                            i++
                        }
                    }
                }
                frets.sort()
                var fingering: alphaTab.xml.XmlNode = diagram.addElement("Fingering")
                if (chord.barreFrets.length > 0)
                {
                    var fingers: alphaTab.collections.List<alphaTab.model.Fingers> = alphaTab.collections.List<alphaTab.model.Fingers>(
                        alphaTab.model.Fingers.LittleFinger, alphaTab.model.Fingers.AnnularFinger, alphaTab.model.Fingers.MiddleFinger, alphaTab.model.Fingers.IndexFinger)
                    
                    for (fret in frets)
                    {
                        var fretStrings: alphaTab.collections.DoubleList = fretToStrings.get(fret)!!
                        if (fretStrings.length > 1 && chord.barreFrets.indexOf(fret) >= 0)
                        {
                            var finger: alphaTab.model.Fingers? = if(fingers.length > 0)  fingers.pop() else alphaTab.model.Fingers.IndexFinger
                            for (fretString in fretStrings)
                            {
                                var position: alphaTab.xml.XmlNode = fingering.addElement("Position")
                                when (finger)
                                {
                                    alphaTab.model.Fingers.LittleFinger -> 
                                    {
                                        position.attributes.set("finger", "Pinky")
                                    }
                                    alphaTab.model.Fingers.AnnularFinger -> 
                                    {
                                        position.attributes.set("finger", "Ring")
                                    }
                                    alphaTab.model.Fingers.MiddleFinger -> 
                                    {
                                        position.attributes.set("finger", "Middle")
                                    }
                                    alphaTab.model.Fingers.IndexFinger -> 
                                    {
                                        position.attributes.set("finger", "Index")
                                    }
                                    else -> { }
                                }
                                position.attributes.set("fret", (fret - chord.firstFret + 1.0).toInvariantString())
                                position.attributes.set("string", fretString.toInvariantString())
                            }
                        }
                    }
                }
                var showName: alphaTab.xml.XmlNode = diagram.addElement("Property")
                showName.attributes.set("name", "ShowName")
                showName.attributes.set("type", "bool")
                showName.attributes.set("value", if(chord.showName)  "true" else "false")
                var showDiagram: alphaTab.xml.XmlNode = diagram.addElement("Property")
                showDiagram.attributes.set("name", "ShowDiagram")
                showDiagram.attributes.set("type", "bool")
                showDiagram.attributes.set("value", if(chord.showDiagram)  "true" else "false")
                var showFingering: alphaTab.xml.XmlNode = diagram.addElement("Property")
                showFingering.attributes.set("name", "ShowFingering")
                showFingering.attributes.set("type", "bool")
                showFingering.attributes.set("value", if(chord.showFingering)  "true" else "false")
                var chordNode: alphaTab.xml.XmlNode = diagram.addElement("Chord")
                var keyNoteNode: alphaTab.xml.XmlNode = chordNode.addElement("KeyNote")
                keyNoteNode.attributes.set("step", "C")
                keyNoteNode.attributes.set("accidental", "Natural")
                var bassNoteNode: alphaTab.xml.XmlNode = chordNode.addElement("BassNote")
                bassNoteNode.attributes.set("step", "C")
                bassNoteNode.attributes.set("accidental", "Natural")
                var degree1Node: alphaTab.xml.XmlNode = chordNode.addElement("Degree")
                degree1Node.attributes.set("interval", "Third")
                degree1Node.attributes.set("alteration", "Major")
                degree1Node.attributes.set("omitted", "false")
                var degree2Node: alphaTab.xml.XmlNode = chordNode.addElement("Degree")
                degree2Node.attributes.set("interval", "Fifth")
                degree2Node.attributes.set("alteration", "Perfect")
                degree2Node.attributes.set("omitted", "false")
            }
        }
    }
    
    /**
     */
    private fun writeSimplePropertyNode(parent: alphaTab.xml.XmlNode, propertyName: String, propertyValueTagName: String, propertyValue: String?): alphaTab.xml.XmlNode{
        var prop: alphaTab.xml.XmlNode = parent.addElement("Property")
        prop.attributes.set("name", propertyName)
        var propertyValueTag: alphaTab.xml.XmlNode = prop.addElement(propertyValueTagName)
        if (propertyValue != null)
        {
            propertyValueTag.innerText = propertyValue
        }
        return prop
    }
    
    /**
     */
    private fun writeSimpleXPropertyNode(parent: alphaTab.xml.XmlNode, propertyId: String, propertyValueTagName: String, propertyValue: String?): alphaTab.xml.XmlNode{
        var prop: alphaTab.xml.XmlNode = parent.addElement("XProperty")
        prop.attributes.set("id", propertyId)
        var propertyValueTag: alphaTab.xml.XmlNode = prop.addElement(propertyValueTagName)
        if (propertyValue != null)
        {
            propertyValueTag.innerText = propertyValue
        }
        return prop
    }
    
    /**
     */
    private fun writeLyricsNode(trackNode: alphaTab.xml.XmlNode, track: alphaTab.model.Track): Unit{
        var lyrics: alphaTab.xml.XmlNode = trackNode.addElement("Lyrics")
        lyrics.attributes.set("dispatched", "true")
        var lines: alphaTab.collections.List<alphaTab.model.Lyrics> = alphaTab.collections.List<alphaTab.model.Lyrics>(
        )
        
        for (bar in track.staves[(0).toInt()].bars)
        {
            for (voice in bar.voices)
            {
                if (!voice.isEmpty)
                {
                    for (beat in voice.beats)
                    {
                        if (alphaTab.core.TypeHelper.isTruthy(beat.lyrics))
                        {
                            if(true) {
                                var l: Double = 0.0
                                
                                while(l < beat.lyrics!!.length){
                                    try{
                                        while (l >= lines.length)
                                        {
                                            var newLyrics: alphaTab.model.Lyrics = alphaTab.model.Lyrics()
                                            newLyrics.startBar = bar.index
                                            newLyrics.text = "[Empty]"
                                            lines.push(newLyrics)
                                        }
                                        var line: alphaTab.model.Lyrics = lines[(l).toInt()]
                                        line.text = if(line.text == "[Empty]")  beat.lyrics!![(l).toInt()] else line.text + " " + beat.lyrics!![(l).toInt()].splitBy(" ").join("+")
                                    }
                                    finally{
                                        l++
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if(true) {
            var i: Double = 0.0
            
            while(i < lines.length){
                try{
                    var line: alphaTab.xml.XmlNode = lyrics.addElement("Line")
                    line.addElement("Text").setCData(lines[(i).toInt()].text)
                    line.addElement("Offset").innerText = lines[(i).toInt()].startBar.toInvariantString()
                }
                finally{
                    i++
                }
            }
        }
    }
    
    /**
     */
    private fun writeTransposeNode(trackNode: alphaTab.xml.XmlNode, track: alphaTab.model.Track): Unit{
        var transpose: alphaTab.xml.XmlNode = trackNode.addElement("Transpose")
        var octaveTranspose: Double = alphaTab.core.ecmaScript.Math.floor(track.staves[(0).toInt()].displayTranspositionPitch / (12.0).toDouble())
        var chromaticTranspose: Double = track.staves[(0).toInt()].displayTranspositionPitch - octaveTranspose * 12.0
        transpose.addElement("Chromatic").innerText = chromaticTranspose.toInvariantString()
        transpose.addElement("Octave").innerText = octaveTranspose.toInvariantString()
    }
    
    /**
     */
    private fun writeInstrumentSetNode(trackNode: alphaTab.xml.XmlNode, track: alphaTab.model.Track): Unit{
        var instrumentSet: alphaTab.xml.XmlNode = trackNode.addElement("InstrumentSet")
        var firstStaff: alphaTab.model.Staff = track.staves[(0).toInt()]
        instrumentSet.addElement("LineCount").innerText = firstStaff.standardNotationLineCount.toInvariantString()
        if (track.percussionArticulations.length > 0 || firstStaff.isPercussion)
        {
            var articulations: alphaTab.collections.List<alphaTab.model.InstrumentArticulation> = if(track.percussionArticulations.length > 0)  track.percussionArticulations else alphaTab.core.ecmaScript.Array.from(alphaTab.model.PercussionMapper.instrumentArticulations.values())
            instrumentSet.addElement("Name").innerText = alphaTab.exporter.GpifWriter.DrumKitProgramInfo.instrumentSetName
            instrumentSet.addElement("Type").innerText = alphaTab.exporter.GpifWriter.DrumKitProgramInfo.instrumentSetType
            var currentElementType: String = ""
            var currentElementName: String = ""
            var currentArticulations: alphaTab.xml.XmlNode = alphaTab.xml.XmlNode()
            var counterPerType: alphaTab.collections.ObjectDoubleMap<String> = alphaTab.collections.ObjectDoubleMap<String>()
            var elements: alphaTab.xml.XmlNode = instrumentSet.addElement("Elements")
            for (articulation in articulations)
            {
                if (!alphaTab.core.TypeHelper.isTruthy(currentElementType) || currentElementType != articulation.elementType)
                {
                    var currentElement: alphaTab.xml.XmlNode = elements.addElement("Element")
                    var name: String = articulation.elementType
                    if (counterPerType.has(name))
                    {
                        var counter: Double = counterPerType.get(name)!!
                        name += " " + (counter).toInvariantString()
                        counterPerType.set(name, counter + 1.0)
                    }
                    else 
                    {
                        counterPerType.set(name, 1.0)
                    }
                    currentElementName = name
                    currentElement.addElement("Name").innerText = name
                    currentElement.addElement("Type").innerText = articulation.elementType
                    currentArticulations = currentElement.addElement("Articulations")
                }
                var articulationNode: alphaTab.xml.XmlNode = currentArticulations.addElement("Articulation")
                articulationNode.addElement("Name").innerText = currentElementName + " " + (currentArticulations.childNodes.length).toInvariantString()
                articulationNode.addElement("StaffLine").innerText = articulation.staffLine.toInvariantString()
                articulationNode.addElement("Noteheads").innerText = alphaTab.collections.List<String>(
                    this.mapMusicSymbol(articulation.noteHeadDefault), this.mapMusicSymbol(articulation.noteHeadHalf), this.mapMusicSymbol(articulation.noteHeadWhole))
                .join(" ")
                when (articulation.techniqueSymbolPlacement)
                {
                    alphaTab.platform.TextBaseline.Top -> 
                    {
                        articulationNode.addElement("TechniquePlacement").innerText = "below"
                    }
                    alphaTab.platform.TextBaseline.Middle -> 
                    {
                        articulationNode.addElement("TechniquePlacement").innerText = "inside"
                    }
                    alphaTab.platform.TextBaseline.Bottom -> 
                    {
                        articulationNode.addElement("TechniquePlacement").innerText = "above"
                    }
                    else -> { }
                }
                articulationNode.addElement("TechniqueSymbol").innerText = this.mapMusicSymbol(articulation.techniqueSymbol)
                articulationNode.addElement("InputMidiNumbers").innerText = ""
                articulationNode.addElement("OutputMidiNumber").innerText = articulation.outputMidiNumber.toInvariantString()
            }
        }
        else 
        {
            var programInfo: alphaTab.exporter.GpifMidiProgramInfo = if(alphaTab.exporter.GpifWriter.MidiProgramInfoLookup.has(track.playbackInfo.program))  alphaTab.exporter.GpifWriter.MidiProgramInfoLookup.get(track.playbackInfo.program)!! else alphaTab.exporter.GpifWriter.MidiProgramInfoLookup.get(0.0)!!
            instrumentSet.addElement("Name").innerText = programInfo.instrumentSetName
            instrumentSet.addElement("Type").innerText = programInfo.instrumentSetType
            var elements: alphaTab.xml.XmlNode = instrumentSet.addElement("Elements")
            var element: alphaTab.xml.XmlNode = elements.addElement("Element")
            element.addElement("Pitched").innerText = "Pitched"
            element.addElement("Type").innerText = "pitched"
            element.addElement("SoundbankName").innerText = ""
            var articulations: alphaTab.xml.XmlNode = element.addElement("Articulations")
            var articulation: alphaTab.xml.XmlNode = articulations.addElement("Articulation")
            articulation.addElement("Name").innerText = ""
            articulation.addElement("StaffLine").innerText = "0"
            articulation.addElement("Noteheads").innerText = "noteheadBlack noteheadHalf noteheadWhole"
            articulation.addElement("TechniquePlacement").innerText = "outside"
            articulation.addElement("TechniqueSymbol").innerText = ""
            articulation.addElement("InputMidiNumbers").innerText = ""
            articulation.addElement("OutputRSESound").innerText = ""
            articulation.addElement("OutputMidiNumber").innerText = "0"
        }
    }
    
    /**
     */
    private fun mapMusicSymbol(symbol: alphaTab.model.MusicFontSymbol): String{
        if (symbol == alphaTab.model.MusicFontSymbol.None)
        {
            return ""
        }
        var s: String = symbol.toString()
        return s.substring(0.0, 1.0).lowercase() + s.substring(1.0)
    }
    
    /**
     */
    private fun writeMasterBarsNode(parent: alphaTab.xml.XmlNode, score: alphaTab.model.Score): Unit{
        var masterBars: alphaTab.xml.XmlNode = parent.addElement("MasterBars")
        for (masterBar in score.masterBars)
        {
            this.writeMasterBarNode(masterBars, masterBar)
        }
    }
    
    /**
     */
    private fun writeMasterBarNode(parent: alphaTab.xml.XmlNode, masterBar: alphaTab.model.MasterBar): Unit{
        var masterBarNode: alphaTab.xml.XmlNode = parent.addElement("MasterBar")
        var key: alphaTab.xml.XmlNode = masterBarNode.addElement("Key")
        key.addElement("AccidentalCount").innerText = (masterBar.keySignature.toDouble()).toInvariantString()
        key.addElement("Mode").innerText = masterBar.keySignatureType.toString()
        key.addElement("Sharps").innerText = "Sharps"
        masterBarNode.addElement("Time").innerText = """${(masterBar.timeSignatureNumerator).toTemplate()}/${(masterBar.timeSignatureDenominator).toTemplate()}"""
        var bars: alphaTab.collections.List<String> = alphaTab.collections.List<String>(
        )
        
        for (tracks in masterBar.score.tracks)
        {
            for (staves in tracks.staves)
            {
                bars.push(staves.bars[(masterBar.index).toInt()].id.toInvariantString())
            }
        }
        masterBarNode.addElement("Bars").innerText = bars.join(" ")
        if (masterBar.isDoubleBar)
        {
            masterBarNode.addElement("DoubleBar")
        }
        if (masterBar.isSectionStart)
        {
            var section: alphaTab.xml.XmlNode = masterBarNode.addElement("Section")
            section.addElement("Letter").setCData(masterBar.section!!.marker)
            section.addElement("Text").setCData(masterBar.section!!.text)
        }
        if (masterBar.isRepeatStart || masterBar.isRepeatEnd)
        {
            var repeat: alphaTab.xml.XmlNode = masterBarNode.addElement("Repeat")
            repeat.attributes.set("start", if(masterBar.isRepeatStart)  "true" else "false")
            repeat.attributes.set("end", if(masterBar.isRepeatEnd)  "true" else "false")
            if (masterBar.isRepeatEnd)
            {
                repeat.attributes.set("count", masterBar.repeatCount.toInvariantString())
            }
        }
        if (masterBar.alternateEndings > 0)
        {
            var remainingBits: Double = masterBar.alternateEndings
            var alternateEndings: alphaTab.collections.DoubleList = alphaTab.collections.DoubleList(
            )
            
            var bit: Double = 0.0
            while (remainingBits > 0)
            {
                if ((((remainingBits).toInt() shr (bit).toInt()) and 1) == 1)
                {
                    alternateEndings.push(bit + 1.0)
                    remainingBits = ((remainingBits.toInt()) and (((((1 shl (bit).toInt()).toDouble())).toInt()).toInt().inv())).toDouble()
                }
                bit++
            }
            masterBarNode.addElement("AlternateEndings").innerText = alternateEndings.join(" ")
        }
        if (masterBar.tripletFeel != alphaTab.model.TripletFeel.NoTripletFeel)
        {
            masterBarNode.addElement("TripletFeel").innerText = masterBar.tripletFeel.toString()
        }
        this.writeFermatas(masterBarNode, masterBar)
    }
    
    /**
     */
    private fun writeFermatas(parent: alphaTab.xml.XmlNode, masterBar: alphaTab.model.MasterBar): Unit{
        var fermataCount: Double = (masterBar.fermata?.size ?: 0.0)
        if (fermataCount == 0.0)
        {
            return
        }
        if (fermataCount > 0)
        {
            var fermatas: alphaTab.xml.XmlNode = parent.addElement("Fermatas")
            for ((offset, fermata) in masterBar.fermata!!)
            {
                this.writeFermata(fermatas, offset, fermata)
            }
        }
    }
    
    /**
     */
    private fun writeFermata(parent: alphaTab.xml.XmlNode, offset: Double, fermata: alphaTab.model.Fermata): Unit{
        var numerator: Double = -1.0
        var denominator: Double = 1.0
        if (offset > 0)
        {
            while (denominator < 10)
            {
                numerator = (offset / alphaTab.midi.MidiUtils.QuarterTime) * denominator
                if (numerator == alphaTab.core.ecmaScript.Math.floor(numerator))
                {
                    break
                }
                numerator = -1.0
                denominator++
            }
        }
        else 
        {
            numerator = 0.0
            denominator = 1.0
        }
        if (numerator == -1.0)
        {
            return
        }
        var fermataNode: alphaTab.xml.XmlNode = parent.addElement("Fermata")
        fermataNode.addElement("Type").innerText = fermata.type.toString()
        fermataNode.addElement("Length").innerText = fermata.length.toInvariantString()
        fermataNode.addElement("Offset").innerText = """${(numerator).toTemplate()}/${(denominator).toTemplate()}"""
    }
    
    /**
     */
    private fun writeBarNode(parent: alphaTab.xml.XmlNode, bar: alphaTab.model.Bar): Unit{
        var barNode: alphaTab.xml.XmlNode = parent.addElement("Bar")
        barNode.attributes.set("id", bar.id.toInvariantString())
        barNode.addElement("Voices").innerText = bar.voices.map(fun(v: alphaTab.model.Voice): String{
            return (if(v.isEmpty)  "-1" else v.id.toInvariantString())
        }
        ).join(" ")
        barNode.addElement("Clef").innerText = bar.clef.toString()
        if (bar.clefOttava != alphaTab.model.Ottavia.Regular)
        {
            barNode.addElement("Ottavia").innerText = bar.clefOttava.toString().substr(1.0)
        }
        if (bar.simileMark != alphaTab.model.SimileMark.None)
        {
            barNode.addElement("SimileMark").innerText = bar.simileMark.toString()
        }
    }
    
    /**
     */
    private fun writeVoiceNode(parent: alphaTab.xml.XmlNode, voice: alphaTab.model.Voice): Unit{
        if (voice.isEmpty)
        {
            return
        }
        var voiceNode: alphaTab.xml.XmlNode = parent.addElement("Voice")
        voiceNode.attributes.set("id", voice.id.toInvariantString())
        voiceNode.addElement("Beats").innerText = voice.beats.map(fun(v: alphaTab.model.Beat): Double{
            return v.id
        }
        ).join(" ")
    }
    
    companion object{
        @kotlin.jvm.JvmStatic
        private var MidiProgramInfoLookup: alphaTab.collections.DoubleObjectMap<alphaTab.exporter.GpifMidiProgramInfo> = alphaTab.collections.DoubleObjectMap<alphaTab.exporter.GpifMidiProgramInfo>(alphaTab.core.TypeHelper.mapInitializer<alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>>(
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(0.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Piano, "Acoustic Piano"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(1.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Piano, "Acoustic Piano"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(2.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Piano, "Electric Piano"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(3.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Piano, "Acoustic Piano"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(4.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Piano, "Electric Piano"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(5.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Piano, "Electric Piano"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(6.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Piano, "Harpsichord"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(7.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Piano, "Harpsichord"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(8.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.PitchedIdiophone, "Celesta"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(9.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.PitchedIdiophone, "Vibraphone"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(10.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.PitchedIdiophone, "Vibraphone"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(11.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.PitchedIdiophone, "Vibraphone"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(12.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.PitchedIdiophone, "Xylophone"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(13.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.PitchedIdiophone, "Xylophone"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(14.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.PitchedIdiophone, "Vibraphone"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(15.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Banjo, "Banjo"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(16.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Piano, "Electric Organ"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(17.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Piano, "Electric Organ"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(18.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Piano, "Electric Organ"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(19.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Piano, "Electric Organ"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(20.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Piano, "Electric Organ"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(21.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Piano, "Electric Organ"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(22.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Woodwind, "Recorder"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(23.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Piano, "Electric Organ"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(24.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.ClassicalGuitar, "Nylon Guitar"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(25.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.SteelGuitar, "Steel Guitar"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(26.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.SteelGuitar, "Electric Guitar"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(27.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.ElectricGuitar, "Electric Guitar"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(28.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.ElectricGuitar, "Electric Guitar"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(29.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.ElectricGuitar, "Electric Guitar"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(30.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.SteelGuitar, "Electric Guitar"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(31.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.SteelGuitar, "Electric Guitar"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(32.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Bass, "Acoustic Bass"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(33.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Bass, "Electric Bass"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(34.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Bass, "Electric Bass"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(35.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Bass, "Acoustic Bass"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(36.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Bass, "Electric Bass"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(37.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Bass, "Electric Bass"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(38.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Synth, "Synth Bass"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(39.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Synth, "Synth Bass"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(40.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Strings, "Violin"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(41.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Strings, "Viola"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(42.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Strings, "Cello"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(43.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Strings, "Contrabass"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(44.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Strings, "Violin"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(45.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Strings, "Violin"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(46.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Piano, "Harp"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(47.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Membraphone, "Timpani"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(48.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Strings, "Violin"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(49.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Strings, "Violin"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(50.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Strings, "Violin"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(51.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Strings, "Violin"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(52.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Vocal, "Voice"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(53.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Vocal, "Voice"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(54.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Vocal, "Voice"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(55.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Synth, "Pad Synthesizer"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(56.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Brass, "Trumpet"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(57.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Brass, "Trombone"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(58.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Brass, "Tuba"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(59.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Brass, "Trumpet"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(60.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Brass, "French Horn"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(61.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Brass, "Trumpet"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(62.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Brass, "Trumpet"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(63.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Brass, "Trumpet"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(64.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Reed, "Saxophone"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(65.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Reed, "Saxophone"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(66.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Reed, "Saxophone"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(67.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Reed, "Saxophone"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(68.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Reed, "Oboe"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(69.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Reed, "English Horn"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(70.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Reed, "Bassoon"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(71.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Reed, "Clarinet"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(72.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Reed, "Piccolo"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(73.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Woodwind, "Flute"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(74.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Woodwind, "Recorder"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(75.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Woodwind, "Flute"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(76.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Woodwind, "Recorder"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(77.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Woodwind, "Flute"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(78.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Woodwind, "Recorder"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(79.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Woodwind, "Flute"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(80.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Synth, "Lead Synthesizer"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(81.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Synth, "Lead Synthesizer"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(82.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Synth, "Lead Synthesizer"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(83.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Synth, "Lead Synthesizer"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(84.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Synth, "Lead Synthesizer"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(85.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Synth, "Lead Synthesizer"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(86.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Synth, "Lead Synthesizer"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(87.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Synth, "Lead Synthesizer"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(88.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Synth, "Pad Synthesizer"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(89.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Synth, "Pad Synthesizer"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(90.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Synth, "Pad Synthesizer"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(91.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Synth, "Pad Synthesizer"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(92.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Synth, "Pad Synthesizer"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(93.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Synth, "Pad Synthesizer"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(94.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Synth, "Pad Synthesizer"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(95.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Synth, "Pad Synthesizer"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(96.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Fx, "Pad Synthesizer"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(97.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Fx, "Pad Synthesizer"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(98.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Fx, "Pad Synthesizer"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(99.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Fx, "Pad Synthesizer"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(100.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Fx, "Lead Synthesizer"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(101.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Fx, "Lead Synthesizer"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(102.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Fx, "Lead Synthesizer"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(103.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Fx, "Trumpet"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(104.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.ElectricGuitar, "Banjo"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(105.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Banjo, "Banjo"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(106.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Ukulele, "Ukulele"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(107.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Banjo, "Banjo"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(108.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.PitchedIdiophone, "Xylophone"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(109.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Reed, "Bassoon"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(110.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Strings, "Violin"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(111.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Woodwind, "Flute"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(112.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.PitchedIdiophone, "Xylophone"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(113.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Idiophone, "Celesta"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(114.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.PitchedIdiophone, "Vibraphone"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(115.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Idiophone, "Xylophone"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(116.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Membraphone, "Xylophone"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(117.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Membraphone, "Xylophone"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(118.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Membraphone, "Xylophone"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(119.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Idiophone, "Celesta"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(120.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Fx, "Steel Guitar"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(121.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Fx, "Recorder"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(122.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Fx, "Recorder"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(123.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Fx, "Recorder"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(124.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Fx, "Recorder"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(125.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Fx, "Recorder"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(126.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Fx, "Recorder"))
            , 
            alphaTab.collections.DoubleObjectMapEntry<alphaTab.exporter.GpifMidiProgramInfo>(127.0, alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.Fx, "Timpani"))
        
        ))
        
        @kotlin.jvm.JvmStatic
        private var DrumKitProgramInfo: alphaTab.exporter.GpifMidiProgramInfo = alphaTab.exporter.GpifMidiProgramInfo(alphaTab.exporter.GpifIconIds.PercussionKit, "Drums", "drumKit")
        
        /**
         */
        @kotlin.jvm.JvmStatic
        private fun getIconId(playbackInfo: alphaTab.model.PlaybackInformation): alphaTab.exporter.GpifIconIds{
            if (playbackInfo.primaryChannel == 9.0)
            {
                return alphaTab.exporter.GpifWriter.DrumKitProgramInfo.icon
            }
            if (alphaTab.exporter.GpifWriter.MidiProgramInfoLookup.has(playbackInfo.program))
            {
                return alphaTab.exporter.GpifWriter.MidiProgramInfoLookup.get(playbackInfo.program)!!.icon
            }
            return alphaTab.exporter.GpifIconIds.SteelGuitar
        }
        
    }
    public constructor()
}

internal enum class GpifIconIds(override val value: Int): alphaTab.core.IAlphaTabEnum
{
    SteelGuitar(1),
    AcousticGuitar(2),
    TwelveStringGuitar(3),
    ElectricGuitar(4),
    Bass(5),
    ClassicalGuitar(23),
    UprightBass(6),
    Ukulele(7),
    Banjo(8),
    Mandolin(9),
    Piano(10),
    Synth(12),
    Strings(11),
    Brass(13),
    Reed(14),
    Woodwind(15),
    Vocal(16),
    PitchedIdiophone(17),
    Fx(21),
    PercussionKit(18),
    Idiophone(19),
    Membraphone(20);
    companion object{
        public fun fromValue(v:Double): GpifIconIds{
            return when(v.toInt()){
                SteelGuitar.value -> SteelGuitar
                AcousticGuitar.value -> AcousticGuitar
                TwelveStringGuitar.value -> TwelveStringGuitar
                ElectricGuitar.value -> ElectricGuitar
                Bass.value -> Bass
                ClassicalGuitar.value -> ClassicalGuitar
                UprightBass.value -> UprightBass
                Ukulele.value -> Ukulele
                Banjo.value -> Banjo
                Mandolin.value -> Mandolin
                Piano.value -> Piano
                Synth.value -> Synth
                Strings.value -> Strings
                Brass.value -> Brass
                Reed.value -> Reed
                Woodwind.value -> Woodwind
                Vocal.value -> Vocal
                PitchedIdiophone.value -> PitchedIdiophone
                Fx.value -> Fx
                PercussionKit.value -> PercussionKit
                Idiophone.value -> Idiophone
                Membraphone.value -> Membraphone
                else -> throw ClassCastException("No enum with value $v found")}
        }
    }
}

@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class GpifMidiProgramInfo
{
    public var icon: alphaTab.exporter.GpifIconIds = alphaTab.exporter.GpifIconIds.Piano
    
    public var instrumentSetName: String
    public var instrumentSetType: String
    public constructor(icon: alphaTab.exporter.GpifIconIds, instrumentSetName: String, instrumentSetType: String? = null){
        this.icon = icon
        this.instrumentSetName = instrumentSetName
        if (!alphaTab.core.TypeHelper.isTruthy(instrumentSetType))
        {
            var parts: alphaTab.collections.List<String> = instrumentSetName.splitBy(" ")
            parts[(0).toInt()] = parts[(0).toInt()].substr(0.0, 1.0).lowercase() + parts[(0).toInt()].substr(1.0)
            this.instrumentSetType = parts.join("")
        }
        else 
        {
            this.instrumentSetType = instrumentSetType
        }
    }
    
}

