// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.importer
import alphaTab.core.*

/**
 * This importer can parse alphaTex markup into a score structure.
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class AlphaTexImporter: alphaTab.importer.ScoreImporter
{
    private var _trackChannel: Double = 0.0
    
    private lateinit var _score: alphaTab.model.Score
    
    private lateinit var _currentTrack: alphaTab.model.Track
    
    private lateinit var _currentStaff: alphaTab.model.Staff
    
    private var _input: String = ""
    
    private var _ch: Double = alphaTab.importer.AlphaTexImporter.Eof
    
    private var _curChPos: Double = 0.0
    
    private var _line: Double = 1.0
    
    private var _col: Double = 0.0
    
    private var _lastValidSpot: alphaTab.collections.DoubleList = alphaTab.collections.DoubleList(
        0.0, 1.0, 0.0)
    
    
    private var _sy: alphaTab.importer.AlphaTexSymbols = alphaTab.importer.AlphaTexSymbols.No
    
    private var _syData: Any? = ""
    
    private var _allowNegatives: Boolean = false
    
    private var _allowFloat: Boolean = false
    
    private var _allowTuning: Boolean = false
    
    private var _currentDuration: alphaTab.model.Duration = alphaTab.model.Duration.QuadrupleWhole
    
    private var _currentDynamics: alphaTab.model.DynamicValue = alphaTab.model.DynamicValue.PPP
    
    private var _currentTuplet: Double = 0.0
    
    private lateinit var _lyrics: alphaTab.collections.DoubleObjectMap<alphaTab.collections.List<alphaTab.model.Lyrics>>
    
    private var _staffHasExplicitTuning: Boolean = false
    
    private var _staffTuningApplied: Boolean = false
    
    public var logErrors: Boolean = false
    
    public constructor()
        : super()
    public override val name: String
    get(){
        return "AlphaTex"
    }
    
    /**
     */
    public fun initFromString(tex: String, settings: alphaTab.Settings): Unit{
        this.`data` = alphaTab.io.ByteBuffer.empty()
        this._input = tex
        this.settings = settings
    }
    
    /**
     * Reads the  contained in the data.
     */
    public override fun readScore(): alphaTab.model.Score{
        try
        {
            if (this.`data`.length > 0)
            {
                this._input = alphaTab.io.IOHelper.toString(this.`data`.readAll(), this.settings.importer.encoding)
            }
            this._allowTuning = true
            this._lyrics = alphaTab.collections.DoubleObjectMap<alphaTab.collections.List<alphaTab.model.Lyrics>>()
            this.createDefaultScore()
            this._curChPos = 0.0
            this._line = 1.0
            this._col = 0.0
            this.saveValidSpot()
            this._currentDuration = alphaTab.model.Duration.Quarter
            this._currentDynamics = alphaTab.model.DynamicValue.F
            this._currentTuplet = 1.0
            this._ch = this.nextChar()
            this._sy = this.newSy()
            if (this._sy == alphaTab.importer.AlphaTexSymbols.LowerThan)
            {
                throw alphaTab.importer.UnsupportedFormatError("Unknown start sign '<' (meant to import as XML?)")
            }
            else if (this._sy == alphaTab.importer.AlphaTexSymbols.Eof)
            {
                throw alphaTab.importer.UnsupportedFormatError("Unexpected end of file")
            }
            var anyMetaRead: Boolean = this.metaData()
            var anyBarsRead: Boolean = this.bars()
            if (!anyMetaRead && !anyBarsRead)
            {
                throw alphaTab.importer.UnsupportedFormatError("No alphaTex data found")
            }
            this.consolidate()
            this._score.finish(this.settings)
            this._score.rebuildRepeatGroups()
            for ((track, lyrics) in this._lyrics)
            {
                this._score.tracks[(track).toInt()].applyLyrics(lyrics)
            }
            return this._score
        }
        catch (e: kotlin.Throwable)
        {
            if (e is alphaTab.importer.AlphaTexError)
            {
                throw alphaTab.importer.UnsupportedFormatError(((e as alphaTab.importer.AlphaTexError)).message, ((e as alphaTab.core.ecmaScript.Error?)))
            }
            else 
            {
                throw e
            }
        }
    }
    
    /**
     * Ensures all staffs of all tracks have the correct number of bars
     * (the number of bars per staff and track could be inconsistent)
     */
    private fun consolidate(): Unit{
        for (track in this._score.tracks)
        {
            for (staff in track.staves)
            {
                while (staff.bars.length < this._score.masterBars.length)
                {
                    var bar: alphaTab.model.Bar = this.newBar(staff)
                    var emptyBeat: alphaTab.model.Beat = alphaTab.model.Beat()
                    emptyBeat.isEmpty = true
                    bar.voices[(0).toInt()].addBeat(emptyBeat)
                }
            }
        }
    }
    
    /**
     */
    private fun error(nonterm: String, expected: alphaTab.importer.AlphaTexSymbols, wrongSymbol: Boolean = true): Unit{
        var receivedSymbol: alphaTab.importer.AlphaTexSymbols
        var showSyData: Boolean = false
        if (wrongSymbol)
        {
            receivedSymbol = this._sy
            if (receivedSymbol == alphaTab.importer.AlphaTexSymbols.String || receivedSymbol == alphaTab.importer.AlphaTexSymbols.Number || receivedSymbol == alphaTab.importer.AlphaTexSymbols.MetaCommand)
            {
                showSyData = true
            }
        }
        else 
        {
            receivedSymbol = expected
        }
        var e: alphaTab.importer.AlphaTexError = alphaTab.importer.AlphaTexError.symbolError(
            this._lastValidSpot[(0).toInt()]
            , 
            this._lastValidSpot[(1).toInt()]
            , 
            this._lastValidSpot[(2).toInt()]
            , 
            nonterm
            , 
            expected
            , 
            receivedSymbol
            , 
            if(showSyData)  this._syData else null
        
        )
        if (this.logErrors)
        {
            alphaTab.Logger.error(this.name, e.message!!)
        }
        throw e
    }
    
    /**
     */
    private fun errorMessage(message: String): Unit{
        var e: alphaTab.importer.AlphaTexError = alphaTab.importer.AlphaTexError.errorMessage(message, this._lastValidSpot[(0).toInt()], this._lastValidSpot[(1).toInt()], this._lastValidSpot[(2).toInt()])
        if (this.logErrors)
        {
            alphaTab.Logger.error(this.name, e.message!!)
        }
        throw e
    }
    
    /**
     * Initializes the song with some required default values.
     */
    private fun createDefaultScore(): Unit{
        this._score = alphaTab.model.Score()
        this._score.tempo = 120.0
        this._score.tempoLabel = ""
        this.newTrack()
    }
    
    private fun newTrack(): Unit{
        this._currentTrack = alphaTab.model.Track()
        this._currentTrack.ensureStaveCount(1.0)
        this._currentTrack.playbackInfo.program = 25.0
        this._currentTrack.playbackInfo.primaryChannel = this._trackChannel++
        this._currentTrack.playbackInfo.secondaryChannel = this._trackChannel++
        this._currentStaff = this._currentTrack.staves[(0).toInt()]
        this._currentStaff.displayTranspositionPitch = -12.0
        this._currentStaff.stringTuning.tunings = alphaTab.model.Tuning.getDefaultTuningFor(6.0)!!.tunings
        this._score.addTrack(this._currentTrack)
        this._lyrics.set(this._currentTrack.index, alphaTab.collections.List<alphaTab.model.Lyrics>(
        )
        )
        this._currentDynamics = alphaTab.model.DynamicValue.F
    }
    
    /**
     * Converts a clef string into the clef value.
     * @param str the string to convert
     */
    private fun parseClefFromString(str: String): alphaTab.model.Clef{
        when (str.lowercase())
        {
            "g2", "treble" -> 
            {
                return alphaTab.model.Clef.G2
            }
            "f4", "bass" -> 
            {
                return alphaTab.model.Clef.F4
            }
            "c3", "tenor" -> 
            {
                return alphaTab.model.Clef.C3
            }
            "c4", "alto" -> 
            {
                return alphaTab.model.Clef.C4
            }
            "n", "neutral" -> 
            {
                return alphaTab.model.Clef.Neutral
            }
            else -> 
            {
                return alphaTab.model.Clef.G2
            }
        }
    }
    
    /**
     * Converts a clef tuning into the clef value.
     * @param i the tuning value to convert
     */
    private fun parseClefFromInt(i: Double): alphaTab.model.Clef{
        when (i)
        {
            43.0 -> 
            {
                return alphaTab.model.Clef.G2
            }
            65.0 -> 
            {
                return alphaTab.model.Clef.F4
            }
            48.0 -> 
            {
                return alphaTab.model.Clef.C3
            }
            60.0 -> 
            {
                return alphaTab.model.Clef.C4
            }
            else -> 
            {
                return alphaTab.model.Clef.G2
            }
        }
    }
    
    /**
     */
    private fun parseTripletFeelFromString(str: String): alphaTab.model.TripletFeel{
        when (str.lowercase())
        {
            "no", "none" -> 
            {
                return alphaTab.model.TripletFeel.NoTripletFeel
            }
            "t16", "triplet-16th" -> 
            {
                return alphaTab.model.TripletFeel.Triplet16th
            }
            "t8", "triplet-8th" -> 
            {
                return alphaTab.model.TripletFeel.Triplet8th
            }
            "d16", "dotted-16th" -> 
            {
                return alphaTab.model.TripletFeel.Dotted16th
            }
            "d8", "dotted-8th" -> 
            {
                return alphaTab.model.TripletFeel.Dotted8th
            }
            "s16", "scottish-16th" -> 
            {
                return alphaTab.model.TripletFeel.Scottish16th
            }
            "s8", "scottish-8th" -> 
            {
                return alphaTab.model.TripletFeel.Scottish8th
            }
            else -> 
            {
                return alphaTab.model.TripletFeel.NoTripletFeel
            }
        }
    }
    
    /**
     */
    private fun parseTripletFeelFromInt(i: Double): alphaTab.model.TripletFeel{
        when (i)
        {
            0.0 -> 
            {
                return alphaTab.model.TripletFeel.NoTripletFeel
            }
            1.0 -> 
            {
                return alphaTab.model.TripletFeel.Triplet16th
            }
            2.0 -> 
            {
                return alphaTab.model.TripletFeel.Triplet8th
            }
            3.0 -> 
            {
                return alphaTab.model.TripletFeel.Dotted16th
            }
            4.0 -> 
            {
                return alphaTab.model.TripletFeel.Dotted8th
            }
            5.0 -> 
            {
                return alphaTab.model.TripletFeel.Scottish16th
            }
            6.0 -> 
            {
                return alphaTab.model.TripletFeel.Scottish8th
            }
            else -> 
            {
                return alphaTab.model.TripletFeel.NoTripletFeel
            }
        }
    }
    
    /**
     * Converts a keysignature string into the assocciated value.
     * @param str the string to convert
     */
    private fun parseKeySignature(str: String): alphaTab.model.KeySignature{
        when (str.lowercase())
        {
            "cb", "cbmajor" -> 
            {
                return alphaTab.model.KeySignature.Cb
            }
            "gb", "gbmajor", "d#minor" -> 
            {
                return alphaTab.model.KeySignature.Gb
            }
            "db", "dbmajor", "bbminor" -> 
            {
                return alphaTab.model.KeySignature.Db
            }
            "ab", "abmajor", "fminor" -> 
            {
                return alphaTab.model.KeySignature.Ab
            }
            "eb", "ebmajor", "cminor" -> 
            {
                return alphaTab.model.KeySignature.Eb
            }
            "bb", "bbmajor", "gminor" -> 
            {
                return alphaTab.model.KeySignature.Bb
            }
            "f", "fmajor", "dminor" -> 
            {
                return alphaTab.model.KeySignature.F
            }
            "c", "cmajor", "aminor" -> 
            {
                return alphaTab.model.KeySignature.C
            }
            "g", "gmajor", "eminor" -> 
            {
                return alphaTab.model.KeySignature.G
            }
            "d", "dmajor", "bminor" -> 
            {
                return alphaTab.model.KeySignature.D
            }
            "a", "amajor", "f#minor" -> 
            {
                return alphaTab.model.KeySignature.A
            }
            "e", "emajor", "c#minor" -> 
            {
                return alphaTab.model.KeySignature.E
            }
            "b", "bmajor", "g#minor" -> 
            {
                return alphaTab.model.KeySignature.B
            }
            "f#", "f#major", "ebminor" -> 
            {
                return alphaTab.model.KeySignature.FSharp
            }
            "c#", "c#major" -> 
            {
                return alphaTab.model.KeySignature.CSharp
            }
            else -> 
            {
                return alphaTab.model.KeySignature.C
            }
        }
    }
    
    /**
     * Reads, saves, and returns the next character of the source stream.
     */
    private fun nextChar(): Double{
        if (this._curChPos < this._input.length.toDouble())
        {
            this._ch = this._input.charCodeAt(this._curChPos++)
            if (this._ch == 10.0)
            {
                this._line++
                this._col = 0.0
            }
            else 
            {
                this._col++
            }
        }
        else 
        {
            this._ch = alphaTab.importer.AlphaTexImporter.Eof
        }
        return this._ch
    }
    
    /**
     * Saves the current position, line, and column.
     * All parsed data until this point is assumed to be valid.
     */
    private fun saveValidSpot(): Unit{
        this._lastValidSpot = alphaTab.collections.DoubleList(
            this._curChPos, this._line, this._col)
        
    }
    
    /**
     * Reads, saves, and returns the next terminal symbol.
     */
    private fun newSy(): alphaTab.importer.AlphaTexSymbols{
        this.saveValidSpot()
        this._sy = alphaTab.importer.AlphaTexSymbols.No
        while (this._sy == alphaTab.importer.AlphaTexSymbols.No)
        {
            if (this._ch == alphaTab.importer.AlphaTexImporter.Eof)
            {
                this._sy = alphaTab.importer.AlphaTexSymbols.Eof
            }
            else if (alphaTab.importer.AlphaTexImporter.isWhiteSpace(this._ch))
            {
                this._ch = this.nextChar()
                this.saveValidSpot()
            }
            else if (this._ch == 47.0)
            {
                this._ch = this.nextChar()
                if (this._ch == 47.0)
                {
                    while (this._ch != 13.0 && this._ch != 10.0 && this._ch != alphaTab.importer.AlphaTexImporter.Eof)
                    {
                        this._ch = this.nextChar()
                    }
                }
                else if (this._ch == 42.0)
                {
                    while (this._ch != alphaTab.importer.AlphaTexImporter.Eof)
                    {
                        if (this._ch == 42.0)
                        {
                            this._ch = this.nextChar()
                            if (this._ch == 47.0)
                            {
                                this._ch = this.nextChar()
                                break
                            }
                        }
                        else 
                        {
                            this._ch = this.nextChar()
                        }
                    }
                }
                else 
                {
                    this.error("comment", alphaTab.importer.AlphaTexSymbols.String, false)
                }
                this.saveValidSpot()
            }
            else if (this._ch == 34.0 || this._ch == 39.0)
            {
                var startChar: Double = this._ch
                this._ch = this.nextChar()
                var s: String = ""
                this._sy = alphaTab.importer.AlphaTexSymbols.String
                while (this._ch != startChar && this._ch != alphaTab.importer.AlphaTexImporter.Eof)
                {
                    s += alphaTab.core.ecmaScript.CoreString.fromCharCode(this._ch)
                    this._ch = this.nextChar()
                }
                if (this._ch == alphaTab.importer.AlphaTexImporter.Eof)
                {
                    this.errorMessage("String opened but never closed")
                }
                this._syData = ((s as Any?))
                this._ch = this.nextChar()
            }
            else if (this._ch == 45.0)
            {
                if (this._allowNegatives)
                {
                    this._sy = alphaTab.importer.AlphaTexSymbols.Number
                    this._syData = this.readNumber()
                }
                else 
                {
                    this._sy = alphaTab.importer.AlphaTexSymbols.String
                    this._syData = this.readName()
                }
            }
            else if (this._ch == 46.0)
            {
                this._sy = alphaTab.importer.AlphaTexSymbols.Dot
                this._ch = this.nextChar()
            }
            else if (this._ch == 58.0)
            {
                this._sy = alphaTab.importer.AlphaTexSymbols.DoubleDot
                this._ch = this.nextChar()
            }
            else if (this._ch == 40.0)
            {
                this._sy = alphaTab.importer.AlphaTexSymbols.LParensis
                this._ch = this.nextChar()
            }
            else if (this._ch == 92.0)
            {
                this._ch = this.nextChar()
                this._sy = alphaTab.importer.AlphaTexSymbols.MetaCommand
                this._syData = this.readName()
            }
            else if (this._ch == 41.0)
            {
                this._sy = alphaTab.importer.AlphaTexSymbols.RParensis
                this._ch = this.nextChar()
            }
            else if (this._ch == 123.0)
            {
                this._sy = alphaTab.importer.AlphaTexSymbols.LBrace
                this._ch = this.nextChar()
            }
            else if (this._ch == 125.0)
            {
                this._sy = alphaTab.importer.AlphaTexSymbols.RBrace
                this._ch = this.nextChar()
            }
            else if (this._ch == 124.0)
            {
                this._sy = alphaTab.importer.AlphaTexSymbols.Pipe
                this._ch = this.nextChar()
            }
            else if (this._ch == 42.0)
            {
                this._sy = alphaTab.importer.AlphaTexSymbols.Multiply
                this._ch = this.nextChar()
            }
            else if (this._ch == 60.0)
            {
                this._sy = alphaTab.importer.AlphaTexSymbols.LowerThan
                this._ch = this.nextChar()
            }
            else if (this.isDigit(this._ch))
            {
                this._sy = alphaTab.importer.AlphaTexSymbols.Number
                this._syData = this.readNumber()
            }
            else if (alphaTab.importer.AlphaTexImporter.isNameLetter(this._ch))
            {
                var name: String = this.readName()
                var tuning: alphaTab.model.TuningParseResult? = if(this._allowTuning)  alphaTab.model.ModelUtils.parseTuning(name) else null
                if (alphaTab.core.TypeHelper.isTruthy(tuning))
                {
                    this._sy = alphaTab.importer.AlphaTexSymbols.Tuning
                    this._syData = tuning
                }
                else 
                {
                    this._sy = alphaTab.importer.AlphaTexSymbols.String
                    this._syData = ((name as Any?))
                }
            }
            else 
            {
                this.error("symbol", alphaTab.importer.AlphaTexSymbols.String, false)
            }
        }
        return this._sy
    }
    
    /**
     */
    private fun isDigit(ch: Double): Boolean{
        return ((ch >= 48 && ch <= 57) || (this._allowNegatives && ch == 45.0) || (this._allowFloat && ch == 46.0))
    }
    
    /**
     * Reads a string from the stream.
     */
    private fun readName(): String{
        var str: String = ""
        do
        {
            str += alphaTab.core.ecmaScript.CoreString.fromCharCode(this._ch)
            this._ch = this.nextChar()
        }
        while (alphaTab.importer.AlphaTexImporter.isNameLetter(this._ch) || this.isDigit(this._ch))
        return str
    }
    
    /**
     * Reads a number from the stream.
     */
    private fun readNumber(): Double{
        var str: String = ""
        do
        {
            str += alphaTab.core.ecmaScript.CoreString.fromCharCode(this._ch)
            this._ch = this.nextChar()
        }
        while (this.isDigit(this._ch))
        return if(this._allowFloat)  alphaTab.core.Globals.parseFloat(str) else alphaTab.core.Globals.parseInt(str)
    }
    
    private fun metaData(): Boolean{
        var anyMeta: Boolean = false
        var continueReading: Boolean = true
        while (this._sy == alphaTab.importer.AlphaTexSymbols.MetaCommand && continueReading)
        {
            var metadataTag: String = (this._syData.toString()).lowercase()
            when (metadataTag)
            {
                "title", "subtitle", "artist", "album", "words", "music", "copyright" -> 
                {
                    this._sy = this.newSy()
                    if (this._sy != alphaTab.importer.AlphaTexSymbols.String)
                    {
                        this.error(metadataTag, alphaTab.importer.AlphaTexSymbols.String, true)
                    }
                    var metadataValue: String = this._syData.toString()
                    when (metadataTag)
                    {
                        "title" -> 
                        {
                            this._score.title = metadataValue
                        }
                        "subtitle" -> 
                        {
                            this._score.subTitle = metadataValue
                        }
                        "artist" -> 
                        {
                            this._score.artist = metadataValue
                        }
                        "album" -> 
                        {
                            this._score.album = metadataValue
                        }
                        "words" -> 
                        {
                            this._score.words = metadataValue
                        }
                        "music" -> 
                        {
                            this._score.music = metadataValue
                        }
                        "copyright" -> 
                        {
                            this._score.copyright = metadataValue
                        }
                        else -> { }
                    }
                    this._sy = this.newSy()
                    anyMeta = true
                }
                "tempo" -> 
                {
                    this._allowFloat = true
                    this._sy = this.newSy()
                    this._allowFloat = false
                    if (this._sy == alphaTab.importer.AlphaTexSymbols.Number)
                    {
                        this._score.tempo = this._syData.toDouble()
                    }
                    else 
                    {
                        this.error("tempo", alphaTab.importer.AlphaTexSymbols.Number, true)
                    }
                    this._sy = this.newSy()
                    anyMeta = true
                }
                else -> 
                {
                    if (this.handleStaffMeta())
                    {
                        anyMeta = true
                    }
                    else if (anyMeta)
                    {
                        this.error("metaDataTags", alphaTab.importer.AlphaTexSymbols.String, false)
                    }
                    else 
                    {
                        continueReading = false
                    }
                }
            }
        }
        if (anyMeta)
        {
            if (this._sy != alphaTab.importer.AlphaTexSymbols.Dot)
            {
                this.error("song", alphaTab.importer.AlphaTexSymbols.Dot, true)
            }
            this._sy = this.newSy()
        }
        else if (this._sy == alphaTab.importer.AlphaTexSymbols.Dot)
        {
            this._sy = this.newSy()
        }
        return anyMeta
    }
    
    private fun handleStaffMeta(): Boolean{
        when ((this._syData.toString()).lowercase())
        {
            "capo" -> 
            {
                this._sy = this.newSy()
                if (this._sy == alphaTab.importer.AlphaTexSymbols.Number)
                {
                    this._currentStaff.capo = this._syData.toDouble()
                }
                else 
                {
                    this.error("capo", alphaTab.importer.AlphaTexSymbols.Number, true)
                }
                this._sy = this.newSy()
                return true
            }
            "tuning" -> 
            {
                this._sy = this.newSy()
                var strings: Double = this._currentStaff.tuning.length
                this._staffHasExplicitTuning = true
                this._staffTuningApplied = false
                when (this._sy)
                {
                    alphaTab.importer.AlphaTexSymbols.String -> 
                    {
                        var text: String = (this._syData.toString()).lowercase()
                        if (text == "piano" || text == "none" || text == "voice")
                        {
                            this._currentStaff.stringTuning.tunings = alphaTab.collections.DoubleList(
                            )
                            
                            this._currentStaff.displayTranspositionPitch = 0.0
                        }
                        else 
                        {
                            this.error("tuning", alphaTab.importer.AlphaTexSymbols.Tuning, true)
                        }
                        this._sy = this.newSy()
                    }
                    alphaTab.importer.AlphaTexSymbols.Tuning -> 
                    {
                        var tuning: alphaTab.collections.DoubleList = alphaTab.collections.DoubleList(
                        )
                        
                        do
                        {
                            var t: alphaTab.model.TuningParseResult = (this._syData as alphaTab.model.TuningParseResult)
                            tuning.push(t.realValue)
                            this._sy = this.newSy()
                        }
                        while (this._sy == alphaTab.importer.AlphaTexSymbols.Tuning)
                        this._currentStaff.stringTuning.tunings = tuning
                    }
                    else -> 
                    {
                        this.error("tuning", alphaTab.importer.AlphaTexSymbols.Tuning, true)
                    }
                }
                if (strings != this._currentStaff.tuning.length && (this._currentStaff.chords?.size ?: 0.0) > 0)
                {
                    this.errorMessage("Tuning must be defined before any chord")
                }
                return true
            }
            "instrument" -> 
            {
                this._sy = this.newSy()
                this._staffTuningApplied = false
                if (this._sy == alphaTab.importer.AlphaTexSymbols.Number)
                {
                    var instrument: Double = this._syData.toDouble()
                    if (instrument >= 0 && instrument <= 127)
                    {
                        this._currentTrack.playbackInfo.program = this._syData.toDouble()
                    }
                    else 
                    {
                        this.error("instrument", alphaTab.importer.AlphaTexSymbols.Number, false)
                    }
                }
                else if (this._sy == alphaTab.importer.AlphaTexSymbols.String)
                {
                    var instrumentName: String = (this._syData.toString()).lowercase()
                    this._currentTrack.playbackInfo.program = alphaTab.midi.GeneralMidi.getValue(instrumentName)
                }
                else 
                {
                    this.error("instrument", alphaTab.importer.AlphaTexSymbols.Number, true)
                }
                this._sy = this.newSy()
                return true
            }
            "lyrics" -> 
            {
                this._sy = this.newSy()
                var lyrics: alphaTab.model.Lyrics = alphaTab.model.Lyrics()
                lyrics.startBar = 0.0
                lyrics.text = ""
                if (this._sy == alphaTab.importer.AlphaTexSymbols.Number)
                {
                    lyrics.startBar = this._syData.toDouble()
                    this._sy = this.newSy()
                }
                if (this._sy == alphaTab.importer.AlphaTexSymbols.String)
                {
                    lyrics.text = this._syData.toString()
                    this._sy = this.newSy()
                }
                else 
                {
                    this.error("lyrics", alphaTab.importer.AlphaTexSymbols.String, true)
                }
                this._lyrics.get(this._currentTrack.index)!!.push(lyrics)
                return true
            }
            "chord" -> 
            {
                this._sy = this.newSy()
                var chord: alphaTab.model.Chord = alphaTab.model.Chord()
                this.chordProperties(chord)
                if (this._sy == alphaTab.importer.AlphaTexSymbols.String)
                {
                    chord.name = this._syData.toString()
                    this._sy = this.newSy()
                }
                else 
                {
                    this.error("chord-name", alphaTab.importer.AlphaTexSymbols.Number, true)
                }
                if(true) {
                    var i: Double = 0.0
                    
                    while(i < this._currentStaff.tuning.length){
                        try{
                            if (this._sy == alphaTab.importer.AlphaTexSymbols.Number)
                            {
                                chord.strings.push(this._syData.toDouble())
                            }
                            else if (this._sy == alphaTab.importer.AlphaTexSymbols.String && (this._syData.toString()).lowercase() == "x")
                            {
                                chord.strings.push(-1.0)
                            }
                            this._sy = this.newSy()
                        }
                        finally{
                            i++
                        }
                    }
                }
                this._currentStaff.addChord(this.getChordId(this._currentStaff, chord.name), chord)
                return true
            }
            else -> 
            {
                return false
            }
        }
    }
    
    /**
     */
    private fun chordProperties(chord: alphaTab.model.Chord): Unit{
        if (this._sy != alphaTab.importer.AlphaTexSymbols.LBrace)
        {
            return
        }
        this._sy = this.newSy()
        while (this._sy == alphaTab.importer.AlphaTexSymbols.String)
        {
            when ((this._syData.toString()).lowercase())
            {
                "firstfret" -> 
                {
                    this._sy = this.newSy()
                    when (this._sy)
                    {
                        alphaTab.importer.AlphaTexSymbols.Number -> 
                        {
                            chord.firstFret = this._syData.toDouble()
                        }
                        else -> 
                        {
                            this.error("chord-firstfret", alphaTab.importer.AlphaTexSymbols.Number, true)
                        }
                    }
                    this._sy = this.newSy()
                }
                "showdiagram" -> 
                {
                    this._sy = this.newSy()
                    when (this._sy)
                    {
                        alphaTab.importer.AlphaTexSymbols.String -> 
                        {
                            chord.showDiagram = (this._syData.toString()).lowercase() != "false"
                        }
                        alphaTab.importer.AlphaTexSymbols.Number -> 
                        {
                            chord.showDiagram = (this._syData.toDouble()) != 0.0
                        }
                        else -> 
                        {
                            this.error("chord-showdiagram", alphaTab.importer.AlphaTexSymbols.String, true)
                        }
                    }
                    this._sy = this.newSy()
                }
                "showfingering" -> 
                {
                    this._sy = this.newSy()
                    when (this._sy)
                    {
                        alphaTab.importer.AlphaTexSymbols.String -> 
                        {
                            chord.showDiagram = (this._syData.toString()).lowercase() != "false"
                        }
                        alphaTab.importer.AlphaTexSymbols.Number -> 
                        {
                            chord.showFingering = (this._syData.toDouble()) != 0.0
                        }
                        else -> 
                        {
                            this.error("chord-showfingering", alphaTab.importer.AlphaTexSymbols.String, true)
                        }
                    }
                    this._sy = this.newSy()
                }
                "showname" -> 
                {
                    this._sy = this.newSy()
                    when (this._sy)
                    {
                        alphaTab.importer.AlphaTexSymbols.String -> 
                        {
                            chord.showName = (this._syData.toString()).lowercase() != "false"
                        }
                        alphaTab.importer.AlphaTexSymbols.Number -> 
                        {
                            chord.showName = (this._syData.toDouble()) != 0.0
                        }
                        else -> 
                        {
                            this.error("chord-showname", alphaTab.importer.AlphaTexSymbols.String, true)
                        }
                    }
                    this._sy = this.newSy()
                }
                "barre" -> 
                {
                    this._sy = this.newSy()
                    while (this._sy == alphaTab.importer.AlphaTexSymbols.Number)
                    {
                        chord.barreFrets.push(this._syData.toDouble())
                        this._sy = this.newSy()
                    }
                }
                else -> 
                {
                    this.error("chord-properties", alphaTab.importer.AlphaTexSymbols.String, false)
                }
            }
        }
        if (this._sy != alphaTab.importer.AlphaTexSymbols.RBrace)
        {
            this.error("chord-properties", alphaTab.importer.AlphaTexSymbols.RBrace, true)
        }
        this._sy = this.newSy()
    }
    
    private fun bars(): Boolean{
        var anyData: Boolean = this.bar()
        while (this._sy != alphaTab.importer.AlphaTexSymbols.Eof)
        {
            if (this._sy == alphaTab.importer.AlphaTexSymbols.Pipe)
            {
                this._sy = this.newSy()
                this.bar()
            }
            else if (this._sy == alphaTab.importer.AlphaTexSymbols.MetaCommand)
            {
                this.bar()
            }
            else 
            {
                break
            }
        }
        return anyData
    }
    
    private fun trackStaffMeta(): Boolean{
        if (this._sy != alphaTab.importer.AlphaTexSymbols.MetaCommand)
        {
            return false
        }
        if ((this._syData.toString()).lowercase() == "track")
        {
            this._staffHasExplicitTuning = false
            this._staffTuningApplied = false
            this._sy = this.newSy()
            if (this._score.masterBars.length > 0)
            {
                this.newTrack()
            }
            if (this._sy == alphaTab.importer.AlphaTexSymbols.String)
            {
                this._currentTrack.name = this._syData.toString()
                this._sy = this.newSy()
            }
            if (this._sy == alphaTab.importer.AlphaTexSymbols.String)
            {
                this._currentTrack.shortName = this._syData.toString()
                this._sy = this.newSy()
            }
        }
        if (this._sy == alphaTab.importer.AlphaTexSymbols.MetaCommand && (this._syData.toString()).lowercase() == "staff")
        {
            this._staffHasExplicitTuning = false
            this._staffTuningApplied = false
            this._sy = this.newSy()
            if (this._currentTrack.staves[(0).toInt()].bars.length > 0)
            {
                this._currentTrack.ensureStaveCount(this._currentTrack.staves.length + 1.0)
                this._currentStaff = this._currentTrack.staves[(this._currentTrack.staves.length - 1.0).toInt()]
                this._currentDynamics = alphaTab.model.DynamicValue.F
            }
            this.staffProperties()
        }
        return true
    }
    
    private fun staffProperties(): Unit{
        if (this._sy != alphaTab.importer.AlphaTexSymbols.LBrace)
        {
            return
        }
        this._sy = this.newSy()
        var showStandardNotation: Boolean = false
        var showTabs: Boolean = false
        while (this._sy == alphaTab.importer.AlphaTexSymbols.String)
        {
            when ((this._syData.toString()).lowercase())
            {
                "score" -> 
                {
                    showStandardNotation = true
                    this._sy = this.newSy()
                }
                "tabs" -> 
                {
                    showTabs = true
                    this._sy = this.newSy()
                }
                else -> 
                {
                    this.error("staff-properties", alphaTab.importer.AlphaTexSymbols.String, false)
                }
            }
        }
        if (showStandardNotation || showTabs)
        {
            this._currentStaff.showStandardNotation = showStandardNotation
            this._currentStaff.showTablature = showTabs
        }
        if (this._sy != alphaTab.importer.AlphaTexSymbols.RBrace)
        {
            this.error("staff-properties", alphaTab.importer.AlphaTexSymbols.RBrace, true)
        }
        this._sy = this.newSy()
    }
    
    private fun bar(): Boolean{
        var anyStaffMeta: Boolean = this.trackStaffMeta()
        var bar: alphaTab.model.Bar = this.newBar(this._currentStaff)
        if (this._currentStaff.bars.length > this._score.masterBars.length)
        {
            var master: alphaTab.model.MasterBar = alphaTab.model.MasterBar()
            this._score.addMasterBar(master)
            if (master.index > 0)
            {
                master.keySignature = master.previousMasterBar!!.keySignature
                master.keySignatureType = master.previousMasterBar!!.keySignatureType
                master.timeSignatureDenominator = master.previousMasterBar!!.timeSignatureDenominator
                master.timeSignatureNumerator = master.previousMasterBar!!.timeSignatureNumerator
                master.tripletFeel = master.previousMasterBar!!.tripletFeel
            }
        }
        var anyBarMeta: Boolean = this.barMeta(bar)
        if (!this._staffTuningApplied && !this._staffHasExplicitTuning)
        {
            var program: Double = this._currentTrack.playbackInfo.program
            this._currentStaff.displayTranspositionPitch = 0.0
            this._currentStaff.stringTuning.tunings = alphaTab.collections.DoubleList(
            )
            
            if (program == 15.0 || (program >= 24 && program <= 31))
            {
                this._currentStaff.displayTranspositionPitch = -12.0
                this._currentStaff.stringTuning.tunings = alphaTab.model.Tuning.getDefaultTuningFor(6.0)!!.tunings
            }
            else if (program >= 32 && program <= 39)
            {
                this._currentStaff.displayTranspositionPitch = -12.0
                this._currentStaff.stringTuning.tunings = alphaTab.collections.DoubleList(
                    43.0, 38.0, 33.0, 28.0)
                
            }
            else if (program == 40.0 || program == 44.0 || program == 45.0 || program == 48.0 || program == 49.0 || program == 50.0 || program == 51.0)
            {
                this._currentStaff.stringTuning.tunings = alphaTab.collections.DoubleList(
                    52.0, 57.0, 50.0, 43.0)
                
            }
            else if (program == 41.0)
            {
                this._currentStaff.stringTuning.tunings = alphaTab.collections.DoubleList(
                    57.0, 50.0, 43.0, 36.0)
                
            }
            else if (program == 42.0)
            {
                this._currentStaff.stringTuning.tunings = alphaTab.collections.DoubleList(
                    45.0, 38.0, 31.0, 24.0)
                
            }
            else if (program == 43.0)
            {
                this._currentStaff.displayTranspositionPitch = -12.0
                this._currentStaff.stringTuning.tunings = alphaTab.collections.DoubleList(
                    43.0, 38.0, 33.0, 28.0)
                
            }
            else if (program == 105.0)
            {
                this._currentStaff.stringTuning.tunings = alphaTab.collections.DoubleList(
                    50.0, 47.0, 43.0, 38.0, 55.0)
                
            }
            else if (program == 106.0)
            {
                this._currentStaff.stringTuning.tunings = alphaTab.collections.DoubleList(
                    57.0, 52.0, 45.0)
                
            }
            else if (program == 107.0)
            {
                this._currentStaff.stringTuning.tunings = alphaTab.collections.DoubleList(
                    52.0, 45.0, 38.0, 31.0)
                
            }
            else if (program == 110.0)
            {
                this._currentStaff.stringTuning.tunings = alphaTab.collections.DoubleList(
                    64.0, 57.0, 50.0, 43.0)
                
            }
            this._staffTuningApplied = true
        }
        var anyBeatData: Boolean = false
        var voice: alphaTab.model.Voice = bar.voices[(0).toInt()]
        while (this._sy != alphaTab.importer.AlphaTexSymbols.Pipe && this._sy != alphaTab.importer.AlphaTexSymbols.Eof)
        {
            if (!this.beat(voice))
            {
                break
            }
            anyBeatData = true
        }
        if (voice.beats.length == 0.0)
        {
            var emptyBeat: alphaTab.model.Beat = alphaTab.model.Beat()
            emptyBeat.isEmpty = true
            voice.addBeat(emptyBeat)
        }
        return anyStaffMeta || anyBarMeta || anyBeatData
    }
    
    /**
     */
    private fun newBar(staff: alphaTab.model.Staff): alphaTab.model.Bar{
        var bar: alphaTab.model.Bar = alphaTab.model.Bar()
        staff.addBar(bar)
        if (bar.index > 0)
        {
            bar.clef = bar.previousBar!!.clef
        }
        var voice: alphaTab.model.Voice = alphaTab.model.Voice()
        bar.addVoice(voice)
        return bar
    }
    
    /**
     */
    private fun beat(voice: alphaTab.model.Voice): Boolean{
        this.beatDuration()
        var beat: alphaTab.model.Beat = alphaTab.model.Beat()
        voice.addBeat(beat)
        if (this._sy == alphaTab.importer.AlphaTexSymbols.LParensis)
        {
            this._sy = this.newSy()
            this.note(beat)
            while (this._sy != alphaTab.importer.AlphaTexSymbols.RParensis && this._sy != alphaTab.importer.AlphaTexSymbols.Eof)
            {
                if (!this.note(beat))
                {
                    break
                }
            }
            if (this._sy != alphaTab.importer.AlphaTexSymbols.RParensis)
            {
                this.error("note-list", alphaTab.importer.AlphaTexSymbols.RParensis, true)
            }
            this._sy = this.newSy()
        }
        else if (this._sy == alphaTab.importer.AlphaTexSymbols.String && (this._syData.toString()).lowercase() == "r")
        {
            this._sy = this.newSy()
        }
        else 
        {
            if (!this.note(beat))
            {
                voice.beats.splice(voice.beats.length - 1.0, 1.0)
                return false
            }
        }
        if (this._sy == alphaTab.importer.AlphaTexSymbols.Dot)
        {
            this._allowNegatives = true
            this._sy = this.newSy()
            this._allowNegatives = false
            if (this._sy != alphaTab.importer.AlphaTexSymbols.Number)
            {
                this.error("duration", alphaTab.importer.AlphaTexSymbols.Number, true)
            }
            this._currentDuration = this.parseDuration(this._syData.toDouble())
            this._sy = this.newSy()
        }
        beat.duration = this._currentDuration
        beat.dynamics = this._currentDynamics
        if (this._currentTuplet != 1.0 && !beat.hasTuplet)
        {
            alphaTab.importer.AlphaTexImporter.applyTuplet(beat, this._currentTuplet)
        }
        var beatRepeat: Double = 1.0
        if (this._sy == alphaTab.importer.AlphaTexSymbols.Multiply)
        {
            this._sy = this.newSy()
            if (this._sy != alphaTab.importer.AlphaTexSymbols.Number)
            {
                this.error("multiplier", alphaTab.importer.AlphaTexSymbols.Number, true)
            }
            else 
            {
                beatRepeat = this._syData.toDouble()
            }
            this._sy = this.newSy()
        }
        this.beatEffects(beat)
        if(true) {
            var i: Double = 0.0
            
            while(i < beatRepeat - 1.0){
                try{
                    voice.addBeat(alphaTab.generated.model.BeatCloner.clone(beat))
                }
                finally{
                    i++
                }
            }
        }
        return true
    }
    
    private fun beatDuration(): Unit{
        if (this._sy != alphaTab.importer.AlphaTexSymbols.DoubleDot)
        {
            return
        }
        this._allowNegatives = true
        this._sy = this.newSy()
        this._allowNegatives = false
        if (this._sy != alphaTab.importer.AlphaTexSymbols.Number)
        {
            this.error("duration", alphaTab.importer.AlphaTexSymbols.Number, true)
        }
        this._currentDuration = this.parseDuration(this._syData.toDouble())
        this._currentTuplet = 1.0
        this._sy = this.newSy()
        if (this._sy != alphaTab.importer.AlphaTexSymbols.LBrace)
        {
            return
        }
        this._sy = this.newSy()
        while (this._sy == alphaTab.importer.AlphaTexSymbols.String)
        {
            var effect: String = (this._syData.toString()).lowercase()
            when (effect)
            {
                "tu" -> 
                {
                    this._sy = this.newSy()
                    if (this._sy != alphaTab.importer.AlphaTexSymbols.Number)
                    {
                        this.error("duration-tuplet", alphaTab.importer.AlphaTexSymbols.Number, true)
                    }
                    this._currentTuplet = this._syData.toDouble()
                    this._sy = this.newSy()
                }
                else -> 
                {
                    this.error("beat-duration", alphaTab.importer.AlphaTexSymbols.String, false)
                }
            }
        }
        if (this._sy != alphaTab.importer.AlphaTexSymbols.RBrace)
        {
            this.error("beat-duration", alphaTab.importer.AlphaTexSymbols.RBrace, true)
        }
        this._sy = this.newSy()
    }
    
    /**
     */
    private fun beatEffects(beat: alphaTab.model.Beat): Unit{
        if (this._sy != alphaTab.importer.AlphaTexSymbols.LBrace)
        {
            return
        }
        this._sy = this.newSy()
        while (this._sy == alphaTab.importer.AlphaTexSymbols.String)
        {
            if (!this.applyBeatEffect(beat))
            {
                this.error("beat-effects", alphaTab.importer.AlphaTexSymbols.String, false)
            }
        }
        if (this._sy != alphaTab.importer.AlphaTexSymbols.RBrace)
        {
            this.error("beat-effects", alphaTab.importer.AlphaTexSymbols.RBrace, true)
        }
        this._sy = this.newSy()
    }
    
    /**
     * Tries to apply a beat effect to the given beat.
     */
    private fun applyBeatEffect(beat: alphaTab.model.Beat): Boolean{
        var syData: String = (this._syData.toString()).lowercase()
        if (syData == "f")
        {
            beat.fadeIn = true
        }
        else if (syData == "v")
        {
            beat.vibrato = alphaTab.model.VibratoType.Slight
        }
        else if (syData == "s")
        {
            beat.slap = true
        }
        else if (syData == "p")
        {
            beat.pop = true
        }
        else if (syData == "tt")
        {
            beat.tap = true
        }
        else if (syData == "dd")
        {
            beat.dots = 2.0
        }
        else if (syData == "d")
        {
            beat.dots = 1.0
        }
        else if (syData == "su")
        {
            beat.pickStroke = alphaTab.model.PickStroke.Up
        }
        else if (syData == "sd")
        {
            beat.pickStroke = alphaTab.model.PickStroke.Down
        }
        else if (syData == "tu")
        {
            this._sy = this.newSy()
            if (this._sy != alphaTab.importer.AlphaTexSymbols.Number)
            {
                this.error("tuplet", alphaTab.importer.AlphaTexSymbols.Number, true)
                return false
            }
            alphaTab.importer.AlphaTexImporter.applyTuplet(beat, this._syData.toDouble())
        }
        else if (syData == "tb" || syData == "tbe")
        {
            var exact: Boolean = syData == "tbe"
            this._sy = this.newSy()
            if (this._sy != alphaTab.importer.AlphaTexSymbols.LParensis)
            {
                this.error("tremolobar-effect", alphaTab.importer.AlphaTexSymbols.LParensis, true)
            }
            this._allowNegatives = true
            this._sy = this.newSy()
            while (this._sy != alphaTab.importer.AlphaTexSymbols.RParensis && this._sy != alphaTab.importer.AlphaTexSymbols.Eof)
            {
                var offset: Double = 0.0
                var value: Double = 0.0
                if (exact)
                {
                    if (this._sy != alphaTab.importer.AlphaTexSymbols.Number)
                    {
                        this.error("tremolobar-effect", alphaTab.importer.AlphaTexSymbols.Number, true)
                    }
                    offset = this._syData.toDouble()
                    this._sy = this.newSy()
                    if (this._sy != alphaTab.importer.AlphaTexSymbols.Number)
                    {
                        this.error("tremolobar-effect", alphaTab.importer.AlphaTexSymbols.Number, true)
                    }
                    value = this._syData.toDouble()
                }
                else 
                {
                    if (this._sy != alphaTab.importer.AlphaTexSymbols.Number)
                    {
                        this.error("tremolobar-effect", alphaTab.importer.AlphaTexSymbols.Number, true)
                    }
                    offset = 0.0
                    value = this._syData.toDouble()
                }
                beat.addWhammyBarPoint(alphaTab.model.BendPoint(offset, value))
                this._sy = this.newSy()
            }
            if (beat.whammyBarPoints != null)
            {
                while (beat.whammyBarPoints!!.length > 60)
                {
                    beat.removeWhammyBarPoint(beat.whammyBarPoints!!.length - 1.0)
                }
                if (!exact)
                {
                    var count: Double = beat.whammyBarPoints!!.length
                    var step: Double = ((((60.0).toDouble() / count)).toInt() or 0).toDouble()
                    var i: Double = 0.0
                    while (i < count)
                    {
                        beat.whammyBarPoints!![(i).toInt()].offset = alphaTab.core.ecmaScript.Math.min(60.0, i * step)
                        i++
                    }
                }
                else 
                {
                    beat.whammyBarPoints!!.sort(fun(a: alphaTab.model.BendPoint, b: alphaTab.model.BendPoint): Double{
                        return a.offset - b.offset
                    }
                    )
                }
            }
            this._allowNegatives = false
            if (this._sy != alphaTab.importer.AlphaTexSymbols.RParensis)
            {
                this.error("tremolobar-effect", alphaTab.importer.AlphaTexSymbols.RParensis, true)
            }
        }
        else if (syData == "bu" || syData == "bd" || syData == "au" || syData == "ad")
        {
            when (syData)
            {
                "bu" -> 
                {
                    beat.brushType = alphaTab.model.BrushType.BrushUp
                }
                "bd" -> 
                {
                    beat.brushType = alphaTab.model.BrushType.BrushDown
                }
                "au" -> 
                {
                    beat.brushType = alphaTab.model.BrushType.ArpeggioUp
                }
                "ad" -> 
                {
                    beat.brushType = alphaTab.model.BrushType.ArpeggioDown
                }
                else -> { }
            }
            this._sy = this.newSy()
            if (this._sy == alphaTab.importer.AlphaTexSymbols.Number)
            {
                beat.brushDuration = this._syData.toDouble()
                this._sy = this.newSy()
                return true
            }
            beat.updateDurations()
            if (syData == "bu" || syData == "bd")
            {
                beat.brushDuration = beat.playbackDuration / (4.0).toDouble() / beat.notes.length
            }
            else if (syData == "au" || (syData.toString()) == "ad")
            {
                beat.brushDuration = beat.playbackDuration / beat.notes.length
            }
            return true
        }
        else if (syData == "ch")
        {
            this._sy = this.newSy()
            var chordName: String = this._syData.toString()
            var chordId: String = this.getChordId(this._currentStaff, chordName)
            if (!this._currentStaff.hasChord(chordId))
            {
                var chord: alphaTab.model.Chord = alphaTab.model.Chord()
                chord.showDiagram = false
                chord.name = chordName
                this._currentStaff.addChord(chordId, chord)
            }
            beat.chordId = chordId
        }
        else if (syData == "gr")
        {
            this._sy = this.newSy()
            if ((this._syData.toString()).lowercase() == "ob")
            {
                beat.graceType = alphaTab.model.GraceType.OnBeat
                this._sy = this.newSy()
            }
            else if ((this._syData.toString()).lowercase() == "b")
            {
                beat.graceType = alphaTab.model.GraceType.BendGrace
                this._sy = this.newSy()
            }
            else 
            {
                beat.graceType = alphaTab.model.GraceType.BeforeBeat
            }
            return true
        }
        else if (syData == "dy")
        {
            this._sy = this.newSy()
            when ((this._syData.toString()).lowercase())
            {
                "ppp" -> 
                {
                    beat.dynamics = alphaTab.model.DynamicValue.PPP
                }
                "pp" -> 
                {
                    beat.dynamics = alphaTab.model.DynamicValue.PP
                }
                "p" -> 
                {
                    beat.dynamics = alphaTab.model.DynamicValue.P
                }
                "mp" -> 
                {
                    beat.dynamics = alphaTab.model.DynamicValue.MP
                }
                "mf" -> 
                {
                    beat.dynamics = alphaTab.model.DynamicValue.MF
                }
                "f" -> 
                {
                    beat.dynamics = alphaTab.model.DynamicValue.F
                }
                "ff" -> 
                {
                    beat.dynamics = alphaTab.model.DynamicValue.FF
                }
                "fff" -> 
                {
                    beat.dynamics = alphaTab.model.DynamicValue.FFF
                }
                else -> { }
            }
            this._currentDynamics = beat.dynamics
        }
        else if (syData == "cre")
        {
            beat.crescendo = alphaTab.model.CrescendoType.Crescendo
        }
        else if (syData == "dec")
        {
            beat.crescendo = alphaTab.model.CrescendoType.Decrescendo
        }
        else if (syData == "tp")
        {
            this._sy = this.newSy()
            beat.tremoloSpeed = alphaTab.model.Duration.Eighth
            if (this._sy == alphaTab.importer.AlphaTexSymbols.Number)
            {
                when (this._syData.toDouble())
                {
                    8.0 -> 
                    {
                        beat.tremoloSpeed = alphaTab.model.Duration.Eighth
                    }
                    16.0 -> 
                    {
                        beat.tremoloSpeed = alphaTab.model.Duration.Sixteenth
                    }
                    32.0 -> 
                    {
                        beat.tremoloSpeed = alphaTab.model.Duration.ThirtySecond
                    }
                    else -> 
                    {
                        beat.tremoloSpeed = alphaTab.model.Duration.Eighth
                    }
                }
                this._sy = this.newSy()
            }
            return true
        }
        else 
        {
            return false
        }
        this._sy = this.newSy()
        return true
    }
    
    /**
     */
    private fun getChordId(currentStaff: alphaTab.model.Staff, chordName: String): String{
        return chordName.lowercase() + (currentStaff.index).toInvariantString() + (currentStaff.track.index).toInvariantString()
    }
    
    /**
     */
    private fun isNoteText(txt: String): Boolean{
        return txt == "x" || txt == "-" || txt == "r"
    }
    
    /**
     */
    private fun note(beat: alphaTab.model.Beat): Boolean{
        var isDead: Boolean = false
        var isTie: Boolean = false
        var fret: Double = -1.0
        var octave: Double = -1.0
        var tone: Double = -1.0
        when (this._sy)
        {
            alphaTab.importer.AlphaTexSymbols.Number -> 
            {
                fret = this._syData.toDouble()
            }
            alphaTab.importer.AlphaTexSymbols.String -> 
            {
                isDead = (this._syData.toString()) == "x"
                isTie = (this._syData.toString()) == "-"
                if (isTie || isDead)
                {
                    fret = 0.0
                }
                else 
                {
                    this.error("note-fret", alphaTab.importer.AlphaTexSymbols.Number, true)
                }
            }
            alphaTab.importer.AlphaTexSymbols.Tuning -> 
            {
                var tuning: alphaTab.model.TuningParseResult = (this._syData as alphaTab.model.TuningParseResult)
                octave = tuning.octave
                tone = tuning.noteValue
            }
            else -> 
            {
                return false
            }
        }
        this._sy = this.newSy()
        var isFretted: Boolean = octave == -1.0 && this._currentStaff.tuning.length > 0
        var noteString: Double = -1.0
        if (isFretted)
        {
            if (this._sy != alphaTab.importer.AlphaTexSymbols.Dot)
            {
                this.error("note", alphaTab.importer.AlphaTexSymbols.Dot, true)
            }
            this._sy = this.newSy()
            if (this._sy != alphaTab.importer.AlphaTexSymbols.Number)
            {
                this.error("note-string", alphaTab.importer.AlphaTexSymbols.Number, true)
            }
            noteString = this._syData.toDouble()
            if (noteString < 1 || noteString > this._currentStaff.tuning.length)
            {
                this.error("note-string", alphaTab.importer.AlphaTexSymbols.Number, false)
            }
            this._sy = this.newSy()
        }
        var note: alphaTab.model.Note = alphaTab.model.Note()
        if (isFretted)
        {
            note.string = this._currentStaff.tuning.length - (noteString - 1.0)
            note.isDead = isDead
            note.isTieDestination = isTie
            if (!isTie)
            {
                note.fret = fret
            }
        }
        else 
        {
            note.octave = octave
            note.tone = tone
            note.isTieDestination = isTie
        }
        beat.addNote(note)
        this.noteEffects(note)
        return true
    }
    
    /**
     */
    private fun noteEffects(note: alphaTab.model.Note): Unit{
        if (this._sy != alphaTab.importer.AlphaTexSymbols.LBrace)
        {
            return
        }
        this._sy = this.newSy()
        while (this._sy == alphaTab.importer.AlphaTexSymbols.String)
        {
            var syData: String = (this._syData.toString()).lowercase()
            if (syData == "b" || syData == "be")
            {
                var exact: Boolean = syData == "be"
                this._sy = this.newSy()
                if (this._sy != alphaTab.importer.AlphaTexSymbols.LParensis)
                {
                    this.error("bend-effect", alphaTab.importer.AlphaTexSymbols.LParensis, true)
                }
                this._sy = this.newSy()
                while (this._sy != alphaTab.importer.AlphaTexSymbols.RParensis && this._sy != alphaTab.importer.AlphaTexSymbols.Eof)
                {
                    var offset: Double = 0.0
                    var value: Double = 0.0
                    if (exact)
                    {
                        if (this._sy != alphaTab.importer.AlphaTexSymbols.Number)
                        {
                            this.error("bend-effect-value", alphaTab.importer.AlphaTexSymbols.Number, true)
                        }
                        offset = this._syData.toDouble()
                        this._sy = this.newSy()
                        if (this._sy != alphaTab.importer.AlphaTexSymbols.Number)
                        {
                            this.error("bend-effect-value", alphaTab.importer.AlphaTexSymbols.Number, true)
                        }
                        value = this._syData.toDouble()
                    }
                    else 
                    {
                        if (this._sy != alphaTab.importer.AlphaTexSymbols.Number)
                        {
                            this.error("bend-effect-value", alphaTab.importer.AlphaTexSymbols.Number, true)
                        }
                        value = this._syData.toDouble()
                    }
                    note.addBendPoint(alphaTab.model.BendPoint(offset, value))
                    this._sy = this.newSy()
                }
                var points: alphaTab.collections.List<alphaTab.model.BendPoint>? = note.bendPoints
                if (points != null)
                {
                    while (points.length > 60)
                    {
                        points.splice(points.length - 1.0, 1.0)
                    }
                    if (exact)
                    {
                        points.sort(fun(a: alphaTab.model.BendPoint, b: alphaTab.model.BendPoint): Double{
                            return a.offset - b.offset
                        }
                        )
                    }
                    else 
                    {
                        var count: Double = points.length
                        var step: Double = ((((60.0).toDouble() / (count - 1.0))).toInt() or 0).toDouble()
                        var i: Double = 0.0
                        while (i < count)
                        {
                            points[(i).toInt()].offset = alphaTab.core.ecmaScript.Math.min(60.0, i * step)
                            i++
                        }
                    }
                }
                if (this._sy != alphaTab.importer.AlphaTexSymbols.RParensis)
                {
                    this.error("bend-effect", alphaTab.importer.AlphaTexSymbols.RParensis, true)
                }
                this._sy = this.newSy()
            }
            else if (syData == "nh")
            {
                note.harmonicType = alphaTab.model.HarmonicType.Natural
                this._sy = this.newSy()
            }
            else if (syData == "ah")
            {
                note.harmonicType = alphaTab.model.HarmonicType.Artificial
                this._sy = this.newSy()
            }
            else if (syData == "th")
            {
                note.harmonicType = alphaTab.model.HarmonicType.Tap
                this._sy = this.newSy()
            }
            else if (syData == "ph")
            {
                note.harmonicType = alphaTab.model.HarmonicType.Pinch
                this._sy = this.newSy()
            }
            else if (syData == "sh")
            {
                note.harmonicType = alphaTab.model.HarmonicType.Semi
                this._sy = this.newSy()
            }
            else if (syData == "tr")
            {
                this._sy = this.newSy()
                if (this._sy != alphaTab.importer.AlphaTexSymbols.Number)
                {
                    this.error("trill-effect", alphaTab.importer.AlphaTexSymbols.Number, true)
                }
                var fret: Double = this._syData.toDouble()
                this._sy = this.newSy()
                var duration: alphaTab.model.Duration = alphaTab.model.Duration.Sixteenth
                if (this._sy == alphaTab.importer.AlphaTexSymbols.Number)
                {
                    when (this._syData.toDouble())
                    {
                        16.0 -> 
                        {
                            duration = alphaTab.model.Duration.Sixteenth
                        }
                        32.0 -> 
                        {
                            duration = alphaTab.model.Duration.ThirtySecond
                        }
                        64.0 -> 
                        {
                            duration = alphaTab.model.Duration.SixtyFourth
                        }
                        else -> 
                        {
                            duration = alphaTab.model.Duration.Sixteenth
                        }
                    }
                    this._sy = this.newSy()
                }
                note.trillValue = fret + note.stringTuning
                note.trillSpeed = duration
            }
            else if (syData == "v")
            {
                this._sy = this.newSy()
                note.vibrato = alphaTab.model.VibratoType.Slight
            }
            else if (syData == "sl")
            {
                this._sy = this.newSy()
                note.slideOutType = alphaTab.model.SlideOutType.Legato
            }
            else if (syData == "ss")
            {
                this._sy = this.newSy()
                note.slideOutType = alphaTab.model.SlideOutType.Shift
            }
            else if (syData == "sib")
            {
                this._sy = this.newSy()
                note.slideInType = alphaTab.model.SlideInType.IntoFromBelow
            }
            else if (syData == "sia")
            {
                this._sy = this.newSy()
                note.slideInType = alphaTab.model.SlideInType.IntoFromAbove
            }
            else if (syData == "sou")
            {
                this._sy = this.newSy()
                note.slideOutType = alphaTab.model.SlideOutType.OutUp
            }
            else if (syData == "sod")
            {
                this._sy = this.newSy()
                note.slideOutType = alphaTab.model.SlideOutType.OutDown
            }
            else if (syData == "psd")
            {
                this._sy = this.newSy()
                note.slideOutType = alphaTab.model.SlideOutType.PickSlideDown
            }
            else if (syData == "psu")
            {
                this._sy = this.newSy()
                note.slideOutType = alphaTab.model.SlideOutType.PickSlideUp
            }
            else if (syData == "h")
            {
                this._sy = this.newSy()
                note.isHammerPullOrigin = true
            }
            else if (syData == "lht")
            {
                this._sy = this.newSy()
                note.isLeftHandTapped = true
            }
            else if (syData == "g")
            {
                this._sy = this.newSy()
                note.isGhost = true
            }
            else if (syData == "ac")
            {
                this._sy = this.newSy()
                note.accentuated = alphaTab.model.AccentuationType.Normal
            }
            else if (syData == "hac")
            {
                this._sy = this.newSy()
                note.accentuated = alphaTab.model.AccentuationType.Heavy
            }
            else if (syData == "pm")
            {
                this._sy = this.newSy()
                note.isPalmMute = true
            }
            else if (syData == "st")
            {
                this._sy = this.newSy()
                note.isStaccato = true
            }
            else if (syData == "lr")
            {
                this._sy = this.newSy()
                note.isLetRing = true
            }
            else if (syData == "x")
            {
                this._sy = this.newSy()
                note.fret = 0.0
                note.isDead = true
            }
            else if (syData == "-" || syData == "t")
            {
                this._sy = this.newSy()
                note.isTieDestination = true
            }
            else if (syData == "lf")
            {
                this._sy = this.newSy()
                var finger: alphaTab.model.Fingers = alphaTab.model.Fingers.Thumb
                if (this._sy == alphaTab.importer.AlphaTexSymbols.Number)
                {
                    finger = this.toFinger(this._syData.toDouble())
                    this._sy = this.newSy()
                }
                note.leftHandFinger = finger
            }
            else if (syData == "rf")
            {
                this._sy = this.newSy()
                var finger: alphaTab.model.Fingers = alphaTab.model.Fingers.Thumb
                if (this._sy == alphaTab.importer.AlphaTexSymbols.Number)
                {
                    finger = this.toFinger(this._syData.toDouble())
                    this._sy = this.newSy()
                }
                note.rightHandFinger = finger
            }
            else if (this.applyBeatEffect(note.beat))
            {
            }
            else 
            {
                this.error(syData, alphaTab.importer.AlphaTexSymbols.String, false)
            }
        }
        if (this._sy != alphaTab.importer.AlphaTexSymbols.RBrace)
        {
            this.error("note-effect", alphaTab.importer.AlphaTexSymbols.RBrace, false)
        }
        this._sy = this.newSy()
    }
    
    /**
     */
    private fun toFinger(num: Double): alphaTab.model.Fingers{
        when (num)
        {
            1.0 -> 
            {
                return alphaTab.model.Fingers.Thumb
            }
            2.0 -> 
            {
                return alphaTab.model.Fingers.IndexFinger
            }
            3.0 -> 
            {
                return alphaTab.model.Fingers.MiddleFinger
            }
            4.0 -> 
            {
                return alphaTab.model.Fingers.AnnularFinger
            }
            5.0 -> 
            {
                return alphaTab.model.Fingers.LittleFinger
            }
            else -> { }
        }
        return alphaTab.model.Fingers.Thumb
    }
    
    /**
     */
    private fun parseDuration(duration: Double): alphaTab.model.Duration{
        when (duration)
        {
            -4.0 -> 
            {
                return alphaTab.model.Duration.QuadrupleWhole
            }
            -2.0 -> 
            {
                return alphaTab.model.Duration.DoubleWhole
            }
            1.0 -> 
            {
                return alphaTab.model.Duration.Whole
            }
            2.0 -> 
            {
                return alphaTab.model.Duration.Half
            }
            4.0 -> 
            {
                return alphaTab.model.Duration.Quarter
            }
            8.0 -> 
            {
                return alphaTab.model.Duration.Eighth
            }
            16.0 -> 
            {
                return alphaTab.model.Duration.Sixteenth
            }
            32.0 -> 
            {
                return alphaTab.model.Duration.ThirtySecond
            }
            64.0 -> 
            {
                return alphaTab.model.Duration.SixtyFourth
            }
            128.0 -> 
            {
                return alphaTab.model.Duration.OneHundredTwentyEighth
            }
            256.0 -> 
            {
                return alphaTab.model.Duration.TwoHundredFiftySixth
            }
            else -> 
            {
                return alphaTab.model.Duration.Quarter
            }
        }
    }
    
    /**
     */
    private fun barMeta(bar: alphaTab.model.Bar): Boolean{
        var anyMeta: Boolean = false
        var master: alphaTab.model.MasterBar = bar.masterBar
        while (this._sy == alphaTab.importer.AlphaTexSymbols.MetaCommand)
        {
            anyMeta = true
            var syData: String = (this._syData.toString()).lowercase()
            if (syData == "ts")
            {
                this._sy = this.newSy()
                if (this._sy != alphaTab.importer.AlphaTexSymbols.Number)
                {
                    this.error("timesignature-numerator", alphaTab.importer.AlphaTexSymbols.Number, true)
                }
                master.timeSignatureNumerator = this._syData.toDouble()
                this._sy = this.newSy()
                if (this._sy != alphaTab.importer.AlphaTexSymbols.Number)
                {
                    this.error("timesignature-denominator", alphaTab.importer.AlphaTexSymbols.Number, true)
                }
                master.timeSignatureDenominator = this._syData.toDouble()
                this._sy = this.newSy()
            }
            else if (syData == "ro")
            {
                master.isRepeatStart = true
                this._sy = this.newSy()
            }
            else if (syData == "rc")
            {
                this._sy = this.newSy()
                if (this._sy != alphaTab.importer.AlphaTexSymbols.Number)
                {
                    this.error("repeatclose", alphaTab.importer.AlphaTexSymbols.Number, true)
                }
                if ((this._syData.toDouble()) > 2048)
                {
                    this.error("repeatclose", alphaTab.importer.AlphaTexSymbols.Number, false)
                }
                master.repeatCount = this._syData.toDouble()
                this._sy = this.newSy()
            }
            else if (syData == "ae")
            {
                this._sy = this.newSy()
                if (this._sy == alphaTab.importer.AlphaTexSymbols.LParensis)
                {
                    this._sy = this.newSy()
                    if (this._sy != alphaTab.importer.AlphaTexSymbols.Number)
                    {
                        this.error("alternateending", alphaTab.importer.AlphaTexSymbols.Number, true)
                    }
                    this.applyAlternateEnding(master)
                    while (this._sy == alphaTab.importer.AlphaTexSymbols.Number)
                    {
                        this.applyAlternateEnding(master)
                    }
                    if (this._sy != alphaTab.importer.AlphaTexSymbols.RParensis)
                    {
                        this.error("alternateending-list", alphaTab.importer.AlphaTexSymbols.RParensis, true)
                    }
                    this._sy = this.newSy()
                }
                else 
                {
                    if (this._sy != alphaTab.importer.AlphaTexSymbols.Number)
                    {
                        this.error("alternateending", alphaTab.importer.AlphaTexSymbols.Number, true)
                    }
                    this.applyAlternateEnding(master)
                }
            }
            else if (syData == "ks")
            {
                this._sy = this.newSy()
                if (this._sy != alphaTab.importer.AlphaTexSymbols.String)
                {
                    this.error("keysignature", alphaTab.importer.AlphaTexSymbols.String, true)
                }
                master.keySignature = this.parseKeySignature(this._syData.toString())
                this._sy = this.newSy()
            }
            else if (syData == "clef")
            {
                this._sy = this.newSy()
                when (this._sy)
                {
                    alphaTab.importer.AlphaTexSymbols.String -> 
                    {
                        bar.clef = this.parseClefFromString(this._syData.toString())
                    }
                    alphaTab.importer.AlphaTexSymbols.Number -> 
                    {
                        bar.clef = this.parseClefFromInt(this._syData.toDouble())
                    }
                    alphaTab.importer.AlphaTexSymbols.Tuning -> 
                    {
                        var parseResult: alphaTab.model.TuningParseResult = (this._syData as alphaTab.model.TuningParseResult)
                        bar.clef = this.parseClefFromInt(parseResult.realValue)
                    }
                    else -> 
                    {
                        this.error("clef", alphaTab.importer.AlphaTexSymbols.String, true)
                    }
                }
                this._sy = this.newSy()
            }
            else if (syData == "tempo")
            {
                this._allowFloat = true
                this._sy = this.newSy()
                this._allowFloat = false
                if (this._sy != alphaTab.importer.AlphaTexSymbols.Number)
                {
                    this.error("tempo", alphaTab.importer.AlphaTexSymbols.Number, true)
                }
                var tempoAutomation: alphaTab.model.Automation = alphaTab.model.Automation()
                tempoAutomation.isLinear = false
                tempoAutomation.type = alphaTab.model.AutomationType.Tempo
                tempoAutomation.value = this._syData.toDouble()
                master.tempoAutomation = tempoAutomation
                this._sy = this.newSy()
            }
            else if (syData == "section")
            {
                this._sy = this.newSy()
                if (this._sy != alphaTab.importer.AlphaTexSymbols.String)
                {
                    this.error("section", alphaTab.importer.AlphaTexSymbols.String, true)
                }
                var text: String = this._syData.toString()
                this._sy = this.newSy()
                var marker: String = ""
                if (this._sy == alphaTab.importer.AlphaTexSymbols.String && !this.isNoteText((this._syData.toString()).lowercase()))
                {
                    marker = text
                    text = this._syData.toString()
                    this._sy = this.newSy()
                }
                var section: alphaTab.model.Section = alphaTab.model.Section()
                section.marker = marker
                section.text = text
                master.section = section
            }
            else if (syData == "tf")
            {
                this._allowTuning = false
                this._sy = this.newSy()
                this._allowTuning = true
                when (this._sy)
                {
                    alphaTab.importer.AlphaTexSymbols.String -> 
                    {
                        master.tripletFeel = this.parseTripletFeelFromString(this._syData.toString())
                    }
                    alphaTab.importer.AlphaTexSymbols.Number -> 
                    {
                        master.tripletFeel = this.parseTripletFeelFromInt(this._syData.toDouble())
                    }
                    else -> 
                    {
                        this.error("triplet-feel", alphaTab.importer.AlphaTexSymbols.String, true)
                    }
                }
                this._sy = this.newSy()
            }
            else if (syData == "ac")
            {
                master.isAnacrusis = true
                this._sy = this.newSy()
            }
            else 
            {
                if (bar.index == 0.0)
                {
                    if (!this.handleStaffMeta())
                    {
                        this.error("measure-effects", alphaTab.importer.AlphaTexSymbols.String, false)
                    }
                }
                else 
                {
                    this.error("measure-effects", alphaTab.importer.AlphaTexSymbols.String, false)
                }
            }
        }
        if (master.index == 0.0 && !alphaTab.core.TypeHelper.isTruthy(master.tempoAutomation))
        {
            var tempoAutomation: alphaTab.model.Automation = alphaTab.model.Automation()
            tempoAutomation.isLinear = false
            tempoAutomation.type = alphaTab.model.AutomationType.Tempo
            tempoAutomation.value = this._score.tempo
            master.tempoAutomation = tempoAutomation
        }
        return anyMeta
    }
    
    /**
     */
    private fun applyAlternateEnding(master: alphaTab.model.MasterBar): Unit{
        var num: Double = this._syData.toDouble()
        if (num < 1)
        {
            this.error("alternateending", alphaTab.importer.AlphaTexSymbols.Number, true)
        }
        master.alternateEndings = ((master.alternateEndings.toInt()) or (1 shl ((num - 1.0)).toInt())).toDouble()
        this._sy = this.newSy()
    }
    
    companion object{
        @kotlin.jvm.JvmStatic
        private val Eof: Double = 0.0
        
        /**
         * Checks if the given character is a valid letter for a name.
         * (no control characters, whitespaces, numbers or dots)
         */
        @kotlin.jvm.JvmStatic
        private fun isNameLetter(ch: Double): Boolean{
            return (!alphaTab.importer.AlphaTexImporter.isTerminal(ch) && ((33 <= ch && ch <= 47) || (58 <= ch && ch <= 126) || 128 <= ch))
        }
        
        /**
         */
        @kotlin.jvm.JvmStatic
        private fun isTerminal(ch: Double): Boolean{
            return (ch == 46.0 || ch == 123.0 || ch == 125.0 || ch == 91.0 || ch == 93.0 || ch == 40.0 || ch == 41.0 || ch == 124.0 || ch == 39.0 || ch == 34.0 || ch == 92.0)
        }
        
        /**
         */
        @kotlin.jvm.JvmStatic
        private fun isWhiteSpace(ch: Double): Boolean{
            return (ch == 9.0 || ch == 10.0 || ch == 11.0 || ch == 13.0 || ch == 32.0)
        }
        
        /**
         */
        @kotlin.jvm.JvmStatic
        private fun applyTuplet(beat: alphaTab.model.Beat, tuplet: Double): Unit{
            when (tuplet)
            {
                3.0 -> 
                {
                    beat.tupletNumerator = 3.0
                    beat.tupletDenominator = 2.0
                }
                5.0 -> 
                {
                    beat.tupletNumerator = 5.0
                    beat.tupletDenominator = 4.0
                }
                6.0 -> 
                {
                    beat.tupletNumerator = 6.0
                    beat.tupletDenominator = 4.0
                }
                7.0 -> 
                {
                    beat.tupletNumerator = 7.0
                    beat.tupletDenominator = 4.0
                }
                9.0 -> 
                {
                    beat.tupletNumerator = 9.0
                    beat.tupletDenominator = 8.0
                }
                10.0 -> 
                {
                    beat.tupletNumerator = 10.0
                    beat.tupletDenominator = 8.0
                }
                11.0 -> 
                {
                    beat.tupletNumerator = 11.0
                    beat.tupletDenominator = 8.0
                }
                12.0 -> 
                {
                    beat.tupletNumerator = 12.0
                    beat.tupletDenominator = 8.0
                }
                else -> 
                {
                    beat.tupletNumerator = 1.0
                    beat.tupletDenominator = 1.0
                }
            }
        }
        
    }
}

/**
 * A list of terminals recognized by the alphaTex-parser
 */
internal enum class AlphaTexSymbols(override val value: Int): alphaTab.core.IAlphaTabEnum
{
    No(0),
    Eof(1),
    Number(2),
    DoubleDot(3),
    Dot(4),
    String(5),
    Tuning(6),
    LParensis(7),
    RParensis(8),
    LBrace(9),
    RBrace(10),
    Pipe(11),
    MetaCommand(12),
    Multiply(13),
    LowerThan(14);
    companion object{
        public fun fromValue(v:Double): AlphaTexSymbols{
            return when(v.toInt()){
                No.value -> No
                Eof.value -> Eof
                Number.value -> Number
                DoubleDot.value -> DoubleDot
                Dot.value -> Dot
                String.value -> String
                Tuning.value -> Tuning
                LParensis.value -> LParensis
                RParensis.value -> RParensis
                LBrace.value -> LBrace
                RBrace.value -> RBrace
                Pipe.value -> Pipe
                MetaCommand.value -> MetaCommand
                Multiply.value -> Multiply
                LowerThan.value -> LowerThan
                else -> throw ClassCastException("No enum with value $v found")}
        }
    }
}

@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class AlphaTexError: alphaTab.AlphaTabError
{
    public var position: Double
    public var line: Double
    public var col: Double
    public var nonTerm: String
    public var expected: alphaTab.importer.AlphaTexSymbols
    public var symbol: alphaTab.importer.AlphaTexSymbols
    public var symbolData: Any?
    public constructor(message: String?, position: Double, line: Double, col: Double, nonTerm: String?, expected: alphaTab.importer.AlphaTexSymbols?, symbol: alphaTab.importer.AlphaTexSymbols?, symbolData: Any? = null)
        : super(alphaTab.AlphaTabErrorType.AlphaTex, message){
        this.position = position
        this.line = line
        this.col = col
        this.nonTerm = nonTerm ?: ""
        this.expected = expected ?: alphaTab.importer.AlphaTexSymbols.No
        this.symbol = symbol ?: alphaTab.importer.AlphaTexSymbols.No
        this.symbolData = symbolData
    }
    
    companion object{
        /**
         */
        @kotlin.jvm.JvmStatic
        public fun symbolError(position: Double, line: Double, col: Double, nonTerm: String, expected: alphaTab.importer.AlphaTexSymbols, symbol: alphaTab.importer.AlphaTexSymbols, symbolData: Any? = null): alphaTab.importer.AlphaTexError{
            var message: String = """MalFormed AlphaTex: @${(position).toTemplate()} (line ${(line).toTemplate()}, col ${(col).toTemplate()}): Error on block ${(nonTerm).toTemplate()}"""
            if (expected != symbol)
            {
                message += """, expected a ${(expected.toString()).toTemplate()} found a ${(symbol.toString()).toTemplate()}"""
                if (symbolData != null)
                {
                    message += """: '${(symbolData).toTemplate()}'"""
                }
            }
            else 
            {
                message += """, invalid value: '${(symbolData).toTemplate()}'"""
            }
            return alphaTab.importer.AlphaTexError(message, position, line, col, nonTerm, expected, symbol, symbolData)
        }
        
        /**
         */
        @kotlin.jvm.JvmStatic
        public fun errorMessage(message: String, position: Double, line: Double, col: Double): alphaTab.importer.AlphaTexError{
            var parammessage = message
            parammessage = """MalFormed AlphaTex: @${(position).toTemplate()} (line ${(line).toTemplate()}, col ${(col).toTemplate()}): ${(parammessage).toTemplate()}"""
            return alphaTab.importer.AlphaTexError(parammessage, position, line, col, null, null, null, null)
        }
        
    }
}

