// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.importer
import alphaTab.core.*

/**
 * A BinaryStylesheet from Guitar Pro 6 and 7 files.
 * The BinaryStylesheet is a simple binary key-value store for additional settings
 * related to the display of the music sheet.
 * 
 * File:
 *     int32 (big endian) | Number of KeyValuePairs
 *     KeyValuePair[]     | The raw records
 * 
 * KeyValuePair:
 *     1 Byte  | length of the key
 *     n Bytes | key as utf8 encoded string
 *     1 Byte  | Data Type
 *     n Bytes | Value
 * 
 * Values based on Data Type:
 *     0 = bool
 *         0===false
 *     1 = int32 (big endian)
 *     2 = float (big endian, IEEE)
 *     3 = string
 *       int16 (big endian) | length of string
 *       n bytes            | utf-8 encoded string
 *     4 = point
 *       int32 (big endian) | X-coordinate
 *       int32 (big endian) | Y-coordinate
 *     5 = size
 *       int32 (big endian) | Width
 *       int32 (big endian) | Height
 *     6 = rectangle
 *       int32 (big endian) | X-coordinate
 *       int32 (big endian) | Y-coordinate
 *       int32 (big endian) | Width
 *       int32 (big endian) | Height
 *     7 = color
 *       1 byte | Red
 *       1 byte | Green
 *       1 byte | Blue
 *       1 byte | Alpha
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class BinaryStylesheet
{
    public var raw: alphaTab.collections.Map<String, Any?> = alphaTab.collections.Map<String, Any?>()
    
    public constructor(`data`: alphaTab.core.ecmaScript.Uint8Array){
        var readable: alphaTab.io.ByteBuffer = alphaTab.io.ByteBuffer.fromBuffer(`data`)
        var entryCount: Double = alphaTab.io.IOHelper.readInt32BE(readable)
        if(true) {
            var i: Double = 0.0
            
            while(i < entryCount){
                try{
                    var key: String = alphaTab.importer.GpBinaryHelpers.gpReadString(readable, readable.readByte(), "utf-8")
                    var type: alphaTab.importer.DataType = alphaTab.importer.DataType.fromValue(readable.readByte())
                    when (type)
                    {
                        alphaTab.importer.DataType.Boolean -> 
                        {
                            var flag: Boolean = readable.readByte() == 1.0
                            this.addValue(key, ((flag as Any?)))
                        }
                        alphaTab.importer.DataType.Integer -> 
                        {
                            var ivalue: Double = alphaTab.io.IOHelper.readInt32BE(readable)
                            this.addValue(key, ((ivalue as Any?)))
                        }
                        alphaTab.importer.DataType.Float -> 
                        {
                            var fvalue: Double = alphaTab.importer.GpBinaryHelpers.gpReadFloat(readable)
                            this.addValue(key, ((fvalue as Any?)))
                        }
                        alphaTab.importer.DataType.String -> 
                        {
                            var s: String = alphaTab.importer.GpBinaryHelpers.gpReadString(readable, alphaTab.io.IOHelper.readInt16BE(readable), "utf-8")
                            this.addValue(key, ((s as Any?)))
                        }
                        alphaTab.importer.DataType.Point -> 
                        {
                            var x: Double = alphaTab.io.IOHelper.readInt32BE(readable)
                            var y: Double = alphaTab.io.IOHelper.readInt32BE(readable)
                            this.addValue(key, alphaTab.model.BendPoint(x, y))
                        }
                        alphaTab.importer.DataType.Size -> 
                        {
                            var width: Double = alphaTab.io.IOHelper.readInt32BE(readable)
                            var height: Double = alphaTab.io.IOHelper.readInt32BE(readable)
                            this.addValue(key, alphaTab.model.BendPoint(width, height))
                        }
                        alphaTab.importer.DataType.Rectangle -> 
                        {
                            var rect: alphaTab.rendering.utils.Bounds = alphaTab.rendering.utils.Bounds()
                            rect.x = alphaTab.io.IOHelper.readInt32BE(readable)
                            rect.y = alphaTab.io.IOHelper.readInt32BE(readable)
                            rect.w = alphaTab.io.IOHelper.readInt32BE(readable)
                            rect.h = alphaTab.io.IOHelper.readInt32BE(readable)
                            this.addValue(key, rect)
                        }
                        alphaTab.importer.DataType.Color -> 
                        {
                            var color: alphaTab.model.Color = alphaTab.importer.GpBinaryHelpers.gpReadColor(readable, true)
                            this.addValue(key, color)
                        }
                        else -> { }
                    }
                }
                finally{
                    i++
                }
            }
        }
    }
    
    /**
     */
    public fun apply(score: alphaTab.model.Score): Unit{
        for ((key, value) in this.raw)
        {
            when (key)
            {
                "StandardNotation/hideDynamics" -> 
                {
                    score.stylesheet.hideDynamics = (value as Boolean)
                }
                else -> { }
            }
        }
    }
    
    /**
     */
    public fun addValue(key: String, value: Any?): Unit{
        this.raw.set(key, value)
    }
    
    companion object{
        /**
         */
        @kotlin.jvm.JvmStatic
        public fun writeForScore(score: alphaTab.model.Score): alphaTab.core.ecmaScript.Uint8Array{
            var writer: alphaTab.io.ByteBuffer = alphaTab.io.ByteBuffer.withCapacity(128.0)
            alphaTab.io.IOHelper.writeInt32BE(writer, 1.0)
            alphaTab.importer.BinaryStylesheet.writeBooleanEntry(writer, "StandardNotation/hideDynamics", score.stylesheet.hideDynamics)
            return writer.toArray()
        }
        
        /**
         */
        @kotlin.jvm.JvmStatic
        private fun writeBooleanEntry(writer: alphaTab.io.ByteBuffer, key: String, value: Boolean): Unit{
            alphaTab.importer.GpBinaryHelpers.gpWriteString(writer, key)
            writer.writeByte(alphaTab.importer.DataType.Boolean.toDouble())
            writer.writeByte(if(value)  1.0 else 0.0)
        }
        
    }
}

internal enum class DataType(override val value: Int): alphaTab.core.IAlphaTabEnum
{
    Boolean(0),
    Integer(1),
    Float(2),
    String(3),
    Point(4),
    Size(5),
    Rectangle(6),
    Color(7);
    companion object{
        public fun fromValue(v:Double): DataType{
            return when(v.toInt()){
                Boolean.value -> Boolean
                Integer.value -> Integer
                Float.value -> Float
                String.value -> String
                Point.value -> Point
                Size.value -> Size
                Rectangle.value -> Rectangle
                Color.value -> Color
                else -> throw ClassCastException("No enum with value $v found")}
        }
    }
}

