// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.importer
import alphaTab.core.*

@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class CapellaParser
{
    public lateinit var score: alphaTab.model.Score
    private var _trackChannel: Double = 0.0
    
    private var _beamingMode: alphaTab.model.BeatBeamingMode = alphaTab.model.BeatBeamingMode.Auto
    
    private lateinit var _galleryObjects: alphaTab.collections.Map<String, alphaTab.importer.DrawObject>
    
    private lateinit var _voiceCounts: alphaTab.collections.DoubleDoubleMap
    
    private var _isFirstSystem: Boolean = true
    
    /**
     */
    public fun parseXml(xml: String, settings: alphaTab.Settings): Unit{
        this._galleryObjects = alphaTab.collections.Map<String, alphaTab.importer.DrawObject>()
        this._tieStarts = alphaTab.collections.List<alphaTab.model.Note>(
        )
        
        this._tieStartIds = alphaTab.collections.DoubleBooleanMap()
        this._voiceCounts = alphaTab.collections.DoubleDoubleMap()
        this._slurs = alphaTab.collections.Map<alphaTab.model.Beat, alphaTab.importer.SlurDrawObject>()
        this._crescendo = alphaTab.collections.Map<alphaTab.model.Beat, alphaTab.importer.WedgeDrawObject>()
        this._isFirstSystem = true
        var dom: alphaTab.xml.XmlDocument = alphaTab.xml.XmlDocument()
        try
        {
            dom.parse(xml)
        }
        catch (e: kotlin.Throwable)
        {
            throw alphaTab.importer.UnsupportedFormatError("Could not parse XML", (e as alphaTab.core.ecmaScript.Error))
        }
        this.parseDom(dom)
        this.consolidate()
        this.score.finish(settings)
    }
    
    private fun consolidate(): Unit{
        var tempo: Double = this.score.tempo
        for (track in this.score.tracks)
        {
            var trackVoiceCount: Double = this._voiceCounts.get(track.index)!!
            for (staff in track.staves)
            {
                while (staff.bars.length < this.score.masterBars.length)
                {
                    this.addNewBar(staff)
                }
                for (bar in staff.bars)
                {
                    while (bar.voices.length < trackVoiceCount)
                    {
                        bar.addVoice(alphaTab.model.Voice())
                    }
                    for (voice in bar.voices)
                    {
                        if (voice.beats.length == 0.0)
                        {
                            var emptyBeat: alphaTab.model.Beat = alphaTab.model.Beat()
                            emptyBeat.isEmpty = true
                            voice.addBeat(emptyBeat)
                        }
                    }
                    var mb: alphaTab.model.MasterBar = bar.masterBar
                    if (alphaTab.core.TypeHelper.isTruthy(mb.tempoAutomation))
                    {
                        if (mb.tempoAutomation!!.value != tempo)
                        {
                            tempo = mb.tempoAutomation!!.value
                        }
                        else 
                        {
                            mb.tempoAutomation = null
                        }
                    }
                }
            }
        }
        alphaTab.importer.CapellaParser.applyEffectRange(this._slurs, fun(_: alphaTab.importer.SlurDrawObject, beat: alphaTab.model.Beat): Unit{
            beat.isLegatoOrigin = true
        }
        )
        alphaTab.importer.CapellaParser.applyEffectRange(this._crescendo, fun(cre: alphaTab.importer.WedgeDrawObject, beat: alphaTab.model.Beat): Unit{
            beat.crescendo = if(cre.decrescendo)  alphaTab.model.CrescendoType.Decrescendo else alphaTab.model.CrescendoType.Crescendo
        }
        )
    }
    
    /**
     */
    private fun parseDom(dom: alphaTab.xml.XmlDocument): Unit{
        var root: alphaTab.xml.XmlNode? = dom.firstElement
        if (!alphaTab.core.TypeHelper.isTruthy(root))
        {
            throw alphaTab.importer.UnsupportedFormatError("No valid XML")
        }
        if (root.localName == "score")
        {
            this.score = alphaTab.model.Score()
            this.score.tempo = 120.0
            for (n in root.childNodes)
            {
                if (n.nodeType == alphaTab.xml.XmlNodeType.Element)
                {
                    when (n.localName)
                    {
                        "info" -> 
                        {
                            this.parseInfo(n)
                        }
                        "layout" -> 
                        {
                            this.parseLayout(n)
                        }
                        "gallery" -> 
                        {
                            this.parseGallery(n)
                        }
                        "pageObjects" -> 
                        {
                            this.parsePageObjects(n)
                        }
                        "systems" -> 
                        {
                            this.parseSystems(n)
                        }
                        else -> { }
                    }
                }
            }
        }
        else 
        {
            throw alphaTab.importer.UnsupportedFormatError("Root node of XML was not \"score\"")
        }
    }
    
    private var _staffLookup: alphaTab.collections.DoubleObjectMap<alphaTab.model.Staff> = alphaTab.collections.DoubleObjectMap<alphaTab.model.Staff>()
    
    /**
     */
    private fun parseLayout(element: alphaTab.xml.XmlNode): Unit{
        for (c in element.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "staves" -> 
                    {
                        this.parseLayoutStaves(c)
                    }
                    "brackets" -> 
                    {
                        this.parseBrackets(c)
                    }
                    else -> { }
                }
            }
        }
        var curlyBrackets: alphaTab.collections.List<alphaTab.importer.Bracket> = this._brackets.filter(fun(b: alphaTab.importer.Bracket): Boolean{
            return (!!b.curly as Boolean)
        }
        )
        curlyBrackets.sort(fun(a: alphaTab.importer.Bracket, b: alphaTab.importer.Bracket): Double{
            return a.from - b.from
        }
        )
        var currentBracketIndex: Double = 0.0
        var currentTrack: alphaTab.model.Track? = null
        if(true) {
            var i: Double = 0.0
            
            while(i < this._staffLayouts.length){
                try{
                    var staffLayout: alphaTab.importer.StaffLayout = this._staffLayouts[(i).toInt()]
                    while (currentBracketIndex < curlyBrackets.length && i > curlyBrackets[(currentBracketIndex).toInt()].to)
                    {
                        currentBracketIndex++
                    }
                    if (alphaTab.core.TypeHelper.isTruthy(currentTrack) && currentBracketIndex < curlyBrackets.length && i > curlyBrackets[(currentBracketIndex).toInt()].from && i <= curlyBrackets[(currentBracketIndex).toInt()].to)
                    {
                        currentTrack.ensureStaveCount(currentTrack.staves.length + 1.0)
                    }
                    else 
                    {
                        currentTrack = alphaTab.model.Track()
                        currentTrack.ensureStaveCount(1.0)
                        currentTrack.name = staffLayout.description
                        currentTrack.playbackInfo.volume = alphaTab.core.ecmaScript.Math.floor((staffLayout.volume / (128.0).toDouble()) * 16.0)
                        currentTrack.playbackInfo.program = staffLayout.instrument
                        if (staffLayout.percussion)
                        {
                            currentTrack.playbackInfo.primaryChannel = 9.0
                            currentTrack.playbackInfo.secondaryChannel = 9.0
                        }
                        else 
                        {
                            currentTrack.playbackInfo.primaryChannel = this._trackChannel++
                            currentTrack.playbackInfo.secondaryChannel = this._trackChannel++
                        }
                        this.score.addTrack(currentTrack)
                    }
                    var staff: alphaTab.model.Staff = currentTrack.staves[(currentTrack.staves.length - 1.0).toInt()]
                    staff.isPercussion = staffLayout.percussion
                    staff.transpositionPitch = staffLayout.transpose
                    staff.displayTranspositionPitch = 0.0
                    staff.showTablature = false
                    this._staffLookup.set(staffLayout.index, staff)
                }
                finally{
                    i++
                }
            }
        }
    }
    
    private var _brackets: alphaTab.collections.List<alphaTab.importer.Bracket> = alphaTab.collections.List<alphaTab.importer.Bracket>(
    )
    
    
    /**
     */
    private fun parseBrackets(element: alphaTab.xml.XmlNode): Unit{
        for (c in element.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "bracket" -> 
                    {
                        this.parseBracket(c)
                    }
                    else -> { }
                }
            }
        }
    }
    
    /**
     */
    private fun parseBracket(element: alphaTab.xml.XmlNode): Unit{
        var bracket: alphaTab.importer.Bracket = alphaTab.importer.Bracket()
        bracket.from = alphaTab.core.Globals.parseInt(element.getAttribute("from"))
        bracket.to = alphaTab.core.Globals.parseInt(element.getAttribute("to"))
        if (element.attributes.has("curly"))
        {
            bracket.curly = element.attributes.get("curly") == "true"
        }
        this._brackets.push(bracket)
    }
    
    /**
     */
    private fun parseLayoutStaves(element: alphaTab.xml.XmlNode): Unit{
        for (c in element.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "staffLayout" -> 
                    {
                        this.parseStaffLayout(c)
                    }
                    else -> { }
                }
            }
        }
    }
    
    private var _staffLayoutLookup: alphaTab.collections.Map<String, alphaTab.importer.StaffLayout> = alphaTab.collections.Map<String, alphaTab.importer.StaffLayout>()
    
    private var _staffLayouts: alphaTab.collections.List<alphaTab.importer.StaffLayout> = alphaTab.collections.List<alphaTab.importer.StaffLayout>(
    )
    
    
    /**
     */
    private fun parseStaffLayout(element: alphaTab.xml.XmlNode): Unit{
        var layout: alphaTab.importer.StaffLayout = alphaTab.importer.StaffLayout()
        layout.description = element.getAttribute("description")
        for (c in element.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "notation" -> 
                    {
                        if (c.attributes.has("defaultClef"))
                        {
                            layout.defaultClef = this.parseClef(c.attributes.get("defaultClef")!!)
                        }
                    }
                    "sound" -> 
                    {
                        if (c.attributes.has("percussion"))
                        {
                            layout.percussion = c.attributes.get("percussion") == "true"
                        }
                        if (c.attributes.has("instr"))
                        {
                            layout.instrument = alphaTab.core.Globals.parseInt(c.attributes.get("instr")!!)
                        }
                        if (c.attributes.has("volume"))
                        {
                            layout.volume = alphaTab.core.Globals.parseInt(c.attributes.get("volume")!!)
                        }
                        if (c.attributes.has("transpose"))
                        {
                            layout.transpose = alphaTab.core.Globals.parseInt(c.attributes.get("transpose")!!)
                        }
                    }
                    else -> { }
                }
            }
        }
        this._staffLayoutLookup.set(layout.description, layout)
        layout.index = this._staffLayouts.length
        this._staffLayouts.push(layout)
    }
    
    /**
     */
    private fun parseClef(v: String): alphaTab.model.Clef{
        when (v)
        {
            "treble" -> 
            {
                return alphaTab.model.Clef.G2
            }
            "bass" -> 
            {
                return alphaTab.model.Clef.F4
            }
            "alto" -> 
            {
                return alphaTab.model.Clef.C4
            }
            "tenor" -> 
            {
                return alphaTab.model.Clef.C4
            }
            else -> { }
        }
        return alphaTab.model.Clef.G2
    }
    
    /**
     */
    private fun parseClefOttava(v: String): alphaTab.model.Ottavia{
        if (v.endsWith("-"))
        {
            return alphaTab.model.Ottavia._8vb
        }
        else if (v.endsWith("+"))
        {
            return alphaTab.model.Ottavia._8va
        }
        return alphaTab.model.Ottavia.Regular
    }
    
    /**
     */
    private fun parseSystems(element: alphaTab.xml.XmlNode): Unit{
        for (c in element.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "system" -> 
                    {
                        this.parseSystem(c)
                    }
                    else -> { }
                }
            }
        }
    }
    
    /**
     */
    private fun parseSystem(element: alphaTab.xml.XmlNode): Unit{
        if (element.attributes.has("tempo"))
        {
            if (this.score.masterBars.length == 0.0)
            {
                this.score.tempo = alphaTab.core.Globals.parseInt(element.attributes.get("tempo")!!)
            }
        }
        if (element.getAttribute("beamGrouping") == "0")
        {
            this._beamingMode = alphaTab.model.BeatBeamingMode.ForceSplitToNext
        }
        for (c in element.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "staves" -> 
                    {
                        this.parseStaves(element, c)
                    }
                    else -> { }
                }
            }
        }
        this._isFirstSystem = false
    }
    
    /**
     */
    private fun parseStaves(systemElement: alphaTab.xml.XmlNode, element: alphaTab.xml.XmlNode): Unit{
        var firstBarIndex: Double = this.score.masterBars.length
        for (c in element.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "staff" -> 
                    {
                        this.parseStaff(systemElement, firstBarIndex, c)
                    }
                    else -> { }
                }
            }
        }
    }
    
    private var _timeSignature: alphaTab.model.MasterBar = alphaTab.model.MasterBar()
    
    private lateinit var _currentStaffLayout: alphaTab.importer.StaffLayout
    
    /**
     */
    private fun parseStaff(systemElement: alphaTab.xml.XmlNode, firstBarIndex: Double, element: alphaTab.xml.XmlNode): Unit{
        var staffId: String = element.getAttribute("layout")
        this._currentStaffLayout = this._staffLayoutLookup.get(staffId)!!
        this._timeSignature.timeSignatureNumerator = 4.0
        this._timeSignature.timeSignatureDenominator = 4.0
        this._timeSignature.timeSignatureCommon = false
        this.parseTime(element.getAttribute("defaultTime"))
        var staff: alphaTab.model.Staff = this._staffLookup.get(this._currentStaffLayout.index)!!
        while (staff.bars.length < firstBarIndex)
        {
            this.addNewBar(staff)
        }
        for (c in element.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "voices" -> 
                    {
                        this.parseVoices(staffId, staff, systemElement, firstBarIndex, c)
                    }
                    else -> { }
                }
            }
        }
    }
    
    /**
     */
    private fun parseTime(value: String): Unit{
        when (value)
        {
            "allaBreve", "C" -> 
            {
                this._timeSignature.timeSignatureNumerator = 2.0
                this._timeSignature.timeSignatureDenominator = 2.0
                this._timeSignature.timeSignatureCommon = true
            }
            "longAllaBreve" -> 
            {
                this._timeSignature.timeSignatureNumerator = 4.0
                this._timeSignature.timeSignatureDenominator = 4.0
                this._timeSignature.timeSignatureCommon = true
            }
            else -> 
            {
                if (value.indexOfInDouble("/") > 0)
                {
                    var parts: alphaTab.collections.List<String> = value.splitBy("/")
                    this._timeSignature.timeSignatureNumerator = alphaTab.core.Globals.parseInt(parts[(0).toInt()])
                    this._timeSignature.timeSignatureDenominator = alphaTab.core.Globals.parseInt(parts[(1).toInt()])
                    this._timeSignature.timeSignatureCommon = false
                }
            }
        }
    }
    
    /**
     */
    private fun parseVoices(staffId: String, staff: alphaTab.model.Staff, systemElement: alphaTab.xml.XmlNode, firstBarIndex: Double, element: alphaTab.xml.XmlNode): Unit{
        var voiceIndex: Double = 0.0
        for (c in element.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "voice" -> 
                    {
                        this.parseVoice(
                            staffId
                            , 
                            staff
                            , 
                            systemElement
                            , 
                            voiceIndex
                            , 
                            firstBarIndex
                            , 
                            c
                        
                        )
                        voiceIndex++
                    }
                    else -> { }
                }
            }
        }
    }
    
    /**
     */
    private fun getOrCreateBar(staff: alphaTab.model.Staff, barIndex: Double): alphaTab.model.Bar{
        if (barIndex < staff.bars.length)
        {
            return staff.bars[(barIndex).toInt()]
        }
        return this.addNewBar(staff)
    }
    
    /**
     */
    private fun addNewBar(staff: alphaTab.model.Staff): alphaTab.model.Bar{
        var currentBar: alphaTab.model.Bar = alphaTab.model.Bar()
        if (staff.bars.length > 0)
        {
            currentBar.clef = staff.bars[(staff.bars.length - 1.0).toInt()].clef
            currentBar.clefOttava = staff.bars[(staff.bars.length - 1.0).toInt()].clefOttava
        }
        else 
        {
            currentBar.clef = this._currentStaffLayout.defaultClef
        }
        staff.addBar(currentBar)
        if (staff.bars.length > this.score.masterBars.length)
        {
            var master: alphaTab.model.MasterBar = alphaTab.model.MasterBar()
            this.score.addMasterBar(master)
            if (master.index > 0)
            {
                master.keySignature = master.previousMasterBar!!.keySignature
                master.keySignatureType = master.previousMasterBar!!.keySignatureType
                master.tripletFeel = master.previousMasterBar!!.tripletFeel
            }
            master.timeSignatureDenominator = this._timeSignature.timeSignatureDenominator
            master.timeSignatureNumerator = this._timeSignature.timeSignatureNumerator
            master.timeSignatureCommon = this._timeSignature.timeSignatureCommon
        }
        return currentBar
    }
    
    private var _voiceStates: alphaTab.collections.Map<String, alphaTab.importer.CapellaVoiceState> = alphaTab.collections.Map<String, alphaTab.importer.CapellaVoiceState>()
    
    private lateinit var _currentVoiceState: alphaTab.importer.CapellaVoiceState
    
    private lateinit var _currentBar: alphaTab.model.Bar
    
    private lateinit var _currentVoice: alphaTab.model.Voice
    
    /**
     */
    private fun newBar(staff: alphaTab.model.Staff, voiceIndex: Double): Unit{
        this._currentVoiceState.currentBarIndex++
        this._currentBar = this.getOrCreateBar(staff, this._currentVoiceState.currentBarIndex)
        this._currentVoiceState.currentBarDuration = this._currentBar.masterBar.calculateDuration(false)
        this._currentVoiceState.currentBarComplete = false
        this._currentVoiceState.currentPosition = 0.0
        this.ensureVoice(staff, voiceIndex)
    }
    
    /**
     */
    private fun parseVoice(staffId: String, staff: alphaTab.model.Staff, systemElement: alphaTab.xml.XmlNode, voiceIndex: Double, firstBarIndex: Double, element: alphaTab.xml.XmlNode): Unit{
        var voiceStateKey: String = staffId + "_" + (voiceIndex).toInvariantString()
        if (alphaTab.core.TypeHelper.isTruthy(this._currentVoiceState) && !this._currentVoiceState.currentBarComplete)
        {
            this._currentBar.masterBar.isAnacrusis = true
        }
        if (!this._voiceStates.has(voiceStateKey))
        {
            this._currentVoiceState = alphaTab.importer.CapellaVoiceState()
            this._currentVoiceState.currentBarIndex = firstBarIndex - 1.0
            this._voiceStates.set(voiceStateKey, this._currentVoiceState)
            this.newBar(staff, voiceIndex)
        }
        else 
        {
            this._currentVoiceState = this._voiceStates.get(voiceStateKey)!!
            this._currentBar = this.getOrCreateBar(staff, this._currentVoiceState.currentBarIndex)
            this.ensureVoice(staff, voiceIndex)
        }
        if (element.attributes.has("stemDir"))
        {
            when (element.attributes.get("stemDir")!!)
            {
                "up" -> 
                {
                    this._currentVoiceState.voiceStemDir = alphaTab.rendering.utils.BeamDirection.Up
                }
                "down" -> 
                {
                    this._currentVoiceState.voiceStemDir = alphaTab.rendering.utils.BeamDirection.Down
                }
                else -> 
                {
                    this._currentVoiceState.voiceStemDir = null
                }
            }
        }
        else 
        {
            this._currentVoiceState.voiceStemDir = null
        }
        var noteObjects: alphaTab.xml.XmlNode? = element.findChildElement("noteObjects")
        if (systemElement.attributes.has("tempo"))
        {
            this._currentBar.masterBar.tempoAutomation = alphaTab.model.Automation()
            this._currentBar.masterBar.tempoAutomation!!.isLinear = true
            this._currentBar.masterBar.tempoAutomation!!.type = alphaTab.model.AutomationType.Tempo
            this._currentBar.masterBar.tempoAutomation!!.value = alphaTab.core.Globals.parseInt(systemElement.attributes.get("tempo")!!)
        }
        if (alphaTab.core.TypeHelper.isTruthy(noteObjects))
        {
            for (c in noteObjects.childNodes)
            {
                if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
                {
                    if (this._currentVoiceState.currentBarComplete && c.localName != "barline")
                    {
                        this.newBar(staff, voiceIndex)
                    }
                    when (c.localName)
                    {
                        "clefSign" -> 
                        {
                            this._currentBar.clef = this.parseClef(c.getAttribute("clef"))
                            this._currentBar.clefOttava = this.parseClefOttava(c.getAttribute("clef"))
                        }
                        "keySign" -> 
                        {
                            this._currentBar.masterBar.keySignature = alphaTab.model.KeySignature.fromValue(alphaTab.core.Globals.parseInt(c.getAttribute("fifths")))
                        }
                        "timeSign" -> 
                        {
                            this.parseTime(c.getAttribute("time"))
                            this._currentBar.masterBar.timeSignatureDenominator = this._timeSignature.timeSignatureDenominator
                            this._currentBar.masterBar.timeSignatureNumerator = this._timeSignature.timeSignatureNumerator
                            this._currentBar.masterBar.timeSignatureCommon = this._timeSignature.timeSignatureCommon
                            this._currentVoiceState.currentPosition = 0.0
                            this._currentVoiceState.currentBarDuration = this._currentBar.masterBar.calculateDuration(false)
                        }
                        "barline" -> 
                        {
                            when (c.getAttribute("type"))
                            {
                                "double" -> 
                                {
                                    this._currentBar.masterBar.isDoubleBar = true
                                    if (!this._currentVoiceState.currentBarComplete)
                                    {
                                        this._currentBar.masterBar.isAnacrusis = true
                                    }
                                    this._currentVoiceState.currentBarComplete = true
                                }
                                "end" -> 
                                {
                                    if (!this._currentVoiceState.currentBarComplete)
                                    {
                                        this._currentBar.masterBar.isAnacrusis = true
                                    }
                                }
                                "repEnd" -> 
                                {
                                    this._currentVoiceState.repeatEnd = this._currentBar.masterBar
                                    if (this._currentBar.masterBar.repeatCount < this._currentVoiceState.repeatCount)
                                    {
                                        this._currentBar.masterBar.repeatCount = this._currentVoiceState.repeatCount
                                    }
                                    this.parseBarDrawObject(c)
                                    if (!this._currentVoiceState.currentBarComplete)
                                    {
                                        this._currentBar.masterBar.isAnacrusis = true
                                    }
                                    this._currentVoiceState.currentBarComplete = true
                                }
                                "repBegin" -> 
                                {
                                    this.newBar(staff, voiceIndex)
                                    this._currentBar.masterBar.isRepeatStart = true
                                    this._currentVoiceState.repeatEnd = null
                                    this._currentVoiceState.repeatCount = 0.0
                                }
                                "repEndBegin" -> 
                                {
                                    this._currentVoiceState.repeatEnd = this._currentBar.masterBar
                                    if (this._currentBar.masterBar.repeatCount < this._currentVoiceState.repeatCount)
                                    {
                                        this._currentBar.masterBar.repeatCount = this._currentVoiceState.repeatCount
                                    }
                                    this.parseBarDrawObject(c)
                                    this.newBar(staff, voiceIndex)
                                    this._currentBar.masterBar.isRepeatStart = true
                                }
                                "dashed" -> 
                                {
                                    if (!this._currentVoiceState.currentBarComplete)
                                    {
                                        this._currentBar.masterBar.isAnacrusis = true
                                    }
                                    this._currentVoiceState.currentBarComplete = true
                                }
                                else -> 
                                {
                                    if (!this._currentVoiceState.currentBarComplete)
                                    {
                                        this._currentBar.masterBar.isAnacrusis = true
                                    }
                                    this._currentVoiceState.currentBarComplete = true
                                }
                            }
                        }
                        "chord" -> 
                        {
                            var chordBeat: alphaTab.model.Beat = alphaTab.model.Beat()
                            this.initFromPreviousBeat(chordBeat, this._currentVoice)
                            chordBeat.beamingMode = this._beamingMode
                            if (alphaTab.core.TypeHelper.isTruthy(this._currentVoiceState.voiceStemDir))
                            {
                                chordBeat.preferredBeamDirection = this._currentVoiceState.voiceStemDir
                            }
                            this.parseDuration(this._currentBar, chordBeat, c.findChildElement("duration")!!)
                            chordBeat.updateDurations()
                            this._currentVoiceState.currentPosition += chordBeat.playbackDuration
                            this._currentVoice.addBeat(chordBeat)
                            this.parseChord(chordBeat, c)
                            if (this._currentVoiceState.currentPosition >= this._currentVoiceState.currentBarDuration)
                            {
                                this._currentVoiceState.currentBarComplete = true
                            }
                        }
                        "rest" -> 
                        {
                            var restBeat: alphaTab.model.Beat? = this.parseRestDurations(this._currentBar, c.findChildElement("duration")!!)
                            if (alphaTab.core.TypeHelper.isTruthy(restBeat))
                            {
                                this.initFromPreviousBeat(restBeat, this._currentVoice)
                                restBeat.updateDurations()
                                this._currentVoiceState.currentPosition += restBeat.playbackDuration
                                this._currentVoice.addBeat(restBeat)
                                if (this._currentVoiceState.currentPosition >= this._currentVoiceState.currentBarDuration)
                                {
                                    this._currentVoiceState.currentBarComplete = true
                                }
                            }
                        }
                        else -> { }
                    }
                }
            }
        }
    }
    
    /**
     */
    private fun initFromPreviousBeat(chordBeat: alphaTab.model.Beat, currentVoice: alphaTab.model.Voice): Unit{
        var previousBeat: alphaTab.model.Beat? = this.getLastBeat(currentVoice)
        if (alphaTab.core.TypeHelper.isTruthy(previousBeat))
        {
            chordBeat.dynamics = previousBeat.dynamics
        }
    }
    
    /**
     */
    private fun getLastBeat(voice: alphaTab.model.Voice): alphaTab.model.Beat?{
        if (voice.beats.length > 0)
        {
            return voice.beats[(voice.beats.length - 1.0).toInt()]
        }
        else if (voice.bar.index > 0)
        {
            var previousBar: alphaTab.model.Bar = voice.bar.staff.bars[(voice.bar.index - 1.0).toInt()]
            if (voice.index < previousBar.voices.length)
            {
                var previousVoice: alphaTab.model.Voice = previousBar.voices[(voice.index).toInt()]
                return this.getLastBeat(previousVoice)
            }
        }
        return null
    }
    
    /**
     */
    private fun ensureVoice(staff: alphaTab.model.Staff, voiceIndex: Double): Unit{
        while (this._currentBar.voices.length < voiceIndex + 1.0)
        {
            this._currentBar.addVoice(alphaTab.model.Voice())
        }
        if (!this._voiceCounts.has(staff.track.index) || this._voiceCounts.get(staff.track.index)!! < this._currentBar.voices.length)
        {
            this._voiceCounts.set(staff.track.index, this._currentBar.voices.length)
        }
        this._currentVoice = this._currentBar.voices[(voiceIndex).toInt()]
    }
    
    /**
     */
    private fun parseChord(beat: alphaTab.model.Beat, element: alphaTab.xml.XmlNode): Unit{
        var articulation: alphaTab.model.Note = alphaTab.model.Note()
        for (c in element.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "stem" -> 
                    {
                        when (c.getAttribute("dir"))
                        {
                            "up" -> 
                            {
                                beat.preferredBeamDirection = alphaTab.rendering.utils.BeamDirection.Up
                            }
                            "down" -> 
                            {
                                beat.preferredBeamDirection = alphaTab.rendering.utils.BeamDirection.Down
                            }
                            else -> { }
                        }
                    }
                    "articulation" -> 
                    {
                        when (c.getAttribute("type"))
                        {
                            "staccato" -> 
                            {
                                articulation.isStaccato = true
                            }
                            "normalAccent" -> 
                            {
                                articulation.accentuated = alphaTab.model.AccentuationType.Normal
                            }
                            "strongAccent" -> 
                            {
                                articulation.accentuated = alphaTab.model.AccentuationType.Heavy
                            }
                            else -> { }
                        }
                    }
                    "lyric" -> 
                    {
                        this.parseLyric(beat, c)
                    }
                    "drawObjects" -> 
                    {
                        this.parseBeatDrawObject(beat, c)
                    }
                    "heads" -> 
                    {
                        this.parseHeads(beat, articulation, c)
                    }
                    "beam" -> 
                    {
                        when (c.getAttribute("group"))
                        {
                            "force" -> 
                            {
                                beat.beamingMode = alphaTab.model.BeatBeamingMode.ForceMergeWithNext
                            }
                            "divide" -> 
                            {
                                beat.beamingMode = alphaTab.model.BeatBeamingMode.ForceSplitToNext
                            }
                            else -> { }
                        }
                    }
                    else -> { }
                }
            }
        }
    }
    
    /**
     */
    private fun parseHeads(beat: alphaTab.model.Beat, articulation: alphaTab.model.Note, element: alphaTab.xml.XmlNode): Unit{
        for (c in element.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "head" -> 
                    {
                        this.parseHead(beat, articulation, c)
                    }
                    else -> { }
                }
            }
        }
    }
    
    private lateinit var _tieStarts: alphaTab.collections.List<alphaTab.model.Note>
    
    private lateinit var _tieStartIds: alphaTab.collections.DoubleBooleanMap
    
    private lateinit var _slurs: alphaTab.collections.Map<alphaTab.model.Beat, alphaTab.importer.SlurDrawObject>
    
    private lateinit var _crescendo: alphaTab.collections.Map<alphaTab.model.Beat, alphaTab.importer.WedgeDrawObject>
    
    /**
     */
    private fun parseHead(beat: alphaTab.model.Beat, articulation: alphaTab.model.Note, element: alphaTab.xml.XmlNode): Unit{
        var note: alphaTab.model.Note = alphaTab.model.Note()
        var pitch: alphaTab.model.TuningParseResult? = alphaTab.model.ModelUtils.parseTuning(element.getAttribute("pitch"))
        note.octave = pitch!!.octave - 1.0
        note.tone = pitch!!.noteValue
        note.isStaccato = articulation.isStaccato
        note.accentuated = articulation.accentuated
        beat.addNote(note)
        for (c in element.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "alter" -> 
                    {
                        if (c.attributes.has("step"))
                        {
                            note.tone += alphaTab.core.Globals.parseInt(c.attributes.get("step")!!)
                        }
                    }
                    "tie" -> 
                    {
                        if (c.attributes.has("begin"))
                        {
                            if (!this._tieStartIds.has(note.id))
                            {
                                this._tieStartIds.set(note.id, true)
                                this._tieStarts.push(note)
                            }
                        }
                        else if (c.attributes.has("end") && this._tieStarts.length > 0 && !note.isTieDestination)
                        {
                            note.isTieDestination = true
                            note.tieOrigin = this._tieStarts[(0).toInt()]
                            this._tieStarts.splice(0.0, 1.0)
                            this._tieStartIds.delete(note.id)
                        }
                    }
                    else -> { }
                }
            }
        }
    }
    
    /**
     */
    private fun parseBeatDrawObject(beat: alphaTab.model.Beat, element: alphaTab.xml.XmlNode): Unit{
        for (c in element.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "drawObj" -> 
                    {
                        var obj: alphaTab.importer.DrawObject? = this.parseDrawObj(c)
                        if (alphaTab.core.TypeHelper.isTruthy(obj))
                        {
                            if (obj is alphaTab.importer.TextDrawObject)
                            {
                                if (((obj as alphaTab.importer.TextDrawObject)).fontFace.startsWith("capella"))
                                {
                                    if (((obj as alphaTab.importer.TextDrawObject)).text == "u")
                                    {
                                        beat.fermata = alphaTab.model.Fermata()
                                        beat.fermata!!.type = alphaTab.model.FermataType.Medium
                                    }
                                    else if (((obj as alphaTab.importer.TextDrawObject)).text == "f")
                                    {
                                        beat.dynamics = alphaTab.model.DynamicValue.F
                                    }
                                    else if (((obj as alphaTab.importer.TextDrawObject)).text == "j")
                                    {
                                        beat.dynamics = alphaTab.model.DynamicValue.MF
                                    }
                                }
                                else if (this._isFirstSystem && this.score.title == "" && ((obj as alphaTab.importer.TextDrawObject)).align == alphaTab.platform.TextAlign.Center && ((obj as alphaTab.importer.TextDrawObject)).height > 16 && ((obj as alphaTab.importer.TextDrawObject)).weight > 400)
                                {
                                    this.score.title = ((obj as alphaTab.importer.TextDrawObject)).text
                                }
                                else if (this._isFirstSystem && this.score.artist == "" && ((obj as alphaTab.importer.TextDrawObject)).align == alphaTab.platform.TextAlign.Center && ((obj as alphaTab.importer.TextDrawObject)).y < 0)
                                {
                                    this.score.artist = ((obj as alphaTab.importer.TextDrawObject)).text
                                }
                                else if (this._isFirstSystem && this.score.music == "" && ((obj as alphaTab.importer.TextDrawObject)).align == alphaTab.platform.TextAlign.Right && ((obj as alphaTab.importer.TextDrawObject)).y < 0)
                                {
                                    this.score.music = ((obj as alphaTab.importer.TextDrawObject)).text
                                }
                                else if (!((obj as alphaTab.importer.TextDrawObject)).text.startsWith("by capella"))
                                {
                                    beat.text = ((obj as alphaTab.importer.TextDrawObject)).text
                                }
                            }
                            else if (obj is alphaTab.importer.GuitarDrawObject)
                            {
                            }
                            else if (obj is alphaTab.importer.WavyLineDrawObject)
                            {
                                beat.vibrato = alphaTab.model.VibratoType.Slight
                            }
                            else if (obj is alphaTab.importer.WedgeDrawObject)
                            {
                                beat.crescendo = if(((obj as alphaTab.importer.WedgeDrawObject)).decrescendo)  alphaTab.model.CrescendoType.Decrescendo else alphaTab.model.CrescendoType.Crescendo
                                ((obj as alphaTab.importer.WedgeDrawObject)).noteRange++
                                this._crescendo.set(beat, ((obj as alphaTab.importer.WedgeDrawObject)))
                            }
                            else if (obj is alphaTab.importer.SlurDrawObject)
                            {
                                var slur: alphaTab.importer.SlurDrawObject = ((obj as Any) as alphaTab.importer.SlurDrawObject)
                                this._slurs.set(beat, slur)
                            }
                            else if (obj is alphaTab.importer.VoltaDrawObject)
                            {
                                this.applyVolta(((obj as alphaTab.importer.VoltaDrawObject)))
                            }
                        }
                    }
                    else -> { }
                }
            }
        }
    }
    
    /**
     */
    private fun parseBarDrawObject(element: alphaTab.xml.XmlNode): Unit{
        for (c in element.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "drawObj" -> 
                    {
                        var obj: alphaTab.importer.DrawObject? = this.parseDrawObj(c)
                        if (alphaTab.core.TypeHelper.isTruthy(obj))
                        {
                            if (obj is alphaTab.importer.VoltaDrawObject)
                            {
                                this.applyVolta(((obj as alphaTab.importer.VoltaDrawObject)))
                            }
                        }
                    }
                    else -> { }
                }
            }
        }
    }
    
    /**
     */
    private fun applyVolta(obj: alphaTab.importer.VoltaDrawObject): Unit{
        if (obj.lastNumber > 0)
        {
            this._currentVoiceState.repeatCount = obj.lastNumber
            if (alphaTab.core.TypeHelper.isTruthy(this._currentVoiceState.repeatEnd) && this._currentVoiceState.repeatEnd!!.repeatCount < this._currentVoiceState.repeatCount)
            {
                this._currentVoiceState.repeatEnd!!.repeatCount = this._currentVoiceState.repeatCount
            }
        }
        else if (obj.firstNumber > 0)
        {
            this._currentVoiceState.repeatCount = obj.firstNumber
            if (alphaTab.core.TypeHelper.isTruthy(this._currentVoiceState.repeatEnd) && this._currentVoiceState.repeatEnd!!.repeatCount < this._currentVoiceState.repeatCount)
            {
                this._currentVoiceState.repeatEnd!!.repeatCount = this._currentVoiceState.repeatCount
            }
        }
        if (obj.lastNumber > 0 && obj.firstNumber > 0)
        {
            var alternateEndings: Double = 0.0
            if(true) {
                var i: Double = obj.firstNumber
                
                while(i <= obj.lastNumber){
                    try{
                        alternateEndings = ((alternateEndings).toInt() or (1 shl ((i - 1.0)).toInt())).toDouble()
                    }
                    finally{
                        i++
                    }
                }
            }
            this._currentBar.masterBar.alternateEndings = alternateEndings
        }
        else if (obj.lastNumber > 0)
        {
            this._currentBar.masterBar.alternateEndings = (1 shl ((obj.lastNumber - 1.0)).toInt()).toDouble()
        }
        else if (obj.firstNumber > 0)
        {
            this._currentBar.masterBar.alternateEndings = (1 shl ((obj.firstNumber - 1.0)).toInt()).toDouble()
        }
    }
    
    /**
     */
    private fun parseLyric(beat: alphaTab.model.Beat, element: alphaTab.xml.XmlNode): Unit{
        for (c in element.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "verse" -> 
                    {
                        if (!alphaTab.core.TypeHelper.isTruthy(beat.lyrics))
                        {
                            beat.lyrics = alphaTab.collections.List(
                            )
                            
                        }
                        var text: String = c.innerText
                        if (c.getAttribute("hyphen") == "true")
                        {
                            text += "-"
                        }
                        beat.lyrics!!.push(text)
                    }
                    else -> { }
                }
            }
        }
    }
    
    /**
     */
    private fun parseRestDurations(bar: alphaTab.model.Bar, element: alphaTab.xml.XmlNode): alphaTab.model.Beat?{
        var durationBase: String = element.getAttribute("base")
        if (durationBase.indexOfInDouble("/") != -1.0)
        {
            var restBeat: alphaTab.model.Beat = alphaTab.model.Beat()
            restBeat.beamingMode = this._beamingMode
            this.parseDuration(bar, restBeat, element)
            return restBeat
        }
        var fullBars: Double = alphaTab.core.Globals.parseInt(durationBase)
        if (fullBars == 1.0)
        {
            var restBeat: alphaTab.model.Beat = alphaTab.model.Beat()
            restBeat.beamingMode = this._beamingMode
            restBeat.duration = alphaTab.model.Duration.Whole
            return restBeat
        }
        else 
        {
            alphaTab.Logger.warning("Importer", "Multi-Bar rests are not supported")
            return null
        }
    }
    
    /**
     */
    private fun parseDurationValue(s: String): alphaTab.model.Duration{
        when (s)
        {
            "2/1" -> 
            {
                return alphaTab.model.Duration.DoubleWhole
            }
            "1/1" -> 
            {
                return alphaTab.model.Duration.Whole
            }
            "1/2" -> 
            {
                return alphaTab.model.Duration.Half
            }
            "1/4" -> 
            {
                return alphaTab.model.Duration.Quarter
            }
            "1/8" -> 
            {
                return alphaTab.model.Duration.Eighth
            }
            "1/16" -> 
            {
                return alphaTab.model.Duration.Sixteenth
            }
            "1/32" -> 
            {
                return alphaTab.model.Duration.ThirtySecond
            }
            "1/64" -> 
            {
                return alphaTab.model.Duration.SixtyFourth
            }
            "1/128" -> 
            {
                return alphaTab.model.Duration.OneHundredTwentyEighth
            }
            else -> 
            {
                alphaTab.Logger.warning("Importer", "Unsupported duration")
                return alphaTab.model.Duration.Quarter
            }
        }
    }
    
    /**
     */
    private fun parseDuration(bar: alphaTab.model.Bar, beat: alphaTab.model.Beat, element: alphaTab.xml.XmlNode): Unit{
        var durationBase: String = element.getAttribute("base")
        beat.duration = this.parseDurationValue(durationBase)
        if (element.attributes.has("dots"))
        {
            beat.dots = alphaTab.core.Globals.parseInt(element.attributes.get("dots")!!)
        }
        var tuplet: alphaTab.xml.XmlNode? = element.findChildElement("tuplet")
        if (alphaTab.core.TypeHelper.isTruthy(tuplet))
        {
            beat.tupletNumerator = alphaTab.core.Globals.parseInt(tuplet.getAttribute("count"))
            var tripartiteMultiplicator: Double = if(tuplet.getAttribute("tripartite") == "true")  3.0 else 1.0
            var prolongDiff: Double = if(tuplet.getAttribute("prolong") == "true")  0.0 else 1.0
            var power: Double = 0.0
            while (tripartiteMultiplicator * alphaTab.core.ecmaScript.Math.pow(2.0, power + prolongDiff) < beat.tupletNumerator)
            {
                power++
            }
            beat.tupletDenominator = tripartiteMultiplicator * alphaTab.core.ecmaScript.Math.pow(2.0, power)
        }
    }
    
    /**
     */
    private fun parsePageObjects(element: alphaTab.xml.XmlNode): Unit{
        for (c in element.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "drawObj" -> 
                    {
                        var obj: alphaTab.importer.DrawObject? = this.parseDrawObj(c)
                        if (alphaTab.core.TypeHelper.isTruthy(obj))
                        {
                            if (obj is alphaTab.importer.TextDrawObject)
                            {
                                when (((obj as alphaTab.importer.TextDrawObject)).align)
                                {
                                    alphaTab.platform.TextAlign.Center -> 
                                    {
                                        if (!alphaTab.core.TypeHelper.isTruthy(this.score.title))
                                        {
                                            this.score.title = c.innerText
                                        }
                                        else if (!alphaTab.core.TypeHelper.isTruthy(this.score.subTitle))
                                        {
                                            this.score.subTitle = c.innerText
                                        }
                                    }
                                    alphaTab.platform.TextAlign.Right -> 
                                    {
                                        if (!alphaTab.core.TypeHelper.isTruthy(this.score.artist))
                                        {
                                            this.score.artist = c.innerText
                                        }
                                    }
                                    else -> { }
                                }
                            }
                        }
                    }
                    else -> { }
                }
            }
        }
    }
    
    /**
     */
    private fun parseGallery(element: alphaTab.xml.XmlNode): Unit{
        for (c in element.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "drawObj" -> 
                    {
                        var obj: alphaTab.importer.DrawObject? = this.parseDrawObj(c)
                        if (alphaTab.core.TypeHelper.isTruthy(obj))
                        {
                            this._galleryObjects.set(c.getAttribute("name"), obj)
                        }
                    }
                    else -> { }
                }
            }
        }
    }
    
    /**
     */
    private fun parseDrawObj(element: alphaTab.xml.XmlNode): alphaTab.importer.DrawObject?{
        var obj: alphaTab.importer.DrawObject? = null
        var noteRange: Double = 1.0
        for (c in element.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "text" -> 
                    {
                        obj = this.parseText(c)
                    }
                    "guitar" -> 
                    {
                        obj = this.parseGuitar(c)
                    }
                    "slur" -> 
                    {
                        obj = this.parseSlur(c)
                    }
                    "wavyLine" -> 
                    {
                        obj = this.parseWavyLine(c)
                    }
                    "bracket" -> 
                    {
                        obj = this.parseTupletBracket(c)
                    }
                    "wedge" -> 
                    {
                        obj = this.parseWedge(c)
                    }
                    "volta" -> 
                    {
                        obj = this.parseVolta(c)
                    }
                    "octaveClef" -> 
                    {
                        obj = this.parseOctaveClef(c)
                    }
                    "trill" -> 
                    {
                        obj = this.parseTrill(c)
                    }
                    "basic" -> 
                    {
                        if (c.attributes.has("noteRange"))
                        {
                            noteRange = alphaTab.core.Globals.parseInt(c.attributes.get("noteRange")!!)
                        }
                    }
                    else -> { }
                }
            }
        }
        if (alphaTab.core.TypeHelper.isTruthy(obj))
        {
            obj.noteRange = noteRange
        }
        return obj
    }
    
    /**
     */
    private fun parseTrill(_unused: alphaTab.xml.XmlNode): alphaTab.importer.DrawObject?{
        var obj: alphaTab.importer.TrillDrawObject = alphaTab.importer.TrillDrawObject()
        return obj
    }
    
    /**
     */
    private fun parseOctaveClef(element: alphaTab.xml.XmlNode): alphaTab.importer.OctaveClefDrawObject{
        var obj: alphaTab.importer.OctaveClefDrawObject = alphaTab.importer.OctaveClefDrawObject()
        if (element.attributes.has("octave"))
        {
            obj.octave = alphaTab.core.Globals.parseInt(element.attributes.get("octave")!!)
        }
        return obj
    }
    
    /**
     */
    private fun parseVolta(element: alphaTab.xml.XmlNode): alphaTab.importer.VoltaDrawObject{
        var obj: alphaTab.importer.VoltaDrawObject = alphaTab.importer.VoltaDrawObject()
        obj.allNumbers = element.attributes.get("allNumbers") == "true"
        if (element.attributes.has("firstNumber"))
        {
            obj.firstNumber = alphaTab.core.Globals.parseInt(element.attributes.get("firstNumber")!!)
        }
        if (element.attributes.has("lastNumber"))
        {
            obj.lastNumber = alphaTab.core.Globals.parseInt(element.attributes.get("lastNumber")!!)
        }
        return obj
    }
    
    /**
     */
    private fun parseWedge(element: alphaTab.xml.XmlNode): alphaTab.importer.WedgeDrawObject{
        var obj: alphaTab.importer.WedgeDrawObject = alphaTab.importer.WedgeDrawObject()
        obj.decrescendo = element.attributes.get("decrescendo") == "true"
        return obj
    }
    
    /**
     */
    private fun parseTupletBracket(element: alphaTab.xml.XmlNode): alphaTab.importer.TupletBracketDrawObject{
        var obj: alphaTab.importer.TupletBracketDrawObject = alphaTab.importer.TupletBracketDrawObject()
        if (element.attributes.has("number"))
        {
            obj.number = alphaTab.core.Globals.parseInt(element.attributes.get("number")!!)
        }
        return obj
    }
    
    /**
     */
    private fun parseWavyLine(_unused: alphaTab.xml.XmlNode): alphaTab.importer.WavyLineDrawObject{
        var obj: alphaTab.importer.WavyLineDrawObject = alphaTab.importer.WavyLineDrawObject()
        return obj
    }
    
    /**
     */
    private fun parseSlur(_unused: alphaTab.xml.XmlNode): alphaTab.importer.SlurDrawObject{
        var obj: alphaTab.importer.SlurDrawObject = alphaTab.importer.SlurDrawObject()
        return obj
    }
    
    /**
     */
    private fun parseGuitar(element: alphaTab.xml.XmlNode): alphaTab.importer.GuitarDrawObject{
        var obj: alphaTab.importer.GuitarDrawObject = alphaTab.importer.GuitarDrawObject()
        var strings: String = element.innerText.trim()
        if(true) {
            var i: Double = 0.0
            
            while(i < strings.length.toDouble()){
                try{
                    if (strings.charAt(i) == "/")
                    {
                        obj.chord.strings.push(0.0)
                    }
                    else 
                    {
                        obj.chord.strings.push(alphaTab.core.Globals.parseInt(strings.charAt(i)))
                    }
                }
                finally{
                    i++
                }
            }
        }
        return obj
    }
    
    /**
     */
    private fun parseText(element: alphaTab.xml.XmlNode): alphaTab.importer.TextDrawObject{
        var obj: alphaTab.importer.TextDrawObject = alphaTab.importer.TextDrawObject()
        if (element.attributes.has("x"))
        {
            obj.x = alphaTab.core.Globals.parseFloat(element.attributes.get("x")!!)
        }
        if (element.attributes.has("x"))
        {
            obj.y = alphaTab.core.Globals.parseFloat(element.attributes.get("y")!!)
        }
        when (element.getAttribute("align"))
        {
            "left" -> 
            {
                obj.align = alphaTab.platform.TextAlign.Left
            }
            "center" -> 
            {
                obj.align = alphaTab.platform.TextAlign.Center
            }
            "right" -> 
            {
                obj.align = alphaTab.platform.TextAlign.Right
            }
            else -> { }
        }
        when (element.getAttribute("frame"))
        {
            "rectangle" -> 
            {
                obj.frame = alphaTab.importer.FrameType.Rectangle
            }
            "ellipse" -> 
            {
                obj.frame = alphaTab.importer.FrameType.Ellipse
            }
            "circle" -> 
            {
                obj.frame = alphaTab.importer.FrameType.Circle
            }
            "none" -> 
            {
                obj.frame = alphaTab.importer.FrameType.None
            }
            else -> { }
        }
        if (alphaTab.core.TypeHelper.isTruthy(element.firstElement))
        {
            for (c in element.childNodes)
            {
                if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
                {
                    when (c.localName)
                    {
                        "font" -> 
                        {
                            obj.fontFace = c.getAttribute("face")
                            if (c.attributes.has("weight"))
                            {
                                obj.weight = alphaTab.core.Globals.parseInt(c.attributes.get("weight")!!)
                            }
                            if (c.attributes.has("height"))
                            {
                                obj.height = alphaTab.core.Globals.parseInt(c.attributes.get("height")!!)
                            }
                        }
                        "content" -> 
                        {
                            obj.text = c.innerText
                        }
                        else -> { }
                    }
                }
            }
        }
        else 
        {
            obj.text = element.innerText
        }
        return obj
    }
    
    /**
     */
    private fun parseInfo(element: alphaTab.xml.XmlNode): Unit{
        for (c in element.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "author" -> 
                    {
                        this.score.tab = c.firstChild!!.innerText
                    }
                    "comment" -> 
                    {
                        this.score.notices = c.firstChild!!.innerText
                    }
                    else -> { }
                }
            }
        }
    }
    
    companion object{
        /**
         */
        @kotlin.jvm.JvmStatic
        private fun <T>applyEffectRange(effects: alphaTab.collections.Map<alphaTab.model.Beat, T>, applyEffect: (arg1: T, arg2: alphaTab.model.Beat) -> Unit): Unit
            where T : alphaTab.importer.DrawObject{
            for ((startBeat, effect) in effects)
            {
                var noteRange: Double = effect.noteRange
                var endBeat: alphaTab.model.Beat = startBeat
                if(true) {
                    var i: Double = 0.0
                    
                    while(i < noteRange){
                        try{
                            applyEffect(effect, endBeat)
                            if (endBeat.index + 1.0 < endBeat.voice.beats.length)
                            {
                                endBeat = endBeat.voice.beats[(endBeat.index + 1.0).toInt()]
                            }
                            else if (endBeat.voice.bar.index + 1.0 < endBeat.voice.bar.staff.bars.length)
                            {
                                var nextBar: alphaTab.model.Bar = endBeat.voice.bar.staff.bars[(endBeat.voice.bar.index + 1.0).toInt()]
                                endBeat = nextBar.voices[(endBeat.voice.index).toInt()].beats[(0).toInt()]
                            }
                            else 
                            {
                                break
                            }
                        }
                        finally{
                            i++
                        }
                    }
                }
            }
        }
        
    }
    public constructor()
}

@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal open class DrawObject
{
    public var noteRange: Double = 1.0
    
    public var x: Double = 0.0
    
    public var y: Double = 0.0
    
    public constructor()
}

internal enum class FrameType(override val value: Int): alphaTab.core.IAlphaTabEnum
{
    None(0),
    Rectangle(1),
    Ellipse(2),
    Circle(3);
    companion object{
        public fun fromValue(v:Double): FrameType{
            return when(v.toInt()){
                None.value -> None
                Rectangle.value -> Rectangle
                Ellipse.value -> Ellipse
                Circle.value -> Circle
                else -> throw ClassCastException("No enum with value $v found")}
        }
    }
}

@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class TextDrawObject: alphaTab.importer.DrawObject
{
    public var align: alphaTab.platform.TextAlign = alphaTab.platform.TextAlign.Left
    
    public var frame: alphaTab.importer.FrameType = alphaTab.importer.FrameType.None
    
    public var text: String = ""
    
    public var fontFace: String = ""
    
    public var weight: Double = 0.0
    
    public var height: Double = 0.0
    
    public constructor()
}

@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class GuitarDrawObject: alphaTab.importer.DrawObject
{
    public var chord: alphaTab.model.Chord = alphaTab.model.Chord()
    
    public constructor()
}

@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class SlurDrawObject: alphaTab.importer.DrawObject
{
    public constructor()
}

@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class WavyLineDrawObject: alphaTab.importer.DrawObject
{
    public constructor()
}

@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class TupletBracketDrawObject: alphaTab.importer.DrawObject
{
    public var number: Double = 0.0
    
    public constructor()
}

@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class WedgeDrawObject: alphaTab.importer.DrawObject
{
    public var decrescendo: Boolean = false
    
    public constructor()
}

@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class VoltaDrawObject: alphaTab.importer.DrawObject
{
    public var allNumbers: Boolean = false
    
    public var firstNumber: Double = 0.0
    
    public var lastNumber: Double = 0.0
    
    public constructor()
}

@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class OctaveClefDrawObject: alphaTab.importer.DrawObject
{
    public var octave: Double = 1.0
    
    public constructor()
}

@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class TrillDrawObject: alphaTab.importer.DrawObject
{
    public constructor()
}

@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class StaffLayout
{
    public var defaultClef: alphaTab.model.Clef = alphaTab.model.Clef.G2
    
    public var description: String = ""
    
    public var percussion: Boolean = false
    
    public var instrument: Double = 0.0
    
    public var volume: Double = 0.0
    
    public var transpose: Double = 0.0
    
    public var index: Double = 0.0
    
    public constructor()
}

@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class Bracket
{
    public var from: Double = 0.0
    
    public var to: Double = 0.0
    
    public var curly: Boolean = false
    
    public constructor()
}

@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class CapellaVoiceState
{
    public var currentBarIndex: Double = -1.0
    
    public var currentBarComplete: Boolean = true
    
    public var currentBarDuration: Double = 0.0
    
    public var currentPosition: Double = 0.0
    
    public var voiceStemDir: alphaTab.rendering.utils.BeamDirection? = null
    
    public var repeatCount: Double = 0.0
    
    public var repeatEnd: alphaTab.model.MasterBar? = null
    
    public constructor()
}

