// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.importer
import alphaTab.core.*

@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class Gp3To5Importer: alphaTab.importer.ScoreImporter
{
    private var _versionNumber: Double = 0.0
    
    private lateinit var _score: alphaTab.model.Score
    
    private var _globalTripletFeel: alphaTab.model.TripletFeel = alphaTab.model.TripletFeel.NoTripletFeel
    
    private var _lyricsTrack: Double = 0.0
    
    private var _lyrics: alphaTab.collections.List<alphaTab.model.Lyrics> = alphaTab.collections.List<alphaTab.model.Lyrics>(
    )
    
    
    private var _barCount: Double = 0.0
    
    private var _trackCount: Double = 0.0
    
    private var _playbackInfos: alphaTab.collections.List<alphaTab.model.PlaybackInformation> = alphaTab.collections.List<alphaTab.model.PlaybackInformation>(
    )
    
    
    private var _beatTextChunksByTrack: alphaTab.collections.DoubleObjectMap<alphaTab.collections.List<String>> = alphaTab.collections.DoubleObjectMap<alphaTab.collections.List<String>>()
    
    public override val name: String
    get(){
        return "Guitar Pro 3-5"
    }
    
    public constructor()
        : super()
    /**
     * Reads the  contained in the data.
     */
    public override fun readScore(): alphaTab.model.Score{
        this.readVersion()
        this._score = alphaTab.model.Score()
        this.readScoreInformation()
        if (this._versionNumber < 500)
        {
            this._globalTripletFeel = if(alphaTab.importer.GpBinaryHelpers.gpReadBool(this.`data`))  alphaTab.model.TripletFeel.Triplet8th else alphaTab.model.TripletFeel.NoTripletFeel
        }
        if (this._versionNumber >= 400)
        {
            this.readLyrics()
        }
        if (this._versionNumber >= 510)
        {
            this.`data`.skip(19.0)
        }
        if (this._versionNumber >= 500)
        {
            this.readPageSetup()
            this._score.tempoLabel = alphaTab.importer.GpBinaryHelpers.gpReadStringIntByte(this.`data`, this.settings.importer.encoding)
        }
        this._score.tempo = alphaTab.io.IOHelper.readInt32LE(this.`data`)
        if (this._versionNumber >= 510)
        {
            alphaTab.importer.GpBinaryHelpers.gpReadBool(this.`data`)
        }
        alphaTab.io.IOHelper.readInt32LE(this.`data`)
        if (this._versionNumber >= 400)
        {
            this.`data`.readByte()
        }
        this.readPlaybackInfos()
        if (this._versionNumber >= 500)
        {
            this.`data`.skip(38.0)
            this.`data`.skip(4.0)
        }
        this._barCount = alphaTab.io.IOHelper.readInt32LE(this.`data`)
        this._trackCount = alphaTab.io.IOHelper.readInt32LE(this.`data`)
        this.readMasterBars()
        this.readTracks()
        this.readBars()
        if (this._score.masterBars.length > 0)
        {
            this._score.masterBars[(0).toInt()].tempoAutomation = alphaTab.model.Automation.buildTempoAutomation(false, 0.0, this._score.tempo, 2.0)
            this._score.masterBars[(0).toInt()].tempoAutomation!!.text = this._score.tempoLabel
        }
        this._score.finish(this.settings)
        if (alphaTab.core.TypeHelper.isTruthy(this._lyrics) && this._lyricsTrack >= 0)
        {
            this._score.tracks[(this._lyricsTrack).toInt()].applyLyrics(this._lyrics)
        }
        return this._score
    }
    
    public fun readVersion(): Unit{
        var version: String = alphaTab.importer.GpBinaryHelpers.gpReadStringByteLength(this.`data`, 30.0, this.settings.importer.encoding)
        if (!version.startsWith(alphaTab.importer.Gp3To5Importer.VersionString))
        {
            throw alphaTab.importer.UnsupportedFormatError("Unsupported format")
        }
        version = version.substr(alphaTab.importer.Gp3To5Importer.VersionString.length.toDouble() + 1.0)
        var dot: Double = version.indexOfInDouble(alphaTab.core.ecmaScript.CoreString.fromCharCode(46.0))
        this._versionNumber = 100.0 * alphaTab.core.Globals.parseInt(version.substr(0.0, dot)) + alphaTab.core.Globals.parseInt(version.substr(dot + 1.0))
        alphaTab.Logger.debug(this.name, "Guitar Pro version " + version + " detected")
    }
    
    public fun readScoreInformation(): Unit{
        this._score.title = alphaTab.importer.GpBinaryHelpers.gpReadStringIntUnused(this.`data`, this.settings.importer.encoding)
        this._score.subTitle = alphaTab.importer.GpBinaryHelpers.gpReadStringIntUnused(this.`data`, this.settings.importer.encoding)
        this._score.artist = alphaTab.importer.GpBinaryHelpers.gpReadStringIntUnused(this.`data`, this.settings.importer.encoding)
        this._score.album = alphaTab.importer.GpBinaryHelpers.gpReadStringIntUnused(this.`data`, this.settings.importer.encoding)
        this._score.words = alphaTab.importer.GpBinaryHelpers.gpReadStringIntUnused(this.`data`, this.settings.importer.encoding)
        this._score.music = if(this._versionNumber >= 500)  alphaTab.importer.GpBinaryHelpers.gpReadStringIntUnused(this.`data`, this.settings.importer.encoding) else this._score.words
        this._score.copyright = alphaTab.importer.GpBinaryHelpers.gpReadStringIntUnused(this.`data`, this.settings.importer.encoding)
        this._score.tab = alphaTab.importer.GpBinaryHelpers.gpReadStringIntUnused(this.`data`, this.settings.importer.encoding)
        this._score.instructions = alphaTab.importer.GpBinaryHelpers.gpReadStringIntUnused(this.`data`, this.settings.importer.encoding)
        var noticeLines: Double = alphaTab.io.IOHelper.readInt32LE(this.`data`)
        var notice: String = ""
        if(true) {
            var i: Double = 0.0
            
            while(i < noticeLines){
                try{
                    if (i > 0)
                    {
                        notice += "\r\n"
                    }
                    notice += alphaTab.importer.GpBinaryHelpers.gpReadStringIntUnused(this.`data`, this.settings.importer.encoding)?.toString()
                }
                finally{
                    i++
                }
            }
        }
        this._score.notices = notice
    }
    
    public fun readLyrics(): Unit{
        this._lyrics = alphaTab.collections.List<alphaTab.model.Lyrics>(
        )
        
        this._lyricsTrack = alphaTab.io.IOHelper.readInt32LE(this.`data`) - 1.0
        if(true) {
            var i: Double = 0.0
            
            while(i < 5){
                try{
                    var lyrics: alphaTab.model.Lyrics = alphaTab.model.Lyrics()
                    lyrics.startBar = alphaTab.io.IOHelper.readInt32LE(this.`data`) - 1.0
                    lyrics.text = alphaTab.importer.GpBinaryHelpers.gpReadStringInt(this.`data`, this.settings.importer.encoding)
                    this._lyrics.push(lyrics)
                }
                finally{
                    i++
                }
            }
        }
    }
    
    public fun readPageSetup(): Unit{
        this.`data`.skip(30.0)
        if(true) {
            var i: Double = 0.0
            
            while(i < 10){
                try{
                    alphaTab.importer.GpBinaryHelpers.gpReadStringIntByte(this.`data`, this.settings.importer.encoding)
                }
                finally{
                    i++
                }
            }
        }
    }
    
    public fun readPlaybackInfos(): Unit{
        this._playbackInfos = alphaTab.collections.List<alphaTab.model.PlaybackInformation>(
        )
        
        if(true) {
            var i: Double = 0.0
            
            while(i < 64){
                try{
                    var info: alphaTab.model.PlaybackInformation = alphaTab.model.PlaybackInformation()
                    info.primaryChannel = i
                    info.secondaryChannel = i
                    info.program = alphaTab.io.IOHelper.readInt32LE(this.`data`)
                    info.volume = this.`data`.readByte()
                    info.balance = this.`data`.readByte()
                    this.`data`.skip(6.0)
                    this._playbackInfos.push(info)
                }
                finally{
                    i++
                }
            }
        }
    }
    
    public fun readMasterBars(): Unit{
        if(true) {
            var i: Double = 0.0
            
            while(i < this._barCount){
                try{
                    this.readMasterBar()
                }
                finally{
                    i++
                }
            }
        }
    }
    
    public fun readMasterBar(): Unit{
        var previousMasterBar: alphaTab.model.MasterBar? = null
        if (this._score.masterBars.length > 0)
        {
            previousMasterBar = this._score.masterBars[(this._score.masterBars.length - 1.0).toInt()]
        }
        var newMasterBar: alphaTab.model.MasterBar = alphaTab.model.MasterBar()
        var flags: Double = this.`data`.readByte()
        if (((flags).toInt() and 1) != 0)
        {
            newMasterBar.timeSignatureNumerator = this.`data`.readByte()
        }
        else if (alphaTab.core.TypeHelper.isTruthy(previousMasterBar))
        {
            newMasterBar.timeSignatureNumerator = previousMasterBar.timeSignatureNumerator
        }
        if (((flags).toInt() and 2) != 0)
        {
            newMasterBar.timeSignatureDenominator = this.`data`.readByte()
        }
        else if (alphaTab.core.TypeHelper.isTruthy(previousMasterBar))
        {
            newMasterBar.timeSignatureDenominator = previousMasterBar.timeSignatureDenominator
        }
        newMasterBar.isRepeatStart = ((flags).toInt() and 4) != 0
        if (((flags).toInt() and 8) != 0)
        {
            newMasterBar.repeatCount = this.`data`.readByte() + (if(this._versionNumber >= 500)  0.0 else 1.0)
        }
        if (((flags).toInt() and 16) != 0 && this._versionNumber < 500)
        {
            var currentMasterBar: alphaTab.model.MasterBar? = previousMasterBar
            var existentAlternatives: Double = 0.0
            while (alphaTab.core.TypeHelper.isTruthy(currentMasterBar))
            {
                if (currentMasterBar.isRepeatEnd && currentMasterBar != previousMasterBar)
                {
                    break
                }
                if (currentMasterBar.isRepeatStart)
                {
                    break
                }
                existentAlternatives = ((existentAlternatives).toInt() or (currentMasterBar.alternateEndings).toInt()).toDouble()
                currentMasterBar = currentMasterBar.previousMasterBar
            }
            var repeatAlternative: Double = 0.0
            var repeatMask: Double = this.`data`.readByte()
            if(true) {
                var i: Double = 0.0
                
                while(i < 8){
                    try{
                        var repeating: Double = (1 shl (i).toInt()).toDouble()
                        if (repeatMask > i && ((existentAlternatives).toInt() and (repeating).toInt()) == 0)
                        {
                            repeatAlternative = ((repeatAlternative).toInt() or (repeating).toInt()).toDouble()
                        }
                    }
                    finally{
                        i++
                    }
                }
            }
            newMasterBar.alternateEndings = repeatAlternative
        }
        if (((flags).toInt() and 32) != 0)
        {
            var section: alphaTab.model.Section = alphaTab.model.Section()
            section.text = alphaTab.importer.GpBinaryHelpers.gpReadStringIntByte(this.`data`, this.settings.importer.encoding)
            section.marker = ""
            alphaTab.importer.GpBinaryHelpers.gpReadColor(this.`data`, false)
            newMasterBar.section = section
        }
        if (((flags).toInt() and 64) != 0)
        {
            newMasterBar.keySignature = alphaTab.model.KeySignature.fromValue(alphaTab.io.IOHelper.readSInt8(this.`data`))
            newMasterBar.keySignatureType = alphaTab.model.KeySignatureType.fromValue(this.`data`.readByte())
        }
        else if (alphaTab.core.TypeHelper.isTruthy(previousMasterBar))
        {
            newMasterBar.keySignature = previousMasterBar.keySignature
            newMasterBar.keySignatureType = previousMasterBar.keySignatureType
        }
        if (this._versionNumber >= 500 && ((flags).toInt() and 3) != 0)
        {
            this.`data`.skip(4.0)
        }
        if (this._versionNumber >= 500)
        {
            newMasterBar.alternateEndings = this.`data`.readByte()
        }
        if (this._versionNumber >= 500)
        {
            var tripletFeel: Double = this.`data`.readByte()
            when (tripletFeel)
            {
                1.0 -> 
                {
                    newMasterBar.tripletFeel = alphaTab.model.TripletFeel.Triplet8th
                }
                2.0 -> 
                {
                    newMasterBar.tripletFeel = alphaTab.model.TripletFeel.Triplet16th
                }
                else -> { }
            }
            this.`data`.readByte()
        }
        else 
        {
            newMasterBar.tripletFeel = this._globalTripletFeel
        }
        newMasterBar.isDoubleBar = ((flags).toInt() and 128) != 0
        this._score.addMasterBar(newMasterBar)
    }
    
    public fun readTracks(): Unit{
        if(true) {
            var i: Double = 0.0
            
            while(i < this._trackCount){
                try{
                    this.readTrack()
                }
                finally{
                    i++
                }
            }
        }
    }
    
    public fun readTrack(): Unit{
        var newTrack: alphaTab.model.Track = alphaTab.model.Track()
        newTrack.ensureStaveCount(1.0)
        this._score.addTrack(newTrack)
        var mainStaff: alphaTab.model.Staff = newTrack.staves[(0).toInt()]
        var flags: Double = this.`data`.readByte()
        newTrack.name = alphaTab.importer.GpBinaryHelpers.gpReadStringByteLength(this.`data`, 40.0, this.settings.importer.encoding)
        if (((flags).toInt() and 1) != 0)
        {
            mainStaff.isPercussion = true
        }
        var stringCount: Double = alphaTab.io.IOHelper.readInt32LE(this.`data`)
        var tuning: alphaTab.collections.DoubleList = alphaTab.collections.DoubleList(
        )
        
        if(true) {
            var i: Double = 0.0
            
            while(i < 7){
                try{
                    var stringTuning: Double = alphaTab.io.IOHelper.readInt32LE(this.`data`)
                    if (stringCount > i)
                    {
                        tuning.push(stringTuning)
                    }
                }
                finally{
                    i++
                }
            }
        }
        mainStaff.stringTuning.tunings = tuning
        var port: Double = alphaTab.io.IOHelper.readInt32LE(this.`data`)
        var index: Double = alphaTab.io.IOHelper.readInt32LE(this.`data`) - 1.0
        var effectChannel: Double = alphaTab.io.IOHelper.readInt32LE(this.`data`) - 1.0
        this.`data`.skip(4.0)
        if (index >= 0 && index < this._playbackInfos.length)
        {
            var info: alphaTab.model.PlaybackInformation = this._playbackInfos[(index).toInt()]
            info.port = port
            info.isSolo = ((flags).toInt() and 16) != 0
            info.isMute = ((flags).toInt() and 32) != 0
            info.secondaryChannel = effectChannel
            if (alphaTab.midi.GeneralMidi.isGuitar(info.program))
            {
                mainStaff.displayTranspositionPitch = -12.0
            }
            newTrack.playbackInfo = info
        }
        mainStaff.capo = alphaTab.io.IOHelper.readInt32LE(this.`data`)
        newTrack.color = alphaTab.importer.GpBinaryHelpers.gpReadColor(this.`data`, false)
        if (this._versionNumber >= 500)
        {
            this.`data`.readByte()
            this.`data`.readByte()
            this.`data`.skip(43.0)
        }
        if (this._versionNumber >= 510)
        {
            this.`data`.skip(4.0)
            alphaTab.importer.GpBinaryHelpers.gpReadStringIntByte(this.`data`, this.settings.importer.encoding)
            alphaTab.importer.GpBinaryHelpers.gpReadStringIntByte(this.`data`, this.settings.importer.encoding)
        }
    }
    
    public fun readBars(): Unit{
        if(true) {
            var i: Double = 0.0
            
            while(i < this._barCount){
                try{
                    if(true) {
                        var t: Double = 0.0
                        
                        while(t < this._trackCount){
                            try{
                                this.readBar(this._score.tracks[(t).toInt()])
                            }
                            finally{
                                t++
                            }
                        }
                    }
                }
                finally{
                    i++
                }
            }
        }
    }
    
    /**
     */
    public fun readBar(track: alphaTab.model.Track): Unit{
        var newBar: alphaTab.model.Bar = alphaTab.model.Bar()
        var mainStaff: alphaTab.model.Staff = track.staves[(0).toInt()]
        if (mainStaff.isPercussion)
        {
            newBar.clef = alphaTab.model.Clef.Neutral
        }
        mainStaff.addBar(newBar)
        var voiceCount: Double = 1.0
        if (this._versionNumber >= 500)
        {
            this.`data`.readByte()
            voiceCount = 2.0
        }
        if(true) {
            var v: Double = 0.0
            
            while(v < voiceCount){
                try{
                    this.readVoice(track, newBar)
                }
                finally{
                    v++
                }
            }
        }
    }
    
    /**
     */
    public fun readVoice(track: alphaTab.model.Track, bar: alphaTab.model.Bar): Unit{
        var beatCount: Double = alphaTab.io.IOHelper.readInt32LE(this.`data`)
        if (beatCount == 0.0)
        {
            return
        }
        var newVoice: alphaTab.model.Voice = alphaTab.model.Voice()
        bar.addVoice(newVoice)
        if(true) {
            var i: Double = 0.0
            
            while(i < beatCount){
                try{
                    this.readBeat(track, bar, newVoice)
                }
                finally{
                    i++
                }
            }
        }
    }
    
    /**
     */
    public fun readBeat(track: alphaTab.model.Track, bar: alphaTab.model.Bar, voice: alphaTab.model.Voice): Unit{
        var newBeat: alphaTab.model.Beat = alphaTab.model.Beat()
        var flags: Double = this.`data`.readByte()
        if (((flags).toInt() and 1) != 0)
        {
            newBeat.dots = 1.0
        }
        if (((flags).toInt() and 64) != 0)
        {
            var type: Double = this.`data`.readByte()
            newBeat.isEmpty = ((type).toInt() and 2) == 0
        }
        voice.addBeat(newBeat)
        var duration: Double = alphaTab.io.IOHelper.readSInt8(this.`data`)
        when (duration)
        {
            -2.0 -> 
            {
                newBeat.duration = alphaTab.model.Duration.Whole
            }
            -1.0 -> 
            {
                newBeat.duration = alphaTab.model.Duration.Half
            }
            0.0 -> 
            {
                newBeat.duration = alphaTab.model.Duration.Quarter
            }
            1.0 -> 
            {
                newBeat.duration = alphaTab.model.Duration.Eighth
            }
            2.0 -> 
            {
                newBeat.duration = alphaTab.model.Duration.Sixteenth
            }
            3.0 -> 
            {
                newBeat.duration = alphaTab.model.Duration.ThirtySecond
            }
            4.0 -> 
            {
                newBeat.duration = alphaTab.model.Duration.SixtyFourth
            }
            else -> 
            {
                newBeat.duration = alphaTab.model.Duration.Quarter
            }
        }
        if (((flags).toInt() and 32) != 0)
        {
            newBeat.tupletNumerator = alphaTab.io.IOHelper.readInt32LE(this.`data`)
            when (newBeat.tupletNumerator)
            {
                1.0 -> 
                {
                    newBeat.tupletDenominator = 1.0
                }
                3.0 -> 
                {
                    newBeat.tupletDenominator = 2.0
                }
                5.0, 6.0, 7.0 -> 
                {
                    newBeat.tupletDenominator = 4.0
                }
                9.0, 10.0, 11.0, 12.0, 13.0 -> 
                {
                    newBeat.tupletDenominator = 8.0
                }
                2.0, 4.0, 8.0 -> 
                {
                }
                else -> 
                {
                    newBeat.tupletNumerator = 1.0
                    newBeat.tupletDenominator = 1.0
                }
            }
        }
        if (((flags).toInt() and 2) != 0)
        {
            this.readChord(newBeat)
        }
        var beatTextAsLyrics: Boolean = this.settings.importer.beatTextAsLyrics && track.index != this._lyricsTrack
        if (((flags).toInt() and 4) != 0)
        {
            var text: String = alphaTab.importer.GpBinaryHelpers.gpReadStringIntUnused(this.`data`, this.settings.importer.encoding)
            if (beatTextAsLyrics)
            {
                var lyrics: alphaTab.model.Lyrics = alphaTab.model.Lyrics()
                lyrics.text = text.trim()
                lyrics.finish(true)
                var beatLyrics: alphaTab.collections.List<String> = alphaTab.collections.List<String>(
                )
                
                if(true) {
                    var i: Double = lyrics.chunks.length - 1.0
                    
                    while(i >= 0){
                        try{
                            beatLyrics.push(lyrics.chunks[(i).toInt()])
                        }
                        finally{
                            i--
                        }
                    }
                }
                this._beatTextChunksByTrack.set(track.index, beatLyrics)
            }
            else 
            {
                newBeat.text = text
            }
        }
        var allNoteHarmonicType: alphaTab.model.HarmonicType = alphaTab.model.HarmonicType.None
        if (((flags).toInt() and 8) != 0)
        {
            allNoteHarmonicType = this.readBeatEffects(newBeat)
        }
        if (((flags).toInt() and 16) != 0)
        {
            this.readMixTableChange(newBeat)
        }
        var stringFlags: Double = this.`data`.readByte()
        if(true) {
            var i: Double = 6.0
            
            while(i >= 0){
                try{
                    if (((stringFlags).toInt() and (1 shl (i).toInt())) != 0 && 6.0 - i < bar.staff.tuning.length)
                    {
                        var note: alphaTab.model.Note = this.readNote(track, bar, voice, newBeat, 6.0 - i)
                        if (allNoteHarmonicType != alphaTab.model.HarmonicType.None)
                        {
                            note.harmonicType = allNoteHarmonicType
                            if (note.harmonicType == alphaTab.model.HarmonicType.Natural)
                            {
                                note.harmonicValue = this.deltaFretToHarmonicValue(note.fret)
                            }
                        }
                    }
                }
                finally{
                    i--
                }
            }
        }
        if (this._versionNumber >= 500)
        {
            this.`data`.readByte()
            var flag: Double = this.`data`.readByte()
            if (((flag).toInt() and 8) != 0)
            {
                this.`data`.readByte()
            }
        }
        if (beatTextAsLyrics && !newBeat.isRest && this._beatTextChunksByTrack.has(track.index) && this._beatTextChunksByTrack.get(track.index)!!.length > 0)
        {
            newBeat.lyrics = alphaTab.collections.List(
                this._beatTextChunksByTrack.get(track.index)!!.pop()!!)
            
        }
    }
    
    /**
     */
    public fun readChord(beat: alphaTab.model.Beat): Unit{
        var chord: alphaTab.model.Chord = alphaTab.model.Chord()
        var chordId: String = alphaTab.model.ModelUtils.newGuid()
        if (this._versionNumber >= 500)
        {
            this.`data`.skip(17.0)
            chord.name = alphaTab.importer.GpBinaryHelpers.gpReadStringByteLength(this.`data`, 21.0, this.settings.importer.encoding)
            this.`data`.skip(4.0)
            chord.firstFret = alphaTab.io.IOHelper.readInt32LE(this.`data`)
            if(true) {
                var i: Double = 0.0
                
                while(i < 7){
                    try{
                        var fret: Double = alphaTab.io.IOHelper.readInt32LE(this.`data`)
                        if (i < beat.voice.bar.staff.tuning.length)
                        {
                            chord.strings.push(fret)
                        }
                    }
                    finally{
                        i++
                    }
                }
            }
            var numberOfBarres: Double = this.`data`.readByte()
            var barreFrets: alphaTab.core.ecmaScript.Uint8Array = alphaTab.core.ecmaScript.Uint8Array(5.0)
            this.`data`.read(barreFrets, 0.0, barreFrets.length)
            if(true) {
                var i: Double = 0.0
                
                while(i < numberOfBarres){
                    try{
                        chord.barreFrets.push(barreFrets[(i).toInt()])
                    }
                    finally{
                        i++
                    }
                }
            }
            this.`data`.skip(26.0)
        }
        else 
        {
            if (this.`data`.readByte() != 0.0)
            {
                if (this._versionNumber >= 400)
                {
                    this.`data`.skip(16.0)
                    chord.name = alphaTab.importer.GpBinaryHelpers.gpReadStringByteLength(this.`data`, 21.0, this.settings.importer.encoding)
                    this.`data`.skip(4.0)
                    chord.firstFret = alphaTab.io.IOHelper.readInt32LE(this.`data`)
                    if(true) {
                        var i: Double = 0.0
                        
                        while(i < 7){
                            try{
                                var fret: Double = alphaTab.io.IOHelper.readInt32LE(this.`data`)
                                if (i < beat.voice.bar.staff.tuning.length)
                                {
                                    chord.strings.push(fret)
                                }
                            }
                            finally{
                                i++
                            }
                        }
                    }
                    var numberOfBarres: Double = this.`data`.readByte()
                    var barreFrets: alphaTab.core.ecmaScript.Uint8Array = alphaTab.core.ecmaScript.Uint8Array(5.0)
                    this.`data`.read(barreFrets, 0.0, barreFrets.length)
                    if(true) {
                        var i: Double = 0.0
                        
                        while(i < numberOfBarres){
                            try{
                                chord.barreFrets.push(barreFrets[(i).toInt()])
                            }
                            finally{
                                i++
                            }
                        }
                    }
                    this.`data`.skip(26.0)
                }
                else 
                {
                    this.`data`.skip(25.0)
                    chord.name = alphaTab.importer.GpBinaryHelpers.gpReadStringByteLength(this.`data`, 34.0, this.settings.importer.encoding)
                    chord.firstFret = alphaTab.io.IOHelper.readInt32LE(this.`data`)
                    if(true) {
                        var i: Double = 0.0
                        
                        while(i < 6){
                            try{
                                var fret: Double = alphaTab.io.IOHelper.readInt32LE(this.`data`)
                                if (i < beat.voice.bar.staff.tuning.length)
                                {
                                    chord.strings.push(fret)
                                }
                            }
                            finally{
                                i++
                            }
                        }
                    }
                    this.`data`.skip(36.0)
                }
            }
            else 
            {
                var strings: Double = if(this._versionNumber >= 406)  7.0 else 6.0
                chord.name = alphaTab.importer.GpBinaryHelpers.gpReadStringIntByte(this.`data`, this.settings.importer.encoding)
                chord.firstFret = alphaTab.io.IOHelper.readInt32LE(this.`data`)
                if (chord.firstFret > 0)
                {
                    if(true) {
                        var i: Double = 0.0
                        
                        while(i < strings){
                            try{
                                var fret: Double = alphaTab.io.IOHelper.readInt32LE(this.`data`)
                                if (i < beat.voice.bar.staff.tuning.length)
                                {
                                    chord.strings.push(fret)
                                }
                            }
                            finally{
                                i++
                            }
                        }
                    }
                }
            }
        }
        if (alphaTab.core.TypeHelper.isTruthy(chord.name))
        {
            beat.chordId = chordId
            beat.voice.bar.staff.addChord(beat.chordId!!, chord)
        }
    }
    
    /**
     */
    public fun readBeatEffects(beat: alphaTab.model.Beat): alphaTab.model.HarmonicType{
        var flags: Double = this.`data`.readByte()
        var flags2: Double = 0.0
        if (this._versionNumber >= 400)
        {
            flags2 = this.`data`.readByte()
        }
        beat.fadeIn = ((flags).toInt() and 16) != 0
        if ((this._versionNumber < 400 && ((flags).toInt() and 1) != 0) || ((flags).toInt() and 2) != 0)
        {
            beat.vibrato = alphaTab.model.VibratoType.Slight
        }
        beat.hasRasgueado = ((flags2).toInt() and 1) != 0
        if (((flags).toInt() and 32) != 0 && this._versionNumber >= 400)
        {
            var slapPop: Double = alphaTab.io.IOHelper.readSInt8(this.`data`)
            when (slapPop)
            {
                1.0 -> 
                {
                    beat.tap = true
                }
                2.0 -> 
                {
                    beat.slap = true
                }
                3.0 -> 
                {
                    beat.pop = true
                }
                else -> { }
            }
        }
        else if (((flags).toInt() and 32) != 0)
        {
            var slapPop: Double = alphaTab.io.IOHelper.readSInt8(this.`data`)
            when (slapPop)
            {
                1.0 -> 
                {
                    beat.tap = true
                }
                2.0 -> 
                {
                    beat.slap = true
                }
                3.0 -> 
                {
                    beat.pop = true
                }
                else -> { }
            }
            this.`data`.skip(4.0)
        }
        if (((flags2).toInt() and 4) != 0)
        {
            this.readTremoloBarEffect(beat)
        }
        if (((flags).toInt() and 64) != 0)
        {
            var strokeUp: Double = 0.0
            var strokeDown: Double = 0.0
            if (this._versionNumber < 500)
            {
                strokeDown = this.`data`.readByte()
                strokeUp = this.`data`.readByte()
            }
            else 
            {
                strokeUp = this.`data`.readByte()
                strokeDown = this.`data`.readByte()
            }
            if (strokeUp > 0)
            {
                beat.brushType = alphaTab.model.BrushType.BrushUp
                beat.brushDuration = alphaTab.importer.Gp3To5Importer.toStrokeValue(strokeUp)
            }
            else if (strokeDown > 0)
            {
                beat.brushType = alphaTab.model.BrushType.BrushDown
                beat.brushDuration = alphaTab.importer.Gp3To5Importer.toStrokeValue(strokeDown)
            }
        }
        if (((flags2).toInt() and 2) != 0)
        {
            when (alphaTab.io.IOHelper.readSInt8(this.`data`))
            {
                0.0 -> 
                {
                    beat.pickStroke = alphaTab.model.PickStroke.None
                }
                1.0 -> 
                {
                    beat.pickStroke = alphaTab.model.PickStroke.Up
                }
                2.0 -> 
                {
                    beat.pickStroke = alphaTab.model.PickStroke.Down
                }
                else -> { }
            }
        }
        if (this._versionNumber < 400)
        {
            if (((flags).toInt() and 4) != 0)
            {
                return alphaTab.model.HarmonicType.Natural
            }
            else if (((flags).toInt() and 8) != 0)
            {
                return alphaTab.model.HarmonicType.Artificial
            }
        }
        return alphaTab.model.HarmonicType.None
    }
    
    /**
     */
    public fun readTremoloBarEffect(beat: alphaTab.model.Beat): Unit{
        this.`data`.readByte()
        alphaTab.io.IOHelper.readInt32LE(this.`data`)
        var pointCount: Double = alphaTab.io.IOHelper.readInt32LE(this.`data`)
        if (pointCount > 0)
        {
            if(true) {
                var i: Double = 0.0
                
                while(i < pointCount){
                    try{
                        var point: alphaTab.model.BendPoint = alphaTab.model.BendPoint(0.0, 0.0)
                        point.offset = alphaTab.io.IOHelper.readInt32LE(this.`data`)
                        point.value = (((alphaTab.io.IOHelper.readInt32LE(this.`data`) / alphaTab.importer.Gp3To5Importer.BendStep)).toInt() or 0).toDouble()
                        alphaTab.importer.GpBinaryHelpers.gpReadBool(this.`data`)
                        beat.addWhammyBarPoint(point)
                    }
                    finally{
                        i++
                    }
                }
            }
        }
    }
    
    /**
     */
    public fun readMixTableChange(beat: alphaTab.model.Beat): Unit{
        var tableChange: alphaTab.importer.MixTableChange = alphaTab.importer.MixTableChange()
        tableChange.instrument = alphaTab.io.IOHelper.readSInt8(this.`data`)
        if (this._versionNumber >= 500)
        {
            this.`data`.skip(16.0)
        }
        tableChange.volume = alphaTab.io.IOHelper.readSInt8(this.`data`)
        tableChange.balance = alphaTab.io.IOHelper.readSInt8(this.`data`)
        var chorus: Double = alphaTab.io.IOHelper.readSInt8(this.`data`)
        var reverb: Double = alphaTab.io.IOHelper.readSInt8(this.`data`)
        var phaser: Double = alphaTab.io.IOHelper.readSInt8(this.`data`)
        var tremolo: Double = alphaTab.io.IOHelper.readSInt8(this.`data`)
        if (this._versionNumber >= 500)
        {
            tableChange.tempoName = alphaTab.importer.GpBinaryHelpers.gpReadStringIntByte(this.`data`, this.settings.importer.encoding)
        }
        tableChange.tempo = alphaTab.io.IOHelper.readInt32LE(this.`data`)
        if (tableChange.volume >= 0)
        {
            this.`data`.readByte()
        }
        if (tableChange.balance >= 0)
        {
            this.`data`.readByte()
        }
        if (chorus >= 0)
        {
            this.`data`.readByte()
        }
        if (reverb >= 0)
        {
            this.`data`.readByte()
        }
        if (phaser >= 0)
        {
            this.`data`.readByte()
        }
        if (tremolo >= 0)
        {
            this.`data`.readByte()
        }
        if (tableChange.tempo >= 0)
        {
            tableChange.duration = alphaTab.io.IOHelper.readSInt8(this.`data`)
            if (this._versionNumber >= 510)
            {
                this.`data`.readByte()
            }
        }
        if (this._versionNumber >= 400)
        {
            this.`data`.readByte()
        }
        if (this._versionNumber >= 500)
        {
            this.`data`.readByte()
        }
        if (this._versionNumber >= 510)
        {
            alphaTab.importer.GpBinaryHelpers.gpReadStringIntByte(this.`data`, this.settings.importer.encoding)
            alphaTab.importer.GpBinaryHelpers.gpReadStringIntByte(this.`data`, this.settings.importer.encoding)
        }
        if (tableChange.volume >= 0)
        {
            var volumeAutomation: alphaTab.model.Automation = alphaTab.model.Automation()
            volumeAutomation.isLinear = true
            volumeAutomation.type = alphaTab.model.AutomationType.Volume
            volumeAutomation.value = tableChange.volume
            beat.automations.push(volumeAutomation)
        }
        if (tableChange.balance >= 0)
        {
            var balanceAutomation: alphaTab.model.Automation = alphaTab.model.Automation()
            balanceAutomation.isLinear = true
            balanceAutomation.type = alphaTab.model.AutomationType.Balance
            balanceAutomation.value = tableChange.balance
            beat.automations.push(balanceAutomation)
        }
        if (tableChange.instrument >= 0)
        {
            var instrumentAutomation: alphaTab.model.Automation = alphaTab.model.Automation()
            instrumentAutomation.isLinear = true
            instrumentAutomation.type = alphaTab.model.AutomationType.Instrument
            instrumentAutomation.value = tableChange.instrument
            beat.automations.push(instrumentAutomation)
        }
        if (tableChange.tempo >= 0)
        {
            var tempoAutomation: alphaTab.model.Automation = alphaTab.model.Automation()
            tempoAutomation.isLinear = true
            tempoAutomation.type = alphaTab.model.AutomationType.Tempo
            tempoAutomation.value = tableChange.tempo
            beat.automations.push(tempoAutomation)
            beat.voice.bar.masterBar.tempoAutomation = tempoAutomation
        }
    }
    
    /**
     */
    public fun readNote(track: alphaTab.model.Track, bar: alphaTab.model.Bar, voice: alphaTab.model.Voice, beat: alphaTab.model.Beat, stringIndex: Double): alphaTab.model.Note{
        var newNote: alphaTab.model.Note = alphaTab.model.Note()
        newNote.string = bar.staff.tuning.length - stringIndex
        var flags: Double = this.`data`.readByte()
        if (((flags).toInt() and 2) != 0)
        {
            newNote.accentuated = alphaTab.model.AccentuationType.Heavy
        }
        else if (((flags).toInt() and 64) != 0)
        {
            newNote.accentuated = alphaTab.model.AccentuationType.Normal
        }
        newNote.isGhost = ((flags).toInt() and 4) != 0
        if (((flags).toInt() and 32) != 0)
        {
            var noteType: Double = this.`data`.readByte()
            if (noteType == 3.0)
            {
                newNote.isDead = true
            }
            else if (noteType == 2.0)
            {
                newNote.isTieDestination = true
            }
        }
        if (((flags).toInt() and 1) != 0 && this._versionNumber < 500)
        {
            this.`data`.readByte()
            this.`data`.readByte()
        }
        if (((flags).toInt() and 16) != 0)
        {
            var dynamicNumber: Double = alphaTab.io.IOHelper.readSInt8(this.`data`)
            newNote.dynamics = this.toDynamicValue(dynamicNumber)
            beat.dynamics = newNote.dynamics
        }
        if (((flags).toInt() and 32) != 0)
        {
            newNote.fret = alphaTab.io.IOHelper.readSInt8(this.`data`)
        }
        if (((flags).toInt() and 128) != 0)
        {
            newNote.leftHandFinger = alphaTab.model.Fingers.fromValue(alphaTab.io.IOHelper.readSInt8(this.`data`))
            newNote.rightHandFinger = alphaTab.model.Fingers.fromValue(alphaTab.io.IOHelper.readSInt8(this.`data`))
            newNote.isFingering = true
        }
        var swapAccidentals: Boolean = false
        if (this._versionNumber >= 500)
        {
            if (((flags).toInt() and 1) != 0)
            {
                newNote.durationPercent = alphaTab.importer.GpBinaryHelpers.gpReadDouble(this.`data`)
            }
            var flags2: Double = this.`data`.readByte()
            swapAccidentals = ((flags2).toInt() and 2) != 0
        }
        beat.addNote(newNote)
        if (((flags).toInt() and 8) != 0)
        {
            this.readNoteEffects(track, voice, beat, newNote)
        }
        if (bar.staff.isPercussion)
        {
            newNote.percussionArticulation = newNote.fret
            newNote.string = -1.0
            newNote.fret = -1.0
        }
        if (swapAccidentals)
        {
            var accidental: String = alphaTab.model.Tuning.defaultAccidentals[(newNote.realValueWithoutHarmonic % 12.0).toInt()]
            if (accidental == "#")
            {
                newNote.accidentalMode = alphaTab.model.NoteAccidentalMode.ForceFlat
            }
            else if (accidental == "b")
            {
                newNote.accidentalMode = alphaTab.model.NoteAccidentalMode.ForceSharp
            }
        }
        return newNote
    }
    
    /**
     */
    public fun toDynamicValue(value: Double): alphaTab.model.DynamicValue{
        when (value)
        {
            1.0 -> 
            {
                return alphaTab.model.DynamicValue.PPP
            }
            2.0 -> 
            {
                return alphaTab.model.DynamicValue.PP
            }
            3.0 -> 
            {
                return alphaTab.model.DynamicValue.P
            }
            4.0 -> 
            {
                return alphaTab.model.DynamicValue.MP
            }
            5.0 -> 
            {
                return alphaTab.model.DynamicValue.MF
            }
            6.0 -> 
            {
                return alphaTab.model.DynamicValue.F
            }
            7.0 -> 
            {
                return alphaTab.model.DynamicValue.FF
            }
            8.0 -> 
            {
                return alphaTab.model.DynamicValue.FFF
            }
            else -> 
            {
                return alphaTab.model.DynamicValue.F
            }
        }
    }
    
    /**
     */
    public fun readNoteEffects(track: alphaTab.model.Track, voice: alphaTab.model.Voice, beat: alphaTab.model.Beat, note: alphaTab.model.Note): Unit{
        var flags: Double = this.`data`.readByte()
        var flags2: Double = 0.0
        if (this._versionNumber >= 400)
        {
            flags2 = this.`data`.readByte()
        }
        if (((flags).toInt() and 1) != 0)
        {
            this.readBend(note)
        }
        if (((flags).toInt() and 16) != 0)
        {
            this.readGrace(voice, note)
        }
        if (((flags2).toInt() and 4) != 0)
        {
            this.readTremoloPicking(beat)
        }
        if (((flags2).toInt() and 8) != 0)
        {
            this.readSlide(note)
        }
        else if (this._versionNumber < 400)
        {
            if (((flags).toInt() and 4) != 0)
            {
                note.slideOutType = alphaTab.model.SlideOutType.Shift
            }
        }
        if (((flags2).toInt() and 16) != 0)
        {
            this.readArtificialHarmonic(note)
        }
        if (((flags2).toInt() and 32) != 0)
        {
            this.readTrill(note)
        }
        note.isLetRing = ((flags).toInt() and 8) != 0
        note.isHammerPullOrigin = ((flags).toInt() and 2) != 0
        if (((flags2).toInt() and 64) != 0)
        {
            note.vibrato = alphaTab.model.VibratoType.Slight
        }
        note.isPalmMute = ((flags2).toInt() and 2) != 0
        note.isStaccato = ((flags2).toInt() and 1) != 0
    }
    
    /**
     */
    public fun readBend(note: alphaTab.model.Note): Unit{
        this.`data`.readByte()
        alphaTab.io.IOHelper.readInt32LE(this.`data`)
        var pointCount: Double = alphaTab.io.IOHelper.readInt32LE(this.`data`)
        if (pointCount > 0)
        {
            if(true) {
                var i: Double = 0.0
                
                while(i < pointCount){
                    try{
                        var point: alphaTab.model.BendPoint = alphaTab.model.BendPoint(0.0, 0.0)
                        point.offset = alphaTab.io.IOHelper.readInt32LE(this.`data`)
                        point.value = (((alphaTab.io.IOHelper.readInt32LE(this.`data`) / alphaTab.importer.Gp3To5Importer.BendStep)).toInt() or 0).toDouble()
                        alphaTab.importer.GpBinaryHelpers.gpReadBool(this.`data`)
                        note.addBendPoint(point)
                    }
                    finally{
                        i++
                    }
                }
            }
        }
    }
    
    /**
     */
    public fun readGrace(voice: alphaTab.model.Voice, note: alphaTab.model.Note): Unit{
        var graceBeat: alphaTab.model.Beat = alphaTab.model.Beat()
        var graceNote: alphaTab.model.Note = alphaTab.model.Note()
        graceNote.string = note.string
        graceNote.fret = alphaTab.io.IOHelper.readSInt8(this.`data`)
        graceBeat.duration = alphaTab.model.Duration.ThirtySecond
        graceBeat.dynamics = this.toDynamicValue(alphaTab.io.IOHelper.readSInt8(this.`data`))
        var transition: Double = alphaTab.io.IOHelper.readSInt8(this.`data`)
        when (transition)
        {
            0.0 -> 
            {
            }
            1.0 -> 
            {
                graceNote.slideOutType = alphaTab.model.SlideOutType.Legato
                graceNote.slideTarget = note
            }
            2.0 -> 
            {
            }
            3.0 -> 
            {
                graceNote.isHammerPullOrigin = true
            }
            else -> { }
        }
        graceNote.dynamics = graceBeat.dynamics
        this.`data`.skip(1.0)
        if (this._versionNumber < 500)
        {
            graceBeat.graceType = alphaTab.model.GraceType.BeforeBeat
        }
        else 
        {
            var flags: Double = this.`data`.readByte()
            graceNote.isDead = ((flags).toInt() and 1) != 0
            graceBeat.graceType = if(((flags).toInt() and 2) != 0)  alphaTab.model.GraceType.OnBeat else alphaTab.model.GraceType.BeforeBeat
        }
        voice.addGraceBeat(graceBeat)
        graceBeat.addNote(graceNote)
    }
    
    /**
     */
    public fun readTremoloPicking(beat: alphaTab.model.Beat): Unit{
        var speed: Double = this.`data`.readByte()
        when (speed)
        {
            1.0 -> 
            {
                beat.tremoloSpeed = alphaTab.model.Duration.Eighth
            }
            2.0 -> 
            {
                beat.tremoloSpeed = alphaTab.model.Duration.Sixteenth
            }
            3.0 -> 
            {
                beat.tremoloSpeed = alphaTab.model.Duration.ThirtySecond
            }
            else -> { }
        }
    }
    
    /**
     */
    public fun readSlide(note: alphaTab.model.Note): Unit{
        if (this._versionNumber >= 500)
        {
            var type: Double = alphaTab.io.IOHelper.readSInt8(this.`data`)
            if (((type).toInt() and 1) != 0)
            {
                note.slideOutType = alphaTab.model.SlideOutType.Shift
            }
            else if (((type).toInt() and 2) != 0)
            {
                note.slideOutType = alphaTab.model.SlideOutType.Legato
            }
            else if (((type).toInt() and 4) != 0)
            {
                note.slideOutType = alphaTab.model.SlideOutType.OutDown
            }
            else if (((type).toInt() and 8) != 0)
            {
                note.slideOutType = alphaTab.model.SlideOutType.OutUp
            }
            if (((type).toInt() and 16) != 0)
            {
                note.slideInType = alphaTab.model.SlideInType.IntoFromBelow
            }
            else if (((type).toInt() and 32) != 0)
            {
                note.slideInType = alphaTab.model.SlideInType.IntoFromAbove
            }
        }
        else 
        {
            var type: Double = alphaTab.io.IOHelper.readSInt8(this.`data`)
            when (type)
            {
                1.0 -> 
                {
                    note.slideOutType = alphaTab.model.SlideOutType.Shift
                }
                2.0 -> 
                {
                    note.slideOutType = alphaTab.model.SlideOutType.Legato
                }
                3.0 -> 
                {
                    note.slideOutType = alphaTab.model.SlideOutType.OutDown
                }
                4.0 -> 
                {
                    note.slideOutType = alphaTab.model.SlideOutType.OutUp
                }
                -1.0 -> 
                {
                    note.slideInType = alphaTab.model.SlideInType.IntoFromBelow
                }
                -2.0 -> 
                {
                    note.slideInType = alphaTab.model.SlideInType.IntoFromAbove
                }
                else -> { }
            }
        }
    }
    
    /**
     */
    public fun readArtificialHarmonic(note: alphaTab.model.Note): Unit{
        var type: Double = this.`data`.readByte()
        if (this._versionNumber >= 500)
        {
            when (type)
            {
                1.0 -> 
                {
                    note.harmonicType = alphaTab.model.HarmonicType.Natural
                    note.harmonicValue = this.deltaFretToHarmonicValue(note.fret)
                }
                2.0 -> 
                {
                    this.`data`.readByte()
                    this.`data`.readByte()
                    this.`data`.readByte()
                    note.harmonicType = alphaTab.model.HarmonicType.Artificial
                }
                3.0 -> 
                {
                    note.harmonicType = alphaTab.model.HarmonicType.Tap
                    note.harmonicValue = this.deltaFretToHarmonicValue(this.`data`.readByte())
                }
                4.0 -> 
                {
                    note.harmonicType = alphaTab.model.HarmonicType.Pinch
                    note.harmonicValue = 12.0
                }
                5.0 -> 
                {
                    note.harmonicType = alphaTab.model.HarmonicType.Semi
                    note.harmonicValue = 12.0
                }
                else -> { }
            }
        }
        else if (this._versionNumber >= 400)
        {
            when (type)
            {
                1.0 -> 
                {
                    note.harmonicType = alphaTab.model.HarmonicType.Natural
                }
                3.0 -> 
                {
                    note.harmonicType = alphaTab.model.HarmonicType.Tap
                }
                4.0 -> 
                {
                    note.harmonicType = alphaTab.model.HarmonicType.Pinch
                }
                5.0 -> 
                {
                    note.harmonicType = alphaTab.model.HarmonicType.Semi
                }
                15.0 -> 
                {
                    note.harmonicType = alphaTab.model.HarmonicType.Artificial
                }
                17.0 -> 
                {
                    note.harmonicType = alphaTab.model.HarmonicType.Artificial
                }
                22.0 -> 
                {
                    note.harmonicType = alphaTab.model.HarmonicType.Artificial
                }
                else -> { }
            }
        }
    }
    
    /**
     */
    public fun deltaFretToHarmonicValue(deltaFret: Double): Double{
        when (deltaFret)
        {
            2.0 -> 
            {
                return 2.4
            }
            3.0 -> 
            {
                return 3.2
            }
            4.0, 5.0, 7.0, 9.0, 12.0, 16.0, 17.0, 19.0, 24.0 -> 
            {
                return deltaFret
            }
            8.0 -> 
            {
                return 8.2
            }
            10.0 -> 
            {
                return 9.6
            }
            14.0, 15.0 -> 
            {
                return 14.7
            }
            21.0, 22.0 -> 
            {
                return 21.7
            }
            else -> 
            {
                return 12.0
            }
        }
    }
    
    /**
     */
    public fun readTrill(note: alphaTab.model.Note): Unit{
        note.trillValue = this.`data`.readByte() + note.stringTuning
        when (this.`data`.readByte())
        {
            1.0 -> 
            {
                note.trillSpeed = alphaTab.model.Duration.Sixteenth
            }
            2.0 -> 
            {
                note.trillSpeed = alphaTab.model.Duration.ThirtySecond
            }
            3.0 -> 
            {
                note.trillSpeed = alphaTab.model.Duration.SixtyFourth
            }
            else -> { }
        }
    }
    
    companion object{
        @kotlin.jvm.JvmStatic
        private val VersionString: String = "FICHIER GUITAR PRO "
        
        /**
         */
        @kotlin.jvm.JvmStatic
        private fun toStrokeValue(value: Double): Double{
            when (value)
            {
                1.0 -> 
                {
                    return 30.0
                }
                2.0 -> 
                {
                    return 30.0
                }
                3.0 -> 
                {
                    return 60.0
                }
                4.0 -> 
                {
                    return 120.0
                }
                5.0 -> 
                {
                    return 240.0
                }
                6.0 -> 
                {
                    return 480.0
                }
                else -> 
                {
                    return 0.0
                }
            }
        }
        
        @kotlin.jvm.JvmStatic
        private val BendStep: Double = 25.0
        
    }
}

@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class GpBinaryHelpers
{
    companion object{
        /**
         */
        @kotlin.jvm.JvmStatic
        public fun gpReadDouble(`data`: alphaTab.io.IReadable): Double{
            var bytes: alphaTab.core.ecmaScript.Uint8Array = alphaTab.core.ecmaScript.Uint8Array(8.0)
            `data`.read(bytes, 0.0, bytes.length)
            var array: alphaTab.core.ecmaScript.Float64Array = alphaTab.core.ecmaScript.Float64Array(bytes.buffer)
            return array[(0).toInt()]
        }
        
        /**
         */
        @kotlin.jvm.JvmStatic
        public fun gpReadFloat(`data`: alphaTab.io.IReadable): Double{
            var bytes: alphaTab.core.ecmaScript.Uint8Array = alphaTab.core.ecmaScript.Uint8Array(4.0)
            bytes[(3).toInt()] = `data`.readByte()
            bytes[(2).toInt()] = `data`.readByte()
            bytes[(2).toInt()] = `data`.readByte()
            bytes[(1).toInt()] = `data`.readByte()
            var array: alphaTab.core.ecmaScript.Float32Array = alphaTab.core.ecmaScript.Float32Array(bytes.buffer)
            return array[(0).toInt()]
        }
        
        /**
         */
        @kotlin.jvm.JvmStatic
        public fun gpReadColor(`data`: alphaTab.io.IReadable, readAlpha: Boolean = false): alphaTab.model.Color{
            var r: Double = `data`.readByte()
            var g: Double = `data`.readByte()
            var b: Double = `data`.readByte()
            var a: Double = 255.0
            if (readAlpha)
            {
                a = `data`.readByte()
            }
            else 
            {
                `data`.skip(1.0)
            }
            return alphaTab.model.Color(r, g, b, a)
        }
        
        /**
         */
        @kotlin.jvm.JvmStatic
        public fun gpReadBool(`data`: alphaTab.io.IReadable): Boolean{
            return `data`.readByte() != 0.0
        }
        
        /**
         * Skips an integer (4byte) and reads a string using
         * a bytesize
         */
        @kotlin.jvm.JvmStatic
        public fun gpReadStringIntUnused(`data`: alphaTab.io.IReadable, encoding: String): String{
            `data`.skip(4.0)
            return alphaTab.importer.GpBinaryHelpers.gpReadString(`data`, `data`.readByte(), encoding)
        }
        
        /**
         * Reads an integer as size, and then the string itself
         */
        @kotlin.jvm.JvmStatic
        public fun gpReadStringInt(`data`: alphaTab.io.IReadable, encoding: String): String{
            return alphaTab.importer.GpBinaryHelpers.gpReadString(`data`, alphaTab.io.IOHelper.readInt32LE(`data`), encoding)
        }
        
        /**
         * Reads an integer as size, skips a byte and reads the string itself
         */
        @kotlin.jvm.JvmStatic
        public fun gpReadStringIntByte(`data`: alphaTab.io.IReadable, encoding: String): String{
            var length: Double = alphaTab.io.IOHelper.readInt32LE(`data`) - 1.0
            `data`.readByte()
            return alphaTab.importer.GpBinaryHelpers.gpReadString(`data`, length, encoding)
        }
        
        /**
         */
        @kotlin.jvm.JvmStatic
        public fun gpReadString(`data`: alphaTab.io.IReadable, length: Double, encoding: String): String{
            var b: alphaTab.core.ecmaScript.Uint8Array = alphaTab.core.ecmaScript.Uint8Array(length)
            `data`.read(b, 0.0, b.length)
            return alphaTab.io.IOHelper.toString(b, encoding)
        }
        
        /**
         */
        @kotlin.jvm.JvmStatic
        public fun gpWriteString(`data`: alphaTab.io.IWriteable, s: String): Unit{
            var encoded: alphaTab.core.ecmaScript.Uint8Array = alphaTab.io.IOHelper.stringToBytes(s)
            `data`.writeByte(s.length.toDouble())
            `data`.write(encoded, 0.0, encoded.length)
        }
        
        /**
         * Reads a byte as size and the string itself.
         * Additionally it is ensured the specified amount of bytes is read.
         * @param `data` the data to read from.
         * @param length the amount of bytes to read
         * @param encoding The encoding to use to decode the byte into a string
         */
        @kotlin.jvm.JvmStatic
        public fun gpReadStringByteLength(`data`: alphaTab.io.IReadable, length: Double, encoding: String): String{
            var stringLength: Double = `data`.readByte()
            var s: String = alphaTab.importer.GpBinaryHelpers.gpReadString(`data`, stringLength, encoding)
            if (stringLength < length)
            {
                `data`.skip(length - stringLength)
            }
            return s
        }
        
    }
    public constructor()
}

/**
 * A mixtablechange describes several track changes.
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class MixTableChange
{
    public var volume: Double = -1.0
    
    public var balance: Double = -1.0
    
    public var instrument: Double = -1.0
    
    public var tempoName: String = ""
    
    public var tempo: Double = -1.0
    
    public var duration: Double = -1.0
    
    public constructor()
}

