// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.importer
import alphaTab.core.*

/**
 * This ScoreImporter can read Guitar Pro 7 (gp) files.
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class Gp7Importer: alphaTab.importer.ScoreImporter
{
    public override val name: String
    get(){
        return "Guitar Pro 7"
    }
    
    public constructor()
        : super()
    /**
     * Reads the  contained in the data.
     */
    public override fun readScore(): alphaTab.model.Score{
        alphaTab.Logger.debug(this.name, "Loading ZIP entries")
        var fileSystem: alphaTab.zip.ZipReader = alphaTab.zip.ZipReader(this.`data`)
        var entries: alphaTab.collections.List<alphaTab.zip.ZipEntry>
        try
        {
            entries = fileSystem.read()
        }
        catch (e: kotlin.Throwable)
        {
            throw alphaTab.importer.UnsupportedFormatError("No Zip archive", (e as alphaTab.core.ecmaScript.Error))
        }
        alphaTab.Logger.debug(this.name, "Zip entries loaded")
        var xml: String? = null
        var binaryStylesheetData: alphaTab.core.ecmaScript.Uint8Array? = null
        var partConfigurationData: alphaTab.core.ecmaScript.Uint8Array? = null
        for (entry in entries)
        {
            when (entry.fileName)
            {
                "score.gpif" -> 
                {
                    xml = alphaTab.io.IOHelper.toString(entry.`data`, this.settings.importer.encoding)
                }
                "BinaryStylesheet" -> 
                {
                    binaryStylesheetData = entry.`data`
                }
                "PartConfiguration" -> 
                {
                    partConfigurationData = entry.`data`
                }
                else -> { }
            }
        }
        if (!alphaTab.core.TypeHelper.isTruthy(xml))
        {
            throw alphaTab.importer.UnsupportedFormatError("No score.gpif found in zip archive")
        }
        alphaTab.Logger.debug(this.name, "Start Parsing score.gpif")
        var gpifParser: alphaTab.importer.GpifParser = alphaTab.importer.GpifParser()
        gpifParser.parseXml(xml, this.settings)
        alphaTab.Logger.debug(this.name, "score.gpif parsed")
        var score: alphaTab.model.Score = gpifParser.score
        if (alphaTab.core.TypeHelper.isTruthy(binaryStylesheetData))
        {
            alphaTab.Logger.debug(this.name, "Start Parsing BinaryStylesheet")
            var stylesheet: alphaTab.importer.BinaryStylesheet = alphaTab.importer.BinaryStylesheet(binaryStylesheetData)
            stylesheet.apply(score)
            alphaTab.Logger.debug(this.name, "BinaryStylesheet parsed")
        }
        if (alphaTab.core.TypeHelper.isTruthy(partConfigurationData))
        {
            alphaTab.Logger.debug(this.name, "Start Parsing Part Configuration")
            var partConfigurationParser: alphaTab.importer.PartConfiguration = alphaTab.importer.PartConfiguration(partConfigurationData)
            partConfigurationParser.apply(score)
            alphaTab.Logger.debug(this.name, "Part Configuration parsed")
        }
        return score
    }
    
}

