// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.importer
import alphaTab.core.*

/**
 * This class can parse a score.gpif xml file into the model structure
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class GpifParser
{
    public lateinit var score: alphaTab.model.Score
    private lateinit var _masterTrackAutomations: alphaTab.collections.DoubleObjectMap<alphaTab.collections.List<alphaTab.model.Automation>>
    
    private lateinit var _automationsPerTrackIdAndBarIndex: alphaTab.collections.Map<String, alphaTab.collections.DoubleObjectMap<alphaTab.collections.List<alphaTab.model.Automation>>>
    
    private lateinit var _tracksMapping: alphaTab.collections.List<String>
    
    private lateinit var _tracksById: alphaTab.collections.Map<String, alphaTab.model.Track>
    
    private lateinit var _masterBars: alphaTab.collections.List<alphaTab.model.MasterBar>
    
    private lateinit var _barsOfMasterBar: alphaTab.collections.List<alphaTab.collections.List<String>>
    
    private lateinit var _barsById: alphaTab.collections.Map<String, alphaTab.model.Bar>
    
    private lateinit var _voicesOfBar: alphaTab.collections.Map<String, alphaTab.collections.List<String>>
    
    private lateinit var _voiceById: alphaTab.collections.Map<String, alphaTab.model.Voice>
    
    private lateinit var _beatsOfVoice: alphaTab.collections.Map<String, alphaTab.collections.List<String>>
    
    private lateinit var _rhythmOfBeat: alphaTab.collections.Map<String, String>
    
    private lateinit var _beatById: alphaTab.collections.Map<String, alphaTab.model.Beat>
    
    private lateinit var _rhythmById: alphaTab.collections.Map<String, alphaTab.importer.GpifRhythm>
    
    private lateinit var _noteById: alphaTab.collections.Map<String, alphaTab.model.Note>
    
    private lateinit var _notesOfBeat: alphaTab.collections.Map<String, alphaTab.collections.List<String>>
    
    private lateinit var _tappedNotes: alphaTab.collections.ObjectBooleanMap<String>
    
    private lateinit var _lyricsByTrack: alphaTab.collections.Map<String, alphaTab.collections.List<alphaTab.model.Lyrics>>
    
    private lateinit var _soundsByTrack: alphaTab.collections.Map<String, alphaTab.collections.Map<String, alphaTab.importer.GpifSound>>
    
    private var _hasAnacrusis: Boolean = false
    
    private lateinit var _articulationByName: alphaTab.collections.Map<String, alphaTab.model.InstrumentArticulation>
    
    private var _skipApplyLyrics: Boolean = false
    
    /**
     */
    public fun parseXml(xml: String, settings: alphaTab.Settings): Unit{
        this._masterTrackAutomations = alphaTab.collections.DoubleObjectMap<alphaTab.collections.List<alphaTab.model.Automation>>()
        this._automationsPerTrackIdAndBarIndex = alphaTab.collections.Map<String, alphaTab.collections.DoubleObjectMap<alphaTab.collections.List<alphaTab.model.Automation>>>()
        this._tracksMapping = alphaTab.collections.List<String>(
        )
        
        this._tracksById = alphaTab.collections.Map<String, alphaTab.model.Track>()
        this._masterBars = alphaTab.collections.List<alphaTab.model.MasterBar>(
        )
        
        this._barsOfMasterBar = alphaTab.collections.List<alphaTab.collections.List<String>>(
        )
        
        this._voicesOfBar = alphaTab.collections.Map<String, alphaTab.collections.List<String>>()
        this._barsById = alphaTab.collections.Map<String, alphaTab.model.Bar>()
        this._voiceById = alphaTab.collections.Map<String, alphaTab.model.Voice>()
        this._beatsOfVoice = alphaTab.collections.Map<String, alphaTab.collections.List<String>>()
        this._beatById = alphaTab.collections.Map<String, alphaTab.model.Beat>()
        this._rhythmOfBeat = alphaTab.collections.Map<String, String>()
        this._rhythmById = alphaTab.collections.Map<String, alphaTab.importer.GpifRhythm>()
        this._notesOfBeat = alphaTab.collections.Map<String, alphaTab.collections.List<String>>()
        this._noteById = alphaTab.collections.Map<String, alphaTab.model.Note>()
        this._tappedNotes = alphaTab.collections.ObjectBooleanMap<String>()
        this._lyricsByTrack = alphaTab.collections.Map<String, alphaTab.collections.List<alphaTab.model.Lyrics>>()
        this._soundsByTrack = alphaTab.collections.Map<String, alphaTab.collections.Map<String, alphaTab.importer.GpifSound>>()
        this._skipApplyLyrics = false
        var dom: alphaTab.xml.XmlDocument = alphaTab.xml.XmlDocument()
        try
        {
            dom.parse(xml)
        }
        catch (e: kotlin.Throwable)
        {
            throw alphaTab.importer.UnsupportedFormatError("Could not parse XML", (e as alphaTab.core.ecmaScript.Error))
        }
        this.parseDom(dom)
        this.buildModel()
        this.score.finish(settings)
        if (!this._skipApplyLyrics && this._lyricsByTrack.size > 0)
        {
            for ((t, lyrics) in this._lyricsByTrack)
            {
                var track: alphaTab.model.Track = this._tracksById.get(t)!!
                track.applyLyrics(lyrics)
            }
        }
    }
    
    /**
     */
    private fun parseDom(dom: alphaTab.xml.XmlDocument): Unit{
        var root: alphaTab.xml.XmlNode? = dom.firstElement
        if (!alphaTab.core.TypeHelper.isTruthy(root))
        {
            return
        }
        if (root.localName == "GPIF")
        {
            this.score = alphaTab.model.Score()
            for (n in root.childNodes)
            {
                if (n.nodeType == alphaTab.xml.XmlNodeType.Element)
                {
                    when (n.localName)
                    {
                        "Score" -> 
                        {
                            this.parseScoreNode(n)
                        }
                        "MasterTrack" -> 
                        {
                            this.parseMasterTrackNode(n)
                        }
                        "Tracks" -> 
                        {
                            this.parseTracksNode(n)
                        }
                        "MasterBars" -> 
                        {
                            this.parseMasterBarsNode(n)
                        }
                        "Bars" -> 
                        {
                            this.parseBars(n)
                        }
                        "Voices" -> 
                        {
                            this.parseVoices(n)
                        }
                        "Beats" -> 
                        {
                            this.parseBeats(n)
                        }
                        "Notes" -> 
                        {
                            this.parseNotes(n)
                        }
                        "Rhythms" -> 
                        {
                            this.parseRhythms(n)
                        }
                        else -> { }
                    }
                }
            }
        }
        else 
        {
            throw alphaTab.importer.UnsupportedFormatError("Root node of XML was not GPIF")
        }
    }
    
    /**
     */
    private fun parseScoreNode(element: alphaTab.xml.XmlNode): Unit{
        for (c in element.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "Title" -> 
                    {
                        this.score.title = c.firstChild!!.innerText
                    }
                    "SubTitle" -> 
                    {
                        this.score.subTitle = c.firstChild!!.innerText
                    }
                    "Artist" -> 
                    {
                        this.score.artist = c.firstChild!!.innerText
                    }
                    "Album" -> 
                    {
                        this.score.album = c.firstChild!!.innerText
                    }
                    "Words" -> 
                    {
                        this.score.words = c.firstChild!!.innerText
                    }
                    "Music" -> 
                    {
                        this.score.music = c.firstChild!!.innerText
                    }
                    "WordsAndMusic" -> 
                    {
                        if (alphaTab.core.TypeHelper.isTruthy(c.firstChild) && c.firstChild!!.innerText != "")
                        {
                            var wordsAndMusic: String = c.firstChild!!.innerText
                            if (alphaTab.core.TypeHelper.isTruthy(wordsAndMusic) && !alphaTab.core.TypeHelper.isTruthy(this.score.words))
                            {
                                this.score.words = wordsAndMusic
                            }
                            if (alphaTab.core.TypeHelper.isTruthy(wordsAndMusic) && !alphaTab.core.TypeHelper.isTruthy(this.score.music))
                            {
                                this.score.music = wordsAndMusic
                            }
                        }
                    }
                    "Copyright" -> 
                    {
                        this.score.copyright = c.firstChild!!.innerText
                    }
                    "Tabber" -> 
                    {
                        this.score.tab = c.firstChild!!.innerText
                    }
                    "Instructions" -> 
                    {
                        this.score.instructions = c.firstChild!!.innerText
                    }
                    "Notices" -> 
                    {
                        this.score.notices = c.firstChild!!.innerText
                    }
                    "ScoreSystemsDefaultLayout" -> 
                    {
                        this.score.defaultSystemsLayout = alphaTab.core.Globals.parseInt(c.innerText)
                    }
                    "ScoreSystemsLayout" -> 
                    {
                        this.score.systemsLayout = c.innerText.splitBy(" ").map(fun(i: String): Double{
                            return alphaTab.core.Globals.parseInt(i)
                        }
                        )
                    }
                    else -> { }
                }
            }
        }
    }
    
    /**
     */
    private fun parseMasterTrackNode(node: alphaTab.xml.XmlNode): Unit{
        for (c in node.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "Automations" -> 
                    {
                        this.parseAutomations(c, this._masterTrackAutomations, null)
                    }
                    "Tracks" -> 
                    {
                        this._tracksMapping = c.innerText.splitBy(" ")
                    }
                    "Anacrusis" -> 
                    {
                        this._hasAnacrusis = true
                    }
                    else -> { }
                }
            }
        }
    }
    
    /**
     */
    private fun parseAutomations(node: alphaTab.xml.XmlNode, automations: alphaTab.collections.DoubleObjectMap<alphaTab.collections.List<alphaTab.model.Automation>>, sounds: alphaTab.collections.Map<String, alphaTab.importer.GpifSound>?): Unit{
        for (c in node.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "Automation" -> 
                    {
                        this.parseAutomation(c, automations, sounds)
                    }
                    else -> { }
                }
            }
        }
    }
    
    /**
     */
    private fun parseAutomation(node: alphaTab.xml.XmlNode, automations: alphaTab.collections.DoubleObjectMap<alphaTab.collections.List<alphaTab.model.Automation>>, sounds: alphaTab.collections.Map<String, alphaTab.importer.GpifSound>?): Unit{
        var type: String? = null
        var isLinear: Boolean = false
        var barIndex: Double = -1.0
        var ratioPosition: Double = 0.0
        var numberValue: Double = 0.0
        var textValue: String? = null
        var reference: Double = 0.0
        var text: String? = null
        for (c in node.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "Type" -> 
                    {
                        type = c.innerText
                    }
                    "Linear" -> 
                    {
                        isLinear = c.innerText.lowercase() == "true"
                    }
                    "Bar" -> 
                    {
                        barIndex = alphaTab.core.Globals.parseInt(c.innerText)
                    }
                    "Position" -> 
                    {
                        ratioPosition = alphaTab.core.Globals.parseFloat(c.innerText)
                    }
                    "Value" -> 
                    {
                        if (alphaTab.core.TypeHelper.isTruthy(c.firstElement) && c.firstElement!!.nodeType == alphaTab.xml.XmlNodeType.CDATA)
                        {
                            textValue = c.innerText
                        }
                        else 
                        {
                            var parts: alphaTab.collections.List<String> = c.innerText.splitBy(" ")
                            if (parts.length == 1.0)
                            {
                                numberValue = alphaTab.core.Globals.parseFloat(parts[(0).toInt()])
                                reference = 1.0
                            }
                            else 
                            {
                                numberValue = alphaTab.core.Globals.parseFloat(parts[(0).toInt()])
                                reference = alphaTab.core.Globals.parseInt(parts[(1).toInt()])
                            }
                        }
                    }
                    "Text" -> 
                    {
                        text = c.innerText
                    }
                    else -> { }
                }
            }
        }
        if (!alphaTab.core.TypeHelper.isTruthy(type))
        {
            return
        }
        var automation: alphaTab.model.Automation? = null
        when (type)
        {
            "Tempo" -> 
            {
                automation = alphaTab.model.Automation.buildTempoAutomation(isLinear, ratioPosition, numberValue, reference)
            }
            "Sound" -> 
            {
                if (alphaTab.core.TypeHelper.isTruthy(textValue) && alphaTab.core.TypeHelper.isTruthy(sounds) && sounds.has(textValue))
                {
                    automation = alphaTab.model.Automation.buildInstrumentAutomation(isLinear, ratioPosition, sounds.get(textValue)!!.program)
                }
            }
            else -> { }
        }
        if (alphaTab.core.TypeHelper.isTruthy(automation))
        {
            if (alphaTab.core.TypeHelper.isTruthy(text))
            {
                automation.text = text
            }
            if (barIndex >= 0)
            {
                if (!automations.has(barIndex))
                {
                    automations.set(barIndex, alphaTab.collections.List<alphaTab.model.Automation>(
                    )
                    )
                }
                automations.get(barIndex)!!.push(automation)
            }
        }
    }
    
    /**
     */
    private fun parseTracksNode(node: alphaTab.xml.XmlNode): Unit{
        for (c in node.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "Track" -> 
                    {
                        this.parseTrack(c)
                    }
                    else -> { }
                }
            }
        }
    }
    
    /**
     */
    private fun parseTrack(node: alphaTab.xml.XmlNode): Unit{
        this._articulationByName = alphaTab.collections.Map<String, alphaTab.model.InstrumentArticulation>()
        var track: alphaTab.model.Track = alphaTab.model.Track()
        track.ensureStaveCount(1.0)
        var staff: alphaTab.model.Staff = track.staves[(0).toInt()]
        staff.showStandardNotation = true
        var trackId: String = node.getAttribute("id")
        for (c in node.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "Name" -> 
                    {
                        track.name = c.innerText
                    }
                    "Color" -> 
                    {
                        var parts: alphaTab.collections.List<String> = c.innerText.splitBy(" ")
                        if (parts.length >= 3)
                        {
                            var r: Double = alphaTab.core.Globals.parseInt(parts[(0).toInt()])
                            var g: Double = alphaTab.core.Globals.parseInt(parts[(1).toInt()])
                            var b: Double = alphaTab.core.Globals.parseInt(parts[(2).toInt()])
                            track.color = alphaTab.model.Color(r, g, b, 255.0)
                        }
                    }
                    "Instrument" -> 
                    {
                        var instrumentName: String = c.getAttribute("ref")
                        if (instrumentName.endsWith("-gs") || instrumentName.endsWith("GrandStaff"))
                        {
                            track.ensureStaveCount(2.0)
                            track.staves[(1).toInt()].showStandardNotation = true
                        }
                    }
                    "InstrumentSet" -> 
                    {
                        this.parseInstrumentSet(track, c)
                    }
                    "NotationPatch" -> 
                    {
                        this.parseNotationPatch(track, c)
                    }
                    "ShortName" -> 
                    {
                        track.shortName = c.innerText
                    }
                    "SystemsDefautLayout" -> 
                    {
                        track.defaultSystemsLayout = alphaTab.core.Globals.parseInt(c.innerText)
                    }
                    "SystemsLayout" -> 
                    {
                        track.systemsLayout = c.innerText.splitBy(" ").map(fun(i: String): Double{
                            return alphaTab.core.Globals.parseInt(i)
                        }
                        )
                    }
                    "Lyrics" -> 
                    {
                        this.parseLyrics(trackId, c)
                    }
                    "Properties" -> 
                    {
                        this.parseTrackProperties(track, c)
                    }
                    "GeneralMidi", "MidiConnection", "MIDISettings" -> 
                    {
                        this.parseGeneralMidi(track, c)
                    }
                    "Sounds" -> 
                    {
                        this.parseSounds(trackId, track, c)
                    }
                    "PlaybackState" -> 
                    {
                        var state: String = c.innerText
                        track.playbackInfo.isSolo = state == "Solo"
                        track.playbackInfo.isMute = state == "Mute"
                    }
                    "PartSounding" -> 
                    {
                        this.parsePartSounding(track, c)
                    }
                    "Staves" -> 
                    {
                        this.parseStaves(track, c)
                    }
                    "Transpose" -> 
                    {
                        this.parseTranspose(track, c)
                    }
                    "RSE" -> 
                    {
                        this.parseRSE(track, c)
                    }
                    "Automations" -> 
                    {
                        this.parseTrackAutomations(trackId, c)
                    }
                    else -> { }
                }
            }
        }
        this._tracksById.set(trackId, track)
    }
    
    /**
     */
    private fun parseTrackAutomations(trackId: String, c: alphaTab.xml.XmlNode): Unit{
        var trackAutomations: alphaTab.collections.DoubleObjectMap<alphaTab.collections.List<alphaTab.model.Automation>> = alphaTab.collections.DoubleObjectMap<alphaTab.collections.List<alphaTab.model.Automation>>()
        this._automationsPerTrackIdAndBarIndex.set(trackId, trackAutomations)
        this.parseAutomations(c, trackAutomations, this._soundsByTrack.get(trackId)!!)
    }
    
    /**
     */
    private fun parseNotationPatch(track: alphaTab.model.Track, node: alphaTab.xml.XmlNode): Unit{
        for (c in node.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "LineCount" -> 
                    {
                        var lineCount: Double = alphaTab.core.Globals.parseInt(c.innerText)
                        for (staff in track.staves)
                        {
                            staff.standardNotationLineCount = lineCount
                        }
                    }
                    "Elements" -> 
                    {
                        this.parseElements(track, c)
                    }
                    else -> { }
                }
            }
        }
    }
    
    /**
     */
    private fun parseInstrumentSet(track: alphaTab.model.Track, node: alphaTab.xml.XmlNode): Unit{
        for (c in node.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "Type" -> 
                    {
                        when (c.innerText)
                        {
                            "drumKit" -> 
                            {
                                for (staff in track.staves)
                                {
                                    staff.isPercussion = true
                                }
                            }
                            else -> { }
                        }
                        if (c.innerText == "drumKit")
                        {
                            for (staff in track.staves)
                            {
                                staff.isPercussion = true
                            }
                        }
                    }
                    "Elements" -> 
                    {
                        this.parseElements(track, c)
                    }
                    "LineCount" -> 
                    {
                        var lineCount: Double = alphaTab.core.Globals.parseInt(c.innerText)
                        for (staff in track.staves)
                        {
                            staff.standardNotationLineCount = lineCount
                        }
                    }
                    else -> { }
                }
            }
        }
    }
    
    /**
     */
    private fun parseElements(track: alphaTab.model.Track, node: alphaTab.xml.XmlNode): Unit{
        for (c in node.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "Element" -> 
                    {
                        this.parseElement(track, c)
                    }
                    else -> { }
                }
            }
        }
    }
    
    /**
     */
    private fun parseElement(track: alphaTab.model.Track, node: alphaTab.xml.XmlNode): Unit{
        var typeElement: alphaTab.xml.XmlNode? = node.findChildElement("Type")
        var type: String = if(alphaTab.core.TypeHelper.isTruthy(typeElement))  typeElement.innerText else ""
        for (c in node.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "Name", "Articulations" -> 
                    {
                        this.parseArticulations(track, c, type)
                    }
                    else -> { }
                }
            }
        }
    }
    
    /**
     */
    private fun parseArticulations(track: alphaTab.model.Track, node: alphaTab.xml.XmlNode, elementType: String): Unit{
        for (c in node.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "Articulation" -> 
                    {
                        this.parseArticulation(track, c, elementType)
                    }
                    else -> { }
                }
            }
        }
    }
    
    /**
     */
    private fun parseArticulation(track: alphaTab.model.Track, node: alphaTab.xml.XmlNode, elementType: String): Unit{
        var articulation: alphaTab.model.InstrumentArticulation = alphaTab.model.InstrumentArticulation()
        articulation.outputMidiNumber = -1.0
        articulation.elementType = elementType
        var name: String = ""
        for (c in node.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                var txt: String = c.innerText
                when (c.localName)
                {
                    "Name" -> 
                    {
                        name = c.innerText
                    }
                    "OutputMidiNumber" -> 
                    {
                        if (txt.length.toDouble() > 0)
                        {
                            articulation.outputMidiNumber = alphaTab.core.Globals.parseInt(txt)
                        }
                    }
                    "TechniqueSymbol" -> 
                    {
                        articulation.techniqueSymbol = this.parseTechniqueSymbol(txt)
                    }
                    "TechniquePlacement" -> 
                    {
                        when (txt)
                        {
                            "outside" -> 
                            {
                                articulation.techniqueSymbolPlacement = alphaTab.platform.TextBaseline.Bottom
                            }
                            "inside" -> 
                            {
                                articulation.techniqueSymbolPlacement = alphaTab.platform.TextBaseline.Middle
                            }
                            "above" -> 
                            {
                                articulation.techniqueSymbolPlacement = alphaTab.platform.TextBaseline.Bottom
                            }
                            "below" -> 
                            {
                                articulation.techniqueSymbolPlacement = alphaTab.platform.TextBaseline.Top
                            }
                            else -> { }
                        }
                    }
                    "Noteheads" -> 
                    {
                        var noteHeadsTxt: alphaTab.collections.List<String> = txt.splitBy(" ")
                        if (noteHeadsTxt.length >= 1)
                        {
                            articulation.noteHeadDefault = this.parseNoteHead(noteHeadsTxt[(0).toInt()])
                        }
                        if (noteHeadsTxt.length >= 2)
                        {
                            articulation.noteHeadHalf = this.parseNoteHead(noteHeadsTxt[(1).toInt()])
                        }
                        if (noteHeadsTxt.length >= 3)
                        {
                            articulation.noteHeadWhole = this.parseNoteHead(noteHeadsTxt[(2).toInt()])
                        }
                        if (articulation.noteHeadHalf == alphaTab.model.MusicFontSymbol.None)
                        {
                            articulation.noteHeadHalf = articulation.noteHeadDefault
                        }
                        if (articulation.noteHeadWhole == alphaTab.model.MusicFontSymbol.None)
                        {
                            articulation.noteHeadWhole = articulation.noteHeadDefault
                        }
                    }
                    "StaffLine" -> 
                    {
                        if (txt.length.toDouble() > 0)
                        {
                            articulation.staffLine = alphaTab.core.Globals.parseInt(txt)
                        }
                    }
                    else -> { }
                }
            }
        }
        if (articulation.outputMidiNumber != -1.0)
        {
            track.percussionArticulations.push(articulation)
            if (name.length.toDouble() > 0)
            {
                this._articulationByName.set(name, articulation)
            }
        }
        else if (name.length.toDouble() > 0 && this._articulationByName.has(name))
        {
            this._articulationByName.get(name)!!.staffLine = articulation.staffLine
        }
    }
    
    /**
     */
    private fun parseTechniqueSymbol(txt: String): alphaTab.model.MusicFontSymbol{
        when (txt)
        {
            "pictEdgeOfCymbal" -> 
            {
                return alphaTab.model.MusicFontSymbol.PictEdgeOfCymbal
            }
            "articStaccatoAbove" -> 
            {
                return alphaTab.model.MusicFontSymbol.ArticStaccatoAbove
            }
            "noteheadParenthesis" -> 
            {
                return alphaTab.model.MusicFontSymbol.NoteheadParenthesis
            }
            "stringsUpBow" -> 
            {
                return alphaTab.model.MusicFontSymbol.StringsUpBow
            }
            "stringsDownBow" -> 
            {
                return alphaTab.model.MusicFontSymbol.StringsDownBow
            }
            "guitarGolpe" -> 
            {
                return alphaTab.model.MusicFontSymbol.GuitarGolpe
            }
            else -> 
            {
                return alphaTab.model.MusicFontSymbol.None
            }
        }
    }
    
    /**
     */
    private fun parseNoteHead(txt: String): alphaTab.model.MusicFontSymbol{
        when (txt)
        {
            "noteheadDoubleWholeSquare" -> 
            {
                return alphaTab.model.MusicFontSymbol.NoteheadDoubleWholeSquare
            }
            "noteheadDoubleWhole" -> 
            {
                return alphaTab.model.MusicFontSymbol.NoteheadDoubleWhole
            }
            "noteheadWhole" -> 
            {
                return alphaTab.model.MusicFontSymbol.NoteheadWhole
            }
            "noteheadHalf" -> 
            {
                return alphaTab.model.MusicFontSymbol.NoteheadHalf
            }
            "noteheadBlack" -> 
            {
                return alphaTab.model.MusicFontSymbol.NoteheadBlack
            }
            "noteheadNull" -> 
            {
                return alphaTab.model.MusicFontSymbol.NoteheadNull
            }
            "noteheadXOrnate" -> 
            {
                return alphaTab.model.MusicFontSymbol.NoteheadXOrnate
            }
            "noteheadTriangleUpWhole" -> 
            {
                return alphaTab.model.MusicFontSymbol.NoteheadTriangleUpWhole
            }
            "noteheadTriangleUpHalf" -> 
            {
                return alphaTab.model.MusicFontSymbol.NoteheadTriangleUpHalf
            }
            "noteheadTriangleUpBlack" -> 
            {
                return alphaTab.model.MusicFontSymbol.NoteheadTriangleUpBlack
            }
            "noteheadDiamondBlackWide" -> 
            {
                return alphaTab.model.MusicFontSymbol.NoteheadDiamondBlackWide
            }
            "noteheadDiamondWhite" -> 
            {
                return alphaTab.model.MusicFontSymbol.NoteheadDiamondWhite
            }
            "noteheadDiamondWhiteWide" -> 
            {
                return alphaTab.model.MusicFontSymbol.NoteheadDiamondWhiteWide
            }
            "noteheadCircleX" -> 
            {
                return alphaTab.model.MusicFontSymbol.NoteheadCircleX
            }
            "noteheadXWhole" -> 
            {
                return alphaTab.model.MusicFontSymbol.NoteheadXWhole
            }
            "noteheadXHalf" -> 
            {
                return alphaTab.model.MusicFontSymbol.NoteheadXHalf
            }
            "noteheadXBlack" -> 
            {
                return alphaTab.model.MusicFontSymbol.NoteheadXBlack
            }
            "noteheadParenthesis" -> 
            {
                return alphaTab.model.MusicFontSymbol.NoteheadParenthesis
            }
            "noteheadSlashedBlack2" -> 
            {
                return alphaTab.model.MusicFontSymbol.NoteheadSlashedBlack2
            }
            "noteheadCircleSlash" -> 
            {
                return alphaTab.model.MusicFontSymbol.NoteheadCircleSlash
            }
            "noteheadHeavyX" -> 
            {
                return alphaTab.model.MusicFontSymbol.NoteheadHeavyX
            }
            "noteheadHeavyXHat" -> 
            {
                return alphaTab.model.MusicFontSymbol.NoteheadHeavyXHat
            }
            else -> 
            {
                alphaTab.Logger.warning("GPIF", "Unknown notehead symbol", ((txt as Any?)))
                return alphaTab.model.MusicFontSymbol.None
            }
        }
    }
    
    /**
     */
    private fun parseStaves(track: alphaTab.model.Track, node: alphaTab.xml.XmlNode): Unit{
        var staffIndex: Double = 0.0
        for (c in node.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "Staff" -> 
                    {
                        track.ensureStaveCount(staffIndex + 1.0)
                        var staff: alphaTab.model.Staff = track.staves[(staffIndex).toInt()]
                        this.parseStaff(staff, c)
                        staffIndex++
                    }
                    else -> { }
                }
            }
        }
    }
    
    /**
     */
    private fun parseStaff(staff: alphaTab.model.Staff, node: alphaTab.xml.XmlNode): Unit{
        for (c in node.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "Properties" -> 
                    {
                        this.parseStaffProperties(staff, c)
                    }
                    else -> { }
                }
            }
        }
    }
    
    /**
     */
    private fun parseStaffProperties(staff: alphaTab.model.Staff, node: alphaTab.xml.XmlNode): Unit{
        for (c in node.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "Property" -> 
                    {
                        this.parseStaffProperty(staff, c)
                    }
                    else -> { }
                }
            }
        }
    }
    
    /**
     */
    private fun parseStaffProperty(staff: alphaTab.model.Staff, node: alphaTab.xml.XmlNode): Unit{
        var propertyName: String = node.getAttribute("name")
        when (propertyName)
        {
            "Tuning" -> 
            {
                for (c in node.childNodes)
                {
                    if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
                    {
                        when (c.localName)
                        {
                            "Pitches" -> 
                            {
                                var tuningParts: alphaTab.collections.List<String> = node.findChildElement("Pitches")!!.innerText.splitBy(" ")
                                var tuning: alphaTab.collections.DoubleList = alphaTab.collections.DoubleList((tuningParts.length).toInt())
                                if(true) {
                                    var i: Double = 0.0
                                    
                                    while(i < tuning.length){
                                        try{
                                            tuning[(tuning.length - 1.0 - i).toInt()] = alphaTab.core.Globals.parseInt(tuningParts[(i).toInt()])
                                        }
                                        finally{
                                            i++
                                        }
                                    }
                                }
                                staff.stringTuning.tunings = tuning
                            }
                            "Label" -> 
                            {
                                staff.stringTuning.name = c.innerText
                            }
                            else -> { }
                        }
                    }
                }
                if (!staff.isPercussion)
                {
                    staff.showTablature = true
                }
            }
            "DiagramCollection", "ChordCollection" -> 
            {
                this.parseDiagramCollectionForStaff(staff, node)
            }
            "CapoFret" -> 
            {
                var capo: Double = alphaTab.core.Globals.parseInt(node.findChildElement("Fret")!!.innerText)
                staff.capo = capo
            }
            else -> { }
        }
    }
    
    /**
     */
    private fun parseLyrics(trackId: String, node: alphaTab.xml.XmlNode): Unit{
        var tracks: alphaTab.collections.List<alphaTab.model.Lyrics> = alphaTab.collections.List<alphaTab.model.Lyrics>(
        )
        
        for (c in node.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "Line" -> 
                    {
                        tracks.push(this.parseLyricsLine(c))
                    }
                    else -> { }
                }
            }
        }
        this._lyricsByTrack.set(trackId, tracks)
    }
    
    /**
     */
    private fun parseLyricsLine(node: alphaTab.xml.XmlNode): alphaTab.model.Lyrics{
        var lyrics: alphaTab.model.Lyrics = alphaTab.model.Lyrics()
        for (c in node.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "Offset" -> 
                    {
                        lyrics.startBar = alphaTab.core.Globals.parseInt(c.innerText)
                    }
                    "Text" -> 
                    {
                        lyrics.text = c.innerText
                    }
                    else -> { }
                }
            }
        }
        return lyrics
    }
    
    /**
     */
    private fun parseDiagramCollectionForTrack(track: alphaTab.model.Track, node: alphaTab.xml.XmlNode): Unit{
        var items: alphaTab.xml.XmlNode = node.findChildElement("Items")!!
        for (c in items.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "Item" -> 
                    {
                        this.parseDiagramItemForTrack(track, c)
                    }
                    else -> { }
                }
            }
        }
    }
    
    /**
     */
    private fun parseDiagramCollectionForStaff(staff: alphaTab.model.Staff, node: alphaTab.xml.XmlNode): Unit{
        var items: alphaTab.xml.XmlNode = node.findChildElement("Items")!!
        for (c in items.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "Item" -> 
                    {
                        this.parseDiagramItemForStaff(staff, c)
                    }
                    else -> { }
                }
            }
        }
    }
    
    /**
     */
    private fun parseDiagramItemForTrack(track: alphaTab.model.Track, node: alphaTab.xml.XmlNode): Unit{
        var chord: alphaTab.model.Chord = alphaTab.model.Chord()
        var chordId: String = node.getAttribute("id")
        for (staff in track.staves)
        {
            staff.addChord(chordId, chord)
        }
        this.parseDiagramItemForChord(chord, node)
    }
    
    /**
     */
    private fun parseDiagramItemForStaff(staff: alphaTab.model.Staff, node: alphaTab.xml.XmlNode): Unit{
        var chord: alphaTab.model.Chord = alphaTab.model.Chord()
        var chordId: String = node.getAttribute("id")
        staff.addChord(chordId, chord)
        this.parseDiagramItemForChord(chord, node)
    }
    
    /**
     */
    private fun parseDiagramItemForChord(chord: alphaTab.model.Chord, node: alphaTab.xml.XmlNode): Unit{
        chord.name = node.getAttribute("name")
        var diagram: alphaTab.xml.XmlNode? = node.findChildElement("Diagram")
        if (!alphaTab.core.TypeHelper.isTruthy(diagram))
        {
            chord.showDiagram = false
            chord.showFingering = false
            return
        }
        var stringCount: Double = alphaTab.core.Globals.parseInt(diagram.getAttribute("stringCount"))
        var baseFret: Double = alphaTab.core.Globals.parseInt(diagram.getAttribute("baseFret"))
        chord.firstFret = baseFret + 1.0
        if(true) {
            var i: Double = 0.0
            
            while(i < stringCount){
                try{
                    chord.strings.push(-1.0)
                }
                finally{
                    i++
                }
            }
        }
        for (c in diagram.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "Fret" -> 
                    {
                        var guitarString: Double = alphaTab.core.Globals.parseInt(c.getAttribute("string"))
                        chord.strings[(stringCount - guitarString - 1.0).toInt()] = baseFret + alphaTab.core.Globals.parseInt(c.getAttribute("fret"))
                    }
                    "Fingering" -> 
                    {
                        var existingFingers: alphaTab.collections.ObjectBooleanMap<alphaTab.model.Fingers> = alphaTab.collections.ObjectBooleanMap<alphaTab.model.Fingers>()
                        for (p in c.childNodes)
                        {
                            if (p.nodeType == alphaTab.xml.XmlNodeType.Element)
                            {
                                when (p.localName)
                                {
                                    "Position" -> 
                                    {
                                        var finger: alphaTab.model.Fingers = alphaTab.model.Fingers.Unknown
                                        var fret: Double = baseFret + alphaTab.core.Globals.parseInt(p.getAttribute("fret"))
                                        when (p.getAttribute("finger"))
                                        {
                                            "Index" -> 
                                            {
                                                finger = alphaTab.model.Fingers.IndexFinger
                                            }
                                            "Middle" -> 
                                            {
                                                finger = alphaTab.model.Fingers.MiddleFinger
                                            }
                                            "Rank" -> 
                                            {
                                                finger = alphaTab.model.Fingers.AnnularFinger
                                            }
                                            "Pinky" -> 
                                            {
                                                finger = alphaTab.model.Fingers.LittleFinger
                                            }
                                            "Thumb" -> 
                                            {
                                                finger = alphaTab.model.Fingers.Thumb
                                            }
                                            "None" -> 
                                            {
                                            }
                                            else -> { }
                                        }
                                        if (finger != alphaTab.model.Fingers.Unknown)
                                        {
                                            if (existingFingers.has(finger))
                                            {
                                                chord.barreFrets.push(fret)
                                            }
                                            else 
                                            {
                                                existingFingers.set(finger, true)
                                            }
                                        }
                                    }
                                    else -> { }
                                }
                            }
                        }
                    }
                    "Property" -> 
                    {
                        when (c.getAttribute("name"))
                        {
                            "ShowName" -> 
                            {
                                chord.showName = c.getAttribute("value") == "true"
                            }
                            "ShowDiagram" -> 
                            {
                                chord.showDiagram = c.getAttribute("value") == "true"
                            }
                            "ShowFingering" -> 
                            {
                                chord.showFingering = c.getAttribute("value") == "true"
                            }
                            else -> { }
                        }
                    }
                    else -> { }
                }
            }
        }
    }
    
    /**
     */
    private fun parseTrackProperties(track: alphaTab.model.Track, node: alphaTab.xml.XmlNode): Unit{
        for (c in node.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "Property" -> 
                    {
                        this.parseTrackProperty(track, c)
                    }
                    else -> { }
                }
            }
        }
    }
    
    /**
     */
    private fun parseTrackProperty(track: alphaTab.model.Track, node: alphaTab.xml.XmlNode): Unit{
        var propertyName: String = node.getAttribute("name")
        when (propertyName)
        {
            "Tuning" -> 
            {
                var tuningParts: alphaTab.collections.List<String> = node.findChildElement("Pitches")!!.innerText.splitBy(" ")
                var tuning: alphaTab.collections.DoubleList = alphaTab.collections.DoubleList((tuningParts.length).toInt())
                if(true) {
                    var i: Double = 0.0
                    
                    while(i < tuning.length){
                        try{
                            tuning[(tuning.length - 1.0 - i).toInt()] = alphaTab.core.Globals.parseInt(tuningParts[(i).toInt()])
                        }
                        finally{
                            i++
                        }
                    }
                }
                for (staff in track.staves)
                {
                    staff.stringTuning.tunings = tuning
                    staff.showStandardNotation = true
                    staff.showTablature = true
                }
            }
            "DiagramCollection", "ChordCollection" -> 
            {
                this.parseDiagramCollectionForTrack(track, node)
            }
            "CapoFret" -> 
            {
                var capo: Double = alphaTab.core.Globals.parseInt(node.findChildElement("Fret")!!.innerText)
                for (staff in track.staves)
                {
                    staff.capo = capo
                }
            }
            else -> { }
        }
    }
    
    /**
     */
    private fun parseGeneralMidi(track: alphaTab.model.Track, node: alphaTab.xml.XmlNode): Unit{
        for (c in node.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "Program" -> 
                    {
                        track.playbackInfo.program = alphaTab.core.Globals.parseInt(c.innerText)
                    }
                    "Port" -> 
                    {
                        track.playbackInfo.port = alphaTab.core.Globals.parseInt(c.innerText)
                    }
                    "PrimaryChannel" -> 
                    {
                        track.playbackInfo.primaryChannel = alphaTab.core.Globals.parseInt(c.innerText)
                    }
                    "SecondaryChannel" -> 
                    {
                        track.playbackInfo.secondaryChannel = alphaTab.core.Globals.parseInt(c.innerText)
                    }
                    else -> { }
                }
            }
        }
        var isPercussion: Boolean = node.getAttribute("table") == "Percussion"
        if (isPercussion)
        {
            for (staff in track.staves)
            {
                staff.isPercussion = true
            }
        }
    }
    
    /**
     */
    private fun parseSounds(trackId: String, track: alphaTab.model.Track, node: alphaTab.xml.XmlNode): Unit{
        for (c in node.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "Sound" -> 
                    {
                        this.parseSound(trackId, track, c)
                    }
                    else -> { }
                }
            }
        }
    }
    
    /**
     */
    private fun parseSound(trackId: String, track: alphaTab.model.Track, node: alphaTab.xml.XmlNode): Unit{
        var sound: alphaTab.importer.GpifSound = alphaTab.importer.GpifSound()
        for (c in node.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "Name" -> 
                    {
                        sound.name = c.innerText
                    }
                    "Path" -> 
                    {
                        sound.path = c.innerText
                    }
                    "Role" -> 
                    {
                        sound.role = c.innerText
                    }
                    "MIDI" -> 
                    {
                        this.parseSoundMidi(sound, c)
                    }
                    else -> { }
                }
            }
        }
        if (sound.role == "Factory" || track.playbackInfo.program == 0.0)
        {
            track.playbackInfo.program = sound.program
        }
        if (!this._soundsByTrack.has(trackId))
        {
            this._soundsByTrack.set(trackId, alphaTab.collections.Map<String, alphaTab.importer.GpifSound>())
        }
        this._soundsByTrack.get(trackId)!!.set(sound.uniqueId, sound)
    }
    
    /**
     */
    private fun parseSoundMidi(sound: alphaTab.importer.GpifSound, node: alphaTab.xml.XmlNode): Unit{
        for (c in node.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "Program" -> 
                    {
                        sound.program = alphaTab.core.Globals.parseInt(c.innerText)
                    }
                    else -> { }
                }
            }
        }
    }
    
    /**
     */
    private fun parsePartSounding(track: alphaTab.model.Track, node: alphaTab.xml.XmlNode): Unit{
        for (c in node.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "TranspositionPitch" -> 
                    {
                        for (staff in track.staves)
                        {
                            staff.displayTranspositionPitch = alphaTab.core.Globals.parseInt(c.innerText)
                        }
                    }
                    else -> { }
                }
            }
        }
    }
    
    /**
     */
    private fun parseTranspose(track: alphaTab.model.Track, node: alphaTab.xml.XmlNode): Unit{
        var octave: Double = 0.0
        var chromatic: Double = 0.0
        for (c in node.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "Chromatic" -> 
                    {
                        chromatic = alphaTab.core.Globals.parseInt(c.innerText)
                    }
                    "Octave" -> 
                    {
                        octave = alphaTab.core.Globals.parseInt(c.innerText)
                    }
                    else -> { }
                }
            }
        }
        for (staff in track.staves)
        {
            staff.displayTranspositionPitch = octave * 12.0 + chromatic
        }
    }
    
    /**
     */
    private fun parseRSE(track: alphaTab.model.Track, node: alphaTab.xml.XmlNode): Unit{
        for (c in node.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "ChannelStrip" -> 
                    {
                        this.parseChannelStrip(track, c)
                    }
                    else -> { }
                }
            }
        }
    }
    
    /**
     */
    private fun parseChannelStrip(track: alphaTab.model.Track, node: alphaTab.xml.XmlNode): Unit{
        for (c in node.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "Parameters" -> 
                    {
                        this.parseChannelStripParameters(track, c)
                    }
                    else -> { }
                }
            }
        }
    }
    
    /**
     */
    private fun parseChannelStripParameters(track: alphaTab.model.Track, node: alphaTab.xml.XmlNode): Unit{
        if (alphaTab.core.TypeHelper.isTruthy(node.firstChild) && alphaTab.core.TypeHelper.isTruthy(node.firstChild!!.value))
        {
            var parameters: alphaTab.collections.List<String> = node.firstChild!!.value!!.splitBy(" ")
            if (parameters.length >= 12)
            {
                track.playbackInfo.balance = alphaTab.core.ecmaScript.Math.floor(alphaTab.core.Globals.parseFloat(parameters[(11).toInt()]) * 16.0)
                track.playbackInfo.volume = alphaTab.core.ecmaScript.Math.floor(alphaTab.core.Globals.parseFloat(parameters[(12).toInt()]) * 16.0)
            }
        }
    }
    
    /**
     */
    private fun parseMasterBarsNode(node: alphaTab.xml.XmlNode): Unit{
        for (c in node.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "MasterBar" -> 
                    {
                        this.parseMasterBar(c)
                    }
                    else -> { }
                }
            }
        }
    }
    
    /**
     */
    private fun parseMasterBar(node: alphaTab.xml.XmlNode): Unit{
        var masterBar: alphaTab.model.MasterBar = alphaTab.model.MasterBar()
        if (this._masterBars.length == 0.0 && this._hasAnacrusis)
        {
            masterBar.isAnacrusis = true
        }
        for (c in node.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "Time" -> 
                    {
                        var timeParts: alphaTab.collections.List<String> = c.innerText.splitBy("/")
                        masterBar.timeSignatureNumerator = alphaTab.core.Globals.parseInt(timeParts[(0).toInt()])
                        masterBar.timeSignatureDenominator = alphaTab.core.Globals.parseInt(timeParts[(1).toInt()])
                    }
                    "DoubleBar" -> 
                    {
                        masterBar.isDoubleBar = true
                    }
                    "Section" -> 
                    {
                        masterBar.section = alphaTab.model.Section()
                        masterBar.section!!.marker = c.findChildElement("Letter")!!.innerText
                        masterBar.section!!.text = c.findChildElement("Text")!!.innerText
                    }
                    "Repeat" -> 
                    {
                        if (c.getAttribute("start").lowercase() == "true")
                        {
                            masterBar.isRepeatStart = true
                        }
                        if (c.getAttribute("end").lowercase() == "true" && alphaTab.core.TypeHelper.isTruthy(c.getAttribute("count")))
                        {
                            masterBar.repeatCount = alphaTab.core.Globals.parseInt(c.getAttribute("count"))
                        }
                    }
                    "AlternateEndings" -> 
                    {
                        var alternateEndings: alphaTab.collections.List<String> = c.innerText.splitBy(" ")
                        var i: Double = 0.0
                        if(true) {
                            var k: Double = 0.0
                            
                            while(k < alternateEndings.length){
                                try{
                                    i = ((i).toInt() or (1 shl ((-1.0 + alphaTab.core.Globals.parseInt(alternateEndings[(k).toInt()]))).toInt())).toDouble()
                                }
                                finally{
                                    k++
                                }
                            }
                        }
                        masterBar.alternateEndings = i
                    }
                    "Bars" -> 
                    {
                        this._barsOfMasterBar.push(c.innerText.splitBy(" "))
                    }
                    "TripletFeel" -> 
                    {
                        when (c.innerText)
                        {
                            "NoTripletFeel" -> 
                            {
                                masterBar.tripletFeel = alphaTab.model.TripletFeel.NoTripletFeel
                            }
                            "Triplet8th" -> 
                            {
                                masterBar.tripletFeel = alphaTab.model.TripletFeel.Triplet8th
                            }
                            "Triplet16th" -> 
                            {
                                masterBar.tripletFeel = alphaTab.model.TripletFeel.Triplet16th
                            }
                            "Dotted8th" -> 
                            {
                                masterBar.tripletFeel = alphaTab.model.TripletFeel.Dotted8th
                            }
                            "Dotted16th" -> 
                            {
                                masterBar.tripletFeel = alphaTab.model.TripletFeel.Dotted16th
                            }
                            "Scottish8th" -> 
                            {
                                masterBar.tripletFeel = alphaTab.model.TripletFeel.Scottish8th
                            }
                            "Scottish16th" -> 
                            {
                                masterBar.tripletFeel = alphaTab.model.TripletFeel.Scottish16th
                            }
                            else -> { }
                        }
                    }
                    "Key" -> 
                    {
                        masterBar.keySignature = alphaTab.model.KeySignature.fromValue(alphaTab.core.Globals.parseInt(c.findChildElement("AccidentalCount")!!.innerText))
                        var mode: alphaTab.xml.XmlNode = c.findChildElement("Mode")!!
                        if (alphaTab.core.TypeHelper.isTruthy(mode))
                        {
                            when (mode.innerText.lowercase())
                            {
                                "major" -> 
                                {
                                    masterBar.keySignatureType = alphaTab.model.KeySignatureType.Major
                                }
                                "minor" -> 
                                {
                                    masterBar.keySignatureType = alphaTab.model.KeySignatureType.Minor
                                }
                                else -> { }
                            }
                        }
                    }
                    "Fermatas" -> 
                    {
                        this.parseFermatas(masterBar, c)
                    }
                    "XProperties" -> 
                    {
                        this.parseMasterBarXProperties(c, masterBar)
                    }
                    else -> { }
                }
            }
        }
        this._masterBars.push(masterBar)
    }
    
    /**
     */
    private fun parseFermatas(masterBar: alphaTab.model.MasterBar, node: alphaTab.xml.XmlNode): Unit{
        for (c in node.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "Fermata" -> 
                    {
                        this.parseFermata(masterBar, c)
                    }
                    else -> { }
                }
            }
        }
    }
    
    /**
     */
    private fun parseFermata(masterBar: alphaTab.model.MasterBar, node: alphaTab.xml.XmlNode): Unit{
        var offset: Double = 0.0
        var fermata: alphaTab.model.Fermata = alphaTab.model.Fermata()
        for (c in node.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "Type" -> 
                    {
                        when (c.innerText)
                        {
                            "Short" -> 
                            {
                                fermata.type = alphaTab.model.FermataType.Short
                            }
                            "Medium" -> 
                            {
                                fermata.type = alphaTab.model.FermataType.Medium
                            }
                            "Long" -> 
                            {
                                fermata.type = alphaTab.model.FermataType.Long
                            }
                            else -> { }
                        }
                    }
                    "Length" -> 
                    {
                        fermata.length = alphaTab.core.Globals.parseFloat(c.innerText)
                    }
                    "Offset" -> 
                    {
                        var parts: alphaTab.collections.List<String> = c.innerText.splitBy("/")
                        if (parts.length == 2.0)
                        {
                            var numerator: Double = alphaTab.core.Globals.parseInt(parts[(0).toInt()])
                            var denominator: Double = alphaTab.core.Globals.parseInt(parts[(1).toInt()])
                            offset = ((((numerator / denominator) * alphaTab.midi.MidiUtils.QuarterTime)).toInt() or 0).toDouble()
                        }
                    }
                    else -> { }
                }
            }
        }
        masterBar.addFermata(offset, fermata)
    }
    
    /**
     */
    private fun parseBars(node: alphaTab.xml.XmlNode): Unit{
        for (c in node.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "Bar" -> 
                    {
                        this.parseBar(c)
                    }
                    else -> { }
                }
            }
        }
    }
    
    /**
     */
    private fun parseBar(node: alphaTab.xml.XmlNode): Unit{
        var bar: alphaTab.model.Bar = alphaTab.model.Bar()
        var barId: String = node.getAttribute("id")
        for (c in node.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "Voices" -> 
                    {
                        this._voicesOfBar.set(barId, c.innerText.splitBy(" "))
                    }
                    "Clef" -> 
                    {
                        when (c.innerText)
                        {
                            "Neutral" -> 
                            {
                                bar.clef = alphaTab.model.Clef.Neutral
                            }
                            "G2" -> 
                            {
                                bar.clef = alphaTab.model.Clef.G2
                            }
                            "F4" -> 
                            {
                                bar.clef = alphaTab.model.Clef.F4
                            }
                            "C4" -> 
                            {
                                bar.clef = alphaTab.model.Clef.C4
                            }
                            "C3" -> 
                            {
                                bar.clef = alphaTab.model.Clef.C3
                            }
                            else -> { }
                        }
                    }
                    "Ottavia" -> 
                    {
                        when (c.innerText)
                        {
                            "8va" -> 
                            {
                                bar.clefOttava = alphaTab.model.Ottavia._8va
                            }
                            "15ma" -> 
                            {
                                bar.clefOttava = alphaTab.model.Ottavia._15ma
                            }
                            "8vb" -> 
                            {
                                bar.clefOttava = alphaTab.model.Ottavia._8vb
                            }
                            "15mb" -> 
                            {
                                bar.clefOttava = alphaTab.model.Ottavia._15mb
                            }
                            else -> { }
                        }
                    }
                    "SimileMark" -> 
                    {
                        when (c.innerText)
                        {
                            "Simple" -> 
                            {
                                bar.simileMark = alphaTab.model.SimileMark.Simple
                            }
                            "FirstOfDouble" -> 
                            {
                                bar.simileMark = alphaTab.model.SimileMark.FirstOfDouble
                            }
                            "SecondOfDouble" -> 
                            {
                                bar.simileMark = alphaTab.model.SimileMark.SecondOfDouble
                            }
                            else -> { }
                        }
                    }
                    "XProperties" -> 
                    {
                        this.parseBarXProperties(c, bar)
                    }
                    else -> { }
                }
            }
        }
        this._barsById.set(barId, bar)
    }
    
    /**
     */
    private fun parseVoices(node: alphaTab.xml.XmlNode): Unit{
        for (c in node.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "Voice" -> 
                    {
                        this.parseVoice(c)
                    }
                    else -> { }
                }
            }
        }
    }
    
    /**
     */
    private fun parseVoice(node: alphaTab.xml.XmlNode): Unit{
        var voice: alphaTab.model.Voice = alphaTab.model.Voice()
        var voiceId: String = node.getAttribute("id")
        for (c in node.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "Beats" -> 
                    {
                        this._beatsOfVoice.set(voiceId, c.innerText.splitBy(" "))
                    }
                    else -> { }
                }
            }
        }
        this._voiceById.set(voiceId, voice)
    }
    
    /**
     */
    private fun parseBeats(node: alphaTab.xml.XmlNode): Unit{
        for (c in node.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "Beat" -> 
                    {
                        this.parseBeat(c)
                    }
                    else -> { }
                }
            }
        }
    }
    
    /**
     */
    private fun parseBeat(node: alphaTab.xml.XmlNode): Unit{
        var beat: alphaTab.model.Beat = alphaTab.model.Beat()
        var beatId: String = node.getAttribute("id")
        for (c in node.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "Notes" -> 
                    {
                        this._notesOfBeat.set(beatId, c.innerText.splitBy(" "))
                    }
                    "Rhythm" -> 
                    {
                        this._rhythmOfBeat.set(beatId, c.getAttribute("ref"))
                    }
                    "Fadding" -> 
                    {
                        if (c.innerText == "FadeIn")
                        {
                            beat.fadeIn = true
                        }
                    }
                    "Tremolo" -> 
                    {
                        when (c.innerText)
                        {
                            "1/2" -> 
                            {
                                beat.tremoloSpeed = alphaTab.model.Duration.Eighth
                            }
                            "1/4" -> 
                            {
                                beat.tremoloSpeed = alphaTab.model.Duration.Sixteenth
                            }
                            "1/8" -> 
                            {
                                beat.tremoloSpeed = alphaTab.model.Duration.ThirtySecond
                            }
                            else -> { }
                        }
                    }
                    "Chord" -> 
                    {
                        beat.chordId = c.innerText
                    }
                    "Hairpin" -> 
                    {
                        when (c.innerText)
                        {
                            "Crescendo" -> 
                            {
                                beat.crescendo = alphaTab.model.CrescendoType.Crescendo
                            }
                            "Decrescendo" -> 
                            {
                                beat.crescendo = alphaTab.model.CrescendoType.Decrescendo
                            }
                            else -> { }
                        }
                    }
                    "Arpeggio" -> 
                    {
                        if (c.innerText == "Up")
                        {
                            beat.brushType = alphaTab.model.BrushType.ArpeggioUp
                        }
                        else 
                        {
                            beat.brushType = alphaTab.model.BrushType.ArpeggioDown
                        }
                    }
                    "Properties" -> 
                    {
                        this.parseBeatProperties(c, beat)
                    }
                    "XProperties" -> 
                    {
                        this.parseBeatXProperties(c, beat)
                    }
                    "FreeText" -> 
                    {
                        beat.text = c.innerText
                    }
                    "TransposedPitchStemOrientation" -> 
                    {
                        when (c.innerText)
                        {
                            "Upward" -> 
                            {
                                beat.preferredBeamDirection = alphaTab.rendering.utils.BeamDirection.Up
                            }
                            "Downward" -> 
                            {
                                beat.preferredBeamDirection = alphaTab.rendering.utils.BeamDirection.Down
                            }
                            else -> { }
                        }
                    }
                    "Dynamic" -> 
                    {
                        when (c.innerText)
                        {
                            "PPP" -> 
                            {
                                beat.dynamics = alphaTab.model.DynamicValue.PPP
                            }
                            "PP" -> 
                            {
                                beat.dynamics = alphaTab.model.DynamicValue.PP
                            }
                            "P" -> 
                            {
                                beat.dynamics = alphaTab.model.DynamicValue.P
                            }
                            "MP" -> 
                            {
                                beat.dynamics = alphaTab.model.DynamicValue.MP
                            }
                            "MF" -> 
                            {
                                beat.dynamics = alphaTab.model.DynamicValue.MF
                            }
                            "F" -> 
                            {
                                beat.dynamics = alphaTab.model.DynamicValue.F
                            }
                            "FF" -> 
                            {
                                beat.dynamics = alphaTab.model.DynamicValue.FF
                            }
                            "FFF" -> 
                            {
                                beat.dynamics = alphaTab.model.DynamicValue.FFF
                            }
                            else -> { }
                        }
                    }
                    "GraceNotes" -> 
                    {
                        when (c.innerText)
                        {
                            "OnBeat" -> 
                            {
                                beat.graceType = alphaTab.model.GraceType.OnBeat
                            }
                            "BeforeBeat" -> 
                            {
                                beat.graceType = alphaTab.model.GraceType.BeforeBeat
                            }
                            else -> { }
                        }
                    }
                    "Legato" -> 
                    {
                        if (c.getAttribute("origin") == "true")
                        {
                            beat.isLegatoOrigin = true
                        }
                    }
                    "Whammy" -> 
                    {
                        var whammyOrigin: alphaTab.model.BendPoint = alphaTab.model.BendPoint(0.0, 0.0)
                        whammyOrigin.value = this.toBendValue(alphaTab.core.Globals.parseFloat(c.getAttribute("originValue")))
                        whammyOrigin.offset = this.toBendOffset(alphaTab.core.Globals.parseFloat(c.getAttribute("originOffset")))
                        beat.addWhammyBarPoint(whammyOrigin)
                        var whammyMiddle1: alphaTab.model.BendPoint = alphaTab.model.BendPoint(0.0, 0.0)
                        whammyMiddle1.value = this.toBendValue(alphaTab.core.Globals.parseFloat(c.getAttribute("middleValue")))
                        whammyMiddle1.offset = this.toBendOffset(alphaTab.core.Globals.parseFloat(c.getAttribute("middleOffset1")))
                        beat.addWhammyBarPoint(whammyMiddle1)
                        var whammyMiddle2: alphaTab.model.BendPoint = alphaTab.model.BendPoint(0.0, 0.0)
                        whammyMiddle2.value = this.toBendValue(alphaTab.core.Globals.parseFloat(c.getAttribute("middleValue")))
                        whammyMiddle2.offset = this.toBendOffset(alphaTab.core.Globals.parseFloat(c.getAttribute("middleOffset2")))
                        beat.addWhammyBarPoint(whammyMiddle2)
                        var whammyDestination: alphaTab.model.BendPoint = alphaTab.model.BendPoint(0.0, 0.0)
                        whammyDestination.value = this.toBendValue(alphaTab.core.Globals.parseFloat(c.getAttribute("destinationValue")))
                        whammyDestination.offset = this.toBendOffset(alphaTab.core.Globals.parseFloat(c.getAttribute("destinationOffset")))
                        beat.addWhammyBarPoint(whammyDestination)
                    }
                    "Ottavia" -> 
                    {
                        when (c.innerText)
                        {
                            "8va" -> 
                            {
                                beat.ottava = alphaTab.model.Ottavia._8va
                            }
                            "8vb" -> 
                            {
                                beat.ottava = alphaTab.model.Ottavia._8vb
                            }
                            "15ma" -> 
                            {
                                beat.ottava = alphaTab.model.Ottavia._15ma
                            }
                            "15mb" -> 
                            {
                                beat.ottava = alphaTab.model.Ottavia._15mb
                            }
                            else -> { }
                        }
                    }
                    "Lyrics" -> 
                    {
                        beat.lyrics = this.parseBeatLyrics(c)
                        this._skipApplyLyrics = true
                    }
                    else -> { }
                }
            }
        }
        this._beatById.set(beatId, beat)
    }
    
    /**
     */
    private fun parseBeatLyrics(node: alphaTab.xml.XmlNode): alphaTab.collections.List<String>{
        var lines: alphaTab.collections.List<String> = alphaTab.collections.List<String>(
        )
        
        for (c in node.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "Line" -> 
                    {
                        lines.push(c.innerText)
                    }
                    else -> { }
                }
            }
        }
        return lines
    }
    
    /**
     */
    private fun parseBeatXProperties(node: alphaTab.xml.XmlNode, beat: alphaTab.model.Beat): Unit{
        for (c in node.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "XProperty" -> 
                    {
                        var id: String = c.getAttribute("id")
                        var value: Double = 0.0
                        when (id)
                        {
                            "1124204545" -> 
                            {
                                value = alphaTab.core.Globals.parseInt(c.findChildElement("Int")!!.innerText)
                                beat.invertBeamDirection = value == 1.0
                            }
                            "687935489" -> 
                            {
                                value = alphaTab.core.Globals.parseInt(c.findChildElement("Int")!!.innerText)
                                beat.brushDuration = value
                            }
                            else -> { }
                        }
                    }
                    else -> { }
                }
            }
        }
    }
    
    /**
     */
    private fun parseBarXProperties(node: alphaTab.xml.XmlNode, bar: alphaTab.model.Bar): Unit{
        for (c in node.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "XProperty" -> 
                    {
                        var id: String = c.getAttribute("id")
                        when (id)
                        {
                            "1124139520" -> 
                            {
                                var childNode: alphaTab.xml.XmlNode? = c.findChildElement("Double") ?: c.findChildElement("Float")
                                bar.displayScale = alphaTab.core.Globals.parseFloat(childNode!!.innerText)
                            }
                            else -> { }
                        }
                    }
                    else -> { }
                }
            }
        }
    }
    
    /**
     */
    private fun parseMasterBarXProperties(node: alphaTab.xml.XmlNode, masterBar: alphaTab.model.MasterBar): Unit{
        for (c in node.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "XProperty" -> 
                    {
                        var id: String = c.getAttribute("id")
                        when (id)
                        {
                            "1124073984" -> 
                            {
                                masterBar.displayScale = alphaTab.core.Globals.parseFloat(c.findChildElement("Double")!!.innerText)
                            }
                            else -> { }
                        }
                    }
                    else -> { }
                }
            }
        }
    }
    
    /**
     */
    private fun parseBeatProperties(node: alphaTab.xml.XmlNode, beat: alphaTab.model.Beat): Unit{
        var isWhammy: Boolean = false
        var whammyOrigin: alphaTab.model.BendPoint? = null
        var whammyMiddleValue: Double? = null
        var whammyMiddleOffset1: Double? = null
        var whammyMiddleOffset2: Double? = null
        var whammyDestination: alphaTab.model.BendPoint? = null
        for (c in node.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "Property" -> 
                    {
                        var name: String = c.getAttribute("name")
                        when (name)
                        {
                            "Brush" -> 
                            {
                                if (c.findChildElement("Direction")!!.innerText == "Up")
                                {
                                    beat.brushType = alphaTab.model.BrushType.BrushUp
                                }
                                else 
                                {
                                    beat.brushType = alphaTab.model.BrushType.BrushDown
                                }
                            }
                            "PickStroke" -> 
                            {
                                if (c.findChildElement("Direction")!!.innerText == "Up")
                                {
                                    beat.pickStroke = alphaTab.model.PickStroke.Up
                                }
                                else 
                                {
                                    beat.pickStroke = alphaTab.model.PickStroke.Down
                                }
                            }
                            "Slapped" -> 
                            {
                                if (alphaTab.core.TypeHelper.isTruthy(c.findChildElement("Enable")))
                                {
                                    beat.slap = true
                                }
                            }
                            "Popped" -> 
                            {
                                if (alphaTab.core.TypeHelper.isTruthy(c.findChildElement("Enable")))
                                {
                                    beat.pop = true
                                }
                            }
                            "VibratoWTremBar" -> 
                            {
                                when (c.findChildElement("Strength")!!.innerText)
                                {
                                    "Wide" -> 
                                    {
                                        beat.vibrato = alphaTab.model.VibratoType.Wide
                                    }
                                    "Slight" -> 
                                    {
                                        beat.vibrato = alphaTab.model.VibratoType.Slight
                                    }
                                    else -> { }
                                }
                            }
                            "WhammyBar" -> 
                            {
                                isWhammy = true
                            }
                            "WhammyBarExtend" -> 
                            {
                            }
                            "WhammyBarOriginValue" -> 
                            {
                                if (!alphaTab.core.TypeHelper.isTruthy(whammyOrigin))
                                {
                                    whammyOrigin = alphaTab.model.BendPoint(0.0, 0.0)
                                }
                                whammyOrigin.value = this.toBendValue(alphaTab.core.Globals.parseFloat(c.findChildElement("Float")!!.innerText))
                            }
                            "WhammyBarOriginOffset" -> 
                            {
                                if (!alphaTab.core.TypeHelper.isTruthy(whammyOrigin))
                                {
                                    whammyOrigin = alphaTab.model.BendPoint(0.0, 0.0)
                                }
                                whammyOrigin.offset = this.toBendOffset(alphaTab.core.Globals.parseFloat(c.findChildElement("Float")!!.innerText))
                            }
                            "WhammyBarMiddleValue" -> 
                            {
                                whammyMiddleValue = this.toBendValue(alphaTab.core.Globals.parseFloat(c.findChildElement("Float")!!.innerText))
                            }
                            "WhammyBarMiddleOffset1" -> 
                            {
                                whammyMiddleOffset1 = this.toBendOffset(alphaTab.core.Globals.parseFloat(c.findChildElement("Float")!!.innerText))
                            }
                            "WhammyBarMiddleOffset2" -> 
                            {
                                whammyMiddleOffset2 = this.toBendOffset(alphaTab.core.Globals.parseFloat(c.findChildElement("Float")!!.innerText))
                            }
                            "WhammyBarDestinationValue" -> 
                            {
                                if (!alphaTab.core.TypeHelper.isTruthy(whammyDestination))
                                {
                                    whammyDestination = alphaTab.model.BendPoint(alphaTab.model.BendPoint.MaxPosition, 0.0)
                                }
                                whammyDestination.value = this.toBendValue(alphaTab.core.Globals.parseFloat(c.findChildElement("Float")!!.innerText))
                            }
                            "WhammyBarDestinationOffset" -> 
                            {
                                if (!alphaTab.core.TypeHelper.isTruthy(whammyDestination))
                                {
                                    whammyDestination = alphaTab.model.BendPoint(0.0, 0.0)
                                }
                                whammyDestination.offset = this.toBendOffset(alphaTab.core.Globals.parseFloat(c.findChildElement("Float")!!.innerText))
                            }
                            else -> { }
                        }
                    }
                    else -> { }
                }
            }
        }
        if (isWhammy)
        {
            if (!alphaTab.core.TypeHelper.isTruthy(whammyOrigin))
            {
                whammyOrigin = alphaTab.model.BendPoint(0.0, 0.0)
            }
            if (!alphaTab.core.TypeHelper.isTruthy(whammyDestination))
            {
                whammyDestination = alphaTab.model.BendPoint(alphaTab.model.BendPoint.MaxPosition, 0.0)
            }
            beat.addWhammyBarPoint(whammyOrigin)
            if (alphaTab.core.TypeHelper.isTruthy(whammyMiddleOffset1) && alphaTab.core.TypeHelper.isTruthy(whammyMiddleValue))
            {
                beat.addWhammyBarPoint(alphaTab.model.BendPoint(whammyMiddleOffset1, whammyMiddleValue))
            }
            if (alphaTab.core.TypeHelper.isTruthy(whammyMiddleOffset2) && alphaTab.core.TypeHelper.isTruthy(whammyMiddleValue))
            {
                beat.addWhammyBarPoint(alphaTab.model.BendPoint(whammyMiddleOffset2, whammyMiddleValue))
            }
            if (!alphaTab.core.TypeHelper.isTruthy(whammyMiddleOffset1) && !alphaTab.core.TypeHelper.isTruthy(whammyMiddleOffset2) && alphaTab.core.TypeHelper.isTruthy(whammyMiddleValue))
            {
                beat.addWhammyBarPoint(alphaTab.model.BendPoint((((alphaTab.model.BendPoint.MaxPosition / (2.0).toDouble())).toInt() or 0).toDouble(), whammyMiddleValue))
            }
            beat.addWhammyBarPoint(whammyDestination)
        }
    }
    
    /**
     */
    private fun parseNotes(node: alphaTab.xml.XmlNode): Unit{
        for (c in node.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "Note" -> 
                    {
                        this.parseNote(c)
                    }
                    else -> { }
                }
            }
        }
    }
    
    /**
     */
    private fun parseNote(node: alphaTab.xml.XmlNode): Unit{
        var note: alphaTab.model.Note = alphaTab.model.Note()
        var noteId: String = node.getAttribute("id")
        for (c in node.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "Properties" -> 
                    {
                        this.parseNoteProperties(c, note, noteId)
                    }
                    "AntiAccent" -> 
                    {
                        if (c.innerText.lowercase() == "normal")
                        {
                            note.isGhost = true
                        }
                    }
                    "LetRing" -> 
                    {
                        note.isLetRing = true
                    }
                    "Trill" -> 
                    {
                        note.trillValue = alphaTab.core.Globals.parseInt(c.innerText)
                        note.trillSpeed = alphaTab.model.Duration.Sixteenth
                    }
                    "Accent" -> 
                    {
                        var accentFlags: Double = alphaTab.core.Globals.parseInt(c.innerText)
                        if (((accentFlags).toInt() and 1) != 0)
                        {
                            note.isStaccato = true
                        }
                        if (((accentFlags).toInt() and 4) != 0)
                        {
                            note.accentuated = alphaTab.model.AccentuationType.Heavy
                        }
                        if (((accentFlags).toInt() and 8) != 0)
                        {
                            note.accentuated = alphaTab.model.AccentuationType.Normal
                        }
                    }
                    "Tie" -> 
                    {
                        if (c.getAttribute("destination").lowercase() == "true")
                        {
                            note.isTieDestination = true
                        }
                    }
                    "Vibrato" -> 
                    {
                        when (c.innerText)
                        {
                            "Slight" -> 
                            {
                                note.vibrato = alphaTab.model.VibratoType.Slight
                            }
                            "Wide" -> 
                            {
                                note.vibrato = alphaTab.model.VibratoType.Wide
                            }
                            else -> { }
                        }
                    }
                    "LeftFingering" -> 
                    {
                        note.isFingering = true
                        when (c.innerText)
                        {
                            "P" -> 
                            {
                                note.leftHandFinger = alphaTab.model.Fingers.Thumb
                            }
                            "I" -> 
                            {
                                note.leftHandFinger = alphaTab.model.Fingers.IndexFinger
                            }
                            "M" -> 
                            {
                                note.leftHandFinger = alphaTab.model.Fingers.MiddleFinger
                            }
                            "A" -> 
                            {
                                note.leftHandFinger = alphaTab.model.Fingers.AnnularFinger
                            }
                            "C" -> 
                            {
                                note.leftHandFinger = alphaTab.model.Fingers.LittleFinger
                            }
                            else -> { }
                        }
                    }
                    "RightFingering" -> 
                    {
                        note.isFingering = true
                        when (c.innerText)
                        {
                            "P" -> 
                            {
                                note.rightHandFinger = alphaTab.model.Fingers.Thumb
                            }
                            "I" -> 
                            {
                                note.rightHandFinger = alphaTab.model.Fingers.IndexFinger
                            }
                            "M" -> 
                            {
                                note.rightHandFinger = alphaTab.model.Fingers.MiddleFinger
                            }
                            "A" -> 
                            {
                                note.rightHandFinger = alphaTab.model.Fingers.AnnularFinger
                            }
                            "C" -> 
                            {
                                note.rightHandFinger = alphaTab.model.Fingers.LittleFinger
                            }
                            else -> { }
                        }
                    }
                    "InstrumentArticulation" -> 
                    {
                        note.percussionArticulation = alphaTab.core.Globals.parseInt(c.innerText)
                    }
                    else -> { }
                }
            }
        }
        this._noteById.set(noteId, note)
    }
    
    /**
     */
    private fun parseNoteProperties(node: alphaTab.xml.XmlNode, note: alphaTab.model.Note, noteId: String): Unit{
        var isBended: Boolean = false
        var bendOrigin: alphaTab.model.BendPoint? = null
        var bendMiddleValue: Double? = null
        var bendMiddleOffset1: Double? = null
        var bendMiddleOffset2: Double? = null
        var bendDestination: alphaTab.model.BendPoint? = null
        var element: Double = -1.0
        var variation: Double = -1.0
        for (c in node.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "Property" -> 
                    {
                        var name: String = c.getAttribute("name")
                        when (name)
                        {
                            "String" -> 
                            {
                                note.string = alphaTab.core.Globals.parseInt(c.findChildElement("String")!!.innerText) + 1.0
                            }
                            "Fret" -> 
                            {
                                note.fret = alphaTab.core.Globals.parseInt(c.findChildElement("Fret")!!.innerText)
                            }
                            "Element" -> 
                            {
                                element = alphaTab.core.Globals.parseInt(c.findChildElement("Element")!!.innerText)
                            }
                            "Variation" -> 
                            {
                                variation = alphaTab.core.Globals.parseInt(c.findChildElement("Variation")!!.innerText)
                            }
                            "Tapped" -> 
                            {
                                this._tappedNotes.set(noteId, true)
                            }
                            "HarmonicType" -> 
                            {
                                var htype: alphaTab.xml.XmlNode = c.findChildElement("HType")!!
                                if (alphaTab.core.TypeHelper.isTruthy(htype))
                                {
                                    when (htype.innerText)
                                    {
                                        "NoHarmonic" -> 
                                        {
                                            note.harmonicType = alphaTab.model.HarmonicType.None
                                        }
                                        "Natural" -> 
                                        {
                                            note.harmonicType = alphaTab.model.HarmonicType.Natural
                                        }
                                        "Artificial" -> 
                                        {
                                            note.harmonicType = alphaTab.model.HarmonicType.Artificial
                                        }
                                        "Pinch" -> 
                                        {
                                            note.harmonicType = alphaTab.model.HarmonicType.Pinch
                                        }
                                        "Tap" -> 
                                        {
                                            note.harmonicType = alphaTab.model.HarmonicType.Tap
                                        }
                                        "Semi" -> 
                                        {
                                            note.harmonicType = alphaTab.model.HarmonicType.Semi
                                        }
                                        "Feedback" -> 
                                        {
                                            note.harmonicType = alphaTab.model.HarmonicType.Feedback
                                        }
                                        else -> { }
                                    }
                                }
                            }
                            "HarmonicFret" -> 
                            {
                                var hfret: alphaTab.xml.XmlNode = c.findChildElement("HFret")!!
                                if (alphaTab.core.TypeHelper.isTruthy(hfret))
                                {
                                    note.harmonicValue = alphaTab.core.Globals.parseFloat(hfret.innerText)
                                }
                            }
                            "Muted" -> 
                            {
                                if (alphaTab.core.TypeHelper.isTruthy(c.findChildElement("Enable")))
                                {
                                    note.isDead = true
                                }
                            }
                            "PalmMuted" -> 
                            {
                                if (alphaTab.core.TypeHelper.isTruthy(c.findChildElement("Enable")))
                                {
                                    note.isPalmMute = true
                                }
                            }
                            "Octave" -> 
                            {
                                note.octave = alphaTab.core.Globals.parseInt(c.findChildElement("Number")!!.innerText)
                                if (note.tone == -1.0)
                                {
                                    note.tone = 0.0
                                }
                            }
                            "Tone" -> 
                            {
                                note.tone = alphaTab.core.Globals.parseInt(c.findChildElement("Step")!!.innerText)
                            }
                            "ConcertPitch" -> 
                            {
                                this.parseConcertPitch(c, note)
                            }
                            "Bended" -> 
                            {
                                isBended = true
                            }
                            "BendOriginValue" -> 
                            {
                                if (!alphaTab.core.TypeHelper.isTruthy(bendOrigin))
                                {
                                    bendOrigin = alphaTab.model.BendPoint(0.0, 0.0)
                                }
                                bendOrigin.value = this.toBendValue(alphaTab.core.Globals.parseFloat(c.findChildElement("Float")!!.innerText))
                            }
                            "BendOriginOffset" -> 
                            {
                                if (!alphaTab.core.TypeHelper.isTruthy(bendOrigin))
                                {
                                    bendOrigin = alphaTab.model.BendPoint(0.0, 0.0)
                                }
                                bendOrigin.offset = this.toBendOffset(alphaTab.core.Globals.parseFloat(c.findChildElement("Float")!!.innerText))
                            }
                            "BendMiddleValue" -> 
                            {
                                bendMiddleValue = this.toBendValue(alphaTab.core.Globals.parseFloat(c.findChildElement("Float")!!.innerText))
                            }
                            "BendMiddleOffset1" -> 
                            {
                                bendMiddleOffset1 = this.toBendOffset(alphaTab.core.Globals.parseFloat(c.findChildElement("Float")!!.innerText))
                            }
                            "BendMiddleOffset2" -> 
                            {
                                bendMiddleOffset2 = this.toBendOffset(alphaTab.core.Globals.parseFloat(c.findChildElement("Float")!!.innerText))
                            }
                            "BendDestinationValue" -> 
                            {
                                if (!alphaTab.core.TypeHelper.isTruthy(bendDestination))
                                {
                                    bendDestination = alphaTab.model.BendPoint(alphaTab.model.BendPoint.MaxPosition, 0.0)
                                }
                                bendDestination.value = this.toBendValue(alphaTab.core.Globals.parseFloat(c.findChildElement("Float")!!.innerText))
                            }
                            "BendDestinationOffset" -> 
                            {
                                if (!alphaTab.core.TypeHelper.isTruthy(bendDestination))
                                {
                                    bendDestination = alphaTab.model.BendPoint(0.0, 0.0)
                                }
                                bendDestination.offset = this.toBendOffset(alphaTab.core.Globals.parseFloat(c.findChildElement("Float")!!.innerText))
                            }
                            "HopoOrigin" -> 
                            {
                                if (alphaTab.core.TypeHelper.isTruthy(c.findChildElement("Enable")))
                                {
                                    note.isHammerPullOrigin = true
                                }
                            }
                            "HopoDestination" -> 
                            {
                            }
                            "LeftHandTapped" -> 
                            {
                                note.isLeftHandTapped = true
                            }
                            "Slide" -> 
                            {
                                var slideFlags: Double = alphaTab.core.Globals.parseInt(c.findChildElement("Flags")!!.innerText)
                                if (((slideFlags).toInt() and 1) != 0)
                                {
                                    note.slideOutType = alphaTab.model.SlideOutType.Shift
                                }
                                else if (((slideFlags).toInt() and 2) != 0)
                                {
                                    note.slideOutType = alphaTab.model.SlideOutType.Legato
                                }
                                else if (((slideFlags).toInt() and 4) != 0)
                                {
                                    note.slideOutType = alphaTab.model.SlideOutType.OutDown
                                }
                                else if (((slideFlags).toInt() and 8) != 0)
                                {
                                    note.slideOutType = alphaTab.model.SlideOutType.OutUp
                                }
                                if (((slideFlags).toInt() and 16) != 0)
                                {
                                    note.slideInType = alphaTab.model.SlideInType.IntoFromBelow
                                }
                                else if (((slideFlags).toInt() and 32) != 0)
                                {
                                    note.slideInType = alphaTab.model.SlideInType.IntoFromAbove
                                }
                                if (((slideFlags).toInt() and 64) != 0)
                                {
                                    note.slideOutType = alphaTab.model.SlideOutType.PickSlideDown
                                }
                                else if (((slideFlags).toInt() and 128) != 0)
                                {
                                    note.slideOutType = alphaTab.model.SlideOutType.PickSlideUp
                                }
                            }
                            else -> { }
                        }
                    }
                    else -> { }
                }
            }
        }
        if (isBended)
        {
            if (!alphaTab.core.TypeHelper.isTruthy(bendOrigin))
            {
                bendOrigin = alphaTab.model.BendPoint(0.0, 0.0)
            }
            if (!alphaTab.core.TypeHelper.isTruthy(bendDestination))
            {
                bendDestination = alphaTab.model.BendPoint(alphaTab.model.BendPoint.MaxPosition, 0.0)
            }
            note.addBendPoint(bendOrigin)
            if (alphaTab.core.TypeHelper.isTruthy(bendMiddleOffset1) && alphaTab.core.TypeHelper.isTruthy(bendMiddleValue))
            {
                note.addBendPoint(alphaTab.model.BendPoint(bendMiddleOffset1, bendMiddleValue))
            }
            if (alphaTab.core.TypeHelper.isTruthy(bendMiddleOffset2) && alphaTab.core.TypeHelper.isTruthy(bendMiddleValue))
            {
                note.addBendPoint(alphaTab.model.BendPoint(bendMiddleOffset2, bendMiddleValue))
            }
            if (!alphaTab.core.TypeHelper.isTruthy(bendMiddleOffset1) && !alphaTab.core.TypeHelper.isTruthy(bendMiddleOffset2) && alphaTab.core.TypeHelper.isTruthy(bendMiddleValue))
            {
                note.addBendPoint(alphaTab.model.BendPoint((((alphaTab.model.BendPoint.MaxPosition / (2.0).toDouble())).toInt() or 0).toDouble(), bendMiddleValue))
            }
            note.addBendPoint(bendDestination)
        }
        if (element != -1.0 && variation != -1.0)
        {
            note.percussionArticulation = alphaTab.model.PercussionMapper.articulationFromElementVariation(element, variation)
        }
    }
    
    /**
     */
    private fun parseConcertPitch(node: alphaTab.xml.XmlNode, note: alphaTab.model.Note): Unit{
        var pitch: alphaTab.xml.XmlNode? = node.findChildElement("Pitch")
        if (alphaTab.core.TypeHelper.isTruthy(pitch))
        {
            for (c in pitch.childNodes)
            {
                if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
                {
                    when (c.localName)
                    {
                        "Accidental" -> 
                        {
                            when (c.innerText)
                            {
                                "x" -> 
                                {
                                    note.accidentalMode = alphaTab.model.NoteAccidentalMode.ForceDoubleSharp
                                }
                                "#" -> 
                                {
                                    note.accidentalMode = alphaTab.model.NoteAccidentalMode.ForceSharp
                                }
                                "b" -> 
                                {
                                    note.accidentalMode = alphaTab.model.NoteAccidentalMode.ForceFlat
                                }
                                "bb" -> 
                                {
                                    note.accidentalMode = alphaTab.model.NoteAccidentalMode.ForceDoubleFlat
                                }
                                else -> { }
                            }
                        }
                        else -> { }
                    }
                }
            }
        }
    }
    
    /**
     */
    private fun toBendValue(gpxValue: Double): Double{
        return (((gpxValue * alphaTab.importer.GpifParser.BendPointValueFactor)).toInt() or 0).toDouble()
    }
    
    /**
     */
    private fun toBendOffset(gpxOffset: Double): Double{
        return (gpxOffset * alphaTab.importer.GpifParser.BendPointPositionFactor)
    }
    
    /**
     */
    private fun parseRhythms(node: alphaTab.xml.XmlNode): Unit{
        for (c in node.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "Rhythm" -> 
                    {
                        this.parseRhythm(c)
                    }
                    else -> { }
                }
            }
        }
    }
    
    /**
     */
    private fun parseRhythm(node: alphaTab.xml.XmlNode): Unit{
        var rhythm: alphaTab.importer.GpifRhythm = alphaTab.importer.GpifRhythm()
        var rhythmId: String = node.getAttribute("id")
        rhythm.id = rhythmId
        for (c in node.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "NoteValue" -> 
                    {
                        when (c.innerText)
                        {
                            "Long" -> 
                            {
                                rhythm.value = alphaTab.model.Duration.QuadrupleWhole
                            }
                            "DoubleWhole" -> 
                            {
                                rhythm.value = alphaTab.model.Duration.DoubleWhole
                            }
                            "Whole" -> 
                            {
                                rhythm.value = alphaTab.model.Duration.Whole
                            }
                            "Half" -> 
                            {
                                rhythm.value = alphaTab.model.Duration.Half
                            }
                            "Quarter" -> 
                            {
                                rhythm.value = alphaTab.model.Duration.Quarter
                            }
                            "Eighth" -> 
                            {
                                rhythm.value = alphaTab.model.Duration.Eighth
                            }
                            "16th" -> 
                            {
                                rhythm.value = alphaTab.model.Duration.Sixteenth
                            }
                            "32nd" -> 
                            {
                                rhythm.value = alphaTab.model.Duration.ThirtySecond
                            }
                            "64th" -> 
                            {
                                rhythm.value = alphaTab.model.Duration.SixtyFourth
                            }
                            "128th" -> 
                            {
                                rhythm.value = alphaTab.model.Duration.OneHundredTwentyEighth
                            }
                            "256th" -> 
                            {
                                rhythm.value = alphaTab.model.Duration.TwoHundredFiftySixth
                            }
                            else -> { }
                        }
                    }
                    "PrimaryTuplet" -> 
                    {
                        rhythm.tupletNumerator = alphaTab.core.Globals.parseInt(c.getAttribute("num"))
                        rhythm.tupletDenominator = alphaTab.core.Globals.parseInt(c.getAttribute("den"))
                    }
                    "AugmentationDot" -> 
                    {
                        rhythm.dots = alphaTab.core.Globals.parseInt(c.getAttribute("count"))
                    }
                    else -> { }
                }
            }
        }
        this._rhythmById.set(rhythmId, rhythm)
    }
    
    private fun buildModel(): Unit{
        if(true) {
            var i: Double = 0.0
            var j: Double = this._masterBars.length
            
            while(i < j){
                try{
                    var masterBar: alphaTab.model.MasterBar = this._masterBars[(i).toInt()]
                    this.score.addMasterBar(masterBar)
                }
                finally{
                    i++
                }
            }
        }
        for (trackId in this._tracksMapping)
        {
            if (!alphaTab.core.TypeHelper.isTruthy(trackId))
            {
                continue
            }
            var track: alphaTab.model.Track = this._tracksById.get(trackId)!!
            this.score.addTrack(track)
        }
        for (barIds in this._barsOfMasterBar)
        {
            var staffIndex: Double = 0.0
            if(true) {
                var barIndex: Double = 0.0
                var trackIndex: Double = 0.0
                
                while(barIndex < barIds.length && trackIndex < this.score.tracks.length){
                    try{
                        var barId: String = barIds[(barIndex).toInt()]
                        if (barId != alphaTab.importer.GpifParser.InvalidId)
                        {
                            var bar: alphaTab.model.Bar = this._barsById.get(barId)!!
                            var track: alphaTab.model.Track = this.score.tracks[(trackIndex).toInt()]
                            var staff: alphaTab.model.Staff = track.staves[(staffIndex).toInt()]
                            staff.addBar(bar)
                            if (this._voicesOfBar.has(barId))
                            {
                                for (voiceId in this._voicesOfBar.get(barId)!!)
                                {
                                    if (voiceId != alphaTab.importer.GpifParser.InvalidId)
                                    {
                                        var voice: alphaTab.model.Voice = this._voiceById.get(voiceId)!!
                                        bar.addVoice(voice)
                                        if (this._beatsOfVoice.has(voiceId))
                                        {
                                            for (beatId in this._beatsOfVoice.get(voiceId)!!)
                                            {
                                                if (beatId != alphaTab.importer.GpifParser.InvalidId)
                                                {
                                                    var beat: alphaTab.model.Beat = alphaTab.generated.model.BeatCloner.clone(this._beatById.get(beatId)!!)
                                                    voice.addBeat(beat)
                                                    var rhythmId: String = this._rhythmOfBeat.get(beatId)!!
                                                    var rhythm: alphaTab.importer.GpifRhythm = this._rhythmById.get(rhythmId)!!
                                                    beat.duration = rhythm.value
                                                    beat.dots = rhythm.dots
                                                    beat.tupletNumerator = rhythm.tupletNumerator
                                                    beat.tupletDenominator = rhythm.tupletDenominator
                                                    if (this._notesOfBeat.has(beatId))
                                                    {
                                                        for (noteId in this._notesOfBeat.get(beatId)!!)
                                                        {
                                                            if (noteId != alphaTab.importer.GpifParser.InvalidId)
                                                            {
                                                                var note: alphaTab.model.Note = alphaTab.generated.model.NoteCloner.clone(this._noteById.get(noteId)!!)
                                                                if (staff.isPercussion)
                                                                {
                                                                    note.fret = -1.0
                                                                    note.string = -1.0
                                                                }
                                                                else 
                                                                {
                                                                    note.percussionArticulation = -1.0
                                                                }
                                                                beat.addNote(note)
                                                                if (this._tappedNotes.has(noteId))
                                                                {
                                                                    beat.tap = true
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    else 
                                    {
                                        var voice: alphaTab.model.Voice = alphaTab.model.Voice()
                                        bar.addVoice(voice)
                                        var beat: alphaTab.model.Beat = alphaTab.model.Beat()
                                        beat.isEmpty = true
                                        beat.duration = alphaTab.model.Duration.Quarter
                                        voice.addBeat(beat)
                                    }
                                }
                            }
                            if (staffIndex == track.staves.length - 1.0)
                            {
                                trackIndex++
                                staffIndex = 0.0
                            }
                            else 
                            {
                                staffIndex++
                            }
                        }
                        else 
                        {
                            trackIndex++
                        }
                    }
                    finally{
                        barIndex++
                    }
                }
            }
        }
        for (trackId in this._tracksMapping)
        {
            if (!alphaTab.core.TypeHelper.isTruthy(trackId))
            {
                continue
            }
            var track: alphaTab.model.Track = this._tracksById.get(trackId)!!
            var hasPercussion: Boolean = false
            for (staff in track.staves)
            {
                if (staff.isPercussion)
                {
                    hasPercussion = true
                    break
                }
            }
            if (!hasPercussion)
            {
                track.percussionArticulations = alphaTab.collections.List<alphaTab.model.InstrumentArticulation>(
                )
                
            }
            if (this._automationsPerTrackIdAndBarIndex.has(trackId))
            {
                var trackAutomations: alphaTab.collections.DoubleObjectMap<alphaTab.collections.List<alphaTab.model.Automation>> = this._automationsPerTrackIdAndBarIndex.get(trackId)!!
                for ((barNumber, automations) in trackAutomations)
                {
                    if (track.staves.length > 0 && barNumber < track.staves[(0).toInt()].bars.length)
                    {
                        var bar: alphaTab.model.Bar = track.staves[(0).toInt()].bars[(barNumber).toInt()]
                        if (bar.voices.length > 0 && bar.voices[(0).toInt()].beats.length > 0)
                        {
                            var beat: alphaTab.model.Beat = bar.voices[(0).toInt()].beats[(0).toInt()]
                            for (a in automations)
                            {
                                beat.automations.push(a)
                            }
                        }
                    }
                }
            }
        }
        for ((barNumber, automations) in this._masterTrackAutomations)
        {
            var masterBar: alphaTab.model.MasterBar = this.score.masterBars[(barNumber).toInt()]
            if(true) {
                var i: Double = 0.0
                var j: Double = automations.length
                
                while(i < j){
                    try{
                        var automation: alphaTab.model.Automation = automations[(i).toInt()]
                        if (automation.type == alphaTab.model.AutomationType.Tempo)
                        {
                            if (barNumber == 0.0)
                            {
                                this.score.tempo = ((automation.value).toInt() or 0).toDouble()
                                if (alphaTab.core.TypeHelper.isTruthy(automation.text))
                                {
                                    this.score.tempoLabel = automation.text
                                }
                            }
                            masterBar.tempoAutomation = automation
                        }
                    }
                    finally{
                        i++
                    }
                }
            }
        }
    }
    
    companion object{
        @kotlin.jvm.JvmStatic
        private val InvalidId: String = "-1"
        
        /**
         * GPX range: 0-100
         * Internal range: 0 - 60
         */
        @kotlin.jvm.JvmStatic
        private val BendPointPositionFactor: Double = alphaTab.model.BendPoint.MaxPosition / (100.0).toDouble()
        
        /**
         * GPIF: 25 per quarternote
         * Internal Range: 1 per quarter note
         */
        @kotlin.jvm.JvmStatic
        private val BendPointValueFactor: Double = (1.0).toDouble() / (25.0).toDouble()
        
    }
    public constructor()
}

/**
 * This structure represents a duration within a gpif
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class GpifRhythm
{
    public var id: String = ""
    
    public var dots: Double = 0.0
    
    public var tupletDenominator: Double = -1.0
    
    public var tupletNumerator: Double = -1.0
    
    public var value: alphaTab.model.Duration = alphaTab.model.Duration.Quarter
    
    public constructor()
}

@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class GpifSound
{
    public var name: String = ""
    
    public var path: String = ""
    
    public var role: String = ""
    
    public val uniqueId: String
    get(){
        return this.path + ";" + this.name + ";" + this.role
    }
    
    public var program: Double = 0.0
    
    public constructor()
}

