// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.importer
import alphaTab.core.*

/**
 * This public class represents the file system structure
 * stored within a GPX container file.
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class GpxFileSystem
{
    /**
     * You can set a file filter method using this setter. On parsing
     * the filestructure this function can determine based on the filename
     * whether this file will be available after loading.
     * This way we can reduce the amount of memory we store.
     */
    public var fileFilter: (arg1: String) -> Boolean
    /**
     * Gets the list of files stored in this FileSystem.
     */
    public var files: alphaTab.collections.List<alphaTab.importer.GpxFile> = alphaTab.collections.List<alphaTab.importer.GpxFile>(
    )
    
    
    public constructor(){
        this.files = alphaTab.collections.List<alphaTab.importer.GpxFile>(
        )
        
        this.fileFilter = fun(s: String): Boolean{
            return true
        }
        
    }
    
    /**
     * Load a complete FileSystem to the memory.
     * @param s the binary source to read from.
     */
    public fun load(s: alphaTab.io.IReadable): Unit{
        var src: alphaTab.io.BitReader = alphaTab.io.BitReader(s)
        this.readBlock(src)
    }
    
    /**
     * Reads the 4 byte header as a string.
     * @param src the BitInput to read from
     */
    public fun readHeader(src: alphaTab.io.BitReader): String{
        return this.getString(src.readBytes(4.0), 0.0, 4.0)
    }
    
    /**
     * Decompresses the given bitinput using the GPX compression format. Only use this method
     * if you are sure the binary data is compressed using the GPX format. Otherwise unexpected
     * behavior can occure.
     * @param src the bitInput to read the data from
     * @param skipHeader true if the header should NOT be included in the result byteset, otherwise false
     */
    public fun decompress(src: alphaTab.io.BitReader, skipHeader: Boolean = false): alphaTab.core.ecmaScript.Uint8Array{
        var uncompressed: alphaTab.io.ByteBuffer = alphaTab.io.ByteBuffer.empty()
        var buffer: alphaTab.core.ecmaScript.Uint8Array
        var expectedLength: Double = this.getInteger(src.readBytes(4.0), 0.0)
        try
        {
            while (uncompressed.length < expectedLength)
            {
                var flag: Double = src.readBits(1.0)
                if (flag == 1.0)
                {
                    var wordSize: Double = src.readBits(4.0)
                    var offset: Double = src.readBitsReversed(wordSize)
                    var size: Double = src.readBitsReversed(wordSize)
                    var sourcePosition: Double = uncompressed.length - offset
                    var toRead: Double = alphaTab.core.ecmaScript.Math.min(offset, size)
                    buffer = uncompressed.getBuffer()
                    uncompressed.write(buffer, sourcePosition, toRead)
                }
                else 
                {
                    var size: Double = src.readBitsReversed(2.0)
                    if(true) {
                        var i: Double = 0.0
                        
                        while(i < size){
                            try{
                                uncompressed.writeByte(src.readByte())
                            }
                            finally{
                                i++
                            }
                        }
                    }
                }
            }
        }
        catch (e: kotlin.Throwable)
        {
            if (!(e is alphaTab.io.EndOfReaderError))
            {
                throw e
            }
        }
        buffer = uncompressed.getBuffer()
        var resultOffset: Double = if(skipHeader)  4.0 else 0.0
        var resultSize: Double = uncompressed.length - resultOffset
        var result: alphaTab.core.ecmaScript.Uint8Array = alphaTab.core.ecmaScript.Uint8Array(resultSize)
        var count: Double = resultSize
        result.set(buffer.subarray(resultOffset, resultOffset + count), 0.0)
        return result
    }
    
    /**
     * Reads a block from the given data source.
     * @param `data` the data source
     */
    private fun readBlock(`data`: alphaTab.io.BitReader): Unit{
        var header: String = this.readHeader(`data`)
        if (header == "BCFZ")
        {
            this.readUncompressedBlock(this.decompress(`data`, true))
        }
        else if (header == "BCFS")
        {
            this.readUncompressedBlock(`data`.readAll())
        }
        else 
        {
            throw alphaTab.importer.UnsupportedFormatError("Unsupported format")
        }
    }
    
    /**
     * Reads an uncompressed data block into the model.
     * @param `data` the data store to read from.
     */
    private fun readUncompressedBlock(`data`: alphaTab.core.ecmaScript.Uint8Array): Unit{
        var sectorSize: Double = 4096.0
        var offset: Double = sectorSize
        while (offset + 3.0 < `data`.length)
        {
            var entryType: Double = this.getInteger(`data`, offset)
            if (entryType == 2.0)
            {
                var file: alphaTab.importer.GpxFile = alphaTab.importer.GpxFile()
                file.fileName = this.getString(`data`, offset + 4.0, 127.0)
                file.fileSize = this.getInteger(`data`, offset + 140.0)
                var storeFile: Boolean = !alphaTab.core.TypeHelper.isTruthy(this.fileFilter) || this.fileFilter(file.fileName)
                if (storeFile)
                {
                    this.files.push(file)
                }
                var dataPointerOffset: Double = offset + 148.0
                var sector: Double = 0.0
                var sectorCount: Double = 0.0
                var fileData: alphaTab.io.ByteBuffer? = if(storeFile)  alphaTab.io.ByteBuffer.withCapacity(file.fileSize) else null
                while (true)
                {
                    sector = this.getInteger(`data`, dataPointerOffset + 4.0 * sectorCount++)
                    if (sector != 0.0)
                    {
                        offset = sector * sectorSize
                        if (storeFile)
                        {
                            fileData!!.write(`data`, offset, sectorSize)
                        }
                    }
                    else 
                    {
                        break
                    }
                }
                if (storeFile)
                {
                    file.`data` = alphaTab.core.ecmaScript.Uint8Array(alphaTab.core.ecmaScript.Math.min(file.fileSize, fileData!!.length))
                    var raw: alphaTab.core.ecmaScript.Uint8Array = fileData!!.toArray()
                    file.`data`!!.set(raw.subarray(0.0, 0.0 + file.`data`!!.length), 0.0)
                }
            }
            offset += sectorSize
        }
    }
    
    /**
     * Reads a zeroterminated ascii string from the given source
     * @param `data` the data source to read from
     * @param offset the offset to start reading from
     * @param length the max length to read
     */
    private fun getString(`data`: alphaTab.core.ecmaScript.Uint8Array, offset: Double, length: Double): String{
        var buf: String = ""
        if(true) {
            var i: Double = 0.0
            
            while(i < length){
                try{
                    var code: Double = ((`data`[(offset + i).toInt()]).toInt() and 255).toDouble()
                    if (code == 0.0)
                    {
                        break
                    }
                    buf += alphaTab.core.ecmaScript.CoreString.fromCharCode(code)
                }
                finally{
                    i++
                }
            }
        }
        return buf
    }
    
    /**
     * Reads an 4 byte signed integer from the given source
     * @param `data` the data source to read from
     * @param offset offset the offset to start reading from
     */
    private fun getInteger(`data`: alphaTab.core.ecmaScript.Uint8Array, offset: Double): Double{
        return (((`data`[(offset + 3.0).toInt()]).toInt() shl 24) or ((`data`[(offset + 2.0).toInt()]).toInt() shl 16) or ((`data`[(offset + 1.0).toInt()]).toInt() shl 8) or (`data`[(offset).toInt()]).toInt()).toDouble()
    }
    
    companion object{
        @kotlin.jvm.JvmStatic
        public val HeaderBcFs: String = "BCFS"
        
        @kotlin.jvm.JvmStatic
        public val HeaderBcFz: String = "BCFZ"
        
        @kotlin.jvm.JvmStatic
        public val ScoreGpif: String = "score.gpif"
        
        @kotlin.jvm.JvmStatic
        public val BinaryStylesheet: String = "BinaryStylesheet"
        
        @kotlin.jvm.JvmStatic
        public val PartConfiguration: String = "PartConfiguration"
        
    }
}

/**
 * this public class represents a file within the GpxFileSystem
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class GpxFile
{
    public var fileName: String = ""
    
    public var fileSize: Double = 0.0
    
    public var `data`: alphaTab.core.ecmaScript.Uint8Array? = null
    
    public constructor()
}

