// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.importer
import alphaTab.core.*

/**
 * This ScoreImporter can read Guitar Pro 6 (gpx) files.
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class GpxImporter: alphaTab.importer.ScoreImporter
{
    public override val name: String
    get(){
        return "Guitar Pro 6"
    }
    
    public constructor()
        : super()
    /**
     * Reads the  contained in the data.
     */
    public override fun readScore(): alphaTab.model.Score{
        alphaTab.Logger.debug(this.name, "Loading GPX filesystem")
        var fileSystem: alphaTab.importer.GpxFileSystem = alphaTab.importer.GpxFileSystem()
        fileSystem.fileFilter = fun(s: String): Boolean{
            return s.endsWith("score.gpif") || s.endsWith("BinaryStylesheet") || s.endsWith("PartConfiguration")
        }
        
        fileSystem.load(this.`data`)
        alphaTab.Logger.debug(this.name, "GPX filesystem loaded")
        var xml: String? = null
        var binaryStylesheetData: alphaTab.core.ecmaScript.Uint8Array? = null
        var partConfigurationData: alphaTab.core.ecmaScript.Uint8Array? = null
        for (entry in fileSystem.files)
        {
            when (entry.fileName)
            {
                "score.gpif" -> 
                {
                    xml = alphaTab.io.IOHelper.toString(entry.`data`!!, this.settings.importer.encoding)
                }
                "BinaryStylesheet" -> 
                {
                    binaryStylesheetData = entry.`data`
                }
                "PartConfiguration" -> 
                {
                    partConfigurationData = entry.`data`
                }
                else -> { }
            }
        }
        if (!alphaTab.core.TypeHelper.isTruthy(xml))
        {
            throw alphaTab.importer.UnsupportedFormatError("No score.gpif found in GPX")
        }
        alphaTab.Logger.debug(this.name, "Start Parsing score.gpif")
        var gpifParser: alphaTab.importer.GpifParser = alphaTab.importer.GpifParser()
        gpifParser.parseXml(xml, this.settings)
        alphaTab.Logger.debug(this.name, "score.gpif parsed")
        var score: alphaTab.model.Score = gpifParser.score
        if (alphaTab.core.TypeHelper.isTruthy(binaryStylesheetData))
        {
            alphaTab.Logger.debug(this.name, "Start Parsing BinaryStylesheet")
            var binaryStylesheet: alphaTab.importer.BinaryStylesheet = alphaTab.importer.BinaryStylesheet(binaryStylesheetData)
            binaryStylesheet.apply(score)
            alphaTab.Logger.debug(this.name, "BinaryStylesheet parsed")
        }
        if (alphaTab.core.TypeHelper.isTruthy(partConfigurationData))
        {
            alphaTab.Logger.debug(this.name, "Start Parsing Part Configuration")
            var partConfiguration: alphaTab.importer.PartConfiguration = alphaTab.importer.PartConfiguration(partConfigurationData)
            partConfiguration.apply(score)
            alphaTab.Logger.debug(this.name, "Part Configuration parsed")
        }
        return score
    }
    
}

