// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.importer
import alphaTab.core.*

@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class MusicXmlImporter: alphaTab.importer.ScoreImporter
{
    private lateinit var _score: alphaTab.model.Score
    
    private lateinit var _trackById: alphaTab.collections.Map<String, alphaTab.model.Track>
    
    private lateinit var _partGroups: alphaTab.collections.Map<String, alphaTab.collections.List<alphaTab.model.Track>>
    
    private var _currentPartGroup: String? = null
    
    private var _trackFirstMeasureNumber: Double = 0.0
    
    private var _maxVoices: Double = 0.0
    
    private var _currentDirection: String? = null
    
    private lateinit var _tieStarts: alphaTab.collections.List<alphaTab.model.Note>
    
    private lateinit var _tieStartIds: alphaTab.collections.DoubleBooleanMap
    
    private lateinit var _slurStarts: alphaTab.collections.Map<String, alphaTab.model.Note>
    
    public override val name: String
    get(){
        return "MusicXML"
    }
    
    public constructor()
        : super()
    /**
     * Reads the  contained in the data.
     */
    public override fun readScore(): alphaTab.model.Score{
        this._trackById = alphaTab.collections.Map<String, alphaTab.model.Track>()
        this._partGroups = alphaTab.collections.Map<String, alphaTab.collections.List<alphaTab.model.Track>>()
        this._tieStarts = alphaTab.collections.List<alphaTab.model.Note>(
        )
        
        this._tieStartIds = alphaTab.collections.DoubleBooleanMap()
        this._slurStarts = alphaTab.collections.Map<String, alphaTab.model.Note>()
        var xml: String = alphaTab.io.IOHelper.toString(this.`data`.readAll(), this.settings.importer.encoding)
        var dom: alphaTab.xml.XmlDocument = alphaTab.xml.XmlDocument()
        try
        {
            dom.parse(xml)
        }
        catch (e: kotlin.Throwable)
        {
            throw alphaTab.importer.UnsupportedFormatError("Unsupported format")
        }
        this._score = alphaTab.model.Score()
        this._score.tempo = 120.0
        this.parseDom(dom)
        if (this.settings.importer.mergePartGroupsInMusicXml)
        {
            this.mergePartGroups()
        }
        this._score.finish(this.settings)
        this._score.rebuildRepeatGroups()
        return this._score
    }
    
    private fun mergePartGroups(): Unit{
        var anyMerged: Boolean = false
        for (tracks in this._partGroups.values())
        {
            if (tracks.length > 1)
            {
                this.mergeGroup(tracks)
                anyMerged = true
            }
        }
        if (anyMerged)
        {
            if(true) {
                var i: Double = 0.0
                
                while(i < this._score.tracks.length){
                    try{
                        this._score.tracks[(i).toInt()].index = i
                    }
                    finally{
                        i++
                    }
                }
            }
        }
    }
    
    /**
     */
    private fun mergeGroup(partGroup: alphaTab.collections.List<alphaTab.model.Track>): Unit{
        var primaryTrack: alphaTab.model.Track = partGroup[(0).toInt()]
        if(true) {
            var i: Double = 1.0
            
            while(i < partGroup.length){
                try{
                    var secondaryTrack: alphaTab.model.Track = partGroup[(i).toInt()]
                    for (staff in secondaryTrack.staves)
                    {
                        primaryTrack.addStaff(staff)
                    }
                    var trackIndex: Double = this._score.tracks.indexOf(secondaryTrack)
                    this._score.tracks.splice(trackIndex, 1.0)
                }
                finally{
                    i++
                }
            }
        }
    }
    
    /**
     */
    private fun parseDom(dom: alphaTab.xml.XmlDocument): Unit{
        var root: alphaTab.xml.XmlNode? = dom.firstElement
        if (!alphaTab.core.TypeHelper.isTruthy(root))
        {
            throw alphaTab.importer.UnsupportedFormatError("Unsupported format")
        }
        when (root.localName)
        {
            "score-partwise" -> 
            {
                this.parsePartwise(root)
            }
            "score-timewise" -> 
            {
            }
            else -> 
            {
                throw alphaTab.importer.UnsupportedFormatError("Unsupported format")
            }
        }
    }
    
    /**
     */
    private fun parsePartwise(element: alphaTab.xml.XmlNode): Unit{
        for (c in element.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "work" -> 
                    {
                        this.parseWork(c)
                    }
                    "movement-title" -> 
                    {
                        this._score.title = c.innerText
                    }
                    "identification" -> 
                    {
                        this.parseIdentification(c)
                    }
                    "part-list" -> 
                    {
                        this.parsePartList(c)
                    }
                    "part" -> 
                    {
                        this.parsePart(c)
                    }
                    else -> { }
                }
            }
        }
    }
    
    /**
     */
    private fun parseWork(element: alphaTab.xml.XmlNode): Unit{
        for (c in element.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "work-title" -> 
                    {
                        this._score.title = c.innerText
                    }
                    else -> { }
                }
            }
        }
    }
    
    /**
     */
    private fun parsePart(element: alphaTab.xml.XmlNode): Unit{
        var id: String = element.getAttribute("id")
        if (!this._trackById.has(id))
        {
            if (this._trackById.size == 1.0)
            {
                for ((x, t) in this._trackById)
                {
                    if (t.staves.length == 0.0 || t.staves[(0).toInt()].bars.length == 0.0)
                    {
                        id = x
                    }
                }
                if (!this._trackById.has(id))
                {
                    return
                }
            }
            else 
            {
                return
            }
        }
        var track: alphaTab.model.Track = this._trackById.get(id)!!
        var isFirstMeasure: Boolean = true
        this._maxVoices = 0.0
        for (c in element.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "measure" -> 
                    {
                        if (this.parseMeasure(c, track, isFirstMeasure))
                        {
                            isFirstMeasure = false
                        }
                    }
                    else -> { }
                }
            }
        }
        for (staff in track.staves)
        {
            for (bar in staff.bars)
            {
                this.ensureVoices(bar)
            }
        }
    }
    
    /**
     */
    private fun parseMeasure(element: alphaTab.xml.XmlNode, track: alphaTab.model.Track, isFirstMeasure: Boolean): Boolean{
        if (element.getAttribute("implicit") == "yes" && element.getElementsByTagName("note", false).length == 0.0)
        {
            return false
        }
        var barIndex: Double = 0.0
        if (isFirstMeasure)
        {
            this._divisionsPerQuarterNote = 0.0
            this._trackFirstMeasureNumber = alphaTab.core.Globals.parseInt(element.getAttribute("number"))
            if (!alphaTab.core.TypeHelper.isTruthy(this._trackFirstMeasureNumber))
            {
                this._trackFirstMeasureNumber = 0.0
            }
            barIndex = 0.0
        }
        else 
        {
            barIndex = alphaTab.core.Globals.parseInt(element.getAttribute("number"))
            if (!alphaTab.core.TypeHelper.isTruthy(barIndex))
            {
                return false
            }
            barIndex -= this._trackFirstMeasureNumber
        }
        if (isFirstMeasure)
        {
            var attributes: alphaTab.collections.List<alphaTab.xml.XmlNode> = element.getElementsByTagName("attributes", false)
            if (attributes.length > 0)
            {
                var stavesElements: alphaTab.collections.List<alphaTab.xml.XmlNode> = attributes[(0).toInt()].getElementsByTagName("staves", false)
                if (stavesElements.length > 0)
                {
                    var staves: Double = alphaTab.core.Globals.parseInt(stavesElements[(0).toInt()].innerText)
                    track.ensureStaveCount(staves)
                }
            }
        }
        var bars: alphaTab.collections.List<alphaTab.model.Bar> = alphaTab.collections.List<alphaTab.model.Bar>((track.staves.length).toInt())
        var masterBar: alphaTab.model.MasterBar? = null
        if(true) {
            var b: Double = track.staves[(0).toInt()].bars.length
            
            while(b <= barIndex){
                try{
                    if(true) {
                        var s: Double = 0.0
                        
                        while(s < track.staves.length){
                            try{
                                var bar: alphaTab.model.Bar = alphaTab.model.Bar()
                                bars[(s).toInt()] = bar
                                if (track.staves[(s).toInt()].bars.length > 0)
                                {
                                    var previousBar: alphaTab.model.Bar = track.staves[(s).toInt()].bars[(track.staves[(s).toInt()].bars.length - 1.0).toInt()]
                                    bar.clef = previousBar.clef
                                }
                                masterBar = this.getOrCreateMasterBar(barIndex)
                                track.staves[(s).toInt()].addBar(bar)
                                this.ensureVoices(bar)
                            }
                            finally{
                                s++
                            }
                        }
                    }
                }
                finally{
                    b++
                }
            }
        }
        var chordsByIdForTrack: alphaTab.collections.Map<String, alphaTab.model.Chord> = alphaTab.collections.Map<String, alphaTab.model.Chord>()
        if (alphaTab.core.TypeHelper.isTruthy(masterBar))
        {
            var attributesParsed: Boolean = false
            for (c in element.childNodes)
            {
                if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
                {
                    when (c.localName)
                    {
                        "note" -> 
                        {
                            this.parseNoteBeat(c, bars)
                        }
                        "forward" -> 
                        {
                            this.parseForward(c, bars)
                        }
                        "direction" -> 
                        {
                            this.parseDirection(c, masterBar)
                        }
                        "attributes" -> 
                        {
                            if (!attributesParsed)
                            {
                                this.parseAttributes(c, bars, masterBar, track)
                                attributesParsed = true
                            }
                        }
                        "harmony" -> 
                        {
                            this.parseHarmony(c, track, chordsByIdForTrack)
                        }
                        "sound" -> 
                        {
                        }
                        "barline" -> 
                        {
                            this.parseBarline(c, masterBar)
                        }
                        else -> { }
                    }
                }
            }
        }
        return true
    }
    
    /**
     */
    private fun ensureVoices(bar: alphaTab.model.Bar): Unit{
        while (bar.voices.length < this._maxVoices)
        {
            var emptyVoice: alphaTab.model.Voice = alphaTab.model.Voice()
            bar.addVoice(emptyVoice)
            var emptyBeat: alphaTab.model.Beat = alphaTab.model.Beat()
            emptyBeat.isEmpty = true
            emptyBeat.chordId = this._currentChord
            emptyVoice.addBeat(emptyBeat)
        }
    }
    
    /**
     */
    private fun getOrCreateBeat(element: alphaTab.xml.XmlNode, bars: alphaTab.collections.List<alphaTab.model.Bar>, chord: Boolean): alphaTab.model.Beat{
        var voiceIndex: Double = 0.0
        var voiceNodes: alphaTab.collections.List<alphaTab.xml.XmlNode> = element.getElementsByTagName("voice", false)
        if (voiceNodes.length > 0)
        {
            voiceIndex = alphaTab.core.Globals.parseInt(voiceNodes[(0).toInt()].innerText) - 1.0
        }
        var previousBeatWasPulled: Boolean = this._previousBeatWasPulled
        this._previousBeatWasPulled = false
        var staffElement: alphaTab.collections.List<alphaTab.xml.XmlNode> = element.getElementsByTagName("staff", false)
        var staff: Double = 1.0
        if (staffElement.length > 0)
        {
            staff = alphaTab.core.Globals.parseInt(staffElement[(0).toInt()].innerText)
            if ((this._isBeamContinue || previousBeatWasPulled) && this._previousBeat!!.voice.bar.staff.index != staff - 1.0)
            {
                staff = this._previousBeat!!.voice.bar.staff.index + 1.0
                this._previousBeatWasPulled = true
            }
            var staffId: String = (bars[(0).toInt()].staff.track.index).toInvariantString() + "-" + (staff).toInvariantString()
            if (!this._voiceOfStaff.has(staffId))
            {
                this._voiceOfStaff.set(staffId, voiceIndex)
            }
        }
        staff--
        var bar: alphaTab.model.Bar
        if (staff < 0)
        {
            bar = bars[(0).toInt()]
        }
        else if (staff >= bars.length)
        {
            bar = bars[(bars.length - 1.0).toInt()]
        }
        else 
        {
            bar = bars[(staff).toInt()]
        }
        var beat: alphaTab.model.Beat
        var voice: alphaTab.model.Voice = this.getOrCreateVoice(bar, voiceIndex)
        if ((chord && voice.beats.length > 0) || (voice.beats.length == 1.0 && voice.isEmpty))
        {
            beat = voice.beats[(voice.beats.length - 1.0).toInt()]
        }
        else 
        {
            beat = alphaTab.model.Beat()
            beat.isEmpty = false
            voice.addBeat(beat)
        }
        this._isBeamContinue = false
        this._previousBeat = beat
        return beat
    }
    
    /**
     */
    private fun parseForward(element: alphaTab.xml.XmlNode, bars: alphaTab.collections.List<alphaTab.model.Bar>): Unit{
        var beat: alphaTab.model.Beat = this.getOrCreateBeat(element, bars, false)
        var durationInDivisions: Double = alphaTab.core.Globals.parseInt(element.findChildElement("duration")!!.innerText)
        var duration: Double = (durationInDivisions * (alphaTab.model.Duration.Quarter.toDouble())) / this._divisionsPerQuarterNote
        var durations: alphaTab.collections.List<alphaTab.model.Duration> = alphaTab.collections.List<alphaTab.model.Duration>(
            alphaTab.model.Duration.SixtyFourth, alphaTab.model.Duration.ThirtySecond, alphaTab.model.Duration.Sixteenth, alphaTab.model.Duration.Eighth, alphaTab.model.Duration.Quarter, alphaTab.model.Duration.Half, alphaTab.model.Duration.Whole)
        
        for (d in durations)
        {
            if (duration >= (d.toDouble()))
            {
                beat.duration = d
                duration -= (d.toDouble())
                break
            }
        }
        if (duration > 0)
        {
        }
        beat.isEmpty = false
    }
    
    /**
     */
    private fun parseStaffDetails(element: alphaTab.xml.XmlNode, track: alphaTab.model.Track): Unit{
        for (c in element.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "staff-lines" -> 
                    {
                        for (staff in track.staves)
                        {
                            staff.stringTuning.tunings = alphaTab.collections.DoubleList((alphaTab.core.Globals.parseInt(c.innerText)).toInt()).fill(0.0)
                        }
                    }
                    "staff-tuning" -> 
                    {
                        this.parseStaffTuning(c, track)
                    }
                    else -> { }
                }
            }
        }
        for (staff in track.staves)
        {
            if (this.isEmptyTuning(staff.tuning))
            {
                staff.stringTuning.tunings = alphaTab.collections.DoubleList(
                )
                
            }
        }
    }
    
    /**
     */
    private fun parseStaffTuning(element: alphaTab.xml.XmlNode, track: alphaTab.model.Track): Unit{
        var line: Double = alphaTab.core.Globals.parseInt(element.getAttribute("line"))
        var tuningStep: String = "C"
        var tuningOctave: String = ""
        var tuningAlter: Double = 0.0
        for (c in element.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "tuning-step" -> 
                    {
                        tuningStep = c.innerText
                    }
                    "tuning-alter" -> 
                    {
                        tuningAlter = alphaTab.core.Globals.parseInt(c.innerText)
                    }
                    "tuning-octave" -> 
                    {
                        tuningOctave = c.innerText
                    }
                    else -> { }
                }
            }
        }
        var tuning: Double = alphaTab.model.ModelUtils.getTuningForText(tuningStep + tuningOctave) + tuningAlter
        for (staff in track.staves)
        {
            staff.tuning[(staff.tuning.length - line).toInt()] = tuning
        }
    }
    
    private var _currentChord: String? = null
    
    private var _divisionsPerQuarterNote: Double = 0.0
    
    /**
     */
    private fun parseHarmony(element: alphaTab.xml.XmlNode, track: alphaTab.model.Track, chordsByIdForTrack: alphaTab.collections.Map<String, alphaTab.model.Chord>): Unit{
        var chord: alphaTab.model.Chord = alphaTab.model.Chord()
        for (childNode in element.childNodes)
        {
            if (childNode.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (childNode.localName)
                {
                    "root" -> 
                    {
                        chord.name = this.parseHarmonyRoot(childNode)
                    }
                    "kind" -> 
                    {
                        chord.name = chord.name + this.parseHarmonyKind(childNode)
                    }
                    "frame" -> 
                    {
                        this.parseHarmonyFrame(childNode, chord)
                    }
                    else -> { }
                }
            }
        }
        this._currentChord = alphaTab.model.ModelUtils.newGuid()
        var chordKey: String = chord.uniqueId
        if (chordsByIdForTrack.has(chordKey))
        {
            chord.showDiagram = false
        }
        for (staff in track.staves)
        {
            staff.addChord(this._currentChord!!, chord)
        }
        chordsByIdForTrack.set(chordKey, chord)
    }
    
    /**
     */
    private fun parseHarmonyRoot(xmlNode: alphaTab.xml.XmlNode): String{
        var rootStep: String = ""
        var rootAlter: String = ""
        for (rootChild in xmlNode.childNodes)
        {
            if (rootChild.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (rootChild.localName)
                {
                    "root-step" -> 
                    {
                        rootStep = rootChild.innerText
                    }
                    "root-alter" -> 
                    {
                        when (alphaTab.core.Globals.parseInt(xmlNode.innerText))
                        {
                            -2.0 -> 
                            {
                                rootAlter = "bb"
                            }
                            -1.0 -> 
                            {
                                rootAlter = "b"
                            }
                            0.0 -> 
                            {
                                rootAlter = ""
                            }
                            1.0 -> 
                            {
                                rootAlter = "#"
                            }
                            2.0 -> 
                            {
                                rootAlter = "##"
                            }
                            else -> { }
                        }
                    }
                    else -> { }
                }
            }
        }
        return rootStep + rootAlter
    }
    
    /**
     */
    private fun parseHarmonyKind(xmlNode: alphaTab.xml.XmlNode): String{
        var kindText: String = xmlNode.getAttribute("text")
        var resultKind: String = ""
        if (alphaTab.core.TypeHelper.isTruthy(kindText))
        {
            resultKind = kindText
        }
        else 
        {
            var kindContent: String = xmlNode.innerText
            when (kindContent)
            {
                "major" -> 
                {
                    resultKind = ""
                }
                "minor" -> 
                {
                    resultKind = "m"
                }
                "augmented" -> 
                {
                    resultKind = "+"
                }
                "diminished" -> 
                {
                    resultKind = "○"
                }
                "dominant" -> 
                {
                    resultKind = "7"
                }
                "major-seventh" -> 
                {
                    resultKind = "7M"
                }
                "minor-seventh" -> 
                {
                    resultKind = "m7"
                }
                "diminished-seventh" -> 
                {
                    resultKind = "○7"
                }
                "augmented-seventh" -> 
                {
                    resultKind = "+7"
                }
                "half-diminished" -> 
                {
                    resultKind = "⍉"
                }
                "major-minor" -> 
                {
                    resultKind = "mMaj"
                }
                "major-sixth" -> 
                {
                    resultKind = "maj6"
                }
                "minor-sixth" -> 
                {
                    resultKind = "m6"
                }
                "dominant-ninth" -> 
                {
                    resultKind = "9"
                }
                "major-ninth" -> 
                {
                    resultKind = "maj9"
                }
                "minor-ninth" -> 
                {
                    resultKind = "m9"
                }
                "dominant-11th" -> 
                {
                    resultKind = "11"
                }
                "major-11th" -> 
                {
                    resultKind = "maj11"
                }
                "minor-11th" -> 
                {
                    resultKind = "m11"
                }
                "dominant-13th" -> 
                {
                    resultKind = "13"
                }
                "major-13th" -> 
                {
                    resultKind = "maj13"
                }
                "minor-13th" -> 
                {
                    resultKind = "m13"
                }
                "suspended-second" -> 
                {
                    resultKind = "sus2"
                }
                "suspended-fourth" -> 
                {
                    resultKind = "sus4"
                }
                else -> { }
            }
        }
        return resultKind
    }
    
    /**
     */
    private fun parseHarmonyFrame(xmlNode: alphaTab.xml.XmlNode, chord: alphaTab.model.Chord): Unit{
        for (frameChild in xmlNode.childNodes)
        {
            if (frameChild.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (frameChild.localName)
                {
                    "frame-strings" -> 
                    {
                        var stringsCount: Double = alphaTab.core.Globals.parseInt(frameChild.innerText)
                        chord.strings = alphaTab.collections.DoubleList((stringsCount).toInt())
                        if(true) {
                            var i: Double = 0.0
                            
                            while(i < stringsCount){
                                try{
                                    chord.strings[(i).toInt()] = -1.0
                                }
                                finally{
                                    i++
                                }
                            }
                        }
                    }
                    "first-fret" -> 
                    {
                        chord.firstFret = alphaTab.core.Globals.parseInt(frameChild.innerText)
                    }
                    "frame-note" -> 
                    {
                        var stringNo: Double? = null
                        var fretNo: Double? = null
                        for (noteChild in frameChild.childNodes)
                        {
                            when (noteChild.localName)
                            {
                                "string" -> 
                                {
                                    stringNo = alphaTab.core.Globals.parseInt(noteChild.innerText)
                                }
                                "fret" -> 
                                {
                                    fretNo = alphaTab.core.Globals.parseInt(noteChild.innerText)
                                    if (alphaTab.core.TypeHelper.isTruthy(stringNo) && fretNo >= 0)
                                    {
                                        chord.strings[(stringNo - 1.0).toInt()] = fretNo
                                    }
                                }
                                "barre" -> 
                                {
                                    if (alphaTab.core.TypeHelper.isTruthy(stringNo) && alphaTab.core.TypeHelper.isTruthy(fretNo) && noteChild.getAttribute("type") == "start")
                                    {
                                        chord.barreFrets.push(fretNo)
                                    }
                                }
                                else -> { }
                            }
                        }
                    }
                    else -> { }
                }
            }
        }
    }
    
    /**
     */
    private fun parseBarline(element: alphaTab.xml.XmlNode, masterBar: alphaTab.model.MasterBar): Unit{
        for (c in element.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "repeat" -> 
                    {
                        this.parseRepeat(c, masterBar)
                    }
                    "ending" -> 
                    {
                        this.parseEnding(c, masterBar)
                    }
                    else -> { }
                }
            }
        }
    }
    
    /**
     */
    private fun parseEnding(element: alphaTab.xml.XmlNode, masterBar: alphaTab.model.MasterBar): Unit{
        var num: Double = alphaTab.core.Globals.parseInt(element.getAttribute("number"))
        if (num > 0)
        {
            --num
            masterBar.alternateEndings = ((masterBar.alternateEndings).toInt() or ((1 shl (num).toInt()) and 255)).toDouble()
        }
    }
    
    /**
     */
    private fun parseRepeat(element: alphaTab.xml.XmlNode, masterBar: alphaTab.model.MasterBar): Unit{
        var direction: String = element.getAttribute("direction")
        var times: Double = alphaTab.core.Globals.parseInt(element.getAttribute("times"))
        if (times < 0 || alphaTab.core.Globals.isNaN(times))
        {
            times = 2.0
        }
        if (direction == "backward")
        {
            masterBar.repeatCount = times
        }
        else if (direction == "forward")
        {
            masterBar.isRepeatStart = true
        }
    }
    
    private var _voiceOfStaff: alphaTab.collections.ObjectDoubleMap<String> = alphaTab.collections.ObjectDoubleMap<String>()
    
    private var _isBeamContinue: Boolean = false
    
    private var _previousBeatWasPulled: Boolean = false
    
    private var _previousBeat: alphaTab.model.Beat? = null
    
    /**
     */
    private fun parseNoteBeat(element: alphaTab.xml.XmlNode, bars: alphaTab.collections.List<alphaTab.model.Bar>): Unit{
        var chord: Boolean = element.getElementsByTagName("chord", false).length > 0
        var beat: alphaTab.model.Beat = this.getOrCreateBeat(element, bars, chord)
        if (!alphaTab.core.TypeHelper.isTruthy(beat.chordId) && alphaTab.core.TypeHelper.isTruthy(this._currentChord))
        {
            beat.chordId = this._currentChord
            this._currentChord = null
        }
        if (alphaTab.core.TypeHelper.isTruthy(this._currentDirection))
        {
            beat.text = this._currentDirection
            this._currentDirection = null
        }
        var note: alphaTab.model.Note = alphaTab.model.Note()
        beat.voice.isEmpty = false
        beat.isEmpty = false
        beat.addNote(note)
        beat.dots = 0.0
        var isFullBarRest: Boolean = false
        for (c in element.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "grace" -> 
                    {
                        beat.graceType = alphaTab.model.GraceType.BeforeBeat
                        beat.duration = alphaTab.model.Duration.ThirtySecond
                    }
                    "duration" -> 
                    {
                        if (beat.isRest && !isFullBarRest)
                        {
                            var duration: Double = alphaTab.core.Globals.parseInt(c.innerText)
                            when (duration)
                            {
                                1.0 -> 
                                {
                                    beat.duration = alphaTab.model.Duration.Whole
                                }
                                2.0 -> 
                                {
                                    beat.duration = alphaTab.model.Duration.Half
                                }
                                4.0 -> 
                                {
                                    beat.duration = alphaTab.model.Duration.Quarter
                                }
                                8.0 -> 
                                {
                                    beat.duration = alphaTab.model.Duration.Eighth
                                }
                                16.0 -> 
                                {
                                    beat.duration = alphaTab.model.Duration.Sixteenth
                                }
                                32.0 -> 
                                {
                                    beat.duration = alphaTab.model.Duration.ThirtySecond
                                }
                                64.0 -> 
                                {
                                    beat.duration = alphaTab.model.Duration.SixtyFourth
                                }
                                else -> 
                                {
                                    beat.duration = alphaTab.model.Duration.Quarter
                                }
                            }
                        }
                    }
                    "tie" -> 
                    {
                        this.parseTied(c, note)
                    }
                    "cue" -> 
                    {
                    }
                    "instrument" -> 
                    {
                    }
                    "type" -> 
                    {
                        beat.duration = this.getDuration(c.innerText)
                        if (beat.graceType != alphaTab.model.GraceType.None && beat.duration < alphaTab.model.Duration.Sixteenth)
                        {
                            beat.duration = alphaTab.model.Duration.Eighth
                        }
                    }
                    "dot" -> 
                    {
                        beat.dots++
                    }
                    "accidental" -> 
                    {
                        this.parseAccidental(c, note)
                    }
                    "time-modification" -> 
                    {
                        this.parseTimeModification(c, beat)
                    }
                    "stem" -> 
                    {
                    }
                    "notehead" -> 
                    {
                        if (c.getAttribute("parentheses") == "yes")
                        {
                            note.isGhost = true
                        }
                    }
                    "beam" -> 
                    {
                        var beamMode: String = c.innerText
                        if (beamMode == "continue")
                        {
                            this._isBeamContinue = true
                        }
                    }
                    "notations" -> 
                    {
                        this.parseNotations(c, beat, note)
                    }
                    "lyric" -> 
                    {
                        this.parseLyric(c, beat)
                    }
                    "pitch" -> 
                    {
                        this.parsePitch(c, note)
                    }
                    "unpitched" -> 
                    {
                        this.parseUnpitched(c, note)
                    }
                    "rest" -> 
                    {
                        isFullBarRest = c.getAttribute("measure") == "yes"
                        beat.isEmpty = false
                        beat.notes = alphaTab.collections.List<alphaTab.model.Note>(
                        )
                        
                        beat.duration = alphaTab.model.Duration.Whole
                    }
                    else -> { }
                }
            }
        }
        if (note.isStringed)
        {
            if(true) {
                var i: Double = 0.0
                
                while(i < beat.notes.length){
                    try{
                        if (beat.notes[(i).toInt()].string == note.string && beat.notes[(i).toInt()] != note)
                        {
                            beat.removeNote(note)
                            break
                        }
                    }
                    finally{
                        i++
                    }
                }
            }
        }
    }
    
    /**
     */
    private fun getDuration(text: String): alphaTab.model.Duration{
        when (text)
        {
            "256th", "128th", "64th" -> 
            {
                return alphaTab.model.Duration.SixtyFourth
            }
            "32nd" -> 
            {
                return alphaTab.model.Duration.ThirtySecond
            }
            "16th" -> 
            {
                return alphaTab.model.Duration.Sixteenth
            }
            "eighth" -> 
            {
                return alphaTab.model.Duration.Eighth
            }
            "quarter" -> 
            {
                return alphaTab.model.Duration.Quarter
            }
            "half" -> 
            {
                return alphaTab.model.Duration.Half
            }
            "long", "breve", "whole" -> 
            {
                return alphaTab.model.Duration.Whole
            }
            else -> { }
        }
        return alphaTab.model.Duration.Quarter
    }
    
    /**
     */
    private fun parseLyric(element: alphaTab.xml.XmlNode, beat: alphaTab.model.Beat): Unit{
        for (c in element.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "text" -> 
                    {
                        if (alphaTab.core.TypeHelper.isTruthy(beat.text))
                        {
                            beat.text += " " + c.innerText
                        }
                        else 
                        {
                            beat.text = c.innerText
                        }
                    }
                    else -> { }
                }
            }
        }
    }
    
    /**
     */
    private fun parseAccidental(element: alphaTab.xml.XmlNode, note: alphaTab.model.Note): Unit{
        when (element.innerText)
        {
            "sharp" -> 
            {
                note.accidentalMode = alphaTab.model.NoteAccidentalMode.ForceSharp
            }
            "natural" -> 
            {
                note.accidentalMode = alphaTab.model.NoteAccidentalMode.ForceNatural
            }
            "flat" -> 
            {
                note.accidentalMode = alphaTab.model.NoteAccidentalMode.ForceFlat
            }
            "double-sharp" -> 
            {
            }
            "sharp-sharp" -> 
            {
            }
            "flat-flat" -> 
            {
            }
            "natural-sharp" -> 
            {
            }
            "natural-flat" -> 
            {
            }
            "quarter-flat" -> 
            {
            }
            "quarter-sharp" -> 
            {
            }
            "three-quarters-flat" -> 
            {
            }
            "three-quarters-sharp" -> 
            {
            }
            else -> { }
        }
    }
    
    /**
     */
    private fun parseTied(element: alphaTab.xml.XmlNode, note: alphaTab.model.Note): Unit{
        if (element.getAttribute("type") == "start")
        {
            if (!this._tieStartIds.has(note.id))
            {
                this._tieStartIds.set(note.id, true)
                this._tieStarts.push(note)
            }
        }
        else if (element.getAttribute("type") == "stop" && this._tieStarts.length > 0 && !note.isTieDestination)
        {
            var tieOrigin: alphaTab.model.Note = this._tieStarts[(0).toInt()]
            if (tieOrigin.beat.voice.index == note.beat.voice.index && tieOrigin.beat.voice.bar.staff.index == note.beat.voice.bar.staff.index && tieOrigin.beat.voice.bar.staff.track.index == note.beat.voice.bar.staff.track.index)
            {
                note.isTieDestination = true
                note.tieOrigin = this._tieStarts[(0).toInt()]
            }
            this._tieStarts.splice(0.0, 1.0)
            this._tieStartIds.delete(note.id)
        }
    }
    
    /**
     */
    private fun parseNotations(element: alphaTab.xml.XmlNode, beat: alphaTab.model.Beat, note: alphaTab.model.Note): Unit{
        for (c in element.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "articulations" -> 
                    {
                        this.parseArticulations(c, note)
                    }
                    "tied" -> 
                    {
                        this.parseTied(c, note)
                    }
                    "slide", "glissando" -> 
                    {
                        if (c.getAttribute("type") == "start")
                        {
                            note.slideOutType = alphaTab.model.SlideOutType.Shift
                        }
                    }
                    "dynamics" -> 
                    {
                        this.parseDynamics(c, beat)
                    }
                    "technical" -> 
                    {
                        this.parseTechnical(c, note)
                    }
                    "ornaments" -> 
                    {
                        this.parseOrnaments(c, note)
                    }
                    "slur" -> 
                    {
                        var slurNumber: String = c.getAttribute("number")
                        if (!alphaTab.core.TypeHelper.isTruthy(slurNumber))
                        {
                            slurNumber = "1"
                        }
                        slurNumber = (beat.voice.bar.staff.index).toInvariantString() + "_" + slurNumber
                        when (c.getAttribute("type"))
                        {
                            "start" -> 
                            {
                                this._slurStarts.set(slurNumber, note)
                            }
                            "stop" -> 
                            {
                                if (this._slurStarts.has(slurNumber))
                                {
                                    note.isSlurDestination = true
                                    var slurStart: alphaTab.model.Note = this._slurStarts.get(slurNumber)!!
                                    slurStart.slurDestination = note
                                    note.slurOrigin = slurStart
                                }
                            }
                            else -> { }
                        }
                    }
                    else -> { }
                }
            }
        }
    }
    
    /**
     */
    private fun parseOrnaments(element: alphaTab.xml.XmlNode, note: alphaTab.model.Note): Unit{
        for (c in element.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "tremolo" -> 
                    {
                        var tremoloSpeed: Double = alphaTab.core.Globals.parseInt(c.innerText)
                        when (tremoloSpeed)
                        {
                            1.0 -> 
                            {
                                note.beat.tremoloSpeed = alphaTab.model.Duration.Eighth
                            }
                            2.0 -> 
                            {
                                note.beat.tremoloSpeed = alphaTab.model.Duration.Sixteenth
                            }
                            3.0 -> 
                            {
                                note.beat.tremoloSpeed = alphaTab.model.Duration.ThirtySecond
                            }
                            else -> { }
                        }
                    }
                    else -> { }
                }
            }
        }
    }
    
    /**
     */
    private fun parseTechnical(element: alphaTab.xml.XmlNode, note: alphaTab.model.Note): Unit{
        for (c in element.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "string" -> 
                    {
                        note.string = alphaTab.core.Globals.parseInt(c.innerText)
                        if (note.string != -2147483648.0)
                        {
                            note.string = note.beat.voice.bar.staff.tuning.length - note.string + 1.0
                        }
                    }
                    "fret" -> 
                    {
                        note.fret = alphaTab.core.Globals.parseInt(c.innerText)
                    }
                    "down-bow" -> 
                    {
                        note.beat.pickStroke = alphaTab.model.PickStroke.Down
                    }
                    "up-bow" -> 
                    {
                        note.beat.pickStroke = alphaTab.model.PickStroke.Up
                    }
                    else -> { }
                }
            }
        }
        if (note.string == -2147483648.0 || note.fret == -2147483648.0)
        {
            note.string = -1.0
            note.fret = -1.0
        }
    }
    
    /**
     */
    private fun parseArticulations(element: alphaTab.xml.XmlNode, note: alphaTab.model.Note): Unit{
        for (c in element.childNodes)
        {
            when (c.localName)
            {
                "accent" -> 
                {
                    note.accentuated = alphaTab.model.AccentuationType.Normal
                }
                "strong-accent" -> 
                {
                    note.accentuated = alphaTab.model.AccentuationType.Heavy
                }
                "staccato", "detached-legato" -> 
                {
                    note.isStaccato = true
                }
                else -> { }
            }
        }
    }
    
    /**
     */
    private fun parseDynamics(element: alphaTab.xml.XmlNode, beat: alphaTab.model.Beat): Unit{
        for (c in element.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "p" -> 
                    {
                        beat.dynamics = alphaTab.model.DynamicValue.P
                    }
                    "pp" -> 
                    {
                        beat.dynamics = alphaTab.model.DynamicValue.PP
                    }
                    "ppp" -> 
                    {
                        beat.dynamics = alphaTab.model.DynamicValue.PPP
                    }
                    "f" -> 
                    {
                        beat.dynamics = alphaTab.model.DynamicValue.F
                    }
                    "ff" -> 
                    {
                        beat.dynamics = alphaTab.model.DynamicValue.FF
                    }
                    "fff" -> 
                    {
                        beat.dynamics = alphaTab.model.DynamicValue.FFF
                    }
                    "mp" -> 
                    {
                        beat.dynamics = alphaTab.model.DynamicValue.MP
                    }
                    "mf" -> 
                    {
                        beat.dynamics = alphaTab.model.DynamicValue.MF
                    }
                    else -> { }
                }
            }
        }
    }
    
    /**
     */
    private fun parseTimeModification(element: alphaTab.xml.XmlNode, beat: alphaTab.model.Beat): Unit{
        for (c in element.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "actual-notes" -> 
                    {
                        beat.tupletNumerator = alphaTab.core.Globals.parseInt(c.innerText)
                    }
                    "normal-notes" -> 
                    {
                        beat.tupletDenominator = alphaTab.core.Globals.parseInt(c.innerText)
                    }
                    else -> { }
                }
            }
        }
    }
    
    /**
     */
    private fun parseUnpitched(element: alphaTab.xml.XmlNode, note: alphaTab.model.Note): Unit{
        var step: String = ""
        var semitones: Double = 0.0
        var octave: Double = 0.0
        for (c in element.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "display-step" -> 
                    {
                        step = c.innerText
                    }
                    "display-alter" -> 
                    {
                        semitones = alphaTab.core.Globals.parseInt(c.innerText)
                    }
                    "display-octave" -> 
                    {
                        octave = alphaTab.core.Globals.parseInt(c.innerText)
                    }
                    else -> { }
                }
            }
        }
        var value: Double = octave * 12.0 + alphaTab.model.ModelUtils.getToneForText(step) + semitones
        note.octave = (((value / (12.0).toDouble())).toInt() or 0).toDouble()
        note.tone = value - note.octave * 12.0
    }
    
    /**
     */
    private fun parsePitch(element: alphaTab.xml.XmlNode, note: alphaTab.model.Note): Unit{
        var step: String = ""
        var semitones: Double = 0.0
        var octave: Double = 0.0
        for (c in element.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "step" -> 
                    {
                        step = c.innerText
                    }
                    "alter" -> 
                    {
                        semitones = alphaTab.core.Globals.parseFloat(c.innerText)
                        if (alphaTab.core.Globals.isNaN(semitones))
                        {
                            semitones = 0.0
                        }
                    }
                    "octave" -> 
                    {
                        octave = alphaTab.core.Globals.parseInt(c.innerText) + 1.0
                    }
                    else -> { }
                }
            }
        }
        var value: Double = octave * 12.0 + alphaTab.model.ModelUtils.getToneForText(step) + ((semitones).toInt() or 0)
        note.octave = (((value / (12.0).toDouble())).toInt() or 0).toDouble()
        note.tone = value - note.octave * 12.0
    }
    
    /**
     */
    private fun getOrCreateVoice(bar: alphaTab.model.Bar, index: Double): alphaTab.model.Voice{
        if (index < bar.voices.length)
        {
            return bar.voices[(index).toInt()]
        }
        if(true) {
            var i: Double = bar.voices.length
            
            while(i <= index){
                try{
                    bar.addVoice(alphaTab.model.Voice())
                }
                finally{
                    i++
                }
            }
        }
        this._maxVoices = alphaTab.core.ecmaScript.Math.max(this._maxVoices, bar.voices.length)
        return bar.voices[(index).toInt()]
    }
    
    /**
     */
    private fun parseDirection(element: alphaTab.xml.XmlNode, masterBar: alphaTab.model.MasterBar): Unit{
        for (c in element.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "sound" -> 
                    {
                        var tempo: String = c.getAttribute("tempo")
                        if (alphaTab.core.TypeHelper.isTruthy(tempo))
                        {
                            var tempoAutomation: alphaTab.model.Automation = alphaTab.model.Automation()
                            tempoAutomation.isLinear = true
                            tempoAutomation.type = alphaTab.model.AutomationType.Tempo
                            tempoAutomation.value = alphaTab.core.Globals.parseInt(tempo)
                            masterBar.tempoAutomation = tempoAutomation
                            if (masterBar.index == 0.0)
                            {
                                masterBar.score.tempo = tempoAutomation.value
                            }
                        }
                    }
                    "direction-type" -> 
                    {
                        var directionType: alphaTab.xml.XmlNode = c.firstElement!!
                        when (directionType.localName)
                        {
                            "words" -> 
                            {
                                this._currentDirection = directionType.innerText
                            }
                            "metronome" -> 
                            {
                                this.parseMetronome(directionType, masterBar)
                            }
                            else -> { }
                        }
                    }
                    else -> { }
                }
            }
        }
    }
    
    /**
     */
    private fun parseMetronome(element: alphaTab.xml.XmlNode, masterBar: alphaTab.model.MasterBar): Unit{
        var unit: alphaTab.model.Duration = alphaTab.model.Duration.Quarter
        var perMinute: Double = 120.0
        for (c in element.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "beat-unit" -> 
                    {
                        unit = this.getDuration(c.innerText)
                    }
                    "per-minute" -> 
                    {
                        perMinute = alphaTab.core.Globals.parseInt(c.innerText)
                    }
                    else -> { }
                }
            }
        }
        var tempoAutomation: alphaTab.model.Automation = alphaTab.model.Automation()
        tempoAutomation.type = alphaTab.model.AutomationType.Tempo
        tempoAutomation.value = perMinute * ((((unit.toDouble()) / (4.0).toDouble())).toInt() or 0)
        masterBar.tempoAutomation = tempoAutomation
        if (masterBar.index == 0.0)
        {
            masterBar.score.tempo = tempoAutomation.value
        }
    }
    
    /**
     */
    private fun parseAttributes(element: alphaTab.xml.XmlNode, bars: alphaTab.collections.List<alphaTab.model.Bar>, masterBar: alphaTab.model.MasterBar, track: alphaTab.model.Track): Unit{
        var num: Double = 0.0
        var hasTime: Boolean = false
        for (c in element.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "divisions" -> 
                    {
                        this._divisionsPerQuarterNote = alphaTab.core.Globals.parseInt(c.innerText)
                    }
                    "key" -> 
                    {
                        this.parseKey(c, masterBar)
                    }
                    "time" -> 
                    {
                        this.parseTime(c, masterBar)
                        hasTime = true
                    }
                    "clef" -> 
                    {
                        num = alphaTab.core.Globals.parseInt(c.getAttribute("number"))
                        if (alphaTab.core.Globals.isNaN(num))
                        {
                            num = 1.0
                        }
                        this.parseClef(c, bars[(num - 1.0).toInt()])
                    }
                    "staff-details" -> 
                    {
                        this.parseStaffDetails(c, track)
                    }
                    "transpose" -> 
                    {
                        this.parseTranspose(c, track)
                    }
                    else -> { }
                }
            }
        }
        if (!hasTime)
        {
            masterBar.timeSignatureCommon = true
        }
    }
    
    /**
     */
    private fun parseTranspose(element: alphaTab.xml.XmlNode, track: alphaTab.model.Track): Unit{
        var semitones: Double = 0.0
        for (c in element.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "chromatic" -> 
                    {
                        semitones += alphaTab.core.Globals.parseInt(c.innerText)
                    }
                    "octave-change" -> 
                    {
                        semitones += alphaTab.core.Globals.parseInt(c.innerText) * 12.0
                    }
                    else -> { }
                }
            }
        }
        for (staff in track.staves)
        {
            staff.transpositionPitch = semitones
        }
    }
    
    /**
     */
    private fun parseClef(element: alphaTab.xml.XmlNode, bar: alphaTab.model.Bar): Unit{
        var sign: String = "s"
        var line: Double = 0.0
        for (c in element.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "sign" -> 
                    {
                        sign = c.innerText.lowercase()
                    }
                    "line" -> 
                    {
                        line = alphaTab.core.Globals.parseInt(c.innerText)
                    }
                    "clef-octave-change" -> 
                    {
                        when (alphaTab.core.Globals.parseInt(c.innerText))
                        {
                            -2.0 -> 
                            {
                                bar.clefOttava = alphaTab.model.Ottavia._15mb
                            }
                            -1.0 -> 
                            {
                                bar.clefOttava = alphaTab.model.Ottavia._8vb
                            }
                            1.0 -> 
                            {
                                bar.clefOttava = alphaTab.model.Ottavia._8va
                            }
                            2.0 -> 
                            {
                                bar.clefOttava = alphaTab.model.Ottavia._15mb
                            }
                            else -> { }
                        }
                    }
                    else -> { }
                }
            }
        }
        when (sign)
        {
            "g" -> 
            {
                bar.clef = alphaTab.model.Clef.G2
            }
            "f" -> 
            {
                bar.clef = alphaTab.model.Clef.F4
            }
            "c" -> 
            {
                if (line == 3.0)
                {
                    bar.clef = alphaTab.model.Clef.C3
                }
                else 
                {
                    bar.clef = alphaTab.model.Clef.C4
                }
            }
            "percussion" -> 
            {
                bar.clef = alphaTab.model.Clef.Neutral
                bar.staff.isPercussion = true
            }
            "tab" -> 
            {
                bar.clef = alphaTab.model.Clef.G2
                bar.staff.showTablature = true
            }
            else -> 
            {
                bar.clef = alphaTab.model.Clef.G2
            }
        }
    }
    
    /**
     */
    private fun parseTime(element: alphaTab.xml.XmlNode, masterBar: alphaTab.model.MasterBar): Unit{
        if (element.getAttribute("symbol") == "common")
        {
            masterBar.timeSignatureCommon = true
        }
        var beatsParsed: Boolean = false
        var beatTypeParsed: Boolean = false
        for (c in element.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                var v: String = c.innerText
                when (c.localName)
                {
                    "beats" -> 
                    {
                        if (!beatsParsed)
                        {
                            if (v.indexOfInDouble("+") == -1.0)
                            {
                                masterBar.timeSignatureNumerator = alphaTab.core.Globals.parseInt(v)
                            }
                            else 
                            {
                                masterBar.timeSignatureNumerator = 4.0
                            }
                            beatsParsed = true
                        }
                    }
                    "beat-type" -> 
                    {
                        if (!beatTypeParsed)
                        {
                            if (v.indexOfInDouble("+") == -1.0)
                            {
                                masterBar.timeSignatureDenominator = alphaTab.core.Globals.parseInt(v)
                            }
                            else 
                            {
                                masterBar.timeSignatureDenominator = 4.0
                            }
                            beatTypeParsed = true
                        }
                    }
                    else -> { }
                }
            }
        }
    }
    
    /**
     */
    private fun parseKey(element: alphaTab.xml.XmlNode, masterBar: alphaTab.model.MasterBar): Unit{
        var fifths: Double = -2147483648.0
        var mode: String = ""
        for (c in element.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "fifths" -> 
                    {
                        fifths = alphaTab.core.Globals.parseInt(c.innerText)
                    }
                    "key-step" -> 
                    {
                    }
                    "key-alter" -> 
                    {
                    }
                    "mode" -> 
                    {
                        mode = c.innerText
                    }
                    else -> { }
                }
            }
        }
        if (-7.0 <= fifths && fifths <= 7)
        {
            masterBar.keySignature = alphaTab.model.KeySignature.fromValue(fifths)
        }
        else 
        {
            masterBar.keySignature = alphaTab.model.KeySignature.C
        }
        if (mode == "minor")
        {
            masterBar.keySignatureType = alphaTab.model.KeySignatureType.Minor
        }
        else 
        {
            masterBar.keySignatureType = alphaTab.model.KeySignatureType.Major
        }
    }
    
    /**
     */
    private fun getOrCreateMasterBar(index: Double): alphaTab.model.MasterBar{
        if (index < this._score.masterBars.length)
        {
            return this._score.masterBars[(index).toInt()]
        }
        if(true) {
            var i: Double = this._score.masterBars.length
            
            while(i <= index){
                try{
                    var mb: alphaTab.model.MasterBar = alphaTab.model.MasterBar()
                    if (this._score.masterBars.length > 0)
                    {
                        var prev: alphaTab.model.MasterBar = this._score.masterBars[(this._score.masterBars.length - 1.0).toInt()]
                        mb.timeSignatureDenominator = prev.timeSignatureDenominator
                        mb.timeSignatureNumerator = prev.timeSignatureNumerator
                        mb.keySignature = prev.keySignature
                        mb.keySignatureType = prev.keySignatureType
                    }
                    this._score.addMasterBar(mb)
                }
                finally{
                    i++
                }
            }
        }
        return this._score.masterBars[(index).toInt()]
    }
    
    /**
     */
    private fun parseIdentification(element: alphaTab.xml.XmlNode): Unit{
        for (c in element.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "creator" -> 
                    {
                        if (c.getAttribute("type") == "composer")
                        {
                            this._score.music = c.innerText
                        }
                    }
                    "rights" -> 
                    {
                        if (alphaTab.core.TypeHelper.isTruthy(this._score.copyright))
                        {
                            this._score.copyright += "\n"
                        }
                        this._score.copyright += c.innerText
                    }
                    else -> { }
                }
            }
        }
    }
    
    /**
     */
    private fun parsePartList(element: alphaTab.xml.XmlNode): Unit{
        for (c in element.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "part-group" -> 
                    {
                        this.parsePartGroup(c)
                    }
                    "score-part" -> 
                    {
                        this.parseScorePart(c)
                    }
                    else -> { }
                }
            }
        }
    }
    
    /**
     */
    private fun parsePartGroup(element: alphaTab.xml.XmlNode): Unit{
        var type: String = element.getAttribute("type")
        when (type)
        {
            "start" -> 
            {
                this._currentPartGroup = element.getAttribute("number")
                this._partGroups.set(this._currentPartGroup!!, alphaTab.collections.List<alphaTab.model.Track>(
                )
                )
            }
            "stop" -> 
            {
                this._currentPartGroup = null
            }
            else -> { }
        }
    }
    
    /**
     */
    private fun parseScorePart(element: alphaTab.xml.XmlNode): Unit{
        var id: String = element.getAttribute("id")
        var track: alphaTab.model.Track = alphaTab.model.Track()
        track.ensureStaveCount(1.0)
        var staff: alphaTab.model.Staff = track.staves[(0).toInt()]
        staff.showStandardNotation = true
        this._trackById.set(id, track)
        this._score.addTrack(track)
        if (alphaTab.core.TypeHelper.isTruthy(this._currentPartGroup))
        {
            this._partGroups.get(this._currentPartGroup!!)!!.push(track)
        }
        for (c in element.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "part-name" -> 
                    {
                        track.name = c.innerText
                    }
                    "part-abbreviation" -> 
                    {
                        track.shortName = c.innerText
                    }
                    "midi-instrument" -> 
                    {
                        this.parseMidiInstrument(c, track)
                    }
                    else -> { }
                }
            }
        }
        if (this.isEmptyTuning(track.staves[(0).toInt()].tuning))
        {
            track.staves[(0).toInt()].stringTuning.tunings = alphaTab.collections.DoubleList(
            )
            
        }
    }
    
    /**
     */
    private fun isEmptyTuning(tuning: alphaTab.collections.DoubleList): Boolean{
        if (!alphaTab.core.TypeHelper.isTruthy(tuning))
        {
            return true
        }
        if(true) {
            var i: Double = 0.0
            
            while(i < tuning.length){
                try{
                    if (tuning[(i).toInt()] != 0.0)
                    {
                        return false
                    }
                }
                finally{
                    i++
                }
            }
        }
        return true
    }
    
    /**
     */
    private fun parseMidiInstrument(element: alphaTab.xml.XmlNode, track: alphaTab.model.Track): Unit{
        for (c in element.childNodes)
        {
            if (c.nodeType == alphaTab.xml.XmlNodeType.Element)
            {
                when (c.localName)
                {
                    "midi-channel" -> 
                    {
                        track.playbackInfo.primaryChannel = alphaTab.core.Globals.parseInt(c.innerText)
                    }
                    "midi-program" -> 
                    {
                        track.playbackInfo.program = alphaTab.core.Globals.parseInt(c.innerText)
                    }
                    "volume" -> 
                    {
                        track.playbackInfo.volume = alphaTab.core.ecmaScript.Math.floor((alphaTab.core.Globals.parseInt(c.innerText) / (100.0).toDouble()) * 16.0)
                    }
                    "pan" -> 
                    {
                        track.playbackInfo.balance = alphaTab.core.ecmaScript.Math.max(0.0, alphaTab.core.ecmaScript.Math.min(16.0, alphaTab.core.ecmaScript.Math.floor(((alphaTab.core.Globals.parseInt(c.innerText) + 90.0) / (180.0).toDouble()) * 16.0)))
                    }
                    else -> { }
                }
            }
        }
    }
    
}

