// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.importer
import alphaTab.core.*

/**
 * The ScoreLoader enables you easy loading of Scores using all
 * available importers
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
public class ScoreLoader
{
    companion object{
        /**
         * Loads the score from the given binary data.
         * @param `data` The binary data containing a score in any known file format.
         * @param settings The settings to use during importing.
         */
        @kotlin.jvm.JvmStatic
        public fun loadScoreFromBytes(`data`: alphaTab.core.ecmaScript.Uint8Array, settings: alphaTab.Settings? = null): alphaTab.model.Score{
            var paramsettings = settings
            if (!alphaTab.core.TypeHelper.isTruthy(paramsettings))
            {
                paramsettings = alphaTab.Settings()
            }
            var importers: alphaTab.collections.List<alphaTab.importer.ScoreImporter> = alphaTab.Environment.buildImporters()
            alphaTab.Logger.debug("ScoreLoader", """Loading score from ${(`data`.length).toTemplate()} bytes using ${(importers.length).toTemplate()} importers""")
            var score: alphaTab.model.Score? = null
            var bb: alphaTab.io.ByteBuffer = alphaTab.io.ByteBuffer.fromBuffer(`data`)
            for (importer in importers)
            {
                bb.reset()
                try
                {
                    alphaTab.Logger.debug("ScoreLoader", "Importing using importer " + importer.name)
                    importer.init(bb, paramsettings)
                    score = importer.readScore()
                    alphaTab.Logger.debug("ScoreLoader", "Score imported using " + importer.name)
                    break
                }
                catch (e: kotlin.Throwable)
                {
                    if (e is alphaTab.importer.UnsupportedFormatError)
                    {
                        alphaTab.Logger.debug("ScoreLoader", importer.name + " does not support the file")
                    }
                    else 
                    {
                        alphaTab.Logger.error("ScoreLoader", "Score import failed due to unexpected error: ", e)
                        throw e
                    }
                }
            }
            if (alphaTab.core.TypeHelper.isTruthy(score))
            {
                return score
            }
            throw alphaTab.importer.UnsupportedFormatError("No compatible importer found for file")
        }
        
    }
    public constructor()
}

