// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.io
import alphaTab.core.*

@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class ByteBuffer: alphaTab.io.IWriteable, alphaTab.io.IReadable
{
    private lateinit var _buffer: alphaTab.core.ecmaScript.Uint8Array
    
    /**
     * Gets the total number of bytes contained in the stream.
     */
    public override var length: Double = 0.0
    
    /**
     * Gets or sets the current read position relative in the stream.
     */
    public override var position: Double = 0.0
    
    public override val bytesWritten: Double
    get(){
        return this.position
    }
    
    public fun getBuffer(): alphaTab.core.ecmaScript.Uint8Array{
        return this._buffer
    }
    
    /**
     * Resets the stream for reading the data from the beginning.
     */
    public override fun reset(): Unit{
        this.position = 0.0
    }
    
    /**
     * Skip the given number of bytes.
     */
    public override fun skip(offset: Double): Unit{
        this.position += offset
    }
    
    /**
     * Read a single byte from the data stream.
     */
    public override fun readByte(): Double{
        var n: Double = this.length - this.position
        if (n <= 0)
        {
            return -1.0
        }
        return this._buffer[(this.position++).toInt()]
    }
    
    /**
     * Reads the given number of bytes from the stream into the given buffer.
     */
    public override fun read(buffer: alphaTab.core.ecmaScript.Uint8Array, offset: Double, count: Double): Double{
        var n: Double = this.length - this.position
        if (n > count)
        {
            n = count
        }
        if (n <= 0)
        {
            return 0.0
        }
        buffer.set(this._buffer.subarray(this.position, this.position + n), offset)
        this.position += n
        return n
    }
    
    /**
     * Write a single byte to the stream.
     */
    public override fun writeByte(value: Double): Unit{
        var i: Double = this.position + 1.0
        this.ensureCapacity(i)
        this._buffer[(this.position).toInt()] = ((value).toInt() and 255).toDouble()
        if (i > this.length)
        {
            this.length = i
        }
        this.position = i
    }
    
    /**
     * Write data from the given buffer.
     */
    public override fun write(buffer: alphaTab.core.ecmaScript.Uint8Array, offset: Double, count: Double): Unit{
        var i: Double = this.position + count
        this.ensureCapacity(i)
        var count1: Double = alphaTab.core.ecmaScript.Math.min(count, buffer.length - offset)
        this._buffer.set(buffer.subarray(offset, offset + count1), this.position)
        if (i > this.length)
        {
            this.length = i
        }
        this.position = i
    }
    
    /**
     */
    private fun ensureCapacity(value: Double): Unit{
        if (value > this._buffer.length)
        {
            var newCapacity: Double = value
            if (newCapacity < 256)
            {
                newCapacity = 256.0
            }
            if (newCapacity < this._buffer.length * 2.0)
            {
                newCapacity = this._buffer.length * 2.0
            }
            var newBuffer: alphaTab.core.ecmaScript.Uint8Array = alphaTab.core.ecmaScript.Uint8Array(newCapacity)
            if (this.length > 0)
            {
                newBuffer.set(this._buffer.subarray(0.0, 0.0 + this.length), 0.0)
            }
            this._buffer = newBuffer
        }
    }
    
    /**
     * Reads the remaining data.
     */
    public override fun readAll(): alphaTab.core.ecmaScript.Uint8Array{
        return this.toArray()
    }
    
    public fun toArray(): alphaTab.core.ecmaScript.Uint8Array{
        var copy: alphaTab.core.ecmaScript.Uint8Array = alphaTab.core.ecmaScript.Uint8Array(this.length)
        copy.set(this._buffer.subarray(0.0, 0.0 + this.length), 0.0)
        return copy
    }
    
    /**
     */
    public fun copyTo(destination: alphaTab.io.IWriteable): Unit{
        destination.write(this._buffer, 0.0, this.length)
    }
    
    companion object{
        @kotlin.jvm.JvmStatic
        public fun empty(): alphaTab.io.ByteBuffer{
            return alphaTab.io.ByteBuffer.withCapacity(0.0)
        }
        
        /**
         */
        @kotlin.jvm.JvmStatic
        public fun withCapacity(capacity: Double): alphaTab.io.ByteBuffer{
            var buffer: alphaTab.io.ByteBuffer = alphaTab.io.ByteBuffer()
            buffer._buffer = alphaTab.core.ecmaScript.Uint8Array(capacity)
            return buffer
        }
        
        /**
         */
        @kotlin.jvm.JvmStatic
        public fun fromBuffer(`data`: alphaTab.core.ecmaScript.Uint8Array): alphaTab.io.ByteBuffer{
            var buffer: alphaTab.io.ByteBuffer = alphaTab.io.ByteBuffer()
            buffer._buffer = `data`
            buffer.length = `data`.length
            return buffer
        }
        
        /**
         */
        @kotlin.jvm.JvmStatic
        public fun fromString(contents: String): alphaTab.io.ByteBuffer{
            var byteArray: alphaTab.core.ecmaScript.Uint8Array = alphaTab.io.IOHelper.stringToBytes(contents)
            return alphaTab.io.ByteBuffer.fromBuffer(byteArray)
        }
        
    }
    public constructor()
}

