// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.midi
import alphaTab.core.*

/**
 * This implementation of the 
 * generates a  object which can be used in AlphaSynth for playback.
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
public class AlphaSynthMidiFileHandler: alphaTab.midi.IMidiFileHandler
{
    private var _midiFile: alphaTab.midi.MidiFile
    
    private var _smf1Mode: Boolean
    
    public constructor(midiFile: alphaTab.midi.MidiFile, smf1Mode: Boolean = false){
        this._midiFile = midiFile
        this._smf1Mode = smf1Mode
    }
    
    /**
     * Adds a time signature to the generated midi file
     */
    public override fun addTimeSignature(tick: Double, timeSignatureNumerator: Double, timeSignatureDenominator: Double): Unit{
        var denominatorIndex: Double = 0.0
        var denominator: Double = timeSignatureDenominator
        while (true)
        {
            denominator = ((denominator).toInt() shr 1).toDouble()
            if (denominator > 0)
            {
                denominatorIndex++
            }
            else 
            {
                break
            }
        }
        this._midiFile.addEvent(alphaTab.midi.TimeSignatureEvent(0.0, tick, timeSignatureNumerator, denominatorIndex, 48.0, 8.0))
    }
    
    /**
     * Adds a rest to the generated midi file.
     */
    public override fun addRest(track: Double, tick: Double, channel: Double): Unit{
        if (!this._smf1Mode)
        {
            this._midiFile.addEvent(alphaTab.midi.AlphaTabRestEvent(track, tick, channel))
        }
    }
    
    /**
     * Adds a note to the generated midi file
     */
    public override fun addNote(track: Double, start: Double, length: Double, key: Double, velocity: Double, channel: Double): Unit{
        this._midiFile.addEvent(alphaTab.midi.NoteOnEvent(track, start, channel, alphaTab.midi.AlphaSynthMidiFileHandler.fixValue(key), alphaTab.midi.AlphaSynthMidiFileHandler.fixValue(velocity)))
        this._midiFile.addEvent(alphaTab.midi.NoteOffEvent(track, start + length, channel, alphaTab.midi.AlphaSynthMidiFileHandler.fixValue(key), alphaTab.midi.AlphaSynthMidiFileHandler.fixValue(velocity)))
    }
    
    /**
     * Adds a control change to the generated midi file.
     */
    public override fun addControlChange(track: Double, tick: Double, channel: Double, controller: alphaTab.midi.ControllerType, value: Double): Unit{
        this._midiFile.addEvent(alphaTab.midi.ControlChangeEvent(track, tick, channel, controller, alphaTab.midi.AlphaSynthMidiFileHandler.fixValue(value)))
    }
    
    /**
     * Add a program change to the generated midi file
     */
    public override fun addProgramChange(track: Double, tick: Double, channel: Double, program: Double): Unit{
        this._midiFile.addEvent(alphaTab.midi.ProgramChangeEvent(track, tick, channel, program))
    }
    
    /**
     * Add a tempo change to the generated midi file.
     */
    public override fun addTempo(tick: Double, tempo: Double): Unit{
        var tempoInUsq: Double = ((((60000000.0).toDouble() / tempo)).toInt() or 0).toDouble()
        this._midiFile.addEvent(alphaTab.midi.TempoChangeEvent(tick, tempoInUsq))
    }
    
    /**
     * Add a bend to the generated midi file.
     */
    public override fun addBend(track: Double, tick: Double, channel: Double, value: Double): Unit{
        var paramvalue = value
        if (paramvalue >= alphaTab.synth.SynthConstants.MaxPitchWheel)
        {
            paramvalue = alphaTab.synth.SynthConstants.MaxPitchWheel
        }
        else 
        {
            paramvalue = alphaTab.core.ecmaScript.Math.floor(paramvalue)
        }
        this._midiFile.addEvent(alphaTab.midi.PitchBendEvent(track, tick, channel, paramvalue))
    }
    
    /**
     * Add a bend specific to a note to the generated midi file.
     * The note does not need to be started, if this event is signaled, the next time a note 
     * on this channel and key is played it will be affected. The note bend is cleared on a note-off for this key.
     */
    public override fun addNoteBend(track: Double, tick: Double, channel: Double, key: Double, value: Double): Unit{
        var paramvalue = value
        if (this._smf1Mode)
        {
            this.addBend(track, tick, channel, paramvalue)
        }
        else 
        {
            paramvalue = paramvalue * alphaTab.synth.SynthConstants.MaxPitchWheel20 / alphaTab.synth.SynthConstants.MaxPitchWheel
            this._midiFile.addEvent(alphaTab.midi.NoteBendEvent(track, tick, channel, key, paramvalue))
        }
    }
    
    /**
     * Indicates that the track is finished on the given ticks.
     */
    public override fun finishTrack(track: Double, tick: Double): Unit{
        if (this._midiFile.format == alphaTab.midi.MidiFileFormat.MultiTrack || track == 0.0)
        {
            this._midiFile.addEvent(alphaTab.midi.EndOfTrackEvent(track, tick))
        }
    }
    
    companion object{
        /**
         */
        @kotlin.jvm.JvmStatic
        private fun fixValue(value: Double): Double{
            if (value > 127)
            {
                return 127.0
            }
            if (value < 0)
            {
                return 0.0
            }
            return value
        }
        
    }
}

