// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.midi
import alphaTab.core.*

/**
 * Represents the time period, for which one or multiple s are played
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
public class BeatTickLookup
{
    private var _highlightedBeats: alphaTab.collections.DoubleBooleanMap = alphaTab.collections.DoubleBooleanMap()
    
    /**
     * Gets or sets the start time in midi ticks at which the given beat is played.
     */
    public var start: Double
    /**
     * Gets or sets the end time in midi ticks at which the given beat is played.
     */
    public var end: Double
    /**
     * Gets or sets a list of all beats that should be highlighted when
     * the beat of this lookup starts playing. This might not mean 
     * the beats start at this position.
     */
    public var highlightedBeats: alphaTab.collections.List<alphaTab.midi.BeatTickLookupItem> = alphaTab.collections.List<alphaTab.midi.BeatTickLookupItem>(
    )
    
    
    /**
     * Gets the next BeatTickLookup which comes after this one and is in the same
     * MasterBarTickLookup.
     */
    public var nextBeat: alphaTab.midi.BeatTickLookup? = null
    
    /**
     * Gets the preivous BeatTickLookup which comes before this one and is in the same
     * MasterBarTickLookup.
     */
    public var previousBeat: alphaTab.midi.BeatTickLookup? = null
    
    public val duration: Double
    get(){
        return this.end - this.start
    }
    
    public constructor(start: Double, end: Double){
        this.start = start
        this.end = end
    }
    
    /**
     * Marks the given beat as highlighed as part of this lookup.
     * @param beat The beat to add.
     */
    public fun highlightBeat(beat: alphaTab.model.Beat, playbackStart: Double): Unit{
        if (beat.isEmpty && !beat.voice.isEmpty)
        {
            return
        }
        if (!this._highlightedBeats.has(beat.id))
        {
            this._highlightedBeats.set(beat.id, true)
            this.highlightedBeats.push(alphaTab.midi.BeatTickLookupItem(beat, playbackStart))
        }
    }
    
    /**
     * Looks for the first visible beat which starts at this lookup so it can be used for cursor placement.
     * @param visibleTracks The visible tracks.
     */
    public fun getVisibleBeatAtStart(visibleTracks: alphaTab.core.ecmaScript.Set<Double>): alphaTab.model.Beat?{
        for (b in this.highlightedBeats)
        {
            if (b.playbackStart == this.start && visibleTracks.has(b.beat.voice.bar.staff.track.index))
            {
                return b.beat
            }
        }
        return null
    }
    
}

/**
 * Represents a beat and when it is actually played according to the generated audio.
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
public class BeatTickLookupItem
{
    /**
     * Gets the beat represented by this item.
     */
    public var beat: alphaTab.model.Beat
    /**
     * Gets the playback start of the beat according to the generated audio.
     */
    public var playbackStart: Double
    public constructor(beat: alphaTab.model.Beat, playbackStart: Double){
        this.beat = beat
        this.playbackStart = playbackStart
    }
    
}

