// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.midi
import alphaTab.core.*

/**
 * A handler is responsible for writing midi events to a custom structure
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
public interface IMidiFileHandler
{
    /**
     * Adds a time signature to the generated midi file
     * @param tick The midi ticks when this event should be happening.
     * @param timeSignatureNumerator The time signature numerator
     * @param timeSignatureDenominator The time signature denominator
     */
    fun addTimeSignature(tick: Double, timeSignatureNumerator: Double, timeSignatureDenominator: Double): Unit
    
    /**
     * Adds a rest to the generated midi file.
     * @param track The midi track on which the rest should be "played".
     * @param tick The midi ticks when the rest is "playing".
     * @param channel The midi channel on which the rest should be "played".
     */
    fun addRest(track: Double, tick: Double, channel: Double): Unit
    
    /**
     * Adds a note to the generated midi file
     * @param track The midi track on which the note should be played.
     * @param start The midi ticks when the note should start playing.
     * @param length The duration the note in midi ticks.
     * @param key The key of the note to play
     * @param velocity The velocity which should be applied to the note (derived from the note dynamics).
     * @param channel The midi channel on which the note should be played.
     */
    fun addNote(track: Double, start: Double, length: Double, key: Double, velocity: Double, channel: Double): Unit
    
    /**
     * Adds a control change to the generated midi file.
     * @param track The midi track on which the controller should change.
     * @param tick The midi ticks when the controller should change.
     * @param channel The midi channel on which the controller should change.
     * @param controller The midi controller that should change.
     * @param value The value to which the midi controller should change
     */
    fun addControlChange(track: Double, tick: Double, channel: Double, controller: alphaTab.midi.ControllerType, value: Double): Unit
    
    /**
     * Add a program change to the generated midi file
     * @param track The midi track on which the program should change.
     * @param tick The midi ticks when the program should change.
     * @param channel The midi channel on which the program should change.
     * @param program The new program for the selected track and channel.
     */
    fun addProgramChange(track: Double, tick: Double, channel: Double, program: Double): Unit
    
    /**
     * Add a tempo change to the generated midi file.
     * @param tick The midi ticks when the tempo should change change.
     * @param tempo The tempo as BPM
     */
    fun addTempo(tick: Double, tempo: Double): Unit
    
    /**
     * Add a bend specific to a note to the generated midi file.
     * The note does not need to be started, if this event is signaled, the next time a note 
     * on this channel and key is played it will be affected. The note bend is cleared on a note-off for this key.
     * @param track The midi track on which the bend should change.
     * @param tick The midi ticks when the bend should change.
     * @param channel 
     * The midi channel on which the bend should change.
     * The key of the note that should be affected by the bend.
    
     * @param value The new bend for the selected note.
     */
    fun addNoteBend(track: Double, tick: Double, channel: Double, key: Double, value: Double): Unit
    
    /**
     * Add a bend to the generated midi file.
     * @param track The midi track on which the bend should change.
     * @param tick The midi ticks when the bend should change.
     * @param channel The midi channel on which the bend should change.
     * @param value The new bend for the selected track and channel.
     */
    fun addBend(track: Double, tick: Double, channel: Double, value: Double): Unit
    
    /**
     * Indicates that the track is finished on the given ticks.
     * @param track The track that was finished.
     * @param tick The end tick for this track.
     */
    fun finishTrack(track: Double, tick: Double): Unit
    
}

