// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.midi
import alphaTab.core.*

/**
 * Represents the time period, for which all bars of a  are played.
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
public class MasterBarTickLookup
{
    /**
     * Gets or sets the start time in midi ticks at which the MasterBar is played.
     */
    public var start: Double = 0.0
    
    /**
     * Gets or sets the end time in midi ticks at which the MasterBar is played.
     */
    public var end: Double = 0.0
    
    /**
     * Gets or sets the current tempo when the MasterBar is played.
     */
    public var tempo: Double = 0.0
    
    /**
     * Gets or sets the MasterBar which is played.
     */
    public lateinit var masterBar: alphaTab.model.MasterBar
    public var firstBeat: alphaTab.midi.BeatTickLookup? = null
    
    public var lastBeat: alphaTab.midi.BeatTickLookup? = null
    
    /**
     * Inserts `newNextBeat` after `currentBeat` in the linked list of items and updates.
     * the `firstBeat` and `lastBeat` respectively too.
     * @param currentBeat The item in which to insert the new item afterwards
     * @param newBeat The new item to insert
     */
    private fun insertAfter(currentBeat: alphaTab.midi.BeatTickLookup?, newBeat: alphaTab.midi.BeatTickLookup): Unit{
        if (this.firstBeat == null || currentBeat == null || this.lastBeat == null)
        {
            this.firstBeat = newBeat
            this.lastBeat = newBeat
        }
        else 
        {
            newBeat.nextBeat = currentBeat.nextBeat
            newBeat.previousBeat = currentBeat
            if (alphaTab.core.TypeHelper.isTruthy(currentBeat.nextBeat))
            {
                currentBeat.nextBeat!!.previousBeat = newBeat
            }
            currentBeat.nextBeat = newBeat
            if (currentBeat == this.lastBeat)
            {
                this.lastBeat = newBeat
            }
        }
    }
    
    /**
     * Inserts `newNextBeat` before `currentBeat` in the linked list of items and updates.
     * the `firstBeat` and `lastBeat` respectively too.
     * @param currentBeat The item in which to insert the new item afterwards
     * @param newBeat The new item to insert
     */
    private fun insertBefore(currentBeat: alphaTab.midi.BeatTickLookup?, newBeat: alphaTab.midi.BeatTickLookup): Unit{
        if (this.firstBeat == null || currentBeat == null || this.lastBeat == null)
        {
            this.firstBeat = newBeat
            this.lastBeat = newBeat
        }
        else 
        {
            newBeat.previousBeat = currentBeat.previousBeat
            newBeat.nextBeat = currentBeat
            if (alphaTab.core.TypeHelper.isTruthy(currentBeat.previousBeat))
            {
                currentBeat.previousBeat!!.nextBeat = newBeat
            }
            currentBeat.previousBeat = newBeat
            if (currentBeat == this.firstBeat)
            {
                this.firstBeat = newBeat
            }
        }
    }
    
    /**
     * Gets or sets the  of the next masterbar in the 
     */
    public var nextMasterBar: alphaTab.midi.MasterBarTickLookup? = null
    
    /**
     * Gets or sets the  of the previous masterbar in the 
     */
    public var previousMasterBar: alphaTab.midi.MasterBarTickLookup? = null
    
    /**
     * Adds a new beat to this masterbar following the slicing logic required by the MidiTickLookup.
     * @param beat The beat to add to this masterbat
     * @param beatPlaybackStart The original start of this beat. This time is relevant for highlighting.
     * @param sliceStart The slice start to which this beat should be added. This time is relevant for creating new slices.
     * @param sliceDuration The slice duration to which this beat should be added. This time is relevant for creating new slices.
     */
    public fun addBeat(beat: alphaTab.model.Beat, beatPlaybackStart: Double, sliceStart: Double, sliceDuration: Double): Unit{
        var end: Double = sliceStart + sliceDuration
        if (this.firstBeat == null)
        {
            var n1: alphaTab.midi.BeatTickLookup = alphaTab.midi.BeatTickLookup(sliceStart, end)
            n1.highlightBeat(beat, beatPlaybackStart)
            this.insertAfter(this.firstBeat, n1)
        }
        else if (sliceStart >= this.lastBeat!!.end)
        {
            var n1: alphaTab.midi.BeatTickLookup = alphaTab.midi.BeatTickLookup(this.lastBeat!!.end, end)
            n1.highlightBeat(beat, beatPlaybackStart)
            this.insertAfter(this.lastBeat, n1)
        }
        else 
        {
            var l1: alphaTab.midi.BeatTickLookup? = null
            if (sliceStart < this.firstBeat!!.start)
            {
                l1 = this.firstBeat!!
            }
            else 
            {
                var current: alphaTab.midi.BeatTickLookup? = this.firstBeat
                while (current != null)
                {
                    if (sliceStart >= current.start && sliceStart < current.end)
                    {
                        l1 = current
                        break
                    }
                    current = current.nextBeat
                }
                if (l1 == null)
                {
                    throw alphaTab.AlphaTabError(alphaTab.AlphaTabErrorType.General, "Error on building lookup, unknown variant")
                }
            }
            if (sliceStart < l1.start)
            {
                if (end == l1.start)
                {
                    var n1: alphaTab.midi.BeatTickLookup = alphaTab.midi.BeatTickLookup(sliceStart, l1.start)
                    n1.highlightBeat(beat, beatPlaybackStart)
                    this.insertBefore(this.firstBeat, n1)
                }
                else if (end < l1.end)
                {
                    var n1: alphaTab.midi.BeatTickLookup = alphaTab.midi.BeatTickLookup(sliceStart, l1.start)
                    n1.highlightBeat(beat, beatPlaybackStart)
                    this.insertBefore(l1, n1)
                    var n2: alphaTab.midi.BeatTickLookup = alphaTab.midi.BeatTickLookup(l1.start, end)
                    for (b in l1.highlightedBeats)
                    {
                        n2.highlightBeat(b.beat, b.playbackStart)
                    }
                    n2.highlightBeat(beat, beatPlaybackStart)
                    this.insertBefore(l1, n2)
                    l1.start = end
                }
                else if (end == l1.end)
                {
                    var n1: alphaTab.midi.BeatTickLookup = alphaTab.midi.BeatTickLookup(sliceStart, l1.start)
                    n1.highlightBeat(beat, beatPlaybackStart)
                    l1.highlightBeat(beat, beatPlaybackStart)
                    this.insertBefore(l1, n1)
                }
                else 
                {
                    var n1: alphaTab.midi.BeatTickLookup = alphaTab.midi.BeatTickLookup(sliceStart, l1.start)
                    n1.highlightBeat(beat, beatPlaybackStart)
                    l1.highlightBeat(beat, beatPlaybackStart)
                    this.insertBefore(l1, n1)
                    this.addBeat(beat, beatPlaybackStart, l1.end, end - l1.end)
                }
            }
            else if (sliceStart > l1.start)
            {
                if (end == l1.end)
                {
                    var n1: alphaTab.midi.BeatTickLookup = alphaTab.midi.BeatTickLookup(l1.start, sliceStart)
                    for (b in l1.highlightedBeats)
                    {
                        n1.highlightBeat(b.beat, b.playbackStart)
                    }
                    l1.start = sliceStart
                    l1.highlightBeat(beat, beatPlaybackStart)
                    this.insertBefore(l1, n1)
                }
                else if (end < l1.end)
                {
                    var n1: alphaTab.midi.BeatTickLookup = alphaTab.midi.BeatTickLookup(l1.start, sliceStart)
                    this.insertBefore(l1, n1)
                    var n2: alphaTab.midi.BeatTickLookup = alphaTab.midi.BeatTickLookup(sliceStart, end)
                    this.insertBefore(l1, n2)
                    for (b in l1.highlightedBeats)
                    {
                        n1.highlightBeat(b.beat, b.playbackStart)
                        n2.highlightBeat(b.beat, b.playbackStart)
                    }
                    n2.highlightBeat(beat, beatPlaybackStart)
                    l1.start = end
                }
                else 
                {
                    var n1: alphaTab.midi.BeatTickLookup = alphaTab.midi.BeatTickLookup(l1.start, sliceStart)
                    for (b in l1.highlightedBeats)
                    {
                        n1.highlightBeat(b.beat, b.playbackStart)
                    }
                    l1.start = sliceStart
                    l1.highlightBeat(beat, beatPlaybackStart)
                    this.insertBefore(l1, n1)
                    this.addBeat(beat, beatPlaybackStart, l1.end, end - l1.end)
                }
            }
            else 
            {
                if (end == l1.end)
                {
                    l1.highlightBeat(beat, beatPlaybackStart)
                }
                else if (end < l1.end)
                {
                    var n1: alphaTab.midi.BeatTickLookup = alphaTab.midi.BeatTickLookup(l1.start, end)
                    for (b in l1.highlightedBeats)
                    {
                        n1.highlightBeat(b.beat, b.playbackStart)
                    }
                    n1.highlightBeat(beat, beatPlaybackStart)
                    l1.start = end
                    this.insertBefore(l1, n1)
                }
                else 
                {
                    l1.highlightBeat(beat, beatPlaybackStart)
                    this.addBeat(beat, beatPlaybackStart, l1.end, end - l1.end)
                }
            }
        }
    }
    
    public constructor()
}

