// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.midi
import alphaTab.core.*

/**
 * Represents a midi event.
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
public abstract class MidiEvent
{
    /**
     * Gets or sets the track to which the midi event belongs.
     */
    public var track: Double
    /**
     * Gets or sets the absolute tick of this midi event.
     */
    public var tick: Double
    /**
     * Gets or sets the midi command (type) of this event.
     */
    public var type: alphaTab.midi.MidiEventType
    public constructor(track: Double, tick: Double, command: alphaTab.midi.MidiEventType){
        this.track = track
        this.tick = tick
        this.type = command
    }
    
    public val command: alphaTab.midi.MidiEventType
    get(){
        return this.type
    }
    
    public val message: Double
    get(){
        return 0.0
    }
    
    public open val data1: Double
    get(){
        return 0.0
    }
    
    public open val data2: Double
    get(){
        return 0.0
    }
    
    /**
     * Writes the midi event as binary into the given stream.
     * @param s The stream to write to.
     */
    public abstract fun writeTo(s: alphaTab.io.IWriteable): Unit
    
}

/**
 * Lists all midi event types. Based on the type the instance is a specific subclass.
 */
public enum class MidiEventType(override val value: Int): alphaTab.core.IAlphaTabEnum
{
    TimeSignature(88),
    NoteOn(128),
    NoteOff(144),
    ControlChange(176),
    ProgramChange(192),
    TempoChange(81),
    PitchBend(224),
    PerNotePitchBend(96),
    EndOfTrack(47),
    AlphaTabRest(241),
    AlphaTabMetronome(242),
    SystemExclusive(240),
    SystemExclusive2(247),
    Meta(255);
    companion object{
        public fun fromValue(v:Double): MidiEventType{
            return when(v.toInt()){
                TimeSignature.value -> TimeSignature
                NoteOn.value -> NoteOn
                NoteOff.value -> NoteOff
                ControlChange.value -> ControlChange
                ProgramChange.value -> ProgramChange
                TempoChange.value -> TempoChange
                PitchBend.value -> PitchBend
                PerNotePitchBend.value -> PerNotePitchBend
                EndOfTrack.value -> EndOfTrack
                AlphaTabRest.value -> AlphaTabRest
                AlphaTabMetronome.value -> AlphaTabMetronome
                SystemExclusive.value -> SystemExclusive
                SystemExclusive2.value -> SystemExclusive2
                Meta.value -> Meta
                else -> throw ClassCastException("No enum with value $v found")}
        }
    }
}

/**
 * Represents a time signature change event.
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
public class TimeSignatureEvent: alphaTab.midi.MidiEvent
{
    /**
     * The time signature numerator.
     */
    public var numerator: Double
    /**
     * The denominator index is a negative power of two: 2 represents a quarter-note, 3 represents an eighth-note, etc.
     * Denominator = 2^(index)
     */
    public var denominatorIndex: Double
    /**
     * The number of MIDI clocks in a metronome click
     */
    public var midiClocksPerMetronomeClick: Double
    /**
     * The number of notated 32nd-notes in what MIDI thinks of as a quarter-note (24 MIDI Clocks).
     */
    public var thirtySecondNodesInQuarter: Double
    public constructor(track: Double, tick: Double, numerator: Double, denominatorIndex: Double, midiClocksPerMetronomeClick: Double, thirtySecondNodesInQuarter: Double)
        : super(track, tick, alphaTab.midi.MidiEventType.TimeSignature){
        this.track = track
        this.tick = tick
        this.numerator = numerator
        this.denominatorIndex = denominatorIndex
        this.midiClocksPerMetronomeClick = midiClocksPerMetronomeClick
        this.thirtySecondNodesInQuarter = thirtySecondNodesInQuarter
    }
    
    /**
     * Writes the midi event as binary into the given stream.
     */
    public override fun writeTo(s: alphaTab.io.IWriteable): Unit{
        s.writeByte(255.0)
        s.writeByte(88.0)
        alphaTab.midi.MidiFile.writeVariableInt(s, 4.0)
        s.writeByte(((this.numerator).toInt() and 255).toDouble())
        s.writeByte(((this.denominatorIndex).toInt() and 255).toDouble())
        s.writeByte(((this.midiClocksPerMetronomeClick).toInt() and 255).toDouble())
        s.writeByte(((this.thirtySecondNodesInQuarter).toInt() and 255).toDouble())
    }
    
}

/**
 * The base class for alphaTab specific midi events (like metronomes and rests).
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
public abstract class AlphaTabSysExEvent: alphaTab.midi.MidiEvent
{
    public constructor(track: Double, tick: Double, type: alphaTab.midi.MidiEventType)
        : super(track, tick, type)
    /**
     * Writes the midi event as binary into the given stream.
     */
    public override fun writeTo(s: alphaTab.io.IWriteable): Unit{
        s.writeByte(240.0)
        var data: alphaTab.io.ByteBuffer = alphaTab.io.ByteBuffer.withCapacity(16.0)
        `data`.writeByte((alphaTab.midi.AlphaTabSysExEvent.AlphaTabManufacturerId.toDouble()))
        this.writeEventData(`data`)
        `data`.writeByte(247.0)
        alphaTab.midi.MidiFile.writeVariableInt(s, `data`.length)
        `data`.copyTo(s)
    }
    
    /**
     */
    protected abstract fun writeEventData(s: alphaTab.io.IWriteable): Unit
    
    companion object{
        @kotlin.jvm.JvmStatic
        public val AlphaTabManufacturerId: Double = 125.0
        
        @kotlin.jvm.JvmStatic
        public val MetronomeEventId: Double = 0.0
        
        @kotlin.jvm.JvmStatic
        public val RestEventId: Double = 1.0
        
    }
}

/**
 * Represents a metronome event. This event is emitted by the synthesizer only during playback and 
 * is typically not part of the midi file itself.
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
public class AlphaTabMetronomeEvent: alphaTab.midi.AlphaTabSysExEvent
{
    /**
     * The metronome counter as per current time signature.
     */
    public var metronomeNumerator: Double
    /**
     * The duration of the metronome tick in MIDI ticks.
     */
    public var metronomeDurationInTicks: Double
    /**
     * The duration of the metronome tick in milliseconds.
     */
    public var metronomeDurationInMilliseconds: Double
    /**
     * Gets a value indicating whether the current event is a metronome event.
     */
    public var isMetronome: Boolean = true
    
    public constructor(track: Double, tick: Double, counter: Double, durationInTicks: Double, durationInMillis: Double)
        : super(track, tick, alphaTab.midi.MidiEventType.AlphaTabMetronome){
        this.metronomeNumerator = counter
        this.metronomeDurationInMilliseconds = durationInMillis
        this.metronomeDurationInTicks = durationInTicks
    }
    
    /**
     */
    protected override fun writeEventData(s: alphaTab.io.IWriteable): Unit{
        s.writeByte((alphaTab.midi.AlphaTabSysExEvent.MetronomeEventId.toDouble()))
        s.writeByte(this.metronomeNumerator)
        alphaTab.io.IOHelper.writeInt32LE(s, this.metronomeDurationInTicks)
        alphaTab.io.IOHelper.writeInt32LE(s, this.metronomeDurationInMilliseconds)
    }
    
}

/**
 * Represents a REST beat being 'played'. This event supports alphaTab in placing the cursor.
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
public class AlphaTabRestEvent: alphaTab.midi.AlphaTabSysExEvent
{
    public var channel: Double
    public constructor(track: Double, tick: Double, channel: Double)
        : super(track, tick, alphaTab.midi.MidiEventType.AlphaTabRest){
        this.channel = channel
    }
    
    /**
     */
    protected override fun writeEventData(s: alphaTab.io.IWriteable): Unit{
        s.writeByte((alphaTab.midi.AlphaTabSysExEvent.RestEventId.toDouble()))
        s.writeByte(this.channel)
    }
    
}

/**
 * The base class for note related events.
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
public abstract class NoteEvent: alphaTab.midi.MidiEvent
{
    /**
     * The channel on which the note is played.
     */
    public var channel: Double
    /**
     * The key of the note being played (aka. the note height).
     */
    public var noteKey: Double
    /**
     * The velocity in which the 'key' of the note is pressed (aka. the loudness/intensity of the note).
     */
    public var noteVelocity: Double
    public constructor(track: Double, tick: Double, type: alphaTab.midi.MidiEventType, channel: Double, noteKey: Double, noteVelocity: Double)
        : super(track, tick, type){
        this.channel = channel
        this.noteKey = noteKey
        this.noteVelocity = noteVelocity
    }
    
    public override val data1: Double
    get(){
        return this.noteKey
    }
    
    public override val data2: Double
    get(){
        return this.noteVelocity
    }
    
}

/**
 * Represents a note being played
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
public class NoteOnEvent: alphaTab.midi.NoteEvent
{
    public constructor(track: Double, tick: Double, channel: Double, noteKey: Double, noteVelocity: Double)
        : super(track, tick, alphaTab.midi.MidiEventType.NoteOn, channel, noteKey, noteVelocity)
    /**
     * Writes the midi event as binary into the given stream.
     */
    public override fun writeTo(s: alphaTab.io.IWriteable): Unit{
        s.writeByte((((this.channel).toInt() and 15) or 144).toDouble())
        s.writeByte(((this.noteKey).toInt() and 255).toDouble())
        s.writeByte(((this.noteVelocity).toInt() and 255).toDouble())
    }
    
}

/**
 * Represents a note stop being played.
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
public class NoteOffEvent: alphaTab.midi.NoteEvent
{
    public constructor(track: Double, tick: Double, channel: Double, noteKey: Double, noteVelocity: Double)
        : super(track, tick, alphaTab.midi.MidiEventType.NoteOff, channel, noteKey, noteVelocity)
    /**
     * Writes the midi event as binary into the given stream.
     */
    public override fun writeTo(s: alphaTab.io.IWriteable): Unit{
        s.writeByte((((this.channel).toInt() and 15) or 128).toDouble())
        s.writeByte(((this.noteKey).toInt() and 255).toDouble())
        s.writeByte(((this.noteVelocity).toInt() and 255).toDouble())
    }
    
}

/**
 * Represents the change of a value on a midi controller.
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
public class ControlChangeEvent: alphaTab.midi.MidiEvent
{
    /**
     * The channel for which the controller is changing.
     */
    public var channel: Double
    /**
     * The type of the controller which is changing.
     */
    public var controller: alphaTab.midi.ControllerType
    /**
     * The new value of the controller. The meaning is depending on the controller type.
     */
    public var value: Double
    public constructor(track: Double, tick: Double, channel: Double, controller: alphaTab.midi.ControllerType, value: Double)
        : super(track, tick, alphaTab.midi.MidiEventType.ControlChange){
        this.channel = channel
        this.controller = controller
        this.value = value
    }
    
    /**
     * Writes the midi event as binary into the given stream.
     */
    public override fun writeTo(s: alphaTab.io.IWriteable): Unit{
        s.writeByte((((this.channel).toInt() and 15) or 176).toDouble())
        s.writeByte((((this.controller.toDouble())).toInt() and 255).toDouble())
        s.writeByte(((this.value).toInt() and 255).toDouble())
    }
    
    public override val data1: Double
    get(){
        return this.controller.toDouble()
    }
    
    public override val data2: Double
    get(){
        return this.value
    }
    
}

/**
 * Represents the change of the midi program on a channel.
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
public class ProgramChangeEvent: alphaTab.midi.MidiEvent
{
    /**
     * The midi channel for which the program changes.
     */
    public var channel: Double
    /**
     * The numeric value of the program indicating the instrument bank to choose.
     */
    public var program: Double
    public constructor(track: Double, tick: Double, channel: Double, program: Double)
        : super(track, tick, alphaTab.midi.MidiEventType.ProgramChange){
        this.channel = channel
        this.program = program
    }
    
    /**
     * Writes the midi event as binary into the given stream.
     */
    public override fun writeTo(s: alphaTab.io.IWriteable): Unit{
        s.writeByte((((this.channel).toInt() and 15) or 192).toDouble())
        s.writeByte(((this.program).toInt() and 255).toDouble())
    }
    
    public override val data1: Double
    get(){
        return this.program
    }
    
}

/**
 * Represents a change of the tempo in the song.
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
public class TempoChangeEvent: alphaTab.midi.MidiEvent
{
    /**
     * The tempo in microseconds per quarter note (aka USQ). A time format typically for midi.
     */
    public var microSecondsPerQuarterNote: Double
    public constructor(tick: Double, microSecondsPerQuarterNote: Double)
        : super(0.0, tick, alphaTab.midi.MidiEventType.TempoChange){
        this.microSecondsPerQuarterNote = microSecondsPerQuarterNote
    }
    
    /**
     * Writes the midi event as binary into the given stream.
     */
    public override fun writeTo(s: alphaTab.io.IWriteable): Unit{
        s.writeByte(255.0)
        s.writeByte(81.0)
        s.writeByte(3.0)
        s.writeByte((((this.microSecondsPerQuarterNote).toInt() shr 16) and 255).toDouble())
        s.writeByte((((this.microSecondsPerQuarterNote).toInt() shr 8) and 255).toDouble())
        s.writeByte(((this.microSecondsPerQuarterNote).toInt() and 255).toDouble())
    }
    
}

/**
 * Represents a change of the pitch bend (aka. pitch wheel) on a specific channel.
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
public class PitchBendEvent: alphaTab.midi.MidiEvent
{
    /**
     * The channel for which the pitch bend changes.
     */
    public var channel: Double
    /**
     * The value to which the pitch changes. This value is according to the MIDI specification.
     */
    public var value: Double
    public constructor(track: Double, tick: Double, channel: Double, value: Double)
        : super(track, tick, alphaTab.midi.MidiEventType.PitchBend){
        this.channel = channel
        this.value = value
    }
    
    /**
     * Writes the midi event as binary into the given stream.
     */
    public override fun writeTo(s: alphaTab.io.IWriteable): Unit{
        s.writeByte((((this.channel).toInt() and 15) or 224).toDouble())
        s.writeByte(((this.value).toInt() and 127).toDouble())
        s.writeByte((((this.value).toInt() shr 7) and 127).toDouble())
    }
    
    public override val data1: Double
    get(){
        return ((this.value).toInt() and 127).toDouble()
    }
    
    public override val data2: Double
    get(){
        return (((this.value).toInt() shr 7) and 127).toDouble()
    }
    
}

/**
 * Represents a single note pitch bend change.
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
public class NoteBendEvent: alphaTab.midi.MidiEvent
{
    /**
     * The channel on which the note is played for which the pitch changes.
     */
    public var channel: Double
    /**
     * The key of the note for which the pitch changes.
     */
    public var noteKey: Double
    /**
     * The value to which the pitch changes. This value is according to the MIDI specification.
     */
    public var value: Double
    public constructor(track: Double, tick: Double, channel: Double, noteKey: Double, value: Double)
        : super(track, tick, alphaTab.midi.MidiEventType.PerNotePitchBend){
        this.channel = channel
        this.noteKey = noteKey
        this.value = value
    }
    
    /**
     * Writes the midi event as binary into the given stream.
     */
    public override fun writeTo(s: alphaTab.io.IWriteable): Unit{
        throw alphaTab.AlphaTabError(alphaTab.AlphaTabErrorType.General, "Note Bend (Midi2.0) events cannot be exported to SMF1.0")
    }
    
}

/**
 * Represents the end of the track indicating that no more events for this track follow.
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
public class EndOfTrackEvent: alphaTab.midi.MidiEvent
{
    public constructor(track: Double, tick: Double)
        : super(track, tick, alphaTab.midi.MidiEventType.EndOfTrack)
    /**
     * Writes the midi event as binary into the given stream.
     */
    public override fun writeTo(s: alphaTab.io.IWriteable): Unit{
        s.writeByte(255.0)
        s.writeByte(47.0)
        s.writeByte(0.0)
    }
    
}

