// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.midi
import alphaTab.core.*

/**
 * Represents a midi file with a single track that can be played via 
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
public class MidiFile
{
    /**
     * Gets or sets the midi file format to use.
     */
    public var format: alphaTab.midi.MidiFileFormat = alphaTab.midi.MidiFileFormat.SingleTrackMultiChannel
    
    /**
     * Gets or sets the division per quarter notes.
     */
    public var division: Double = alphaTab.midi.MidiUtils.QuarterTime
    
    public val events: alphaTab.collections.List<alphaTab.midi.MidiEvent>
    get(){
        if (this.tracks.length == 1.0)
        {
            return this.tracks[(0).toInt()].events
        }
        else 
        {
            var events: alphaTab.collections.List<alphaTab.midi.MidiEvent> = alphaTab.collections.List<alphaTab.midi.MidiEvent>(
            )
            
            for (t in this.tracks)
            {
                this.events.push(t.events)
            }
            events.sort(fun(a: alphaTab.midi.MidiEvent, b: alphaTab.midi.MidiEvent): Double{
                return a.tick - b.tick
            }
            )
            return events
        }
    }
    
    /**
     * Gets a list of midi tracks.
     */
    public var tracks: alphaTab.collections.List<alphaTab.midi.MidiTrack> = alphaTab.collections.List<alphaTab.midi.MidiTrack>(
    )
    
    
    /**
     */
    private fun ensureTracks(trackCount: Double): Unit{
        while (this.tracks.length < trackCount)
        {
            this.tracks.push(alphaTab.midi.MidiTrack())
        }
    }
    
    /**
     * Adds the given midi event a the correct time position into the file.
     */
    public fun addEvent(e: alphaTab.midi.MidiEvent): Unit{
        if (this.format == alphaTab.midi.MidiFileFormat.SingleTrackMultiChannel)
        {
            this.ensureTracks(1.0)
            this.tracks[(0).toInt()].addEvent(e)
        }
        else 
        {
            this.ensureTracks(e.track + 1.0)
            this.tracks[(e.track).toInt()].addEvent(e)
        }
    }
    
    /**
     * Writes the midi file into a binary format.
     */
    public fun toBinary(): alphaTab.core.ecmaScript.Uint8Array{
        var data: alphaTab.io.ByteBuffer = alphaTab.io.ByteBuffer.empty()
        this.writeTo(`data`)
        return `data`.toArray()
    }
    
    /**
     * Writes the midi file as binary into the given stream.
     */
    public fun writeTo(s: alphaTab.io.IWriteable): Unit{
        var b: alphaTab.core.ecmaScript.Uint8Array = alphaTab.core.ecmaScript.Uint8Array(alphaTab.collections.List(77.0, 84.0, 104.0, 100.0))
        s.write(b, 0.0, b.length)
        alphaTab.io.IOHelper.writeInt32BE(s, 6.0)
        alphaTab.io.IOHelper.writeInt16BE(s, this.format.toDouble())
        alphaTab.io.IOHelper.writeInt16BE(s, this.tracks.length)
        alphaTab.io.IOHelper.writeInt16BE(s, this.division)
        for (track in this.tracks)
        {
            track.writeTo(s)
        }
    }
    
    companion object{
        /**
         */
        @kotlin.jvm.JvmStatic
        public fun writeVariableInt(s: alphaTab.io.IWriteable, value: Double): Unit{
            var paramvalue = value
            var array: alphaTab.core.ecmaScript.Uint8Array = alphaTab.core.ecmaScript.Uint8Array(4.0)
            var n: Double = 0.0
            do
            {
                array[(n++).toInt()] = ((paramvalue).toInt() and 127).toDouble()
                paramvalue = ((paramvalue.toInt()) shr (7)).toDouble()
            }
            while (paramvalue > 0)
            while (n > 0)
            {
                n--
                if (n > 0)
                {
                    s.writeByte(((array[(n).toInt()]).toInt() or 128).toDouble())
                }
                else 
                {
                    s.writeByte(array[(n).toInt()])
                }
            }
        }
        
    }
    public constructor()
}

/**
 * Lists the different midi file formats which are supported for export.
 */
public enum class MidiFileFormat(override val value: Int): alphaTab.core.IAlphaTabEnum
{
    /**
     * A single track multi channel file (SMF Type 0)
     */
    SingleTrackMultiChannel(0),
    /**
     * A multi track file (SMF Type 1)
     */
    MultiTrack(1);
    companion object{
        public fun fromValue(v:Double): MidiFileFormat{
            return when(v.toInt()){
                SingleTrackMultiChannel.value -> SingleTrackMultiChannel
                MultiTrack.value -> MultiTrack
                else -> throw ClassCastException("No enum with value $v found")}
        }
    }
}

@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
public class MidiTrack
{
    /**
     * Gets a list of midi events sorted by time.
     */
    public var events: alphaTab.collections.List<alphaTab.midi.MidiEvent> = alphaTab.collections.List<alphaTab.midi.MidiEvent>(
    )
    
    
    /**
     * Adds the given midi event a the correct time position into the file.
     */
    public fun addEvent(e: alphaTab.midi.MidiEvent): Unit{
        if (this.events.length == 0.0 || e.tick >= this.events[(this.events.length - 1.0).toInt()].tick)
        {
            this.events.push(e)
        }
        else 
        {
            var insertPos: Double = this.events.length
            while (insertPos > 0)
            {
                var prevItem: alphaTab.midi.MidiEvent = this.events[(insertPos - 1.0).toInt()]
                if (prevItem.tick > e.tick)
                {
                    insertPos--
                }
                else 
                {
                    break
                }
            }
            this.events.splice(insertPos, 0.0, e)
        }
    }
    
    /**
     * Writes the midi track as binary into the given stream.
     */
    public fun writeTo(s: alphaTab.io.IWriteable): Unit{
        var trackData: alphaTab.io.ByteBuffer = alphaTab.io.ByteBuffer.empty()
        var previousTick: Double = 0.0
        for (midiEvent in this.events)
        {
            var delta: Double = midiEvent.tick - previousTick
            alphaTab.midi.MidiFile.writeVariableInt(trackData, delta)
            midiEvent.writeTo(trackData)
            previousTick = midiEvent.tick
        }
        var b: alphaTab.core.ecmaScript.Uint8Array = alphaTab.core.ecmaScript.Uint8Array(alphaTab.collections.List(77.0, 84.0, 114.0, 107.0))
        s.write(b, 0.0, b.length)
        var data: alphaTab.core.ecmaScript.Uint8Array = trackData.toArray()
        alphaTab.io.IOHelper.writeInt32BE(s, `data`.length)
        s.write(`data`, 0.0, `data`.length)
    }
    
    public constructor()
}

