// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.midi
import alphaTab.core.*

/**
 * This generator creates a midi file using a score.
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
public class MidiFileGenerator
{
    private var _score: alphaTab.model.Score
    
    private var _settings: alphaTab.Settings
    
    private var _handler: alphaTab.midi.IMidiFileHandler
    
    private var _currentTempo: Double = 0.0
    
    private var _programsPerChannel: alphaTab.collections.DoubleDoubleMap = alphaTab.collections.DoubleDoubleMap()
    
    /**
     * Gets a lookup object which can be used to quickly find beats and bars
     * at a given midi tick position.
     */
    public var tickLookup: alphaTab.midi.MidiTickLookup = alphaTab.midi.MidiTickLookup()
    
    /**
     * Gets or sets whether transposition pitches should be applied to the individual midi events or not.
     */
    public var applyTranspositionPitches: Boolean = true
    
    /**
     * Gets the transposition pitches for the individual midi channels.
     */
    public var transpositionPitches: alphaTab.collections.DoubleDoubleMap = alphaTab.collections.DoubleDoubleMap()
    
    public constructor(score: alphaTab.model.Score, settings: alphaTab.Settings?, handler: alphaTab.midi.IMidiFileHandler){
        this._score = score
        this._settings = if(!alphaTab.core.TypeHelper.isTruthy(settings))  alphaTab.Settings() else settings
        this._currentTempo = this._score.tempo
        this._handler = handler
    }
    
    /**
     * Starts the generation of the midi file.
     */
    public fun generate(): Unit{
        this.transpositionPitches.clear()
        for (track in this._score.tracks)
        {
            this.generateTrack(track)
        }
        alphaTab.Logger.debug("Midi", "Begin midi generation")
        var controller: alphaTab.midi.MidiPlaybackController = alphaTab.midi.MidiPlaybackController(this._score)
        var previousMasterBar: alphaTab.model.MasterBar? = null
        while (!controller.finished)
        {
            var index: Double = controller.index
            var bar: alphaTab.model.MasterBar = this._score.masterBars[(index).toInt()]
            var currentTick: Double = controller.currentTick
            controller.processCurrent()
            if (controller.shouldPlay)
            {
                this.generateMasterBar(bar, previousMasterBar, currentTick)
                for (track in this._score.tracks)
                {
                    for (staff in track.staves)
                    {
                        if (index < staff.bars.length)
                        {
                            this.generateBar(staff.bars[(index).toInt()], currentTick)
                        }
                    }
                }
            }
            controller.moveNext()
            previousMasterBar = bar
        }
        for (track in this._score.tracks)
        {
            this._handler.finishTrack(track.index, controller.currentTick)
        }
        alphaTab.Logger.debug("Midi", "Midi generation done")
    }
    
    /**
     */
    private fun generateTrack(track: alphaTab.model.Track): Unit{
        this.generateChannel(track, track.playbackInfo.primaryChannel, track.playbackInfo)
        if (track.playbackInfo.primaryChannel != track.playbackInfo.secondaryChannel)
        {
            this.generateChannel(track, track.playbackInfo.secondaryChannel, track.playbackInfo)
        }
    }
    
    /**
     */
    private fun addProgramChange(track: alphaTab.model.Track, tick: Double, channel: Double, program: Double): Unit{
        if (!this._programsPerChannel.has(channel) || this._programsPerChannel.get(channel) != program)
        {
            this._handler.addProgramChange(track.index, tick, channel, program)
            this._programsPerChannel.set(channel, program)
        }
    }
    
    /**
     */
    private fun generateChannel(track: alphaTab.model.Track, channel: Double, playbackInfo: alphaTab.model.PlaybackInformation): Unit{
        var transpositionPitch: Double = if(track.index < this._settings.notation.transpositionPitches.length)  this._settings.notation.transpositionPitches[(track.index).toInt()] else 0.0
        this.transpositionPitches.set(channel, transpositionPitch)
        var volume: Double = alphaTab.midi.MidiFileGenerator.toChannelShort(playbackInfo.volume)
        var balance: Double = alphaTab.midi.MidiFileGenerator.toChannelShort(playbackInfo.balance)
        this._handler.addControlChange(track.index, 0.0, channel, alphaTab.midi.ControllerType.VolumeCoarse, volume)
        this._handler.addControlChange(track.index, 0.0, channel, alphaTab.midi.ControllerType.PanCoarse, balance)
        this._handler.addControlChange(track.index, 0.0, channel, alphaTab.midi.ControllerType.ExpressionControllerCoarse, 127.0)
        this._handler.addControlChange(track.index, 0.0, channel, alphaTab.midi.ControllerType.RegisteredParameterFine, 0.0)
        this._handler.addControlChange(track.index, 0.0, channel, alphaTab.midi.ControllerType.RegisteredParameterCourse, 0.0)
        this._handler.addControlChange(track.index, 0.0, channel, alphaTab.midi.ControllerType.DataEntryFine, 0.0)
        this._handler.addControlChange(track.index, 0.0, channel, alphaTab.midi.ControllerType.DataEntryCoarse, alphaTab.midi.MidiFileGenerator.PitchBendRangeInSemitones)
        this.addProgramChange(track, 0.0, channel, playbackInfo.program)
    }
    
    /**
     */
    private fun generateMasterBar(masterBar: alphaTab.model.MasterBar, previousMasterBar: alphaTab.model.MasterBar?, currentTick: Double): Unit{
        if (!alphaTab.core.TypeHelper.isTruthy(previousMasterBar) || previousMasterBar.timeSignatureDenominator != masterBar.timeSignatureDenominator || previousMasterBar.timeSignatureNumerator != masterBar.timeSignatureNumerator)
        {
            this._handler.addTimeSignature(currentTick, masterBar.timeSignatureNumerator, masterBar.timeSignatureDenominator)
        }
        if (alphaTab.core.TypeHelper.isTruthy(masterBar.tempoAutomation))
        {
            this._handler.addTempo(currentTick, masterBar.tempoAutomation!!.value)
            this._currentTempo = masterBar.tempoAutomation!!.value
        }
        else if (!alphaTab.core.TypeHelper.isTruthy(previousMasterBar))
        {
            this._handler.addTempo(currentTick, masterBar.score.tempo)
            this._currentTempo = masterBar.score.tempo
        }
        var masterBarLookup: alphaTab.midi.MasterBarTickLookup = alphaTab.midi.MasterBarTickLookup()
        masterBarLookup.masterBar = masterBar
        masterBarLookup.start = currentTick
        masterBarLookup.tempo = this._currentTempo
        masterBarLookup.end = masterBarLookup.start + masterBar.calculateDuration()
        this.tickLookup.addMasterBar(masterBarLookup)
    }
    
    /**
     */
    private fun generateBar(bar: alphaTab.model.Bar, barStartTick: Double): Unit{
        var playbackBar: alphaTab.model.Bar = this.getPlaybackBar(bar)
        for (v in playbackBar.voices)
        {
            this.generateVoice(v, barStartTick, bar)
        }
    }
    
    /**
     */
    private fun getPlaybackBar(bar: alphaTab.model.Bar): alphaTab.model.Bar{
        var parambar = bar
        when (parambar.simileMark)
        {
            alphaTab.model.SimileMark.Simple -> 
            {
                if (alphaTab.core.TypeHelper.isTruthy(parambar.previousBar))
                {
                    parambar = this.getPlaybackBar(parambar.previousBar!!)
                }
            }
            alphaTab.model.SimileMark.FirstOfDouble -> 
            {
                if (alphaTab.core.TypeHelper.isTruthy(parambar.previousBar) && alphaTab.core.TypeHelper.isTruthy(parambar.previousBar!!.previousBar))
                {
                    parambar = this.getPlaybackBar(parambar.previousBar!!.previousBar!!)
                }
            }
            alphaTab.model.SimileMark.SecondOfDouble -> 
            {
                if (alphaTab.core.TypeHelper.isTruthy(parambar.previousBar) && alphaTab.core.TypeHelper.isTruthy(parambar.previousBar!!.previousBar))
                {
                    parambar = this.getPlaybackBar(parambar.previousBar!!.previousBar!!)
                }
            }
            else -> { }
        }
        return parambar
    }
    
    /**
     */
    private fun generateVoice(voice: alphaTab.model.Voice, barStartTick: Double, realBar: alphaTab.model.Bar): Unit{
        if (voice.isEmpty && (!voice.bar.isEmpty || voice.index != 0.0))
        {
            return
        }
        for (b in voice.beats)
        {
            this.generateBeat(b, barStartTick, realBar)
        }
    }
    
    private var _currentTripletFeel: alphaTab.midi.TripletFeelDurations? = null
    
    /**
     */
    private fun generateBeat(beat: alphaTab.model.Beat, barStartTick: Double, realBar: alphaTab.model.Bar): Unit{
        var beatStart: Double = beat.playbackStart
        var audioDuration: Double = beat.playbackDuration
        if (beat.voice.bar.isEmpty)
        {
            audioDuration = beat.voice.bar.masterBar.calculateDuration()
        }
        else if (beat.voice.bar.masterBar.tripletFeel != alphaTab.model.TripletFeel.NoTripletFeel && this._settings.player.playTripletFeel)
        {
            if (alphaTab.core.TypeHelper.isTruthy(this._currentTripletFeel))
            {
                beatStart -= this._currentTripletFeel!!.secondBeatStartOffset
                audioDuration = this._currentTripletFeel!!.secondBeatDuration
                this._currentTripletFeel = null
            }
            else 
            {
                this._currentTripletFeel = alphaTab.midi.MidiFileGenerator.calculateTripletFeelInfo(beatStart, audioDuration, beat)
                if (alphaTab.core.TypeHelper.isTruthy(this._currentTripletFeel))
                {
                    audioDuration = this._currentTripletFeel!!.firstBeatDuration
                }
            }
        }
        if (realBar == beat.voice.bar)
        {
            this.tickLookup.addBeat(beat, beatStart, audioDuration)
        }
        else 
        {
            this.tickLookup.addBeat(beat, 0.0, audioDuration)
        }
        var track: alphaTab.model.Track = beat.voice.bar.staff.track
        for (automation in beat.automations)
        {
            this.generateAutomation(beat, automation, barStartTick)
        }
        if (beat.isRest)
        {
            this._handler.addRest(track.index, barStartTick + beatStart, track.playbackInfo.primaryChannel)
        }
        else 
        {
            var brushInfo: alphaTab.core.ecmaScript.Int32Array = this.getBrushInfo(beat)
            for (n in beat.notes)
            {
                this.generateNote(n, barStartTick + beatStart, audioDuration, brushInfo)
            }
        }
        if (beat.vibrato != alphaTab.model.VibratoType.None)
        {
            var phaseLength: Double = 240.0
            var bendAmplitude: Double = 3.0
            when (beat.vibrato)
            {
                alphaTab.model.VibratoType.Slight -> 
                {
                    phaseLength = this._settings.player.vibrato.beatSlightLength
                    bendAmplitude = this._settings.player.vibrato.beatSlightAmplitude
                }
                alphaTab.model.VibratoType.Wide -> 
                {
                    phaseLength = this._settings.player.vibrato.beatWideLength
                    bendAmplitude = this._settings.player.vibrato.beatWideAmplitude
                }
                else -> { }
            }
            this.generateVibratorWithParams(barStartTick + beatStart, beat.playbackDuration, phaseLength, bendAmplitude, fun(tick: Double, value: Double): Unit{
                this._handler.addBend(beat.voice.bar.staff.track.index, tick, track.playbackInfo.secondaryChannel, value)
            }
            )
        }
    }
    
    /**
     */
    private fun generateNote(note: alphaTab.model.Note, beatStart: Double, beatDuration: Double, brushInfo: alphaTab.core.ecmaScript.Int32Array): Unit{
        var track: alphaTab.model.Track = note.beat.voice.bar.staff.track
        var staff: alphaTab.model.Staff = note.beat.voice.bar.staff
        var noteKey: Double = note.calculateRealValue(this.applyTranspositionPitches, true)
        if (note.isPercussion)
        {
            var articulation: alphaTab.model.InstrumentArticulation? = alphaTab.model.PercussionMapper.getArticulation(note)
            if (alphaTab.core.TypeHelper.isTruthy(articulation))
            {
                noteKey = articulation.outputMidiNumber
            }
        }
        var brushOffset: Double = if(note.isStringed && note.string <= brushInfo.length)  brushInfo[(note.string - 1.0).toInt()] else 0.0
        var noteStart: Double = beatStart + brushOffset
        var noteDuration: alphaTab.midi.MidiNoteDuration = this.getNoteDuration(note, beatDuration)
        noteDuration.untilTieOrSlideEnd -= brushOffset
        noteDuration.noteOnly -= brushOffset
        noteDuration.letRingEnd -= brushOffset
        var velocity: Double = alphaTab.midi.MidiFileGenerator.getNoteVelocity(note)
        var channel: Double = if(note.hasBend || note.beat.hasWhammyBar || note.beat.vibrato != alphaTab.model.VibratoType.None)  track.playbackInfo.secondaryChannel else track.playbackInfo.primaryChannel
        var initialBend: Double = 0.0
        if (note.hasBend)
        {
            initialBend = alphaTab.midi.MidiFileGenerator.getPitchWheel(note.bendPoints!![(0).toInt()].value)
        }
        else if (note.beat.hasWhammyBar)
        {
            initialBend = alphaTab.midi.MidiFileGenerator.getPitchWheel(note.beat.whammyBarPoints!![(0).toInt()].value)
        }
        else if (note.isTieDestination || (alphaTab.core.TypeHelper.isTruthy(note.slideOrigin) && note.slideOrigin!!.slideOutType == alphaTab.model.SlideOutType.Legato))
        {
            initialBend = -1.0
        }
        else 
        {
            initialBend = alphaTab.midi.MidiFileGenerator.getPitchWheel(0.0)
        }
        if (initialBend >= 0)
        {
            this._handler.addNoteBend(track.index, noteStart, channel, noteKey, initialBend)
        }
        if (note.beat.fadeIn)
        {
            this.generateFadeIn(note, noteStart, noteDuration)
        }
        if (note.isTrill && !staff.isPercussion)
        {
            this.generateTrill(
                note
                , 
                noteStart
                , 
                noteDuration
                , 
                noteKey
                , 
                velocity
                , 
                channel
            
            )
            return
        }
        if (note.beat.isTremolo)
        {
            this.generateTremoloPicking(
                note
                , 
                noteStart
                , 
                noteDuration
                , 
                noteKey
                , 
                velocity
                , 
                channel
            
            )
            return
        }
        if (note.hasBend)
        {
            this.generateBend(note, noteStart, noteDuration, noteKey, channel)
        }
        else if (note.beat.hasWhammyBar && note.index == 0.0)
        {
            this.generateWhammy(note.beat, noteStart, noteDuration, channel)
        }
        else if (note.slideInType != alphaTab.model.SlideInType.None || note.slideOutType != alphaTab.model.SlideOutType.None)
        {
            this.generateSlide(note, noteStart, noteDuration, noteKey, channel)
        }
        else if (note.vibrato != alphaTab.model.VibratoType.None || (note.isTieDestination && note.tieOrigin!!.vibrato != alphaTab.model.VibratoType.None))
        {
            this.generateVibrato(note, noteStart, noteDuration, noteKey, channel)
        }
        if (!note.isTieDestination && (!alphaTab.core.TypeHelper.isTruthy(note.slideOrigin) || note.slideOrigin!!.slideOutType != alphaTab.model.SlideOutType.Legato))
        {
            var noteSoundDuration: Double = alphaTab.core.ecmaScript.Math.max(noteDuration.untilTieOrSlideEnd, noteDuration.letRingEnd)
            this._handler.addNote(
                track.index
                , 
                noteStart
                , 
                noteSoundDuration
                , 
                noteKey
                , 
                velocity
                , 
                channel
            
            )
        }
    }
    
    /**
     */
    private fun getNoteDuration(note: alphaTab.model.Note, duration: Double): alphaTab.midi.MidiNoteDuration{
        var durationWithEffects: alphaTab.midi.MidiNoteDuration = alphaTab.midi.MidiNoteDuration()
        durationWithEffects.noteOnly = duration
        durationWithEffects.untilTieOrSlideEnd = duration
        durationWithEffects.letRingEnd = duration
        if (note.isDead)
        {
            durationWithEffects.noteOnly = this.applyStaticDuration(alphaTab.midi.MidiFileGenerator.DefaultDurationDead, duration)
            durationWithEffects.untilTieOrSlideEnd = durationWithEffects.noteOnly
            durationWithEffects.letRingEnd = durationWithEffects.noteOnly
            return durationWithEffects
        }
        if (note.isPalmMute)
        {
            durationWithEffects.noteOnly = this.applyStaticDuration(alphaTab.midi.MidiFileGenerator.DefaultDurationPalmMute, duration)
            durationWithEffects.untilTieOrSlideEnd = durationWithEffects.noteOnly
            durationWithEffects.letRingEnd = durationWithEffects.noteOnly
            return durationWithEffects
        }
        if (note.isStaccato)
        {
            durationWithEffects.noteOnly = (((duration / (2.0).toDouble())).toInt() or 0).toDouble()
            durationWithEffects.untilTieOrSlideEnd = durationWithEffects.noteOnly
            durationWithEffects.letRingEnd = durationWithEffects.noteOnly
            return durationWithEffects
        }
        if (note.isTieOrigin)
        {
            var endNote: alphaTab.model.Note = note.tieDestination!!
            if (alphaTab.core.TypeHelper.isTruthy(endNote))
            {
                if (!note.isTieDestination)
                {
                    var startTick: Double = note.beat.absolutePlaybackStart
                    var tieDestinationDuration: alphaTab.midi.MidiNoteDuration = this.getNoteDuration(endNote, endNote.beat.playbackDuration)
                    var endTick: Double = endNote.beat.absolutePlaybackStart + tieDestinationDuration.untilTieOrSlideEnd
                    durationWithEffects.untilTieOrSlideEnd = endTick - startTick
                }
                else 
                {
                    var tieDestinationDuration: alphaTab.midi.MidiNoteDuration = this.getNoteDuration(endNote, endNote.beat.playbackDuration)
                    durationWithEffects.untilTieOrSlideEnd = duration + tieDestinationDuration.untilTieOrSlideEnd
                }
            }
        }
        else if (note.slideOutType == alphaTab.model.SlideOutType.Legato)
        {
            var endNote: alphaTab.model.Note = note.slideTarget!!
            if (alphaTab.core.TypeHelper.isTruthy(endNote))
            {
                var startTick: Double = note.beat.absolutePlaybackStart
                var slideTargetDuration: alphaTab.midi.MidiNoteDuration = this.getNoteDuration(endNote, endNote.beat.playbackDuration)
                var endTick: Double = endNote.beat.absolutePlaybackStart + slideTargetDuration.untilTieOrSlideEnd
                durationWithEffects.untilTieOrSlideEnd = endTick - startTick
            }
        }
        if (note.isLetRing && this._settings.notation.notationMode == alphaTab.NotationMode.GuitarPro)
        {
            var lastLetRingBeat: alphaTab.model.Beat = note.beat
            var letRingEnd: Double = 0.0
            var maxDuration: Double = note.beat.voice.bar.masterBar.calculateDuration()
            while (alphaTab.core.TypeHelper.isTruthy(lastLetRingBeat.nextBeat))
            {
                var next: alphaTab.model.Beat = lastLetRingBeat.nextBeat!!
                if (next.isRest)
                {
                    break
                }
                if (note.isStringed && next.hasNoteOnString(note.string))
                {
                    break
                }
                lastLetRingBeat = lastLetRingBeat.nextBeat!!
                letRingEnd = lastLetRingBeat.absolutePlaybackStart - note.beat.absolutePlaybackStart + lastLetRingBeat.playbackDuration
                if (letRingEnd > maxDuration)
                {
                    letRingEnd = maxDuration
                    break
                }
            }
            if (lastLetRingBeat == note.beat)
            {
                durationWithEffects.letRingEnd = duration
            }
            else 
            {
                durationWithEffects.letRingEnd = letRingEnd
            }
        }
        else 
        {
            durationWithEffects.letRingEnd = durationWithEffects.untilTieOrSlideEnd
        }
        return durationWithEffects
    }
    
    /**
     */
    private fun applyStaticDuration(duration: Double, maximum: Double): Double{
        var value: Double = ((((this._currentTempo * duration) / alphaTab.model.BendPoint.MaxPosition)).toInt() or 0).toDouble()
        return alphaTab.core.ecmaScript.Math.min(value, maximum)
    }
    
    /**
     */
    private fun generateFadeIn(note: alphaTab.model.Note, noteStart: Double, noteDuration: alphaTab.midi.MidiNoteDuration): Unit{
        var track: alphaTab.model.Track = note.beat.voice.bar.staff.track
        var endVolume: Double = alphaTab.midi.MidiFileGenerator.toChannelShort(track.playbackInfo.volume)
        var volumeFactor: Double = endVolume / noteDuration.noteOnly
        var tickStep: Double = 120.0
        var steps: Double = (((noteDuration.noteOnly / tickStep)).toInt() or 0).toDouble()
        var endTick: Double = noteStart + noteDuration.noteOnly
        if(true) {
            var i: Double = steps - 1.0
            
            while(i >= 0){
                try{
                    var tick: Double = endTick - i * tickStep
                    var volume: Double = (tick - noteStart) * volumeFactor
                    if (i == steps - 1.0)
                    {
                        this._handler.addControlChange(track.index, noteStart, track.playbackInfo.primaryChannel, alphaTab.midi.ControllerType.VolumeCoarse, volume)
                        this._handler.addControlChange(track.index, noteStart, track.playbackInfo.secondaryChannel, alphaTab.midi.ControllerType.VolumeCoarse, volume)
                    }
                    this._handler.addControlChange(track.index, tick, track.playbackInfo.primaryChannel, alphaTab.midi.ControllerType.VolumeCoarse, volume)
                    this._handler.addControlChange(track.index, tick, track.playbackInfo.secondaryChannel, alphaTab.midi.ControllerType.VolumeCoarse, volume)
                }
                finally{
                    i--
                }
            }
        }
    }
    
    /**
     */
    private fun generateVibrato(note: alphaTab.model.Note, noteStart: Double, noteDuration: alphaTab.midi.MidiNoteDuration, noteKey: Double, channel: Double): Unit{
        var phaseLength: Double = 0.0
        var bendAmplitude: Double = 0.0
        var vibratoType: alphaTab.model.VibratoType = if(note.vibrato != alphaTab.model.VibratoType.None)  note.vibrato else (if(note.isTieDestination)  note.tieOrigin!!.vibrato else alphaTab.model.VibratoType.Slight)
        when (vibratoType)
        {
            alphaTab.model.VibratoType.Slight -> 
            {
                phaseLength = this._settings.player.vibrato.noteSlightLength
                bendAmplitude = this._settings.player.vibrato.noteSlightAmplitude
            }
            alphaTab.model.VibratoType.Wide -> 
            {
                phaseLength = this._settings.player.vibrato.noteWideLength
                bendAmplitude = this._settings.player.vibrato.noteWideAmplitude
            }
            else -> 
            {
                return
            }
        }
        var track: alphaTab.model.Track = note.beat.voice.bar.staff.track
        this.generateVibratorWithParams(noteStart, noteDuration.noteOnly, phaseLength, bendAmplitude, fun(tick: Double, value: Double): Unit{
            this._handler.addNoteBend(track.index, tick, channel, noteKey, value)
        }
        )
    }
    
    public var vibratoResolution: Double = 16.0
    
    /**
     */
    private fun generateVibratorWithParams(noteStart: Double, noteDuration: Double, phaseLength: Double, bendAmplitude: Double, addBend: (arg1: Double, arg2: Double) -> Unit): Unit{
        var paramnoteStart = noteStart
        var resolution: Double = this.vibratoResolution
        var phaseHalf: Double = (((phaseLength / (2.0).toDouble())).toInt() or 0).toDouble()
        paramnoteStart += phaseLength
        var noteEnd: Double = paramnoteStart + noteDuration
        while (paramnoteStart < noteEnd)
        {
            var phase: Double = 0.0
            var phaseDuration: Double = if(paramnoteStart + phaseLength < noteEnd)  phaseLength else noteEnd - paramnoteStart
            while (phase < phaseDuration)
            {
                var bend: Double = bendAmplitude * alphaTab.core.ecmaScript.Math.sin((phase * alphaTab.core.ecmaScript.Math.PI) / phaseHalf)
                addBend((((paramnoteStart + phase)).toInt() or 0).toDouble(), alphaTab.midi.MidiFileGenerator.getPitchWheel(bend))
                phase += resolution
            }
            paramnoteStart += phaseLength
        }
    }
    
    /**
     */
    private fun generateSlide(note: alphaTab.model.Note, noteStart: Double, noteDuration: alphaTab.midi.MidiNoteDuration, noteKey: Double, channel: Double): Unit{
        var duration: Double = if(note.slideOutType == alphaTab.model.SlideOutType.Legato)  noteDuration.noteOnly else noteDuration.untilTieOrSlideEnd
        var playedBendPoints: alphaTab.collections.List<alphaTab.model.BendPoint> = alphaTab.collections.List<alphaTab.model.BendPoint>(
        )
        
        var track: alphaTab.model.Track = note.beat.voice.bar.staff.track
        var simpleSlidePitchOffset: Double = this._settings.player.slide.simpleSlidePitchOffset
        var simpleSlideDurationOffset: Double = alphaTab.core.ecmaScript.Math.floor(alphaTab.model.BendPoint.MaxPosition * this._settings.player.slide.simpleSlideDurationRatio)
        var shiftSlideDurationOffset: Double = alphaTab.core.ecmaScript.Math.floor(alphaTab.model.BendPoint.MaxPosition * this._settings.player.slide.shiftSlideDurationRatio)
        when (note.slideInType)
        {
            alphaTab.model.SlideInType.IntoFromAbove -> 
            {
                playedBendPoints.push(alphaTab.model.BendPoint(0.0, simpleSlidePitchOffset))
                playedBendPoints.push(alphaTab.model.BendPoint(simpleSlideDurationOffset, 0.0))
            }
            alphaTab.model.SlideInType.IntoFromBelow -> 
            {
                playedBendPoints.push(alphaTab.model.BendPoint(0.0, -simpleSlidePitchOffset))
                playedBendPoints.push(alphaTab.model.BendPoint(simpleSlideDurationOffset, 0.0))
            }
            else -> { }
        }
        when (note.slideOutType)
        {
            alphaTab.model.SlideOutType.Legato, alphaTab.model.SlideOutType.Shift -> 
            {
                playedBendPoints.push(alphaTab.model.BendPoint(shiftSlideDurationOffset, 0.0))
                var dy: Double = (note.slideTarget!!.calculateRealValue(this.applyTranspositionPitches, true) - note.calculateRealValue(this.applyTranspositionPitches, true)) * 2.0
                playedBendPoints.push(alphaTab.model.BendPoint(alphaTab.model.BendPoint.MaxPosition, dy))
            }
            alphaTab.model.SlideOutType.OutDown -> 
            {
                playedBendPoints.push(alphaTab.model.BendPoint(alphaTab.model.BendPoint.MaxPosition - simpleSlideDurationOffset, 0.0))
                playedBendPoints.push(alphaTab.model.BendPoint(alphaTab.model.BendPoint.MaxPosition, -simpleSlidePitchOffset))
            }
            alphaTab.model.SlideOutType.OutUp -> 
            {
                playedBendPoints.push(alphaTab.model.BendPoint(alphaTab.model.BendPoint.MaxPosition - simpleSlideDurationOffset, 0.0))
                playedBendPoints.push(alphaTab.model.BendPoint(alphaTab.model.BendPoint.MaxPosition, simpleSlidePitchOffset))
            }
            else -> { }
        }
        this.generateWhammyOrBend(noteStart, duration, playedBendPoints, fun(tick: Double, value: Double): Unit{
            this._handler.addNoteBend(track.index, tick, channel, noteKey, value)
        }
        )
    }
    
    /**
     */
    private fun generateBend(note: alphaTab.model.Note, noteStart: Double, noteDuration: alphaTab.midi.MidiNoteDuration, noteKey: Double, channel: Double): Unit{
        var paramnoteStart = noteStart
        var bendPoints: alphaTab.collections.List<alphaTab.model.BendPoint> = note.bendPoints!!
        var track: alphaTab.model.Track = note.beat.voice.bar.staff.track
        var addBend: (arg1: Double, arg2: Double) -> Unit = fun(tick: Double, value: Double): Unit{
            this._handler.addNoteBend(track.index, tick, channel, noteKey, value)
        }
        
        var finalBendValue: Double? = null
        var duration: Double
        if (note.isTieOrigin && this._settings.notation.extendBendArrowsOnTiedNotes)
        {
            var endNote: alphaTab.model.Note = note
            while (endNote.isTieOrigin && !endNote.tieDestination!!.hasBend)
            {
                endNote = endNote.tieDestination!!
            }
            duration = endNote.beat.absolutePlaybackStart - note.beat.absolutePlaybackStart + this.getNoteDuration(endNote, endNote.beat.playbackDuration).noteOnly
        }
        else if (note.isTieOrigin && note.beat.graceType != alphaTab.model.GraceType.None)
        {
            when (note.tieDestination!!.bendType)
            {
                alphaTab.model.BendType.Bend, alphaTab.model.BendType.BendRelease, alphaTab.model.BendType.PrebendBend -> 
                {
                    finalBendValue = note.tieDestination!!.bendPoints!![(1).toInt()].value
                }
                alphaTab.model.BendType.Prebend, alphaTab.model.BendType.PrebendRelease -> 
                {
                    finalBendValue = note.tieDestination!!.bendPoints!![(0).toInt()].value
                }
                else -> { }
            }
            duration = alphaTab.core.ecmaScript.Math.max(noteDuration.noteOnly, alphaTab.midi.MidiUtils.millisToTicks(this._settings.player.songBookBendDuration, this._currentTempo))
        }
        else 
        {
            duration = noteDuration.noteOnly
        }
        if (bendPoints[(0).toInt()].value > 0 && !note.isContinuedBend && paramnoteStart > 0)
        {
            paramnoteStart--
        }
        var bendDuration: Double = alphaTab.core.ecmaScript.Math.min(duration, alphaTab.midi.MidiUtils.millisToTicks(this._settings.player.songBookBendDuration, this._currentTempo))
        var playedBendPoints: alphaTab.collections.List<alphaTab.model.BendPoint> = alphaTab.collections.List<alphaTab.model.BendPoint>(
        )
        
        when (note.bendType)
        {
            alphaTab.model.BendType.Custom -> 
            {
                playedBendPoints = bendPoints
            }
            alphaTab.model.BendType.Bend, alphaTab.model.BendType.Release -> 
            {
                when (note.bendStyle)
                {
                    alphaTab.model.BendStyle.Default -> 
                    {
                        playedBendPoints = bendPoints
                    }
                    alphaTab.model.BendStyle.Gradual -> 
                    {
                        playedBendPoints.push(alphaTab.model.BendPoint(0.0, note.bendPoints!![(0).toInt()].value))
                        if (!alphaTab.core.TypeHelper.isTruthy(finalBendValue) || finalBendValue < note.bendPoints!![(1).toInt()].value)
                        {
                            finalBendValue = note.bendPoints!![(1).toInt()].value
                        }
                        playedBendPoints.push(alphaTab.model.BendPoint(alphaTab.model.BendPoint.MaxPosition, finalBendValue))
                    }
                    alphaTab.model.BendStyle.Fast -> 
                    {
                        if (!alphaTab.core.TypeHelper.isTruthy(finalBendValue) || finalBendValue < note.bendPoints!![(1).toInt()].value)
                        {
                            finalBendValue = note.bendPoints!![(1).toInt()].value
                        }
                        if (note.beat.graceType == alphaTab.model.GraceType.BendGrace)
                        {
                            this.generateSongBookWhammyOrBend(
                                paramnoteStart
                                , 
                                duration
                                , 
                                true
                                , 
                                alphaTab.collections.DoubleList(
                                    note.bendPoints!![(0).toInt()].value, finalBendValue)
                                
                                , 
                                bendDuration
                                , 
                                addBend
                            
                            )
                        }
                        else 
                        {
                            this.generateSongBookWhammyOrBend(
                                paramnoteStart
                                , 
                                duration
                                , 
                                false
                                , 
                                alphaTab.collections.DoubleList(
                                    note.bendPoints!![(0).toInt()].value, finalBendValue)
                                
                                , 
                                bendDuration
                                , 
                                addBend
                            
                            )
                        }
                        return
                    }
                    else -> { }
                }
            }
            alphaTab.model.BendType.BendRelease -> 
            {
                when (note.bendStyle)
                {
                    alphaTab.model.BendStyle.Default -> 
                    {
                        playedBendPoints = bendPoints
                    }
                    alphaTab.model.BendStyle.Gradual -> 
                    {
                        playedBendPoints.push(alphaTab.model.BendPoint(0.0, note.bendPoints!![(0).toInt()].value))
                        playedBendPoints.push(alphaTab.model.BendPoint((((alphaTab.model.BendPoint.MaxPosition / (2.0).toDouble())).toInt() or 0).toDouble(), note.bendPoints!![(1).toInt()].value))
                        playedBendPoints.push(alphaTab.model.BendPoint(alphaTab.model.BendPoint.MaxPosition, note.bendPoints!![(2).toInt()].value))
                    }
                    alphaTab.model.BendStyle.Fast -> 
                    {
                        this.generateSongBookWhammyOrBend(
                            paramnoteStart
                            , 
                            duration
                            , 
                            false
                            , 
                            alphaTab.collections.DoubleList(
                                note.bendPoints!![(0).toInt()].value, note.bendPoints!![(1).toInt()].value, note.bendPoints!![(2).toInt()].value)
                            
                            , 
                            bendDuration
                            , 
                            addBend
                        
                        )
                        return
                    }
                    else -> { }
                }
            }
            alphaTab.model.BendType.Hold -> 
            {
                playedBendPoints = bendPoints
            }
            alphaTab.model.BendType.Prebend -> 
            {
                playedBendPoints = bendPoints
            }
            alphaTab.model.BendType.PrebendBend -> 
            {
                when (note.bendStyle)
                {
                    alphaTab.model.BendStyle.Default -> 
                    {
                        playedBendPoints = bendPoints
                    }
                    alphaTab.model.BendStyle.Gradual -> 
                    {
                        playedBendPoints.push(alphaTab.model.BendPoint(0.0, note.bendPoints!![(0).toInt()].value))
                        playedBendPoints.push(alphaTab.model.BendPoint(alphaTab.model.BendPoint.MaxPosition, note.bendPoints!![(1).toInt()].value))
                    }
                    alphaTab.model.BendStyle.Fast -> 
                    {
                        var preBendValue: Double = alphaTab.midi.MidiFileGenerator.getPitchWheel(note.bendPoints!![(0).toInt()].value)
                        addBend(paramnoteStart, ((preBendValue).toInt() or 0).toDouble())
                        if (!alphaTab.core.TypeHelper.isTruthy(finalBendValue) || finalBendValue < note.bendPoints!![(1).toInt()].value)
                        {
                            finalBendValue = note.bendPoints!![(1).toInt()].value
                        }
                        this.generateSongBookWhammyOrBend(
                            paramnoteStart
                            , 
                            duration
                            , 
                            false
                            , 
                            alphaTab.collections.DoubleList(
                                note.bendPoints!![(0).toInt()].value, finalBendValue)
                            
                            , 
                            bendDuration
                            , 
                            addBend
                        
                        )
                        return
                    }
                    else -> { }
                }
            }
            alphaTab.model.BendType.PrebendRelease -> 
            {
                when (note.bendStyle)
                {
                    alphaTab.model.BendStyle.Default -> 
                    {
                        playedBendPoints = bendPoints
                    }
                    alphaTab.model.BendStyle.Gradual -> 
                    {
                        playedBendPoints.push(alphaTab.model.BendPoint(0.0, note.bendPoints!![(0).toInt()].value))
                        playedBendPoints.push(alphaTab.model.BendPoint(alphaTab.model.BendPoint.MaxPosition, note.bendPoints!![(1).toInt()].value))
                    }
                    alphaTab.model.BendStyle.Fast -> 
                    {
                        var preBendValue: Double = alphaTab.midi.MidiFileGenerator.getPitchWheel(note.bendPoints!![(0).toInt()].value)
                        addBend(paramnoteStart, ((preBendValue).toInt() or 0).toDouble())
                        this.generateSongBookWhammyOrBend(
                            paramnoteStart
                            , 
                            duration
                            , 
                            false
                            , 
                            alphaTab.collections.DoubleList(
                                note.bendPoints!![(0).toInt()].value, note.bendPoints!![(1).toInt()].value)
                            
                            , 
                            bendDuration
                            , 
                            addBend
                        
                        )
                        return
                    }
                    else -> { }
                }
            }
            else -> { }
        }
        this.generateWhammyOrBend(paramnoteStart, duration, playedBendPoints, addBend)
    }
    
    /**
     */
    private fun generateSongBookWhammyOrBend(noteStart: Double, duration: Double, bendAtBeginning: Boolean, bendValues: alphaTab.collections.DoubleList, bendDuration: Double, addBend: (arg1: Double, arg2: Double) -> Unit): Unit{
        var startTick: Double = if(bendAtBeginning)  noteStart else noteStart + duration - bendDuration
        var ticksBetweenPoints: Double = bendDuration / (bendValues.length - 1.0)
        if(true) {
            var i: Double = 0.0
            
            while(i < bendValues.length - 1.0){
                try{
                    var currentBendValue: Double = alphaTab.midi.MidiFileGenerator.getPitchWheel(bendValues[(i).toInt()])
                    var nextBendValue: Double = alphaTab.midi.MidiFileGenerator.getPitchWheel(bendValues[(i + 1.0).toInt()])
                    var tick: Double = startTick + ticksBetweenPoints * i
                    this.generateBendValues(tick, ticksBetweenPoints, currentBendValue, nextBendValue, addBend)
                }
                finally{
                    i++
                }
            }
        }
    }
    
    /**
     */
    private fun generateWhammy(beat: alphaTab.model.Beat, noteStart: Double, noteDuration: alphaTab.midi.MidiNoteDuration, channel: Double): Unit{
        var paramnoteStart = noteStart
        var bendPoints: alphaTab.collections.List<alphaTab.model.BendPoint> = beat.whammyBarPoints!!
        var track: alphaTab.model.Track = beat.voice.bar.staff.track
        var duration: Double = noteDuration.noteOnly
        if (bendPoints[(0).toInt()].value > 0 && !beat.isContinuedWhammy)
        {
            paramnoteStart--
        }
        var addBend: (arg1: Double, arg2: Double) -> Unit = fun(tick: Double, value: Double): Unit{
            this._handler.addBend(track.index, tick, channel, value)
        }
        
        var playedBendPoints: alphaTab.collections.List<alphaTab.model.BendPoint> = alphaTab.collections.List<alphaTab.model.BendPoint>(
        )
        
        when (beat.whammyBarType)
        {
            alphaTab.model.WhammyType.Custom -> 
            {
                playedBendPoints = bendPoints
            }
            alphaTab.model.WhammyType.Dive -> 
            {
                when (beat.whammyStyle)
                {
                    alphaTab.model.BendStyle.Default -> 
                    {
                        playedBendPoints = bendPoints
                    }
                    alphaTab.model.BendStyle.Gradual -> 
                    {
                        playedBendPoints.push(alphaTab.model.BendPoint(0.0, bendPoints[(0).toInt()].value))
                        playedBendPoints.push(alphaTab.model.BendPoint(alphaTab.model.BendPoint.MaxPosition, bendPoints[(1).toInt()].value))
                    }
                    alphaTab.model.BendStyle.Fast -> 
                    {
                        var whammyDuration: Double = alphaTab.core.ecmaScript.Math.min(duration, alphaTab.midi.MidiUtils.millisToTicks(this._settings.player.songBookBendDuration, this._currentTempo))
                        this.generateSongBookWhammyOrBend(
                            paramnoteStart
                            , 
                            duration
                            , 
                            false
                            , 
                            alphaTab.collections.DoubleList(
                                bendPoints[(0).toInt()].value, bendPoints[(1).toInt()].value)
                            
                            , 
                            whammyDuration
                            , 
                            addBend
                        
                        )
                        return
                    }
                    else -> { }
                }
            }
            alphaTab.model.WhammyType.Dip -> 
            {
                when (beat.whammyStyle)
                {
                    alphaTab.model.BendStyle.Default -> 
                    {
                        playedBendPoints = bendPoints
                    }
                    alphaTab.model.BendStyle.Gradual -> 
                    {
                        playedBendPoints.push(alphaTab.model.BendPoint(0.0, bendPoints[(0).toInt()].value))
                        playedBendPoints.push(alphaTab.model.BendPoint((((alphaTab.model.BendPoint.MaxPosition / (2.0).toDouble())).toInt() or 0).toDouble(), bendPoints[(1).toInt()].value))
                        playedBendPoints.push(alphaTab.model.BendPoint(alphaTab.model.BendPoint.MaxPosition, bendPoints[(2).toInt()].value))
                    }
                    alphaTab.model.BendStyle.Fast -> 
                    {
                        var whammyDuration: Double = alphaTab.core.ecmaScript.Math.min(duration, alphaTab.midi.MidiUtils.millisToTicks(this._settings.player.songBookDipDuration, this._currentTempo))
                        this.generateSongBookWhammyOrBend(
                            paramnoteStart
                            , 
                            duration
                            , 
                            true
                            , 
                            alphaTab.collections.DoubleList(
                                bendPoints[(0).toInt()].value, bendPoints[(1).toInt()].value, bendPoints[(2).toInt()].value)
                            
                            , 
                            whammyDuration
                            , 
                            addBend
                        
                        )
                        return
                    }
                    else -> { }
                }
            }
            alphaTab.model.WhammyType.Hold -> 
            {
                playedBendPoints = bendPoints
            }
            alphaTab.model.WhammyType.Predive -> 
            {
                playedBendPoints = bendPoints
            }
            alphaTab.model.WhammyType.PrediveDive -> 
            {
                when (beat.whammyStyle)
                {
                    alphaTab.model.BendStyle.Default -> 
                    {
                        playedBendPoints = bendPoints
                    }
                    alphaTab.model.BendStyle.Gradual -> 
                    {
                        playedBendPoints.push(alphaTab.model.BendPoint(0.0, bendPoints[(0).toInt()].value))
                        playedBendPoints.push(alphaTab.model.BendPoint((((alphaTab.model.BendPoint.MaxPosition / (2.0).toDouble())).toInt() or 0).toDouble(), bendPoints[(0).toInt()].value))
                        playedBendPoints.push(alphaTab.model.BendPoint(alphaTab.model.BendPoint.MaxPosition, bendPoints[(1).toInt()].value))
                    }
                    alphaTab.model.BendStyle.Fast -> 
                    {
                        var preDiveValue: Double = alphaTab.midi.MidiFileGenerator.getPitchWheel(bendPoints[(0).toInt()].value)
                        this._handler.addBend(track.index, paramnoteStart, channel, ((preDiveValue).toInt() or 0).toDouble())
                        var whammyDuration: Double = alphaTab.core.ecmaScript.Math.min(duration, alphaTab.midi.MidiUtils.millisToTicks(this._settings.player.songBookBendDuration, this._currentTempo))
                        this.generateSongBookWhammyOrBend(
                            paramnoteStart
                            , 
                            duration
                            , 
                            false
                            , 
                            alphaTab.collections.DoubleList(
                                bendPoints[(0).toInt()].value, bendPoints[(1).toInt()].value)
                            
                            , 
                            whammyDuration
                            , 
                            addBend
                        
                        )
                        return
                    }
                    else -> { }
                }
            }
            else -> { }
        }
        this.generateWhammyOrBend(paramnoteStart, duration, playedBendPoints, addBend)
    }
    
    /**
     */
    private fun generateWhammyOrBend(noteStart: Double, duration: Double, playedBendPoints: alphaTab.collections.List<alphaTab.model.BendPoint>, addBend: (arg1: Double, arg2: Double) -> Unit): Unit{
        var ticksPerPosition: Double = duration / alphaTab.model.BendPoint.MaxPosition
        if(true) {
            var i: Double = 0.0
            
            while(i < playedBendPoints.length - 1.0){
                try{
                    var currentPoint: alphaTab.model.BendPoint = playedBendPoints[(i).toInt()]
                    var nextPoint: alphaTab.model.BendPoint = playedBendPoints[(i + 1.0).toInt()]
                    var currentBendValue: Double = alphaTab.midi.MidiFileGenerator.getPitchWheel(currentPoint.value)
                    var nextBendValue: Double = alphaTab.midi.MidiFileGenerator.getPitchWheel(nextPoint.value)
                    var ticksBetweenPoints: Double = ticksPerPosition * (nextPoint.offset - currentPoint.offset)
                    var tick: Double = noteStart + ticksPerPosition * currentPoint.offset
                    this.generateBendValues(tick, ticksBetweenPoints, currentBendValue, nextBendValue, addBend)
                }
                finally{
                    i++
                }
            }
        }
    }
    
    /**
     */
    private fun generateBendValues(currentTick: Double, ticksBetweenPoints: Double, currentBendValue: Double, nextBendValue: Double, addBend: (arg1: Double, arg2: Double) -> Unit): Unit{
        var paramcurrentBendValue = currentBendValue
        var paramcurrentTick = currentTick
        var millisBetweenPoints: Double = alphaTab.midi.MidiUtils.ticksToMillis(ticksBetweenPoints, this._currentTempo)
        var numberOfSemitones: Double = alphaTab.core.ecmaScript.Math.abs(nextBendValue - paramcurrentBendValue) / alphaTab.midi.MidiFileGenerator.PitchValuePerSemitone
        var numberOfSteps: Double = alphaTab.core.ecmaScript.Math.max(alphaTab.midi.MidiFileGenerator.MinBreakpointsPerSemitone * numberOfSemitones, millisBetweenPoints / alphaTab.midi.MidiFileGenerator.MillisecondsPerBreakpoint)
        var ticksPerBreakpoint: Double = ticksBetweenPoints / numberOfSteps
        var pitchPerBreakpoint: Double = (nextBendValue - paramcurrentBendValue) / numberOfSteps
        if(true) {
            var i: Double = 0.0
            
            while(i < numberOfSteps){
                try{
                    addBend(((paramcurrentTick).toInt() or 0).toDouble(), alphaTab.core.ecmaScript.Math.round(paramcurrentBendValue))
                    paramcurrentBendValue += pitchPerBreakpoint
                    paramcurrentTick += ticksPerBreakpoint
                }
                finally{
                    i++
                }
            }
        }
        if (paramcurrentBendValue < nextBendValue)
        {
            addBend(((paramcurrentTick).toInt() or 0).toDouble(), nextBendValue)
        }
    }
    
    /**
     */
    private fun generateTrill(note: alphaTab.model.Note, noteStart: Double, noteDuration: alphaTab.midi.MidiNoteDuration, noteKey: Double, dynamicValue: Double, channel: Double): Unit{
        var track: alphaTab.model.Track = note.beat.voice.bar.staff.track
        var trillKey: Double = note.stringTuning + note.trillFret
        var trillLength: Double = alphaTab.midi.MidiUtils.toTicks(note.trillSpeed)
        var realKey: Boolean = true
        var tick: Double = noteStart
        var end: Double = noteStart + noteDuration.untilTieOrSlideEnd
        while (tick + 10.0 < end)
        {
            if (tick + trillLength >= end)
            {
                trillLength = end - tick
            }
            this._handler.addNote(
                track.index
                , 
                tick
                , 
                trillLength
                , 
                if(realKey)  trillKey else noteKey
                , 
                dynamicValue
                , 
                channel
            
            )
            realKey = !realKey
            tick += trillLength
        }
    }
    
    /**
     */
    private fun generateTremoloPicking(note: alphaTab.model.Note, noteStart: Double, noteDuration: alphaTab.midi.MidiNoteDuration, noteKey: Double, dynamicValue: Double, channel: Double): Unit{
        var track: alphaTab.model.Track = note.beat.voice.bar.staff.track
        var tpLength: Double = alphaTab.midi.MidiUtils.toTicks(note.beat.tremoloSpeed!!)
        var tick: Double = noteStart
        var end: Double = noteStart + noteDuration.untilTieOrSlideEnd
        while (tick + 10.0 < end)
        {
            if (tick + tpLength >= end)
            {
                tpLength = end - tick
            }
            this._handler.addNote(
                track.index
                , 
                tick
                , 
                tpLength
                , 
                noteKey
                , 
                dynamicValue
                , 
                channel
            
            )
            tick += tpLength
        }
    }
    
    /**
     */
    private fun getBrushInfo(beat: alphaTab.model.Beat): alphaTab.core.ecmaScript.Int32Array{
        var brushInfo: alphaTab.core.ecmaScript.Int32Array = alphaTab.core.ecmaScript.Int32Array(beat.voice.bar.staff.tuning.length)
        if (beat.brushType != alphaTab.model.BrushType.None)
        {
            var stringUsed: Double = 0.0
            var stringCount: Double = 0.0
            for (n in beat.notes)
            {
                if (n.isTieDestination)
                {
                    continue
                }
                stringUsed = ((stringUsed.toInt()) or (1 shl ((n.string - 1.0)).toInt())).toDouble()
                stringCount++
            }
            if (beat.notes.length > 0)
            {
                var brushMove: Double = 0.0
                var brushIncrement: Double = (((beat.brushDuration / (stringCount - 1.0))).toInt() or 0).toDouble()
                if(true) {
                    var i: Double = 0.0
                    
                    while(i < beat.voice.bar.staff.tuning.length){
                        try{
                            var index: Double = if(beat.brushType == alphaTab.model.BrushType.ArpeggioDown || beat.brushType == alphaTab.model.BrushType.BrushDown)  i else brushInfo.length - 1.0 - i
                            if (((stringUsed).toInt() and (1 shl (index).toInt())) != 0)
                            {
                                brushInfo[(index).toInt()] = brushMove
                                brushMove += brushIncrement
                            }
                        }
                        finally{
                            i++
                        }
                    }
                }
            }
        }
        return brushInfo
    }
    
    /**
     */
    private fun generateAutomation(beat: alphaTab.model.Beat, automation: alphaTab.model.Automation, startMove: Double): Unit{
        when (automation.type)
        {
            alphaTab.model.AutomationType.Instrument -> 
            {
                this.addProgramChange(beat.voice.bar.staff.track, beat.playbackStart + startMove, beat.voice.bar.staff.track.playbackInfo.primaryChannel, (((automation.value).toInt() or 0) and 255).toDouble())
                this.addProgramChange(beat.voice.bar.staff.track, beat.playbackStart + startMove, beat.voice.bar.staff.track.playbackInfo.secondaryChannel, (((automation.value).toInt() or 0) and 255).toDouble())
            }
            alphaTab.model.AutomationType.Balance -> 
            {
                var balance: Double = alphaTab.midi.MidiFileGenerator.toChannelShort(automation.value)
                this._handler.addControlChange(beat.voice.bar.staff.track.index, beat.playbackStart + startMove, beat.voice.bar.staff.track.playbackInfo.primaryChannel, alphaTab.midi.ControllerType.PanCoarse, balance)
                this._handler.addControlChange(beat.voice.bar.staff.track.index, beat.playbackStart + startMove, beat.voice.bar.staff.track.playbackInfo.secondaryChannel, alphaTab.midi.ControllerType.PanCoarse, balance)
            }
            alphaTab.model.AutomationType.Volume -> 
            {
                var volume: Double = alphaTab.midi.MidiFileGenerator.toChannelShort(automation.value)
                this._handler.addControlChange(beat.voice.bar.staff.track.index, beat.playbackStart + startMove, beat.voice.bar.staff.track.playbackInfo.primaryChannel, alphaTab.midi.ControllerType.VolumeCoarse, volume)
                this._handler.addControlChange(beat.voice.bar.staff.track.index, beat.playbackStart + startMove, beat.voice.bar.staff.track.playbackInfo.secondaryChannel, alphaTab.midi.ControllerType.VolumeCoarse, volume)
            }
            else -> { }
        }
    }
    
    /**
     */
    public fun prepareSingleBeat(beat: alphaTab.model.Beat): Unit{
        var tempo: Double = -1.0
        var program: Double = -1.0
        var currentBeat: alphaTab.model.Beat? = beat
        while (alphaTab.core.TypeHelper.isTruthy(currentBeat) && (tempo == -1.0 || program == -1.0))
        {
            for (automation in beat.automations)
            {
                when (automation.type)
                {
                    alphaTab.model.AutomationType.Instrument -> 
                    {
                        program = automation.value
                    }
                    alphaTab.model.AutomationType.Tempo -> 
                    {
                        tempo = automation.value
                    }
                    else -> { }
                }
            }
            currentBeat = currentBeat.previousBeat
        }
        var track: alphaTab.model.Track = beat.voice.bar.staff.track
        var masterBar: alphaTab.model.MasterBar = beat.voice.bar.masterBar
        if (tempo == -1.0)
        {
            tempo = masterBar.score.tempo
        }
        if (program == -1.0)
        {
            program = track.playbackInfo.program
        }
        var volume: Double = track.playbackInfo.volume
        this.generateTrack(track)
        this._handler.addTimeSignature(0.0, masterBar.timeSignatureNumerator, masterBar.timeSignatureDenominator)
        this._handler.addTempo(0.0, tempo)
        var volumeCoarse: Double = alphaTab.midi.MidiFileGenerator.toChannelShort(volume)
        this._handler.addControlChange(0.0, 0.0, track.playbackInfo.primaryChannel, alphaTab.midi.ControllerType.VolumeCoarse, volumeCoarse)
        this._handler.addControlChange(0.0, 0.0, track.playbackInfo.secondaryChannel, alphaTab.midi.ControllerType.VolumeCoarse, volumeCoarse)
    }
    
    /**
     */
    public fun generateSingleBeat(beat: alphaTab.model.Beat): Unit{
        this.prepareSingleBeat(beat)
        this.generateBeat(beat, -beat.playbackStart, beat.voice.bar)
    }
    
    /**
     */
    public fun generateSingleNote(note: alphaTab.model.Note): Unit{
        this.prepareSingleBeat(note.beat)
        this.generateNote(note, 0.0, note.beat.playbackDuration, alphaTab.core.ecmaScript.Int32Array(note.beat.voice.bar.staff.tuning.length))
    }
    
    companion object{
        @kotlin.jvm.JvmStatic
        private val DefaultDurationDead: Double = 30.0
        
        @kotlin.jvm.JvmStatic
        private val DefaultDurationPalmMute: Double = 80.0
        
        /**
         */
        @kotlin.jvm.JvmStatic
        public fun buildTranspositionPitches(score: alphaTab.model.Score, settings: alphaTab.Settings): alphaTab.collections.DoubleDoubleMap{
            var transpositionPitches: alphaTab.collections.DoubleDoubleMap = alphaTab.collections.DoubleDoubleMap()
            for (track in score.tracks)
            {
                var transpositionPitch: Double = if(track.index < settings.notation.transpositionPitches.length)  settings.notation.transpositionPitches[(track.index).toInt()] else 0.0
                transpositionPitches.set(track.playbackInfo.primaryChannel, transpositionPitch)
                transpositionPitches.set(track.playbackInfo.secondaryChannel, transpositionPitch)
            }
            return transpositionPitches
        }
        
        /**
         */
        @kotlin.jvm.JvmStatic
        private fun toChannelShort(`data`: Double): Double{
            var value: Double = alphaTab.core.ecmaScript.Math.max(-32768.0, alphaTab.core.ecmaScript.Math.min(32767.0, `data` * 8.0 - 1.0))
            return alphaTab.core.ecmaScript.Math.max(value, -1.0) + 1.0
        }
        
        /**
         */
        @kotlin.jvm.JvmStatic
        private fun calculateTripletFeelInfo(beatStart: Double, audioDuration: Double, beat: alphaTab.model.Beat): alphaTab.midi.TripletFeelDurations?{
            var initialDuration: alphaTab.model.Duration
            when (beat.voice.bar.masterBar.tripletFeel)
            {
                alphaTab.model.TripletFeel.Triplet8th, alphaTab.model.TripletFeel.Dotted8th, alphaTab.model.TripletFeel.Scottish8th -> 
                {
                    initialDuration = alphaTab.model.Duration.Eighth
                }
                alphaTab.model.TripletFeel.Triplet16th, alphaTab.model.TripletFeel.Dotted16th, alphaTab.model.TripletFeel.Scottish16th -> 
                {
                    initialDuration = alphaTab.model.Duration.Sixteenth
                }
                else -> 
                {
                    return null
                }
            }
            var interval: Double = alphaTab.midi.MidiUtils.toTicks(initialDuration)
            if (audioDuration != interval)
            {
                return null
            }
            if (beatStart % interval != 0.0)
            {
                return null
            }
            if (!alphaTab.core.TypeHelper.isTruthy(beat.nextBeat) || beat.nextBeat!!.voice != beat.voice || beat.playbackDuration != interval)
            {
                return null
            }
            var durations: alphaTab.midi.TripletFeelDurations = alphaTab.midi.TripletFeelDurations()
            when (beat.voice.bar.masterBar.tripletFeel)
            {
                alphaTab.model.TripletFeel.Triplet8th -> 
                {
                    durations.firstBeatDuration = alphaTab.midi.MidiUtils.applyTuplet(alphaTab.midi.MidiUtils.toTicks(alphaTab.model.Duration.Quarter), 3.0, 2.0)
                    durations.secondBeatDuration = alphaTab.midi.MidiUtils.applyTuplet(alphaTab.midi.MidiUtils.toTicks(alphaTab.model.Duration.Eighth), 3.0, 2.0)
                }
                alphaTab.model.TripletFeel.Dotted8th -> 
                {
                    durations.firstBeatDuration = alphaTab.midi.MidiUtils.applyDot(alphaTab.midi.MidiUtils.toTicks(alphaTab.model.Duration.Eighth), false)
                    durations.secondBeatDuration = alphaTab.midi.MidiUtils.toTicks(alphaTab.model.Duration.Sixteenth)
                }
                alphaTab.model.TripletFeel.Scottish8th -> 
                {
                    durations.firstBeatDuration = alphaTab.midi.MidiUtils.toTicks(alphaTab.model.Duration.Sixteenth)
                    durations.secondBeatDuration = alphaTab.midi.MidiUtils.applyDot(alphaTab.midi.MidiUtils.toTicks(alphaTab.model.Duration.Eighth), false)
                }
                alphaTab.model.TripletFeel.Triplet16th -> 
                {
                    durations.firstBeatDuration = alphaTab.midi.MidiUtils.applyTuplet(alphaTab.midi.MidiUtils.toTicks(alphaTab.model.Duration.Eighth), 3.0, 2.0)
                    durations.secondBeatDuration = alphaTab.midi.MidiUtils.applyTuplet(alphaTab.midi.MidiUtils.toTicks(alphaTab.model.Duration.Sixteenth), 3.0, 2.0)
                }
                alphaTab.model.TripletFeel.Dotted16th -> 
                {
                    durations.firstBeatDuration = alphaTab.midi.MidiUtils.applyDot(alphaTab.midi.MidiUtils.toTicks(alphaTab.model.Duration.Sixteenth), false)
                    durations.secondBeatDuration = alphaTab.midi.MidiUtils.toTicks(alphaTab.model.Duration.ThirtySecond)
                }
                alphaTab.model.TripletFeel.Scottish16th -> 
                {
                    durations.firstBeatDuration = alphaTab.midi.MidiUtils.toTicks(alphaTab.model.Duration.ThirtySecond)
                    durations.secondBeatDuration = alphaTab.midi.MidiUtils.applyDot(alphaTab.midi.MidiUtils.toTicks(alphaTab.model.Duration.Sixteenth), false)
                }
                else -> { }
            }
            durations.secondBeatStartOffset = audioDuration - durations.firstBeatDuration
            return durations
        }
        
        /**
         */
        @kotlin.jvm.JvmStatic
        private fun getNoteVelocity(note: alphaTab.model.Note): Double{
            var dynamicValue: Double = note.dynamics.toDouble()
            if (!note.beat.voice.bar.staff.isPercussion && alphaTab.core.TypeHelper.isTruthy(note.hammerPullOrigin))
            {
                dynamicValue--
            }
            if (note.isGhost)
            {
                dynamicValue--
            }
            when (note.accentuated)
            {
                alphaTab.model.AccentuationType.Normal -> 
                {
                    dynamicValue++
                }
                alphaTab.model.AccentuationType.Heavy -> 
                {
                    dynamicValue += 2.0
                }
                else -> { }
            }
            return alphaTab.midi.MidiUtils.dynamicToVelocity(dynamicValue)
        }
        
        /**
         * Maximum semitones that are supported in bends in one direction (up or down)
         * GP has 8 full tones on whammys.
         */
        @kotlin.jvm.JvmStatic
        private val PitchBendRangeInSemitones: Double = 8.0 * 2.0
        
        /**
         * The value on how many pitch-values are used for one semitone
         */
        @kotlin.jvm.JvmStatic
        private val PitchValuePerSemitone: Double = alphaTab.synth.SynthConstants.DefaultPitchWheel / alphaTab.midi.MidiFileGenerator.PitchBendRangeInSemitones
        
        /**
         * The minimum number of breakpoints generated per semitone bend.
         */
        @kotlin.jvm.JvmStatic
        private val MinBreakpointsPerSemitone: Double = 6.0
        
        /**
         * How long until a new breakpoint is generated for a bend.
         */
        @kotlin.jvm.JvmStatic
        private val MillisecondsPerBreakpoint: Double = 150.0
        
        /**
         * Calculates the midi pitch wheel value for the give bend value.
         */
        @kotlin.jvm.JvmStatic
        public fun getPitchWheel(bendValue: Double): Double{
            return alphaTab.synth.SynthConstants.DefaultPitchWheel + (bendValue / (2.0).toDouble()) * alphaTab.midi.MidiFileGenerator.PitchValuePerSemitone
        }
        
    }
}

@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class MidiNoteDuration
{
    public var noteOnly: Double = 0.0
    
    public var untilTieOrSlideEnd: Double = 0.0
    
    public var letRingEnd: Double = 0.0
    
    public constructor()
}

@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class TripletFeelDurations
{
    public var firstBeatDuration: Double = 0.0
    
    public var secondBeatStartOffset: Double = 0.0
    
    public var secondBeatDuration: Double = 0.0
    
    public constructor()
}

