// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.midi
import alphaTab.core.*

@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class MidiPlaybackController
{
    private var _score: alphaTab.model.Score
    
    private var _repeatStack: alphaTab.collections.List<alphaTab.midi.Repeat> = alphaTab.collections.List<alphaTab.midi.Repeat>(
    )
    
    
    private var _groupsOnStack: alphaTab.core.ecmaScript.Set<alphaTab.model.RepeatGroup> = alphaTab.core.ecmaScript.Set<alphaTab.model.RepeatGroup>()
    
    private var _previousAlternateEndings: Double = 0.0
    
    public var shouldPlay: Boolean = true
    
    public var index: Double = 0.0
    
    public var currentTick: Double = 0.0
    
    public val finished: Boolean
    get(){
        return this.index >= this._score.masterBars.length
    }
    
    public constructor(score: alphaTab.model.Score){
        this._score = score
    }
    
    public fun processCurrent(): Unit{
        var masterBar: alphaTab.model.MasterBar = this._score.masterBars[(this.index).toInt()]
        var masterBarAlternateEndings: Double = masterBar.alternateEndings
        if (masterBarAlternateEndings == 0.0)
        {
            masterBarAlternateEndings = this._previousAlternateEndings
        }
        if (masterBar == masterBar.repeatGroup.opening && masterBar.repeatGroup.isClosed)
        {
            if (!this._groupsOnStack.has(masterBar.repeatGroup))
            {
                var repeat: alphaTab.midi.Repeat = alphaTab.midi.Repeat(masterBar.repeatGroup, masterBar)
                this._repeatStack.push(repeat)
                this._groupsOnStack.add(masterBar.repeatGroup)
                this._previousAlternateEndings = 0.0
                masterBarAlternateEndings = masterBar.alternateEndings
            }
        }
        if (this._repeatStack.length == 0.0 || masterBarAlternateEndings == 0.0)
        {
            this.shouldPlay = true
        }
        else 
        {
            var repeat: alphaTab.midi.Repeat = this._repeatStack[(this._repeatStack.length - 1.0).toInt()]
            var iteration: Double = repeat.iterations[(repeat.closingIndex).toInt()]
            this._previousAlternateEndings = masterBarAlternateEndings
            if (((masterBarAlternateEndings).toInt() and (1 shl (iteration).toInt())) == 0)
            {
                this.shouldPlay = false
            }
            else 
            {
                this.shouldPlay = true
            }
        }
        if (this.shouldPlay)
        {
            this.currentTick += masterBar.calculateDuration()
        }
    }
    
    public fun moveNext(): Unit{
        var masterBar: alphaTab.model.MasterBar = this._score.masterBars[(this.index).toInt()]
        var masterBarRepeatCount: Double = masterBar.repeatCount - 1.0
        if (this._repeatStack.length > 0 && masterBarRepeatCount > 0)
        {
            var repeat: alphaTab.midi.Repeat = this._repeatStack[(this._repeatStack.length - 1.0).toInt()]
            var iteration: Double = repeat.iterations[(repeat.closingIndex).toInt()]
            if (iteration < masterBarRepeatCount)
            {
                this.index = repeat.opening.index
                repeat.iterations[(repeat.closingIndex).toInt()]++
                if(true) {
                    var i: Double = 0.0
                    
                    while(i < repeat.closingIndex){
                        try{
                            repeat.iterations[(i).toInt()] = 0.0
                        }
                        finally{
                            i++
                        }
                    }
                }
                repeat.closingIndex = 0.0
                this._previousAlternateEndings = 0.0
            }
            else 
            {
                if (repeat.closingIndex < repeat.group.closings.length - 1.0)
                {
                    repeat.closingIndex++
                    this.index++
                }
                else 
                {
                    this._repeatStack.pop()
                    this._groupsOnStack.delete(repeat.group)
                    this.index++
                }
            }
        }
        else 
        {
            this.index++
        }
    }
    
}

/**
 * Helper container to handle repeats correctly
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class Repeat
{
    public var group: alphaTab.model.RepeatGroup
    public var opening: alphaTab.model.MasterBar
    public var iterations: alphaTab.collections.DoubleList
    public var closingIndex: Double = 0.0
    
    public constructor(group: alphaTab.model.RepeatGroup, opening: alphaTab.model.MasterBar){
        this.group = group
        this.opening = opening
        group.closings = group.closings.sort(fun(a: alphaTab.model.MasterBar, b: alphaTab.model.MasterBar): Double{
            return a.index - b.index
        }
        )
        this.iterations = group.closings.map(fun(_: alphaTab.model.MasterBar): Double{
            return 0.0
        }
        )
    }
    
}

