// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.midi
import alphaTab.core.*

/**
 * This class holds all information about when s and s are played.
 * 
 * On top level it is organized into  objects indicating the 
 * master bar start and end times. This information is used to highlight the currently played bars
 * and it gives access to the played beats in this masterbar and their times. 
 * 
 * The  are then the slices into which the masterbar is separated by the voices and beats 
 * of all tracks. An example how things are organized:
 * 
 * Time (eighths):  | 01 | 02 | 03 | 04 | 05 | 06 | 07 | 08 | 09 | 10 | 11 | 12 | 13 | 14 | 15 | 16 | 
 * 
 * Track 1:         |        B1         |        B2         |    B3   |    B4   |    B5   |    B6   |
 * Track 2:         |                  B7                   |         B7        | B9 | B10| B11| B12|
 * Track 3:         |                                      B13                                      |
 * 
 * Lookup:          |        L1         |        L2         |    L3    |   L4   | L5 | L6 | L7 | L8 |
 * Active Beats:    
 * - L1             B1,B7,B13           
 * - L2                                 B2,B7,B13           
 * - L3                                                      B3,B7,B13    
 * - L4                                                                 B4,B7,B13
 * - L5                                                                          B5,B9,B13
 * - L6                                                                               B5,B10,B13
 * - L7                                                                                    B6,B11,B13
 * - L8                                                                                         B6,B12,B13
 * 
 * Then during playback we build out of this list  objects which are sepcific
 * to the visible tracks displayed. This is required because if only Track 2 is displayed we cannot use the the 
 * Lookup L1 alone to determine the start and end of the beat cursor. In this case we will derive a 
 * MidiTickLookupFindBeatResult which holds for Time 01 the lookup L1 as start and L3 as end. This will be used
 * both for the cursor and beat highlighting.
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
public class MidiTickLookup
{
    private var _currentMasterBar: alphaTab.midi.MasterBarTickLookup? = null
    
    /**
     * Gets a dictionary of all master bars played. The index is the index equals to .
     * This lookup only contains the first time a MasterBar is played. For a whole sequence of the song refer to .
     */
    internal var masterBarLookup: alphaTab.collections.DoubleObjectMap<alphaTab.midi.MasterBarTickLookup> = alphaTab.collections.DoubleObjectMap<alphaTab.midi.MasterBarTickLookup>()
    
    /**
     * Gets a list of all  sorted by time.
     */
    internal var masterBars: alphaTab.collections.List<alphaTab.midi.MasterBarTickLookup> = alphaTab.collections.List<alphaTab.midi.MasterBarTickLookup>(
    )
    
    
    /**
     * Finds the currently played beat given a list of tracks and the current time.
     * @param trackLookup The tracks indices in which to search the played beat for.
     * @param tick The current time in midi ticks.
     */
    public fun findBeat(trackLookup: alphaTab.core.ecmaScript.Set<Double>, tick: Double, currentBeatHint: alphaTab.midi.MidiTickLookupFindBeatResult? = null): alphaTab.midi.MidiTickLookupFindBeatResult?{
        var result: alphaTab.midi.MidiTickLookupFindBeatResult? = null
        if (alphaTab.core.TypeHelper.isTruthy(currentBeatHint))
        {
            result = this.findBeatFast(trackLookup, currentBeatHint, tick)
        }
        if (!alphaTab.core.TypeHelper.isTruthy(result))
        {
            result = this.findBeatSlow(trackLookup, currentBeatHint, tick, false)
        }
        return result
    }
    
    /**
     */
    private fun findBeatFast(trackLookup: alphaTab.core.ecmaScript.Set<Double>, currentBeatHint: alphaTab.midi.MidiTickLookupFindBeatResult, tick: Double): alphaTab.midi.MidiTickLookupFindBeatResult?{
        if (tick >= currentBeatHint.start && tick < currentBeatHint.end)
        {
            return currentBeatHint
        }
        else if (alphaTab.core.TypeHelper.isTruthy(currentBeatHint.nextBeat) && tick >= currentBeatHint.nextBeat!!.start && tick < currentBeatHint.nextBeat!!.end)
        {
            var next: alphaTab.midi.MidiTickLookupFindBeatResult = currentBeatHint.nextBeat!!
            this.fillNextBeat(next, trackLookup)
            return next
        }
        return null
    }
    
    /**
     */
    private fun fillNextBeat(current: alphaTab.midi.MidiTickLookupFindBeatResult, trackLookup: alphaTab.core.ecmaScript.Set<Double>): Unit{
        current.nextBeat = this.findBeatInMasterBar(
            current.masterBar
            , 
            current.beatLookup.nextBeat
            , 
            current.end
            , 
            trackLookup
            , 
            false
            , 
            true
        
        )
        if (current.nextBeat == null)
        {
            current.nextBeat = this.findBeatSlow(trackLookup, current, current.end, true)
        }
        if (alphaTab.core.TypeHelper.isTruthy(current.nextBeat))
        {
            current.tickDuration = current.nextBeat!!.start - current.start
            current.duration = alphaTab.midi.MidiUtils.ticksToMillis(current.tickDuration, current.masterBar.tempo)
        }
        if (!alphaTab.core.TypeHelper.isTruthy(current.nextBeat))
        {
            current.tickDuration = current.masterBar.end - current.start
            current.duration = alphaTab.midi.MidiUtils.ticksToMillis(current.tickDuration, current.masterBar.tempo)
        }
    }
    
    /**
     */
    private fun findBeatSlow(trackLookup: alphaTab.core.ecmaScript.Set<Double>, currentBeatHint: alphaTab.midi.MidiTickLookupFindBeatResult?, tick: Double, isNextSearch: Boolean): alphaTab.midi.MidiTickLookupFindBeatResult?{
        var masterBar: alphaTab.midi.MasterBarTickLookup? = null
        if (currentBeatHint != null)
        {
            if (currentBeatHint.masterBar.start <= tick && currentBeatHint.masterBar.end > tick)
            {
                masterBar = currentBeatHint.masterBar
            }
            else if (alphaTab.core.TypeHelper.isTruthy(currentBeatHint.masterBar.nextMasterBar) && currentBeatHint.masterBar.nextMasterBar!!.start <= tick && currentBeatHint.masterBar.nextMasterBar!!.end > tick)
            {
                masterBar = currentBeatHint.masterBar.nextMasterBar
            }
        }
        if (!alphaTab.core.TypeHelper.isTruthy(masterBar))
        {
            masterBar = this.findMasterBar(tick)
        }
        if (!alphaTab.core.TypeHelper.isTruthy(masterBar))
        {
            return null
        }
        while (alphaTab.core.TypeHelper.isTruthy(masterBar))
        {
            if (alphaTab.core.TypeHelper.isTruthy(masterBar.firstBeat))
            {
                var beat: alphaTab.midi.MidiTickLookupFindBeatResult? = this.findBeatInMasterBar(
                    masterBar
                    , 
                    masterBar.firstBeat
                    , 
                    tick
                    , 
                    trackLookup
                    , 
                    true
                    , 
                    isNextSearch
                
                )
                if (alphaTab.core.TypeHelper.isTruthy(beat))
                {
                    return beat
                }
            }
            masterBar = masterBar.nextMasterBar
        }
        return null
    }
    
    /**
     * Finds the beat at a given tick position within the known master bar.
     */
    private fun findBeatInMasterBar(masterBar: alphaTab.midi.MasterBarTickLookup, currentStartLookup: alphaTab.midi.BeatTickLookup?, tick: Double, visibleTracks: alphaTab.core.ecmaScript.Set<Double>, fillNext: Boolean, isNextSeach: Boolean): alphaTab.midi.MidiTickLookupFindBeatResult?{
        var parammasterBar = masterBar
        var paramcurrentStartLookup = currentStartLookup
        if (!alphaTab.core.TypeHelper.isTruthy(paramcurrentStartLookup))
        {
            return null
        }
        var startBeatLookup: alphaTab.midi.BeatTickLookup? = null
        var startBeat: alphaTab.model.Beat? = null
        var relativeTick: Double = tick - parammasterBar.start
        while (paramcurrentStartLookup != null && startBeat == null)
        {
            if (paramcurrentStartLookup.start <= relativeTick && relativeTick < paramcurrentStartLookup.end)
            {
                startBeatLookup = paramcurrentStartLookup
                startBeat = paramcurrentStartLookup.getVisibleBeatAtStart(visibleTracks)
                if (!alphaTab.core.TypeHelper.isTruthy(startBeat))
                {
                    if (isNextSeach)
                    {
                        var currentMasterBar: alphaTab.midi.MasterBarTickLookup? = parammasterBar
                        while (currentMasterBar != null && startBeat == null)
                        {
                            while (paramcurrentStartLookup != null)
                            {
                                startBeat = paramcurrentStartLookup.getVisibleBeatAtStart(visibleTracks)
                                if (alphaTab.core.TypeHelper.isTruthy(startBeat))
                                {
                                    startBeatLookup = paramcurrentStartLookup
                                    parammasterBar = currentMasterBar
                                    break
                                }
                                paramcurrentStartLookup = paramcurrentStartLookup.nextBeat
                            }
                            if (!alphaTab.core.TypeHelper.isTruthy(startBeat) || !alphaTab.core.TypeHelper.isTruthy(startBeatLookup))
                            {
                                currentMasterBar = currentMasterBar.nextMasterBar
                                paramcurrentStartLookup = currentMasterBar?.firstBeat 
                            }
                        }
                    }
                    else 
                    {
                        var currentMasterBar: alphaTab.midi.MasterBarTickLookup? = parammasterBar
                        while (currentMasterBar != null && startBeat == null)
                        {
                            while (paramcurrentStartLookup != null)
                            {
                                startBeat = paramcurrentStartLookup.getVisibleBeatAtStart(visibleTracks)
                                if (alphaTab.core.TypeHelper.isTruthy(startBeat))
                                {
                                    startBeatLookup = paramcurrentStartLookup
                                    parammasterBar = currentMasterBar
                                    break
                                }
                                paramcurrentStartLookup = paramcurrentStartLookup.previousBeat
                            }
                            if (!alphaTab.core.TypeHelper.isTruthy(startBeat) || !alphaTab.core.TypeHelper.isTruthy(startBeatLookup))
                            {
                                currentMasterBar = currentMasterBar.previousMasterBar
                                paramcurrentStartLookup = currentMasterBar?.firstBeat 
                            }
                        }
                    }
                }
            }
            else if (paramcurrentStartLookup.end > relativeTick)
            {
                break
            }
            paramcurrentStartLookup = paramcurrentStartLookup?.nextBeat 
        }
        if (startBeat == null)
        {
            return null
        }
        var result: alphaTab.midi.MidiTickLookupFindBeatResult = this.createResult(parammasterBar, startBeatLookup!!, startBeat, fillNext, visibleTracks)
        return result
    }
    
    /**
     */
    private fun createResult(masterBar: alphaTab.midi.MasterBarTickLookup, beatLookup: alphaTab.midi.BeatTickLookup, beat: alphaTab.model.Beat, fillNext: Boolean, visibleTracks: alphaTab.core.ecmaScript.Set<Double>): alphaTab.midi.MidiTickLookupFindBeatResult{
        var result: alphaTab.midi.MidiTickLookupFindBeatResult = alphaTab.midi.MidiTickLookupFindBeatResult(masterBar)
        result.beat = beat
        result.beatLookup = beatLookup
        result.tickDuration = beatLookup!!.end - beatLookup!!.start
        if (fillNext)
        {
            this.fillNextBeat(result, visibleTracks)
        }
        result.duration = alphaTab.midi.MidiUtils.ticksToMillis(result.tickDuration, masterBar.tempo)
        return result
    }
    
    /**
     */
    private fun findMasterBar(tick: Double): alphaTab.midi.MasterBarTickLookup?{
        var bars: alphaTab.collections.List<alphaTab.midi.MasterBarTickLookup> = this.masterBars
        var bottom: Double = 0.0
        var top: Double = bars.length - 1.0
        while (bottom <= top)
        {
            var middle: Double = ((((top + bottom) / (2.0).toDouble())).toInt() or 0).toDouble()
            var bar: alphaTab.midi.MasterBarTickLookup = bars[(middle).toInt()]
            if (tick >= bar.start && tick < bar.end)
            {
                return bar
            }
            if (tick < bar.start)
            {
                top = middle - 1.0
            }
            else 
            {
                bottom = middle + 1.0
            }
        }
        return null
    }
    
    /**
     * Gets the  for a given masterbar at which the masterbar is played the first time.
     * @param bar The masterbar to find the time period for.
     */
    public fun getMasterBar(bar: alphaTab.model.MasterBar): alphaTab.midi.MasterBarTickLookup{
        if (!this.masterBarLookup.has(bar.index))
        {
            var fallback: alphaTab.midi.MasterBarTickLookup = alphaTab.midi.MasterBarTickLookup()
            fallback.masterBar = bar
            return fallback
        }
        return this.masterBarLookup.get(bar.index)!!
    }
    
    /**
     * Gets the start time in midi ticks for a given masterbar at which the masterbar is played the first time.
     * @param bar The masterbar to find the time period for.
     */
    public fun getMasterBarStart(bar: alphaTab.model.MasterBar): Double{
        if (!this.masterBarLookup.has(bar.index))
        {
            return 0.0
        }
        return this.masterBarLookup.get(bar.index)!!.start
    }
    
    /**
     * Gets the start time in midi ticks for a given beat at which the masterbar is played the first time.
     * @param beat The beat to find the time period for.
     */
    public fun getBeatStart(beat: alphaTab.model.Beat): Double{
        if (!this.masterBarLookup.has(beat.voice.bar.index))
        {
            return 0.0
        }
        return this.masterBarLookup.get(beat.voice.bar.index)!!.start + beat.playbackStart
    }
    
    /**
     * Adds a new  to the lookup table.
     * @param masterBar The item to add.
     */
    public fun addMasterBar(masterBar: alphaTab.midi.MasterBarTickLookup): Unit{
        this.masterBars.push(masterBar)
        if (alphaTab.core.TypeHelper.isTruthy(this._currentMasterBar))
        {
            masterBar.previousMasterBar = this._currentMasterBar
            this._currentMasterBar!!.nextMasterBar = masterBar
        }
        this._currentMasterBar = masterBar
        if (!this.masterBarLookup.has(masterBar.masterBar.index))
        {
            this.masterBarLookup.set(masterBar.masterBar.index, masterBar)
        }
    }
    
    /**
     */
    public fun addBeat(beat: alphaTab.model.Beat, start: Double, duration: Double): Unit{
        var currentMasterBar: alphaTab.midi.MasterBarTickLookup? = this._currentMasterBar
        if (alphaTab.core.TypeHelper.isTruthy(currentMasterBar))
        {
            if (start < 0 && alphaTab.core.TypeHelper.isTruthy(currentMasterBar.previousMasterBar))
            {
                var relativeMasterBarEnd: Double = currentMasterBar.previousMasterBar!!.end - currentMasterBar.previousMasterBar!!.start
                var previousStart: Double = relativeMasterBarEnd + start
                var previousEnd: Double = previousStart + duration
                currentMasterBar.previousMasterBar!!.addBeat(beat, previousStart, previousStart, duration)
                if (previousEnd > relativeMasterBarEnd)
                {
                    var overlapDuration: Double = duration + start
                    currentMasterBar.addBeat(beat, start, 0.0, overlapDuration)
                }
            }
            else 
            {
                currentMasterBar.addBeat(beat, start, start, duration)
            }
        }
    }
    
    public constructor()
}

/**
 * Represents the results of searching the currently played beat.
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
public class MidiTickLookupFindBeatResult
{
    /**
     * Gets or sets the beat that is currently played and used for the start 
     * position of the cursor animation.
     */
    public lateinit var beat: alphaTab.model.Beat
    /**
     * Gets or sets the parent MasterBarTickLookup to which this beat lookup belongs to.
     */
    public var masterBar: alphaTab.midi.MasterBarTickLookup
    /**
     * Gets or sets the related beat tick lookup.
     */
    public lateinit var beatLookup: alphaTab.midi.BeatTickLookup
    /**
     * Gets or sets the beat that will be played next.
     */
    public var nextBeat: alphaTab.midi.MidiTickLookupFindBeatResult? = null
    
    /**
     * Gets or sets the duration in midi ticks how long this lookup is valid.
     */
    public var tickDuration: Double = 0.0
    
    /**
     * Gets or sets the duration in milliseconds how long this lookup is valid.
     */
    public var duration: Double = 0.0
    
    public val start: Double
    get(){
        return this.masterBar.start + this.beatLookup.start
    }
    
    public val end: Double
    get(){
        return this.start + this.tickDuration
    }
    
    public constructor(masterBar: alphaTab.midi.MasterBarTickLookup){
        this.masterBar = masterBar
    }
    
}

