// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.midi
import alphaTab.core.*

@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class MidiUtils
{
    companion object{
        @kotlin.jvm.JvmStatic
        public val QuarterTime: Double = 960.0
        
        @kotlin.jvm.JvmStatic
        private val MinVelocity: Double = 15.0
        
        @kotlin.jvm.JvmStatic
        private val VelocityIncrement: Double = 16.0
        
        /**
         * Converts the given midi tick duration into milliseconds.
         * @param ticks The duration in midi ticks
         * @param tempo The current tempo in BPM.
         */
        @kotlin.jvm.JvmStatic
        public fun ticksToMillis(ticks: Double, tempo: Double): Double{
            return (((ticks * ((60000.0).toDouble() / (tempo * alphaTab.midi.MidiUtils.QuarterTime)))).toInt() or 0).toDouble()
        }
        
        /**
         * Converts the given midi tick duration into milliseconds.
         * @param millis The duration in milliseconds
         * @param tempo The current tempo in BPM.
         */
        @kotlin.jvm.JvmStatic
        public fun millisToTicks(millis: Double, tempo: Double): Double{
            return (((millis / ((60000.0).toDouble() / (tempo * alphaTab.midi.MidiUtils.QuarterTime)))).toInt() or 0).toDouble()
        }
        
        /**
         * Converts a duration value to its ticks equivalent.
         */
        @kotlin.jvm.JvmStatic
        public fun toTicks(duration: alphaTab.model.Duration): Double{
            return alphaTab.midi.MidiUtils.valueToTicks((duration.toDouble()))
        }
        
        /**
         * Converts a numerical value to its ticks equivalent.
         * @param duration the numerical proportion to convert. (i.E. timesignature denominator, note duration,...)
         */
        @kotlin.jvm.JvmStatic
        public fun valueToTicks(duration: Double): Double{
            var denomninator: Double = duration
            if (denomninator < 0)
            {
                denomninator = (1.0).toDouble() / -denomninator
            }
            return (((alphaTab.midi.MidiUtils.QuarterTime * ((4.0).toDouble() / denomninator))).toInt() or 0).toDouble()
        }
        
        /**
         */
        @kotlin.jvm.JvmStatic
        public fun applyDot(ticks: Double, doubleDotted: Boolean): Double{
            if (doubleDotted)
            {
                return ticks + (((ticks / (4.0).toDouble())).toInt() or 0) * 3.0
            }
            return ticks + (((ticks / (2.0).toDouble())).toInt() or 0)
        }
        
        /**
         */
        @kotlin.jvm.JvmStatic
        public fun applyTuplet(ticks: Double, numerator: Double, denominator: Double): Double{
            return ((((ticks * denominator) / numerator)).toInt() or 0).toDouble()
        }
        
        /**
         */
        @kotlin.jvm.JvmStatic
        public fun removeTuplet(ticks: Double, numerator: Double, denominator: Double): Double{
            return ((((ticks * numerator) / denominator)).toInt() or 0).toDouble()
        }
        
        /**
         */
        @kotlin.jvm.JvmStatic
        public fun dynamicToVelocity(dynamicsSteps: Double): Double{
            return alphaTab.midi.MidiUtils.MinVelocity + dynamicsSteps * alphaTab.midi.MidiUtils.VelocityIncrement
        }
        
    }
    public constructor()
}

