// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.model
import alphaTab.core.*

/**
 * A beat is a single block within a bar. A beat is a combination
 * of several notes played at the same time.
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
public class Beat
{
    /**
     * Gets or sets the unique id of this beat.
     */
    public var id: Double = alphaTab.model.Beat._globalBeatId++
    
    /**
     * Gets or sets the zero-based index of this beat within the voice.
     */
    public var index: Double = 0.0
    
    /**
     * Gets or sets the previous beat within the whole song.
     */
    public var previousBeat: alphaTab.model.Beat? = null
    
    /**
     * Gets or sets the next beat within the whole song.
     */
    public var nextBeat: alphaTab.model.Beat? = null
    
    public val isLastOfVoice: Boolean
    get(){
        return this.index == this.voice.beats.length - 1.0
    }
    
    /**
     * Gets or sets the reference to the parent voice this beat belongs to.
     */
    public lateinit var voice: alphaTab.model.Voice
    /**
     * Gets or sets the list of notes contained in this beat.
     */
    public var notes: alphaTab.collections.List<alphaTab.model.Note> = alphaTab.collections.List<alphaTab.model.Note>(
    )
    
    
    /**
     * Gets the lookup where the notes per string are registered.
     * If this staff contains string based notes this lookup allows fast access.
     */
    public var noteStringLookup: alphaTab.collections.DoubleObjectMap<alphaTab.model.Note> = alphaTab.collections.DoubleObjectMap<alphaTab.model.Note>()
    
    /**
     * Gets the lookup where the notes per value are registered.
     * If this staff contains string based notes this lookup allows fast access.
     */
    public var noteValueLookup: alphaTab.collections.DoubleObjectMap<alphaTab.model.Note> = alphaTab.collections.DoubleObjectMap<alphaTab.model.Note>()
    
    /**
     * Gets or sets a value indicating whether this beat is considered empty.
     */
    public var isEmpty: Boolean = false
    
    /**
     * Gets or sets which whammy bar style should be used for this bar.
     */
    public var whammyStyle: alphaTab.model.BendStyle = alphaTab.model.BendStyle.Default
    
    /**
     * Gets or sets the ottava applied to this beat.
     */
    public var ottava: alphaTab.model.Ottavia = alphaTab.model.Ottavia.Regular
    
    /**
     * Gets or sets the fermata applied to this beat.
     */
    public var fermata: alphaTab.model.Fermata? = null
    
    /**
     * Gets a value indicating whether this beat starts a legato slur.
     */
    public var isLegatoOrigin: Boolean = false
    
    public val isLegatoDestination: Boolean
    get(){
        return !!alphaTab.core.TypeHelper.isTruthy(this.previousBeat) && this.previousBeat!!.isLegatoOrigin
    }
    
    /**
     * Gets or sets the note with the lowest pitch in this beat. Only visible notes are considered.
     */
    public var minNote: alphaTab.model.Note? = null
    
    /**
     * Gets or sets the note with the highest pitch in this beat. Only visible notes are considered.
     */
    public var maxNote: alphaTab.model.Note? = null
    
    /**
     * Gets or sets the note with the highest string number in this beat. Only visible notes are considered.
     */
    public var maxStringNote: alphaTab.model.Note? = null
    
    /**
     * Gets or sets the note with the lowest string number in this beat. Only visible notes are considered.
     */
    public var minStringNote: alphaTab.model.Note? = null
    
    /**
     * Gets or sets the duration of this beat.
     */
    public var duration: alphaTab.model.Duration = alphaTab.model.Duration.Quarter
    
    public val isRest: Boolean
    get(){
        return this.isEmpty || this.notes.length == 0.0
    }
    
    public val isFullBarRest: Boolean
    get(){
        return this.isRest && this.voice.beats.length == 1.0 && this.duration == alphaTab.model.Duration.Whole
    }
    
    /**
     * Gets or sets whether any note in this beat has a let-ring applied.
     */
    public var isLetRing: Boolean = false
    
    /**
     * Gets or sets whether any note in this beat has a palm-mute paplied.
     */
    public var isPalmMute: Boolean = false
    
    /**
     * Gets or sets a list of all automations on this beat.
     */
    public var automations: alphaTab.collections.List<alphaTab.model.Automation> = alphaTab.collections.List<alphaTab.model.Automation>(
    )
    
    
    /**
     * Gets or sets the number of dots applied to the duration of this beat.
     */
    public var dots: Double = 0.0
    
    /**
     * Gets or sets a value indicating whether this beat is fade-in.
     */
    public var fadeIn: Boolean = false
    
    /**
     * Gets or sets the lyrics shown on this beat.
     */
    public var lyrics: alphaTab.collections.List<String>? = null
    
    /**
     * Gets or sets a value indicating whether the beat is played in rasgueado style.
     */
    public var hasRasgueado: Boolean = false
    
    /**
     * Gets or sets a value indicating whether the notes on this beat are played with a pop-style (bass).
     */
    public var pop: Boolean = false
    
    /**
     * Gets or sets a value indicating whether the notes on this beat are played with a slap-style (bass).
     */
    public var slap: Boolean = false
    
    /**
     * Gets or sets a value indicating whether the notes on this beat are played with a tap-style (bass).
     */
    public var tap: Boolean = false
    
    /**
     * Gets or sets the text annotation shown on this beat.
     */
    public var text: String? = null
    
    /**
     * Gets or sets the brush type applied to the notes of this beat.
     */
    public var brushType: alphaTab.model.BrushType = alphaTab.model.BrushType.None
    
    /**
     * Gets or sets the duration of the brush between the notes in midi ticks.
     */
    public var brushDuration: Double = 0.0
    
    /**
     * Gets or sets the tuplet denominator.
     */
    public var tupletDenominator: Double = -1.0
    
    /**
     * Gets or sets the tuplet numerator.
     */
    public var tupletNumerator: Double = -1.0
    
    public val hasTuplet: Boolean
    get(){
        return (!(this.tupletDenominator == -1.0 && this.tupletNumerator == -1.0) && !(this.tupletDenominator == 1.0 && this.tupletNumerator == 1.0))
    }
    
    public var tupletGroup: alphaTab.model.TupletGroup? = null
    
    /**
     * Gets or sets whether this beat continues a whammy effect.
     */
    public var isContinuedWhammy: Boolean = false
    
    /**
     * Gets or sets the whammy bar style of this beat.
     */
    public var whammyBarType: alphaTab.model.WhammyType = alphaTab.model.WhammyType.None
    
    /**
     * Gets or sets the points defining the whammy bar usage.
     */
    public var whammyBarPoints: alphaTab.collections.List<alphaTab.model.BendPoint>? = null
    
    /**
     * Gets or sets the highest point with for the highest whammy bar value.
     */
    public var maxWhammyPoint: alphaTab.model.BendPoint? = null
    
    /**
     * Gets or sets the highest point with for the lowest whammy bar value.
     */
    public var minWhammyPoint: alphaTab.model.BendPoint? = null
    
    public val hasWhammyBar: Boolean
    get(){
        return this.whammyBarPoints != null && this.whammyBarType != alphaTab.model.WhammyType.None
    }
    
    /**
     * Gets or sets the vibrato effect used on this beat.
     */
    public var vibrato: alphaTab.model.VibratoType = alphaTab.model.VibratoType.None
    
    /**
     * Gets or sets the ID of the chord used on this beat.
     */
    public var chordId: String? = null
    
    public val hasChord: Boolean
    get(){
        return !!alphaTab.core.TypeHelper.isTruthy(this.chordId)
    }
    
    public val chord: alphaTab.model.Chord?
    get(){
        return if(alphaTab.core.TypeHelper.isTruthy(this.chordId))  this.voice.bar.staff.getChord(this.chordId!!)!! else null
    }
    
    /**
     * Gets or sets the grace style of this beat.
     */
    public var graceType: alphaTab.model.GraceType = alphaTab.model.GraceType.None
    
    /**
     * Gets or sets the grace group this beat belongs to.
     * If this beat is not a grace note, it holds the group which belongs to this beat.
     */
    public var graceGroup: alphaTab.model.GraceGroup? = null
    
    /**
     * Gets or sets the index of this beat within the grace group if
     * this is a grace beat.
     */
    public var graceIndex: Double = -1.0
    
    /**
     * Gets or sets the pickstroke applied on this beat.
     */
    public var pickStroke: alphaTab.model.PickStroke = alphaTab.model.PickStroke.None
    
    public val isTremolo: Boolean
    get(){
        return !!alphaTab.core.TypeHelper.isTruthy(this.tremoloSpeed)
    }
    
    /**
     * Gets or sets the speed of the tremolo effect.
     */
    public var tremoloSpeed: alphaTab.model.Duration? = null
    
    /**
     * Gets or sets whether a crescendo/decrescendo is applied on this beat.
     */
    public var crescendo: alphaTab.model.CrescendoType = alphaTab.model.CrescendoType.None
    
    /**
     * The timeline position of the voice within the current bar as it is displayed. (unit: midi ticks)
     * This might differ from the actual playback time due to special grace types.
     */
    public var displayStart: Double = 0.0
    
    /**
     * The timeline position of the voice within the current bar as it is played. (unit: midi ticks)
     * This might differ from the actual playback time due to special grace types.
     */
    public var playbackStart: Double = 0.0
    
    /**
     * Gets or sets the duration that is used for the display of this beat. It defines the size/width of the beat in
     * the music sheet. (unit: midi ticks).
     */
    public var displayDuration: Double = 0.0
    
    /**
     * Gets or sets the duration that the note is played during the audio generation.
     */
    public var playbackDuration: Double = 0.0
    
    public val absoluteDisplayStart: Double
    get(){
        return this.voice.bar.masterBar.start + this.displayStart
    }
    
    public val absolutePlaybackStart: Double
    get(){
        return this.voice.bar.masterBar.start + this.playbackStart
    }
    
    /**
     * Gets or sets the dynamics applied to this beat.
     */
    public var dynamics: alphaTab.model.DynamicValue = alphaTab.model.DynamicValue.F
    
    /**
     * Gets or sets a value indicating whether the beam direction should be inverted.
     */
    public var invertBeamDirection: Boolean = false
    
    /**
     * Gets or sets the preferred beam direction as specified in the input source.
     */
    public var preferredBeamDirection: alphaTab.rendering.utils.BeamDirection? = null
    
    public var isEffectSlurOrigin: Boolean = false
    
    public val isEffectSlurDestination: Boolean
    get(){
        return !!alphaTab.core.TypeHelper.isTruthy(this.effectSlurOrigin)
    }
    
    public var effectSlurOrigin: alphaTab.model.Beat? = null
    
    public var effectSlurDestination: alphaTab.model.Beat? = null
    
    /**
     * Gets or sets how the beaming should be done for this beat.
     */
    public var beamingMode: alphaTab.model.BeatBeamingMode = alphaTab.model.BeatBeamingMode.Auto
    
    /**
     */
    public fun addWhammyBarPoint(point: alphaTab.model.BendPoint): Unit{
        var points: alphaTab.collections.List<alphaTab.model.BendPoint>? = this.whammyBarPoints
        if (points == null)
        {
            points = alphaTab.collections.List(
            )
            
            this.whammyBarPoints = points
        }
        points.push(point)
        if (!alphaTab.core.TypeHelper.isTruthy(this.maxWhammyPoint) || point.value > this.maxWhammyPoint!!.value)
        {
            this.maxWhammyPoint = point
        }
        if (!alphaTab.core.TypeHelper.isTruthy(this.minWhammyPoint) || point.value < this.minWhammyPoint!!.value)
        {
            this.minWhammyPoint = point
        }
        if (this.whammyBarType == alphaTab.model.WhammyType.None)
        {
            this.whammyBarType = alphaTab.model.WhammyType.Custom
        }
    }
    
    /**
     */
    public fun removeWhammyBarPoint(index: Double): Unit{
        var points: alphaTab.collections.List<alphaTab.model.BendPoint>? = this.whammyBarPoints
        if (points == null || index < 0 || index >= points.length)
        {
            return
        }
        points.splice(index, 1.0)
        var point: alphaTab.model.BendPoint = points[(index).toInt()]
        if (point == this.maxWhammyPoint)
        {
            this.maxWhammyPoint = null
            for (currentPoint in points)
            {
                if (!alphaTab.core.TypeHelper.isTruthy(this.maxWhammyPoint) || currentPoint.value > this.maxWhammyPoint!!.value)
                {
                    this.maxWhammyPoint = currentPoint
                }
            }
        }
        if (point == this.minWhammyPoint)
        {
            this.minWhammyPoint = null
            for (currentPoint in points)
            {
                if (!alphaTab.core.TypeHelper.isTruthy(this.minWhammyPoint) || currentPoint.value < this.minWhammyPoint!!.value)
                {
                    this.minWhammyPoint = currentPoint
                }
            }
        }
    }
    
    /**
     */
    public fun addNote(note: alphaTab.model.Note): Unit{
        note.beat = this
        note.index = this.notes.length
        this.notes.push(note)
        if (note.isStringed)
        {
            this.noteStringLookup.set(note.string, note)
        }
    }
    
    /**
     */
    public fun removeNote(note: alphaTab.model.Note): Unit{
        var index: Double = this.notes.indexOf(note)
        if (index >= 0)
        {
            this.notes.splice(index, 1.0)
            if (note.isStringed)
            {
                this.noteStringLookup.delete(note.string)
            }
        }
    }
    
    /**
     */
    public fun getAutomation(type: alphaTab.model.AutomationType): alphaTab.model.Automation?{
        if(true) {
            var i: Double = 0.0
            var j: Double = this.automations.length
            
            while(i < j){
                try{
                    var automation: alphaTab.model.Automation = this.automations[(i).toInt()]
                    if (automation.type == type)
                    {
                        return automation
                    }
                }
                finally{
                    i++
                }
            }
        }
        return null
    }
    
    /**
     */
    public fun getNoteOnString(noteString: Double): alphaTab.model.Note?{
        if (this.noteStringLookup.has(noteString))
        {
            return this.noteStringLookup.get(noteString)!!
        }
        return null
    }
    
    private fun calculateDuration(): Double{
        if (this.isFullBarRest)
        {
            return this.voice.bar.masterBar.calculateDuration()
        }
        var ticks: Double = alphaTab.midi.MidiUtils.toTicks(this.duration)
        if (this.dots == 2.0)
        {
            ticks = alphaTab.midi.MidiUtils.applyDot(ticks, true)
        }
        else if (this.dots == 1.0)
        {
            ticks = alphaTab.midi.MidiUtils.applyDot(ticks, false)
        }
        if (this.tupletDenominator > 0 && this.tupletNumerator >= 0)
        {
            ticks = alphaTab.midi.MidiUtils.applyTuplet(ticks, this.tupletNumerator, this.tupletDenominator)
        }
        return ticks
    }
    
    public fun updateDurations(): Unit{
        var ticks: Double = this.calculateDuration()
        this.playbackDuration = ticks
        when (this.graceType)
        {
            alphaTab.model.GraceType.BeforeBeat, alphaTab.model.GraceType.OnBeat -> 
            {
                when (this.duration)
                {
                    alphaTab.model.Duration.Sixteenth -> 
                    {
                        this.playbackDuration = alphaTab.midi.MidiUtils.toTicks(alphaTab.model.Duration.SixtyFourth)
                    }
                    alphaTab.model.Duration.ThirtySecond -> 
                    {
                        this.playbackDuration = alphaTab.midi.MidiUtils.toTicks(alphaTab.model.Duration.OneHundredTwentyEighth)
                    }
                    else -> 
                    {
                        this.playbackDuration = alphaTab.midi.MidiUtils.toTicks(alphaTab.model.Duration.ThirtySecond)
                    }
                }
                this.displayDuration = 0.0
            }
            alphaTab.model.GraceType.BendGrace -> 
            {
                this.playbackDuration /= 2.0
                this.displayDuration = 0.0
            }
            else -> 
            {
                this.displayDuration = ticks
                var previous: alphaTab.model.Beat? = this.previousBeat
                if (alphaTab.core.TypeHelper.isTruthy(previous) && previous.graceType == alphaTab.model.GraceType.BendGrace)
                {
                    this.playbackDuration = previous.playbackDuration
                }
            }
        }
    }
    
    public fun finishTuplet(): Unit{
        var previousBeat: alphaTab.model.Beat? = this.previousBeat
        var currentTupletGroup: alphaTab.model.TupletGroup? = if(alphaTab.core.TypeHelper.isTruthy(previousBeat))  previousBeat.tupletGroup else null
        if (this.hasTuplet || (this.graceType != alphaTab.model.GraceType.None && alphaTab.core.TypeHelper.isTruthy(currentTupletGroup)))
        {
            if (!alphaTab.core.TypeHelper.isTruthy(previousBeat) || !alphaTab.core.TypeHelper.isTruthy(currentTupletGroup) || !currentTupletGroup.check(this))
            {
                currentTupletGroup = alphaTab.model.TupletGroup(this.voice)
                currentTupletGroup.check(this)
            }
            this.tupletGroup = currentTupletGroup
        }
    }
    
    /**
     */
    public fun finish(settings: alphaTab.Settings, sharedDataBag: alphaTab.collections.Map<String, Any?>? = null): Unit{
        if (this.getAutomation(alphaTab.model.AutomationType.Instrument) == null && this.index == 0.0 && this.voice.index == 0.0 && this.voice.bar.index == 0.0 && this.voice.bar.staff.index == 0.0)
        {
            this.automations.push(alphaTab.model.Automation.buildInstrumentAutomation(false, 0.0, this.voice.bar.staff.track.playbackInfo.program))
        }
        when (this.graceType)
        {
            alphaTab.model.GraceType.OnBeat, alphaTab.model.GraceType.BeforeBeat -> 
            {
                var numberOfGraceBeats: Double = this.graceGroup!!.beats.length
                if (numberOfGraceBeats == 1.0)
                {
                    this.duration = alphaTab.model.Duration.Eighth
                }
                else if (numberOfGraceBeats == 2.0)
                {
                    this.duration = alphaTab.model.Duration.Sixteenth
                }
                else 
                {
                    this.duration = alphaTab.model.Duration.ThirtySecond
                }
            }
            else -> { }
        }
        var displayMode: alphaTab.NotationMode = if(!alphaTab.core.TypeHelper.isTruthy(settings))  alphaTab.NotationMode.GuitarPro else settings.notation.notationMode
        var isGradual: Boolean = this.text == "grad" || this.text == "grad."
        if (isGradual && displayMode == alphaTab.NotationMode.SongBook)
        {
            this.text = ""
        }
        var needCopyBeatForBend: Boolean = false
        this.minNote = null
        this.maxNote = null
        this.minStringNote = null
        this.maxStringNote = null
        var visibleNotes: Double = 0.0
        var isEffectSlurBeat: Boolean = false
        if(true) {
            var i: Double = 0.0
            var j: Double = this.notes.length
            
            while(i < j){
                try{
                    var note: alphaTab.model.Note = this.notes[(i).toInt()]
                    note.dynamics = this.dynamics
                    note.finish(settings, sharedDataBag)
                    if (note.isLetRing)
                    {
                        this.isLetRing = true
                    }
                    if (note.isPalmMute)
                    {
                        this.isPalmMute = true
                    }
                    if (displayMode == alphaTab.NotationMode.SongBook && note.hasBend && this.graceType != alphaTab.model.GraceType.BendGrace)
                    {
                        if (!note.isTieOrigin)
                        {
                            when (note.bendType)
                            {
                                alphaTab.model.BendType.Bend, alphaTab.model.BendType.PrebendRelease, alphaTab.model.BendType.PrebendBend -> 
                                {
                                    needCopyBeatForBend = true
                                }
                                else -> { }
                            }
                        }
                        if (isGradual || note.bendStyle == alphaTab.model.BendStyle.Gradual)
                        {
                            isGradual = true
                            note.bendStyle = alphaTab.model.BendStyle.Gradual
                            needCopyBeatForBend = false
                        }
                        else 
                        {
                            note.bendStyle = alphaTab.model.BendStyle.Fast
                        }
                    }
                    if (note.isVisible)
                    {
                        visibleNotes++
                        if (!alphaTab.core.TypeHelper.isTruthy(this.minNote) || note.realValue < this.minNote!!.realValue)
                        {
                            this.minNote = note
                        }
                        if (!alphaTab.core.TypeHelper.isTruthy(this.maxNote) || note.realValue > this.maxNote!!.realValue)
                        {
                            this.maxNote = note
                        }
                        if (!alphaTab.core.TypeHelper.isTruthy(this.minStringNote) || note.string < this.minStringNote!!.string)
                        {
                            this.minStringNote = note
                        }
                        if (!alphaTab.core.TypeHelper.isTruthy(this.maxStringNote) || note.string > this.maxStringNote!!.string)
                        {
                            this.maxStringNote = note
                        }
                        if (note.hasEffectSlur)
                        {
                            isEffectSlurBeat = true
                        }
                    }
                }
                finally{
                    i++
                }
            }
        }
        if (isEffectSlurBeat)
        {
            if (alphaTab.core.TypeHelper.isTruthy(this.effectSlurOrigin))
            {
                this.effectSlurOrigin!!.effectSlurDestination = this.nextBeat
                if (alphaTab.core.TypeHelper.isTruthy(this.effectSlurOrigin!!.effectSlurDestination))
                {
                    this.effectSlurOrigin!!.effectSlurDestination!!.effectSlurOrigin = this.effectSlurOrigin
                }
                this.effectSlurOrigin = null
            }
            else 
            {
                this.isEffectSlurOrigin = true
                this.effectSlurDestination = this.nextBeat
                if (alphaTab.core.TypeHelper.isTruthy(this.effectSlurDestination))
                {
                    this.effectSlurDestination!!.effectSlurOrigin = this
                }
            }
        }
        if (this.notes.length > 0 && visibleNotes == 0.0)
        {
            this.isEmpty = true
        }
        if (!this.isRest && (!this.isLetRing || !this.isPalmMute))
        {
            var currentBeat: alphaTab.model.Beat? = this.previousBeat
            while (alphaTab.core.TypeHelper.isTruthy(currentBeat) && currentBeat.isRest)
            {
                if (!this.isLetRing)
                {
                    currentBeat.isLetRing = false
                }
                if (!this.isPalmMute)
                {
                    currentBeat.isPalmMute = false
                }
                currentBeat = currentBeat.previousBeat
            }
        }
        else if (this.isRest && alphaTab.core.TypeHelper.isTruthy(this.previousBeat) && alphaTab.core.TypeHelper.isTruthy(settings) && settings.notation.notationMode == alphaTab.NotationMode.GuitarPro)
        {
            if (this.previousBeat!!.isLetRing)
            {
                this.isLetRing = true
            }
            if (this.previousBeat!!.isPalmMute)
            {
                this.isPalmMute = true
            }
        }
        var points: alphaTab.collections.List<alphaTab.model.BendPoint>? = this.whammyBarPoints
        if (points != null && points.length > 0 && this.whammyBarType == alphaTab.model.WhammyType.Custom)
        {
            if (displayMode == alphaTab.NotationMode.SongBook)
            {
                this.whammyStyle = if(isGradual)  alphaTab.model.BendStyle.Gradual else alphaTab.model.BendStyle.Fast
            }
            var isContinuedWhammy: Boolean = !!alphaTab.core.TypeHelper.isTruthy(this.previousBeat) && this.previousBeat!!.hasWhammyBar
            this.isContinuedWhammy = isContinuedWhammy
            if (points.length == 4.0)
            {
                var origin: alphaTab.model.BendPoint = points[(0).toInt()]
                var middle1: alphaTab.model.BendPoint = points[(1).toInt()]
                var middle2: alphaTab.model.BendPoint = points[(2).toInt()]
                var destination: alphaTab.model.BendPoint = points[(3).toInt()]
                if (middle1.value == middle2.value)
                {
                    if ((origin.value < middle1.value && middle1.value < destination.value) || (origin.value > middle1.value && middle1.value > destination.value))
                    {
                        if (origin.value != 0.0 && !isContinuedWhammy)
                        {
                            this.whammyBarType = alphaTab.model.WhammyType.PrediveDive
                        }
                        else 
                        {
                            this.whammyBarType = alphaTab.model.WhammyType.Dive
                        }
                        points.splice(2.0, 1.0)
                        points.splice(1.0, 1.0)
                    }
                    else if ((origin.value > middle1.value && middle1.value < destination.value) || (origin.value < middle1.value && middle1.value > destination.value))
                    {
                        this.whammyBarType = alphaTab.model.WhammyType.Dip
                        if (middle1.offset == middle2.offset || displayMode == alphaTab.NotationMode.SongBook)
                        {
                            points.splice(2.0, 1.0)
                        }
                    }
                    else if (origin.value == middle1.value && middle1.value == destination.value)
                    {
                        if (origin.value != 0.0 && !isContinuedWhammy)
                        {
                            this.whammyBarType = alphaTab.model.WhammyType.Predive
                        }
                        else 
                        {
                            this.whammyBarType = alphaTab.model.WhammyType.Hold
                        }
                        points.splice(2.0, 1.0)
                        points.splice(1.0, 1.0)
                    }
                }
            }
        }
        this.updateDurations()
        if (needCopyBeatForBend)
        {
            var cloneBeat: alphaTab.model.Beat = alphaTab.generated.model.BeatCloner.clone(this)
            cloneBeat.id = alphaTab.model.Beat._globalBeatId++
            cloneBeat.pickStroke = alphaTab.model.PickStroke.None
            if(true) {
                var i: Double = 0.0
                var j: Double = cloneBeat.notes.length
                
                while(i < j){
                    try{
                        var cloneNote: alphaTab.model.Note = cloneBeat.notes[(i).toInt()]
                        var note: alphaTab.model.Note = this.notes[(i).toInt()]
                        cloneNote.bendType = alphaTab.model.BendType.None
                        cloneNote.maxBendPoint = null
                        cloneNote.bendPoints = null
                        cloneNote.bendStyle = alphaTab.model.BendStyle.Default
                        cloneNote.id = alphaTab.model.Note.GlobalNoteId++
                        if (note.isTieOrigin)
                        {
                            cloneNote.tieDestination = note.tieDestination!!
                            note.tieDestination!!.tieOrigin = cloneNote
                        }
                        if (note.isTieDestination)
                        {
                            cloneNote.tieOrigin = if(alphaTab.core.TypeHelper.isTruthy(note.tieOrigin))  note.tieOrigin else null
                            note.tieOrigin!!.tieDestination = cloneNote
                        }
                        if (note.hasBend && note.isTieOrigin)
                        {
                            var tieDestination: alphaTab.model.Note? = alphaTab.model.Note.findTieOrigin(note)
                            if (alphaTab.core.TypeHelper.isTruthy(tieDestination) && tieDestination.hasBend)
                            {
                                cloneNote.bendType = alphaTab.model.BendType.Hold
                                var lastPoint: alphaTab.model.BendPoint = note.bendPoints!![(note.bendPoints!!.length - 1.0).toInt()]
                                cloneNote.addBendPoint(alphaTab.model.BendPoint(0.0, lastPoint.value))
                                cloneNote.addBendPoint(alphaTab.model.BendPoint(alphaTab.model.BendPoint.MaxPosition, lastPoint.value))
                            }
                        }
                        cloneNote.isTieDestination = true
                    }
                    finally{
                        i++
                    }
                }
            }
            this.graceType = alphaTab.model.GraceType.BendGrace
            this.graceGroup = alphaTab.model.GraceGroup()
            this.graceGroup!!.addBeat(this)
            this.graceGroup!!.isComplete = true
            this.graceGroup!!.finish()
            this.updateDurations()
            this.voice.insertBeat(this, cloneBeat)
            cloneBeat.graceGroup = alphaTab.model.GraceGroup()
            cloneBeat.graceGroup!!.addBeat(this)
            cloneBeat.graceGroup!!.isComplete = true
            cloneBeat.graceGroup!!.finish()
        }
    }
    
    /**
     * Checks whether the current beat is timewise before the given beat.
     */
    public fun isBefore(beat: alphaTab.model.Beat): Boolean{
        return (this.voice.bar.index < beat.voice.bar.index || (beat.voice.bar.index == this.voice.bar.index && this.index < beat.index))
    }
    
    /**
     * Checks whether the current beat is timewise after the given beat.
     */
    public fun isAfter(beat: alphaTab.model.Beat): Boolean{
        return (this.voice.bar.index > beat.voice.bar.index || (beat.voice.bar.index == this.voice.bar.index && this.index > beat.index))
    }
    
    /**
     */
    public fun hasNoteOnString(noteString: Double): Boolean{
        return this.noteStringLookup.has(noteString)
    }
    
    /**
     */
    public fun getNoteWithRealValue(noteRealValue: Double): alphaTab.model.Note?{
        if (this.noteValueLookup.has(noteRealValue))
        {
            return this.noteValueLookup.get(noteRealValue)!!
        }
        return null
    }
    
    /**
     */
    public fun chain(sharedDataBag: alphaTab.collections.Map<String, Any?>? = null): Unit{
        for (n in this.notes)
        {
            this.noteValueLookup.set(n.realValue, n)
            n.chain(sharedDataBag)
        }
    }
    
    companion object{
        @kotlin.jvm.JvmStatic
        private var _globalBeatId: Double = 0.0
        
    }
    public constructor()
}

/**
 * Lists the different modes on how beaming for a beat should be done.
 */
public enum class BeatBeamingMode(override val value: Int): alphaTab.core.IAlphaTabEnum
{
    /**
     * Automatic beaming based on the timing rules.
     */
    Auto(0),
    /**
     * Force a split to the next beat.
     */
    ForceSplitToNext(1),
    /**
     * Force a merge with the next beat.
     */
    ForceMergeWithNext(2);
    companion object{
        public fun fromValue(v:Double): BeatBeamingMode{
            return when(v.toInt()){
                Auto.value -> Auto
                ForceSplitToNext.value -> ForceSplitToNext
                ForceMergeWithNext.value -> ForceMergeWithNext
                else -> throw ClassCastException("No enum with value $v found")}
        }
    }
}

