// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.model
import alphaTab.core.*

@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
public class Color
{
    public constructor(r: Double, g: Double, b: Double, a: Double = 255.0){
        this.raw = ((((a).toInt() and 255) shl 24) or (((r).toInt() and 255) shl 16) or (((g).toInt() and 255) shl 8) or ((b).toInt() and 255)).toDouble()
        this.updateRgba()
    }
    
    public fun updateRgba(): Unit{
        if (this.a == 255.0)
        {
            this.rgba = "#" + alphaTab.model.ModelUtils.toHexString(this.r, 2.0) + alphaTab.model.ModelUtils.toHexString(this.g, 2.0) + alphaTab.model.ModelUtils.toHexString(this.b, 2.0)
        }
        else 
        {
            this.rgba = """rgba(${(this.r).toTemplate()},${(this.g).toTemplate()},${(this.b).toTemplate()},${(this.a / (255.0).toDouble()).toTemplate()})"""
        }
    }
    
    /**
     * Gets or sets the raw RGBA value.
     */
    public var raw: Double = 0.0
    
    public val a: Double
    get(){
        return (((this.raw).toInt() shr 24) and 255).toDouble()
    }
    
    public val r: Double
    get(){
        return (((this.raw).toInt() shr 16) and 255).toDouble()
    }
    
    public val g: Double
    get(){
        return (((this.raw).toInt() shr 8) and 255).toDouble()
    }
    
    public val b: Double
    get(){
        return ((this.raw).toInt() and 255).toDouble()
    }
    
    /**
     * Gets the RGBA hex string to use in CSS areas.
     */
    public lateinit var rgba: String
    companion object{
        @kotlin.jvm.JvmStatic
        public val BlackRgb: String = "#000000"
        
        /**
         */
        @kotlin.jvm.JvmStatic
        public fun random(opacity: Double = 100.0): alphaTab.model.Color{
            return alphaTab.model.Color((((alphaTab.core.ecmaScript.Math.random() * 255.0)).toInt() or 0).toDouble(), (((alphaTab.core.ecmaScript.Math.random() * 255.0)).toInt() or 0).toDouble(), (((alphaTab.core.ecmaScript.Math.random() * 255.0)).toInt() or 0).toDouble(), opacity)
        }
        
        /**
         */
        @kotlin.jvm.JvmStatic
        public fun fromJson(v: Any?): alphaTab.model.Color?{
            when (alphaTab.core.TypeHelper.typeOf(v))
            {
                "number" -> 
                {
                    var c: alphaTab.model.Color = alphaTab.model.Color(0.0, 0.0, 0.0, 0.0)
                    c.raw = v!!.toDouble()
                    c.updateRgba()
                    return c
                }
                "string" -> 
                {
                    var json: String = v.toString()
                    if (json.startsWith("#"))
                    {
                        if (json.length.toDouble() == 4.0)
                        {
                            return alphaTab.model.Color(alphaTab.core.Globals.parseInt(json[1.0], 16.0) * 17.0, alphaTab.core.Globals.parseInt(json[2.0], 16.0) * 17.0, alphaTab.core.Globals.parseInt(json[3.0], 16.0) * 17.0)
                        }
                        if (json.length.toDouble() == 5.0)
                        {
                            return alphaTab.model.Color(alphaTab.core.Globals.parseInt(json[1.0], 16.0) * 17.0, alphaTab.core.Globals.parseInt(json[2.0], 16.0) * 17.0, alphaTab.core.Globals.parseInt(json[3.0], 16.0) * 17.0, alphaTab.core.Globals.parseInt(json[4.0], 16.0) * 17.0)
                        }
                        if (json.length.toDouble() == 7.0)
                        {
                            return alphaTab.model.Color(alphaTab.core.Globals.parseInt(json.substring(1.0, 3.0), 16.0), alphaTab.core.Globals.parseInt(json.substring(3.0, 5.0), 16.0), alphaTab.core.Globals.parseInt(json.substring(5.0, 7.0), 16.0))
                        }
                        if (json.length.toDouble() == 9.0)
                        {
                            return alphaTab.model.Color(alphaTab.core.Globals.parseInt(json.substring(1.0, 3.0), 16.0), alphaTab.core.Globals.parseInt(json.substring(3.0, 5.0), 16.0), alphaTab.core.Globals.parseInt(json.substring(5.0, 7.0), 16.0), alphaTab.core.Globals.parseInt(json.substring(7.0, 9.0), 16.0))
                        }
                    }
                    else if (json.startsWith("rgba") || json.startsWith("rgb"))
                    {
                        var start: Double = json.indexOfInDouble("(")
                        var end: Double = json.lastIndexOfInDouble(")")
                        if (start == -1.0 || end == -1.0)
                        {
                            throw alphaTab.FormatError("No values specified for rgb/rgba function")
                        }
                        var numbers: alphaTab.collections.List<String> = json.substring(start + 1.0, end).splitBy(",")
                        if (numbers.length == 3.0)
                        {
                            return alphaTab.model.Color(alphaTab.core.Globals.parseInt(numbers[(0).toInt()]), alphaTab.core.Globals.parseInt(numbers[(1).toInt()]), alphaTab.core.Globals.parseInt(numbers[(2).toInt()]))
                        }
                        if (numbers.length == 4.0)
                        {
                            return alphaTab.model.Color(alphaTab.core.Globals.parseInt(numbers[(0).toInt()]), alphaTab.core.Globals.parseInt(numbers[(1).toInt()]), alphaTab.core.Globals.parseInt(numbers[(2).toInt()]), alphaTab.core.Globals.parseFloat(numbers[(3).toInt()]) * 255.0)
                        }
                    }
                    return null
                }
                else -> { }
            }
            throw alphaTab.FormatError("Unsupported format for color")
        }
        
        /**
         */
        @kotlin.jvm.JvmStatic
        public fun toJson(obj: alphaTab.model.Color): Double{
            return obj.raw
        }
        
    }
}

