// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.model
import alphaTab.core.*

@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
public class Font
{
    private var _css: String
    
    private var _cssScale: Double = 0.0
    
    private var _families: alphaTab.collections.List<String>
    
    private var _style: alphaTab.model.FontStyle
    
    private var _weight: alphaTab.model.FontWeight
    
    private var _size: Double
    
    private fun reset(): Unit{
        this._cssScale = 0.0
        this._css = this.toCssString()
    }
    
    public var family: String
    get(){
        return this._families[(0).toInt()]
    }
    set(value){
        this.families = alphaTab.model.FontParser.parseFamilies(value)
    }
    
    public var families: alphaTab.collections.List<String>
    get(){
        return this._families
    }
    set(value){
        this._families = value
        this.reset()
    }
    
    public var size: Double
    get(){
        return this._size
    }
    set(value){
        this._size = value
        this.reset()
    }
    
    public var style: alphaTab.model.FontStyle
    get(){
        return this._style
    }
    set(value){
        this._style = value
        this.reset()
    }
    
    public var weight: alphaTab.model.FontWeight
    get(){
        return this._weight
    }
    set(value){
        this._weight = value
        this.reset()
    }
    
    public val isBold: Boolean
    get(){
        return this.weight == alphaTab.model.FontWeight.Bold
    }
    
    public val isItalic: Boolean
    get(){
        return this.style == alphaTab.model.FontStyle.Italic
    }
    
    public constructor(family: String, size: Double, style: alphaTab.model.FontStyle = alphaTab.model.FontStyle.Plain, weight: alphaTab.model.FontWeight = alphaTab.model.FontWeight.Regular){
        this._families = alphaTab.model.FontParser.parseFamilies(family)
        this._size = size
        this._style = style
        this._weight = weight
        this._css = this.toCssString()
    }
    
    /**
     */
    public fun toCssString(scale: Double = 1.0): String{
        if (!alphaTab.core.TypeHelper.isTruthy(this._css) || !(alphaTab.core.ecmaScript.Math.abs(scale - this._cssScale) < 0.01))
        {
            var buf: String = ""
            if (this.isBold)
            {
                buf += "bold "
            }
            if (this.isItalic)
            {
                buf += "italic "
            }
            buf += (this.size * scale).toInvariantString()
            buf += "px "
            buf += this.families.map(fun(f: String): String{
                return alphaTab.model.FontParser.quoteFont(f)
            }
            ).join(", ")
            this._css = buf
            this._cssScale = scale
        }
        return this._css
    }
    
    companion object{
        /**
         * Initializes a new instance of the  class.
         * @param families The families.
         * @param size The size.
         * @param style The style.
         * @param weight The weight.
         */
        @kotlin.jvm.JvmStatic
        public fun withFamilyList(families: alphaTab.collections.List<String>, size: Double, style: alphaTab.model.FontStyle = alphaTab.model.FontStyle.Plain, weight: alphaTab.model.FontWeight = alphaTab.model.FontWeight.Regular): alphaTab.model.Font{
            var f: alphaTab.model.Font = alphaTab.model.Font("", size, style, weight)
            f.families = families
            return f
        }
        
        /**
         */
        @kotlin.jvm.JvmStatic
        public fun fromJson(v: Any?): alphaTab.model.Font?{
            when (alphaTab.core.TypeHelper.typeOf(v))
            {
                "undefined" -> 
                {
                    return null
                }
                "object" -> 
                {
                    var m: alphaTab.collections.Map<String, Any?> = (v as alphaTab.collections.Map<String, Any?>)
                    var families: alphaTab.collections.List<String> = (m.get("families") as alphaTab.collections.List<String>)
                    var size: Double = m.get("size")!!.toDouble()
                    var style: alphaTab.model.FontStyle = alphaTab.io.JsonHelperPartials.parseEnum<alphaTab.model.FontStyle>(m.get("style"), alphaTab.model.FontStyle::class)!!
                    var weight: alphaTab.model.FontWeight = alphaTab.io.JsonHelperPartials.parseEnum<alphaTab.model.FontWeight>(m.get("weight"), alphaTab.model.FontWeight::class)!!
                    return alphaTab.model.Font.withFamilyList(families, size, style, weight)
                }
                "string" -> 
                {
                    var parser: alphaTab.model.FontParser = alphaTab.model.FontParser(v.toString())
                    parser.parse()
                    var families: alphaTab.collections.List<String> = parser.families
                    var fontSizeString: String = parser.size.lowercase()
                    var fontSize: Double = 0.0
                    when (fontSizeString)
                    {
                        "xx-small" -> 
                        {
                            fontSize = 7.0
                        }
                        "x-small" -> 
                        {
                            fontSize = 10.0
                        }
                        "small", "smaller" -> 
                        {
                            fontSize = 13.0
                        }
                        "medium" -> 
                        {
                            fontSize = 16.0
                        }
                        "large", "larger" -> 
                        {
                            fontSize = 18.0
                        }
                        "x-large" -> 
                        {
                            fontSize = 24.0
                        }
                        "xx-large" -> 
                        {
                            fontSize = 32.0
                        }
                        else -> 
                        {
                            try
                            {
                                if (fontSizeString.endsWith("em"))
                                {
                                    fontSize = alphaTab.core.Globals.parseFloat(fontSizeString.substr(0.0, fontSizeString.length.toDouble() - 2.0)) * 16.0
                                }
                                else if (fontSizeString.endsWith("pt"))
                                {
                                    fontSize = (alphaTab.core.Globals.parseFloat(fontSizeString.substr(0.0, fontSizeString.length.toDouble() - 2.0)) * 16.0) / (12.0).toDouble()
                                }
                                else if (fontSizeString.endsWith("px"))
                                {
                                    fontSize = alphaTab.core.Globals.parseFloat(fontSizeString.substr(0.0, fontSizeString.length.toDouble() - 2.0))
                                }
                                else 
                                {
                                    fontSize = 12.0
                                }
                            }
                            catch (e: kotlin.Throwable)
                            {
                                fontSize = 12.0
                            }
                        }
                    }
                    var fontStyle: alphaTab.model.FontStyle = alphaTab.model.FontStyle.Plain
                    if (parser.style == "italic")
                    {
                        fontStyle = alphaTab.model.FontStyle.Italic
                    }
                    var fontWeight: alphaTab.model.FontWeight = alphaTab.model.FontWeight.Regular
                    var fontWeightString: String = parser.weight.lowercase()
                    when (fontWeightString)
                    {
                        "normal", "lighter" -> 
                        {
                        }
                        else -> 
                        {
                            fontWeight = alphaTab.model.FontWeight.Bold
                        }
                    }
                    return alphaTab.model.Font.withFamilyList(families, fontSize, fontStyle, fontWeight)
                }
                else -> 
                {
                    return null
                }
            }
        }
        
        /**
         */
        @kotlin.jvm.JvmStatic
        public fun toJson(font: alphaTab.model.Font): alphaTab.collections.Map<String, Any?>{
            var o: alphaTab.collections.Map<String, Any?> = alphaTab.collections.Map<String, Any?>()
            o.set("families", font.families)
            o.set("size", font.size)
            o.set("style", font.style.toDouble())
            o.set("weight", font.weight.toDouble())
            return o
        }
        
    }
}

/**
 * Lists all flags for font styles.
 */
public enum class FontStyle(override val value: Int): alphaTab.core.IAlphaTabEnum
{
    /**
     * No flags.
     */
    Plain(0),
    /**
     * Font is italic.
     */
    Italic(1);
    companion object{
        public fun fromValue(v:Double): FontStyle{
            return when(v.toInt()){
                Plain.value -> Plain
                Italic.value -> Italic
                else -> throw ClassCastException("No enum with value $v found")}
        }
    }
}

/**
 * Lists all font weight values.
 */
public enum class FontWeight(override val value: Int): alphaTab.core.IAlphaTabEnum
{
    /**
     * Not bold
     */
    Regular(0),
    /**
     * Font is bold
     */
    Bold(1);
    companion object{
        public fun fromValue(v:Double): FontWeight{
            return when(v.toInt()){
                Regular.value -> Regular
                Bold.value -> Bold
                else -> throw ClassCastException("No enum with value $v found")}
        }
    }
}

/**
 * A very basic font parser which parses the fields according to
 * https://www.w3.org/TR/CSS21/fonts.html#propdef-font
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class FontParserToken
{
    public var startPos: Double
    public var endPos: Double
    public var text: String
    public constructor(text: String, startPos: Double, endPos: Double){
        this.text = text
        this.startPos = startPos
        this.endPos = endPos
    }
    
}

@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class FontParser
{
    public var style: String = "normal"
    
    public var variant: String = "normal"
    
    public var weight: String = "normal"
    
    public var stretch: String = "normal"
    
    public var lineHeight: String = "normal"
    
    public var size: String = "1rem"
    
    public var families: alphaTab.collections.List<String> = alphaTab.collections.List<String>(
    )
    
    
    public var parseOnlyFamilies: Boolean = false
    
    private var _tokens: alphaTab.collections.List<alphaTab.model.FontParserToken>
    
    private var _currentTokenIndex: Double = -1.0
    
    private var _input: String = ""
    
    private var _currentToken: alphaTab.model.FontParserToken? = null
    
    public constructor(input: String){
        this._input = input
        this._tokens = this.splitToTokens(input)
    }
    
    /**
     */
    private fun splitToTokens(input: String): alphaTab.collections.List<alphaTab.model.FontParserToken>{
        var tokens: alphaTab.collections.List<alphaTab.model.FontParserToken> = alphaTab.collections.List<alphaTab.model.FontParserToken>(
        )
        
        var startPos: Double = 0.0
        while (startPos < input.length.toDouble())
        {
            var endPos: Double = startPos
            while (endPos < input.length.toDouble() && input.charAt(endPos) != " ")
            {
                endPos++
            }
            if (endPos > startPos)
            {
                tokens.push(alphaTab.model.FontParserToken(input.substring(startPos, endPos), startPos, endPos))
            }
            startPos = endPos + 1.0
        }
        return tokens
    }
    
    public fun parse(): Unit{
        this.reset()
        if (this._tokens.length == 1.0)
        {
            when (this._currentToken?.text)
            {
                "caption", "icon", "menu", "message-box", "small-caption", "status-bar", "inherit" -> 
                {
                    return
                }
                else -> { }
            }
        }
        if (!this.parseOnlyFamilies)
        {
            this.fontStyleVariantWeight()
            this.fontSizeLineHeight()
        }
        this.fontFamily()
    }
    
    private fun fontFamily(): Unit{
        if (!alphaTab.core.TypeHelper.isTruthy(this._currentToken))
        {
            if (this.parseOnlyFamilies)
            {
                return
            }
            else 
            {
                throw alphaTab.core.ecmaScript.Error("Missing font list")
            }
        }
        var familyListInput: String = this._input.substr(this._currentToken!!.startPos).trim()
        var pos: Double = 0.0
        while (pos < familyListInput.length.toDouble())
        {
            var c: String = familyListInput.charAt(pos)
            if (c == " " || c == ",")
            {
                pos++
            }
            else if (c == "\"" || c == "'")
            {
                var endOfString: Double = this.findEndOfQuote(familyListInput, pos + 1.0, c)
                this.families.push(familyListInput.substring(pos + 1.0, endOfString).splitBy("\\" + c).join(c))
                pos = endOfString + 1.0
            }
            else 
            {
                var endOfString: Double = this.findEndOfQuote(familyListInput, pos + 1.0, ",")
                this.families.push(familyListInput.substring(pos, endOfString).trim())
                pos = endOfString + 1.0
            }
        }
    }
    
    /**
     */
    private fun findEndOfQuote(s: String, pos: Double, quoteChar: String): Double{
        var parampos = pos
        var escaped: Boolean = false
        while (parampos < s.length.toDouble())
        {
            var c: String = s.charAt(parampos)
            if (!escaped && c == quoteChar)
            {
                return parampos
            }
            if (!escaped && c == "\\")
            {
                escaped = true
            }
            else 
            {
                escaped = false
            }
            parampos += 1.0
        }
        return s.length.toDouble()
    }
    
    private fun fontSizeLineHeight(): Unit{
        if (!alphaTab.core.TypeHelper.isTruthy(this._currentToken))
        {
            throw alphaTab.core.ecmaScript.Error("Missing font size")
        }
        var parts: alphaTab.collections.List<String> = this._currentToken!!.text.splitBy("/")
        if (parts.length >= 3)
        {
            throw alphaTab.core.ecmaScript.Error("""Invalid font size '${(this._currentToken).toTemplate()}' specified""")
        }
        this.nextToken()
        if (parts.length >= 2)
        {
            if (parts[(1.0).toInt()] == "/")
            {
                if (!alphaTab.core.TypeHelper.isTruthy(this._currentToken))
                {
                    throw alphaTab.core.ecmaScript.Error("Missing line-height after font size")
                }
                this.lineHeight = this._currentToken!!.text
                this.nextToken()
            }
            else 
            {
                this.size = parts[(0).toInt()]
                this.lineHeight = parts[(1).toInt()]
            }
        }
        else if (parts.length >= 1)
        {
            this.size = parts[(0).toInt()]
            if (alphaTab.core.TypeHelper.isTruthy(this._currentToken) && this._currentToken!!.text.indexOfInDouble("/") == 0.0)
            {
                if (this._currentToken!!.text == "/")
                {
                    this.nextToken()
                    if (!alphaTab.core.TypeHelper.isTruthy(this._currentToken))
                    {
                        throw alphaTab.core.ecmaScript.Error("Missing line-height after font size")
                    }
                    this.lineHeight = this._currentToken!!.text
                    this.nextToken()
                }
                else 
                {
                    this.lineHeight = this._currentToken!!.text.substr(1.0)
                    this.nextToken()
                }
            }
        }
        else 
        {
            throw alphaTab.core.ecmaScript.Error("Missing font size")
        }
    }
    
    private fun nextToken(): Unit{
        this._currentTokenIndex++
        if (this._currentTokenIndex < this._tokens.length)
        {
            this._currentToken = this._tokens[(this._currentTokenIndex).toInt()]
        }
        else 
        {
            this._currentToken = null
        }
    }
    
    private fun fontStyleVariantWeight(): Unit{
        var hasStyle: Boolean = false
        var hasVariant: Boolean = false
        var hasWeight: Boolean = false
        var valuesNeeded: Double = 3.0
        var ambiguous: alphaTab.collections.List<String> = alphaTab.collections.List<String>(
        )
        
        while (true)
        {
            if (!alphaTab.core.TypeHelper.isTruthy(this._currentToken))
            {
                return
            }
            var text: String = this._currentToken!!.text
            when (text)
            {
                "normal", "inherit" -> 
                {
                    ambiguous.push(text)
                    valuesNeeded--
                    this.nextToken()
                }
                "italic", "oblique" -> 
                {
                    this.style = text
                    hasStyle = true
                    valuesNeeded--
                    this.nextToken()
                }
                "small-caps" -> 
                {
                    this.variant = text
                    hasVariant = true
                    valuesNeeded--
                    this.nextToken()
                }
                "bold", "bolder", "lighter", "100", "200", "300", "400", "500", "600", "700", "800", "900" -> 
                {
                    this.weight = text
                    hasWeight = true
                    valuesNeeded--
                    this.nextToken()
                }
                else -> 
                {
                    return
                }
            }
            if (valuesNeeded == 0.0)
            {
                break
            }
        }
        while (ambiguous.length > 0)
        {
            var v: String = ambiguous.pop()!!
            if (!hasWeight)
            {
                this.weight = v
            }
            else if (!hasVariant)
            {
                this.variant = v
            }
            else if (!hasStyle)
            {
                this.style = v
            }
        }
    }
    
    private fun reset(): Unit{
        this._currentTokenIndex = -1.0
        this.nextToken()
    }
    
    companion object{
        /**
         */
        @kotlin.jvm.JvmStatic
        public fun parseFamilies(value: String): alphaTab.collections.List<String>{
            var parser: alphaTab.model.FontParser = alphaTab.model.FontParser(value)
            parser.parseOnlyFamilies = true
            parser.parse()
            return parser.families
        }
        
        /**
         */
        @kotlin.jvm.JvmStatic
        public fun quoteFont(f: String): String{
            if (f.indexOfInDouble(" ") == -1.0)
            {
                return f
            }
            var escapedQuotes: String = f.replaceAll("\"", "\\\"")
            return """"${(escapedQuotes).toTemplate()}""""
        }
        
    }
}

